// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLogPatternInput struct {
	_ struct{} `type:"structure"`

	// The name of the log pattern.
	//
	// PatternName is a required field
	PatternName *string `min:"1" type:"string" required:"true"`

	// The name of the log pattern set.
	//
	// PatternSetName is a required field
	PatternSetName *string `min:"1" type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLogPatternInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLogPatternInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLogPatternInput"}

	if s.PatternName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatternName"))
	}
	if s.PatternName != nil && len(*s.PatternName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatternName", 1))
	}

	if s.PatternSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PatternSetName"))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatternSetName", 1))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeLogPatternOutput struct {
	_ struct{} `type:"structure"`

	// The successfully created log pattern.
	LogPattern *LogPattern `type:"structure"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeLogPatternOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLogPattern = "DescribeLogPattern"

// DescribeLogPatternRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Describe a specific log pattern from a LogPatternSet.
//
//    // Example sending a request using DescribeLogPatternRequest.
//    req := client.DescribeLogPatternRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeLogPattern
func (c *Client) DescribeLogPatternRequest(input *DescribeLogPatternInput) DescribeLogPatternRequest {
	op := &aws.Operation{
		Name:       opDescribeLogPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLogPatternInput{}
	}

	req := c.newRequest(op, input, &DescribeLogPatternOutput{})
	return DescribeLogPatternRequest{Request: req, Input: input, Copy: c.DescribeLogPatternRequest}
}

// DescribeLogPatternRequest is the request type for the
// DescribeLogPattern API operation.
type DescribeLogPatternRequest struct {
	*aws.Request
	Input *DescribeLogPatternInput
	Copy  func(*DescribeLogPatternInput) DescribeLogPatternRequest
}

// Send marshals and sends the DescribeLogPattern API request.
func (r DescribeLogPatternRequest) Send(ctx context.Context) (*DescribeLogPatternResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLogPatternResponse{
		DescribeLogPatternOutput: r.Request.Data.(*DescribeLogPatternOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLogPatternResponse is the response type for the
// DescribeLogPattern API operation.
type DescribeLogPatternResponse struct {
	*DescribeLogPatternOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLogPattern request.
func (r *DescribeLogPatternResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
