// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RejectSkillInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RejectSkillInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectSkillInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RejectSkillInput"}

	if s.SkillId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RejectSkillOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectSkillOutput) String() string {
	return awsutil.Prettify(s)
}

const opRejectSkill = "RejectSkill"

// RejectSkillRequest returns a request value for making API operation for
// Alexa For Business.
//
// Disassociates a skill from the organization under a user's AWS account. If
// the skill is a private skill, it moves to an AcceptStatus of PENDING. Any
// private or public skill that is rejected can be added later by calling the
// ApproveSkill API.
//
//    // Example sending a request using RejectSkillRequest.
//    req := client.RejectSkillRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill
func (c *Client) RejectSkillRequest(input *RejectSkillInput) RejectSkillRequest {
	op := &aws.Operation{
		Name:       opRejectSkill,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectSkillInput{}
	}

	req := c.newRequest(op, input, &RejectSkillOutput{})
	return RejectSkillRequest{Request: req, Input: input, Copy: c.RejectSkillRequest}
}

// RejectSkillRequest is the request type for the
// RejectSkill API operation.
type RejectSkillRequest struct {
	*aws.Request
	Input *RejectSkillInput
	Copy  func(*RejectSkillInput) RejectSkillRequest
}

// Send marshals and sends the RejectSkill API request.
func (r RejectSkillRequest) Send(ctx context.Context) (*RejectSkillResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RejectSkillResponse{
		RejectSkillOutput: r.Request.Data.(*RejectSkillOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RejectSkillResponse is the response type for the
// RejectSkill API operation.
type RejectSkillResponse struct {
	*RejectSkillOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RejectSkill request.
func (r *RejectSkillResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
