// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateSkillFromUsersInput struct {
	_ struct{} `type:"structure"`

	// The private skill ID you want to make unavailable for enrolled users.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateSkillFromUsersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateSkillFromUsersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateSkillFromUsersInput"}

	if s.SkillId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateSkillFromUsersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateSkillFromUsersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateSkillFromUsers = "DisassociateSkillFromUsers"

// DisassociateSkillFromUsersRequest returns a request value for making API operation for
// Alexa For Business.
//
// Makes a private skill unavailable for enrolled users and prevents them from
// enabling it on their devices.
//
//    // Example sending a request using DisassociateSkillFromUsersRequest.
//    req := client.DisassociateSkillFromUsersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers
func (c *Client) DisassociateSkillFromUsersRequest(input *DisassociateSkillFromUsersInput) DisassociateSkillFromUsersRequest {
	op := &aws.Operation{
		Name:       opDisassociateSkillFromUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateSkillFromUsersInput{}
	}

	req := c.newRequest(op, input, &DisassociateSkillFromUsersOutput{})
	return DisassociateSkillFromUsersRequest{Request: req, Input: input, Copy: c.DisassociateSkillFromUsersRequest}
}

// DisassociateSkillFromUsersRequest is the request type for the
// DisassociateSkillFromUsers API operation.
type DisassociateSkillFromUsersRequest struct {
	*aws.Request
	Input *DisassociateSkillFromUsersInput
	Copy  func(*DisassociateSkillFromUsersInput) DisassociateSkillFromUsersRequest
}

// Send marshals and sends the DisassociateSkillFromUsers API request.
func (r DisassociateSkillFromUsersRequest) Send(ctx context.Context) (*DisassociateSkillFromUsersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateSkillFromUsersResponse{
		DisassociateSkillFromUsersOutput: r.Request.Data.(*DisassociateSkillFromUsersOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateSkillFromUsersResponse is the response type for the
// DisassociateSkillFromUsers API operation.
type DisassociateSkillFromUsersResponse struct {
	*DisassociateSkillFromUsersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateSkillFromUsers request.
func (r *DisassociateSkillFromUsersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
