// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/ml/v1/job_service.proto

package ml

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/api/serviceconfig"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A scale tier is an abstract representation of the resources Cloud ML
// will allocate to a training job. When selecting a scale tier for your
// training job, you should consider the size of your training dataset and
// the complexity of your model. As the tiers increase, virtual machines are
// added to handle your job, and the individual machines in the cluster
// generally have more memory and greater processing power than they do at
// lower tiers. The number of training units charged per hour of processing
// increases as tiers get more advanced. Refer to the
// [pricing guide](/ml/pricing) for more details. Note that in addition to
// incurring costs, your use of training resources is constrained by the
// [quota policy](/ml/quota).
type TrainingInput_ScaleTier int32

const (
	// A single worker instance. This tier is suitable for learning how to use
	// Cloud ML, and for experimenting with new models using small datasets.
	TrainingInput_BASIC TrainingInput_ScaleTier = 0
	// Many workers and a few parameter servers.
	TrainingInput_STANDARD_1 TrainingInput_ScaleTier = 1
	// A large number of workers with many parameter servers.
	TrainingInput_PREMIUM_1 TrainingInput_ScaleTier = 3
	// A single worker instance [with a GPU](ml/docs/how-tos/using-gpus).
	TrainingInput_BASIC_GPU TrainingInput_ScaleTier = 6
	// The CUSTOM tier is not a set tier, but rather enables you to use your
	// own cluster specification. When you use this tier, set values to
	// configure your processing cluster according to these guidelines:
	//
	// *   You _must_ set `TrainingInput.masterType` to specify the type
	//     of machine to use for your master node. This is the only required
	//     setting.
	//
	// *   You _may_ set `TrainingInput.workerCount` to specify the number of
	//     workers to use. If you specify one or more workers, you _must_ also
	//     set `TrainingInput.workerType` to specify the type of machine to use
	//     for your worker nodes.
	//
	// *   You _may_ set `TrainingInput.parameterServerCount` to specify the
	//     number of parameter servers to use. If you specify one or more
	//     parameter servers, you _must_ also set
	//     `TrainingInput.parameterServerType` to specify the type of machine to
	//     use for your parameter servers.
	//
	// Note that all of your workers must use the same machine type, which can
	// be different from your parameter server type and master type. Your
	// parameter servers must likewise use the same machine type, which can be
	// different from your worker type and master type.
	TrainingInput_CUSTOM TrainingInput_ScaleTier = 5
)

// Enum value maps for TrainingInput_ScaleTier.
var (
	TrainingInput_ScaleTier_name = map[int32]string{
		0: "BASIC",
		1: "STANDARD_1",
		3: "PREMIUM_1",
		6: "BASIC_GPU",
		5: "CUSTOM",
	}
	TrainingInput_ScaleTier_value = map[string]int32{
		"BASIC":      0,
		"STANDARD_1": 1,
		"PREMIUM_1":  3,
		"BASIC_GPU":  6,
		"CUSTOM":     5,
	}
)

func (x TrainingInput_ScaleTier) Enum() *TrainingInput_ScaleTier {
	p := new(TrainingInput_ScaleTier)
	*p = x
	return p
}

func (x TrainingInput_ScaleTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrainingInput_ScaleTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_ml_v1_job_service_proto_enumTypes[0].Descriptor()
}

func (TrainingInput_ScaleTier) Type() protoreflect.EnumType {
	return &file_google_cloud_ml_v1_job_service_proto_enumTypes[0]
}

func (x TrainingInput_ScaleTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrainingInput_ScaleTier.Descriptor instead.
func (TrainingInput_ScaleTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{0, 0}
}

// The available types of optimization goals.
type HyperparameterSpec_GoalType int32

const (
	// Goal Type will default to maximize.
	HyperparameterSpec_GOAL_TYPE_UNSPECIFIED HyperparameterSpec_GoalType = 0
	// Maximize the goal metric.
	HyperparameterSpec_MAXIMIZE HyperparameterSpec_GoalType = 1
	// Minimize the goal metric.
	HyperparameterSpec_MINIMIZE HyperparameterSpec_GoalType = 2
)

// Enum value maps for HyperparameterSpec_GoalType.
var (
	HyperparameterSpec_GoalType_name = map[int32]string{
		0: "GOAL_TYPE_UNSPECIFIED",
		1: "MAXIMIZE",
		2: "MINIMIZE",
	}
	HyperparameterSpec_GoalType_value = map[string]int32{
		"GOAL_TYPE_UNSPECIFIED": 0,
		"MAXIMIZE":              1,
		"MINIMIZE":              2,
	}
)

func (x HyperparameterSpec_GoalType) Enum() *HyperparameterSpec_GoalType {
	p := new(HyperparameterSpec_GoalType)
	*p = x
	return p
}

func (x HyperparameterSpec_GoalType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HyperparameterSpec_GoalType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_ml_v1_job_service_proto_enumTypes[1].Descriptor()
}

func (HyperparameterSpec_GoalType) Type() protoreflect.EnumType {
	return &file_google_cloud_ml_v1_job_service_proto_enumTypes[1]
}

func (x HyperparameterSpec_GoalType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HyperparameterSpec_GoalType.Descriptor instead.
func (HyperparameterSpec_GoalType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{1, 0}
}

// The type of the parameter.
type ParameterSpec_ParameterType int32

const (
	// You must specify a valid type. Using this unspecified type will result in
	// an error.
	ParameterSpec_PARAMETER_TYPE_UNSPECIFIED ParameterSpec_ParameterType = 0
	// Type for real-valued parameters.
	ParameterSpec_DOUBLE ParameterSpec_ParameterType = 1
	// Type for integral parameters.
	ParameterSpec_INTEGER ParameterSpec_ParameterType = 2
	// The parameter is categorical, with a value chosen from the categories
	// field.
	ParameterSpec_CATEGORICAL ParameterSpec_ParameterType = 3
	// The parameter is real valued, with a fixed set of feasible points. If
	// `type==DISCRETE`, feasible_points must be provided, and
	// {`min_value`, `max_value`} will be ignored.
	ParameterSpec_DISCRETE ParameterSpec_ParameterType = 4
)

// Enum value maps for ParameterSpec_ParameterType.
var (
	ParameterSpec_ParameterType_name = map[int32]string{
		0: "PARAMETER_TYPE_UNSPECIFIED",
		1: "DOUBLE",
		2: "INTEGER",
		3: "CATEGORICAL",
		4: "DISCRETE",
	}
	ParameterSpec_ParameterType_value = map[string]int32{
		"PARAMETER_TYPE_UNSPECIFIED": 0,
		"DOUBLE":                     1,
		"INTEGER":                    2,
		"CATEGORICAL":                3,
		"DISCRETE":                   4,
	}
)

func (x ParameterSpec_ParameterType) Enum() *ParameterSpec_ParameterType {
	p := new(ParameterSpec_ParameterType)
	*p = x
	return p
}

func (x ParameterSpec_ParameterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ParameterSpec_ParameterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_ml_v1_job_service_proto_enumTypes[2].Descriptor()
}

func (ParameterSpec_ParameterType) Type() protoreflect.EnumType {
	return &file_google_cloud_ml_v1_job_service_proto_enumTypes[2]
}

func (x ParameterSpec_ParameterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ParameterSpec_ParameterType.Descriptor instead.
func (ParameterSpec_ParameterType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{2, 0}
}

// The type of scaling that should be applied to this parameter.
type ParameterSpec_ScaleType int32

const (
	// By default, no scaling is applied.
	ParameterSpec_NONE ParameterSpec_ScaleType = 0
	// Scales the feasible space to (0, 1) linearly.
	ParameterSpec_UNIT_LINEAR_SCALE ParameterSpec_ScaleType = 1
	// Scales the feasible space logarithmically to (0, 1). The entire feasible
	// space must be strictly positive.
	ParameterSpec_UNIT_LOG_SCALE ParameterSpec_ScaleType = 2
	// Scales the feasible space "reverse" logarithmically to (0, 1). The result
	// is that values close to the top of the feasible space are spread out more
	// than points near the bottom. The entire feasible space must be strictly
	// positive.
	ParameterSpec_UNIT_REVERSE_LOG_SCALE ParameterSpec_ScaleType = 3
)

// Enum value maps for ParameterSpec_ScaleType.
var (
	ParameterSpec_ScaleType_name = map[int32]string{
		0: "NONE",
		1: "UNIT_LINEAR_SCALE",
		2: "UNIT_LOG_SCALE",
		3: "UNIT_REVERSE_LOG_SCALE",
	}
	ParameterSpec_ScaleType_value = map[string]int32{
		"NONE":                   0,
		"UNIT_LINEAR_SCALE":      1,
		"UNIT_LOG_SCALE":         2,
		"UNIT_REVERSE_LOG_SCALE": 3,
	}
)

func (x ParameterSpec_ScaleType) Enum() *ParameterSpec_ScaleType {
	p := new(ParameterSpec_ScaleType)
	*p = x
	return p
}

func (x ParameterSpec_ScaleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ParameterSpec_ScaleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_ml_v1_job_service_proto_enumTypes[3].Descriptor()
}

func (ParameterSpec_ScaleType) Type() protoreflect.EnumType {
	return &file_google_cloud_ml_v1_job_service_proto_enumTypes[3]
}

func (x ParameterSpec_ScaleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ParameterSpec_ScaleType.Descriptor instead.
func (ParameterSpec_ScaleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{2, 1}
}

// The format used to separate data instances in the source files.
type PredictionInput_DataFormat int32

const (
	// Unspecified format.
	PredictionInput_DATA_FORMAT_UNSPECIFIED PredictionInput_DataFormat = 0
	// The source file is a text file with instances separated by the
	// new-line character.
	PredictionInput_TEXT PredictionInput_DataFormat = 1
	// The source file is a TFRecord file.
	PredictionInput_TF_RECORD PredictionInput_DataFormat = 2
	// The source file is a GZIP-compressed TFRecord file.
	PredictionInput_TF_RECORD_GZIP PredictionInput_DataFormat = 3
)

// Enum value maps for PredictionInput_DataFormat.
var (
	PredictionInput_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "TEXT",
		2: "TF_RECORD",
		3: "TF_RECORD_GZIP",
	}
	PredictionInput_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"TEXT":                    1,
		"TF_RECORD":               2,
		"TF_RECORD_GZIP":          3,
	}
)

func (x PredictionInput_DataFormat) Enum() *PredictionInput_DataFormat {
	p := new(PredictionInput_DataFormat)
	*p = x
	return p
}

func (x PredictionInput_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PredictionInput_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_ml_v1_job_service_proto_enumTypes[4].Descriptor()
}

func (PredictionInput_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_ml_v1_job_service_proto_enumTypes[4]
}

func (x PredictionInput_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PredictionInput_DataFormat.Descriptor instead.
func (PredictionInput_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{5, 0}
}

// Describes the job state.
type Job_State int32

const (
	// The job state is unspecified.
	Job_STATE_UNSPECIFIED Job_State = 0
	// The job has been just created and processing has not yet begun.
	Job_QUEUED Job_State = 1
	// The service is preparing to run the job.
	Job_PREPARING Job_State = 2
	// The job is in progress.
	Job_RUNNING Job_State = 3
	// The job completed successfully.
	Job_SUCCEEDED Job_State = 4
	// The job failed.
	// `error_message` should contain the details of the failure.
	Job_FAILED Job_State = 5
	// The job is being cancelled.
	// `error_message` should describe the reason for the cancellation.
	Job_CANCELLING Job_State = 6
	// The job has been cancelled.
	// `error_message` should describe the reason for the cancellation.
	Job_CANCELLED Job_State = 7
)

// Enum value maps for Job_State.
var (
	Job_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "QUEUED",
		2: "PREPARING",
		3: "RUNNING",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "CANCELLING",
		7: "CANCELLED",
	}
	Job_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"QUEUED":            1,
		"PREPARING":         2,
		"RUNNING":           3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"CANCELLING":        6,
		"CANCELLED":         7,
	}
)

func (x Job_State) Enum() *Job_State {
	p := new(Job_State)
	*p = x
	return p
}

func (x Job_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_ml_v1_job_service_proto_enumTypes[5].Descriptor()
}

func (Job_State) Type() protoreflect.EnumType {
	return &file_google_cloud_ml_v1_job_service_proto_enumTypes[5]
}

func (x Job_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_State.Descriptor instead.
func (Job_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{7, 0}
}

// Represents input parameters for a training job.
type TrainingInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies the machine types, the number of replicas for workers
	// and parameter servers.
	ScaleTier TrainingInput_ScaleTier `protobuf:"varint,1,opt,name=scale_tier,json=scaleTier,proto3,enum=google.cloud.ml.v1.TrainingInput_ScaleTier" json:"scale_tier,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's master worker.
	//
	// The following types are supported:
	//
	// <dl>
	//   <dt>standard</dt>
	//   <dd>
	//   A basic machine configuration suitable for training simple models with
	//   small to moderate datasets.
	//   </dd>
	//   <dt>large_model</dt>
	//   <dd>
	//   A machine with a lot of memory, specially suited for parameter servers
	//   when your model is large (having many hidden layers or layers with very
	//   large numbers of nodes).
	//   </dd>
	//   <dt>complex_model_s</dt>
	//   <dd>
	//   A machine suitable for the master and workers of the cluster when your
	//   model requires more computation than the standard machine can handle
	//   satisfactorily.
	//   </dd>
	//   <dt>complex_model_m</dt>
	//   <dd>
	//   A machine with roughly twice the number of cores and roughly double the
	//   memory of <code suppresswarning="true">complex_model_s</code>.
	//   </dd>
	//   <dt>complex_model_l</dt>
	//   <dd>
	//   A machine with roughly twice the number of cores and roughly double the
	//   memory of <code suppresswarning="true">complex_model_m</code>.
	//   </dd>
	//   <dt>standard_gpu</dt>
	//   <dd>
	//   A machine equivalent to <code suppresswarning="true">standard</code> that
	//   also includes a
	//   <a href="ml/docs/how-tos/using-gpus">
	//   GPU that you can use in your trainer</a>.
	//   </dd>
	//   <dt>complex_model_m_gpu</dt>
	//   <dd>
	//   A machine equivalent to
	//   <code suppresswarning="true">coplex_model_m</code> that also includes
	//   four GPUs.
	//   </dd>
	// </dl>
	//
	// You must set this value when `scaleTier` is set to `CUSTOM`.
	MasterType string `protobuf:"bytes,2,opt,name=master_type,json=masterType,proto3" json:"master_type,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's worker nodes.
	//
	// The supported values are the same as those described in the entry for
	// `masterType`.
	//
	// This value must be present when `scaleTier` is set to `CUSTOM` and
	// `workerCount` is greater than zero.
	WorkerType string `protobuf:"bytes,3,opt,name=worker_type,json=workerType,proto3" json:"worker_type,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's parameter server.
	//
	// The supported values are the same as those described in the entry for
	// `master_type`.
	//
	// This value must be present when `scaleTier` is set to `CUSTOM` and
	// `parameter_server_count` is greater than zero.
	ParameterServerType string `protobuf:"bytes,4,opt,name=parameter_server_type,json=parameterServerType,proto3" json:"parameter_server_type,omitempty"`
	// Optional. The number of worker replicas to use for the training job. Each
	// replica in the cluster will be of the type specified in `worker_type`.
	//
	// This value can only be used when `scale_tier` is set to `CUSTOM`. If you
	// set this value, you must also set `worker_type`.
	WorkerCount int64 `protobuf:"varint,5,opt,name=worker_count,json=workerCount,proto3" json:"worker_count,omitempty"`
	// Optional. The number of parameter server replicas to use for the training
	// job. Each replica in the cluster will be of the type specified in
	// `parameter_server_type`.
	//
	// This value can only be used when `scale_tier` is set to `CUSTOM`.If you
	// set this value, you must also set `parameter_server_type`.
	ParameterServerCount int64 `protobuf:"varint,6,opt,name=parameter_server_count,json=parameterServerCount,proto3" json:"parameter_server_count,omitempty"`
	// Required. The Google Cloud Storage location of the packages with
	// the training program and any additional dependencies.
	PackageUris []string `protobuf:"bytes,7,rep,name=package_uris,json=packageUris,proto3" json:"package_uris,omitempty"`
	// Required. The Python module name to run after installing the packages.
	PythonModule string `protobuf:"bytes,8,opt,name=python_module,json=pythonModule,proto3" json:"python_module,omitempty"`
	// Optional. Command line arguments to pass to the program.
	Args []string `protobuf:"bytes,10,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. The set of Hyperparameters to tune.
	Hyperparameters *HyperparameterSpec `protobuf:"bytes,12,opt,name=hyperparameters,proto3" json:"hyperparameters,omitempty"`
	// Required. The Google Compute Engine region to run the training job in.
	Region string `protobuf:"bytes,14,opt,name=region,proto3" json:"region,omitempty"`
	// Optional. A Google Cloud Storage path in which to store training outputs
	// and other data needed for training. This path is passed to your TensorFlow
	// program as the 'job_dir' command-line argument. The benefit of specifying
	// this field is that Cloud ML validates the path for use in training.
	JobDir string `protobuf:"bytes,16,opt,name=job_dir,json=jobDir,proto3" json:"job_dir,omitempty"`
	// Optional. The Google Cloud ML runtime version to use for training.  If not
	// set, Google Cloud ML will choose the latest stable version.
	RuntimeVersion string `protobuf:"bytes,15,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
}

func (x *TrainingInput) Reset() {
	*x = TrainingInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainingInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainingInput) ProtoMessage() {}

func (x *TrainingInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainingInput.ProtoReflect.Descriptor instead.
func (*TrainingInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{0}
}

func (x *TrainingInput) GetScaleTier() TrainingInput_ScaleTier {
	if x != nil {
		return x.ScaleTier
	}
	return TrainingInput_BASIC
}

func (x *TrainingInput) GetMasterType() string {
	if x != nil {
		return x.MasterType
	}
	return ""
}

func (x *TrainingInput) GetWorkerType() string {
	if x != nil {
		return x.WorkerType
	}
	return ""
}

func (x *TrainingInput) GetParameterServerType() string {
	if x != nil {
		return x.ParameterServerType
	}
	return ""
}

func (x *TrainingInput) GetWorkerCount() int64 {
	if x != nil {
		return x.WorkerCount
	}
	return 0
}

func (x *TrainingInput) GetParameterServerCount() int64 {
	if x != nil {
		return x.ParameterServerCount
	}
	return 0
}

func (x *TrainingInput) GetPackageUris() []string {
	if x != nil {
		return x.PackageUris
	}
	return nil
}

func (x *TrainingInput) GetPythonModule() string {
	if x != nil {
		return x.PythonModule
	}
	return ""
}

func (x *TrainingInput) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *TrainingInput) GetHyperparameters() *HyperparameterSpec {
	if x != nil {
		return x.Hyperparameters
	}
	return nil
}

func (x *TrainingInput) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *TrainingInput) GetJobDir() string {
	if x != nil {
		return x.JobDir
	}
	return ""
}

func (x *TrainingInput) GetRuntimeVersion() string {
	if x != nil {
		return x.RuntimeVersion
	}
	return ""
}

// Represents a set of hyperparameters to optimize.
type HyperparameterSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of goal to use for tuning. Available types are
	// `MAXIMIZE` and `MINIMIZE`.
	//
	// Defaults to `MAXIMIZE`.
	Goal HyperparameterSpec_GoalType `protobuf:"varint,1,opt,name=goal,proto3,enum=google.cloud.ml.v1.HyperparameterSpec_GoalType" json:"goal,omitempty"`
	// Required. The set of parameters to tune.
	Params []*ParameterSpec `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty"`
	// Optional. How many training trials should be attempted to optimize
	// the specified hyperparameters.
	//
	// Defaults to one.
	MaxTrials int32 `protobuf:"varint,3,opt,name=max_trials,json=maxTrials,proto3" json:"max_trials,omitempty"`
	// Optional. The number of training trials to run concurrently.
	// You can reduce the time it takes to perform hyperparameter tuning by adding
	// trials in parallel. However, each trail only benefits from the information
	// gained in completed trials. That means that a trial does not get access to
	// the results of trials running at the same time, which could reduce the
	// quality of the overall optimization.
	//
	// Each trial will use the same scale tier and machine types.
	//
	// Defaults to one.
	MaxParallelTrials int32 `protobuf:"varint,4,opt,name=max_parallel_trials,json=maxParallelTrials,proto3" json:"max_parallel_trials,omitempty"`
	// Optional. The Tensorflow summary tag name to use for optimizing trials. For
	// current versions of Tensorflow, this tag name should exactly match what is
	// shown in Tensorboard, including all scopes.  For versions of Tensorflow
	// prior to 0.12, this should be only the tag passed to tf.Summary.
	// By default, "training/hptuning/metric" will be used.
	HyperparameterMetricTag string `protobuf:"bytes,5,opt,name=hyperparameter_metric_tag,json=hyperparameterMetricTag,proto3" json:"hyperparameter_metric_tag,omitempty"`
}

func (x *HyperparameterSpec) Reset() {
	*x = HyperparameterSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HyperparameterSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HyperparameterSpec) ProtoMessage() {}

func (x *HyperparameterSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HyperparameterSpec.ProtoReflect.Descriptor instead.
func (*HyperparameterSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{1}
}

func (x *HyperparameterSpec) GetGoal() HyperparameterSpec_GoalType {
	if x != nil {
		return x.Goal
	}
	return HyperparameterSpec_GOAL_TYPE_UNSPECIFIED
}

func (x *HyperparameterSpec) GetParams() []*ParameterSpec {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *HyperparameterSpec) GetMaxTrials() int32 {
	if x != nil {
		return x.MaxTrials
	}
	return 0
}

func (x *HyperparameterSpec) GetMaxParallelTrials() int32 {
	if x != nil {
		return x.MaxParallelTrials
	}
	return 0
}

func (x *HyperparameterSpec) GetHyperparameterMetricTag() string {
	if x != nil {
		return x.HyperparameterMetricTag
	}
	return ""
}

// Represents a single hyperparameter to optimize.
type ParameterSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parameter name must be unique amongst all ParameterConfigs in
	// a HyperparameterSpec message. E.g., "learning_rate".
	ParameterName string `protobuf:"bytes,1,opt,name=parameter_name,json=parameterName,proto3" json:"parameter_name,omitempty"`
	// Required. The type of the parameter.
	Type ParameterSpec_ParameterType `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.ml.v1.ParameterSpec_ParameterType" json:"type,omitempty"`
	// Required if type is `DOUBLE` or `INTEGER`. This field
	// should be unset if type is `CATEGORICAL`. This value should be integers if
	// type is INTEGER.
	MinValue float64 `protobuf:"fixed64,2,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Required if typeis `DOUBLE` or `INTEGER`. This field
	// should be unset if type is `CATEGORICAL`. This value should be integers if
	// type is `INTEGER`.
	MaxValue float64 `protobuf:"fixed64,3,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Required if type is `CATEGORICAL`. The list of possible categories.
	CategoricalValues []string `protobuf:"bytes,5,rep,name=categorical_values,json=categoricalValues,proto3" json:"categorical_values,omitempty"`
	// Required if type is `DISCRETE`.
	// A list of feasible points.
	// The list should be in strictly increasing order. For instance, this
	// parameter might have possible settings of 1.5, 2.5, and 4.0. This list
	// should not contain more than 1,000 values.
	DiscreteValues []float64 `protobuf:"fixed64,6,rep,packed,name=discrete_values,json=discreteValues,proto3" json:"discrete_values,omitempty"`
	// Optional. How the parameter should be scaled to the hypercube.
	// Leave unset for categorical parameters.
	// Some kind of scaling is strongly recommended for real or integral
	// parameters (e.g., `UNIT_LINEAR_SCALE`).
	ScaleType ParameterSpec_ScaleType `protobuf:"varint,7,opt,name=scale_type,json=scaleType,proto3,enum=google.cloud.ml.v1.ParameterSpec_ScaleType" json:"scale_type,omitempty"`
}

func (x *ParameterSpec) Reset() {
	*x = ParameterSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ParameterSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParameterSpec) ProtoMessage() {}

func (x *ParameterSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParameterSpec.ProtoReflect.Descriptor instead.
func (*ParameterSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{2}
}

func (x *ParameterSpec) GetParameterName() string {
	if x != nil {
		return x.ParameterName
	}
	return ""
}

func (x *ParameterSpec) GetType() ParameterSpec_ParameterType {
	if x != nil {
		return x.Type
	}
	return ParameterSpec_PARAMETER_TYPE_UNSPECIFIED
}

func (x *ParameterSpec) GetMinValue() float64 {
	if x != nil {
		return x.MinValue
	}
	return 0
}

func (x *ParameterSpec) GetMaxValue() float64 {
	if x != nil {
		return x.MaxValue
	}
	return 0
}

func (x *ParameterSpec) GetCategoricalValues() []string {
	if x != nil {
		return x.CategoricalValues
	}
	return nil
}

func (x *ParameterSpec) GetDiscreteValues() []float64 {
	if x != nil {
		return x.DiscreteValues
	}
	return nil
}

func (x *ParameterSpec) GetScaleType() ParameterSpec_ScaleType {
	if x != nil {
		return x.ScaleType
	}
	return ParameterSpec_NONE
}

// Represents the result of a single hyperparameter tuning trial from a
// training job. The TrainingOutput object that is returned on successful
// completion of a training job with hyperparameter tuning includes a list
// of HyperparameterOutput objects, one for each successful trial.
type HyperparameterOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The trial id for these results.
	TrialId string `protobuf:"bytes,1,opt,name=trial_id,json=trialId,proto3" json:"trial_id,omitempty"`
	// The hyperparameters given to this trial.
	Hyperparameters map[string]string `protobuf:"bytes,2,rep,name=hyperparameters,proto3" json:"hyperparameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The final objective metric seen for this trial.
	FinalMetric *HyperparameterOutput_HyperparameterMetric `protobuf:"bytes,3,opt,name=final_metric,json=finalMetric,proto3" json:"final_metric,omitempty"`
	// All recorded object metrics for this trial.
	AllMetrics []*HyperparameterOutput_HyperparameterMetric `protobuf:"bytes,4,rep,name=all_metrics,json=allMetrics,proto3" json:"all_metrics,omitempty"`
}

func (x *HyperparameterOutput) Reset() {
	*x = HyperparameterOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HyperparameterOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HyperparameterOutput) ProtoMessage() {}

func (x *HyperparameterOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HyperparameterOutput.ProtoReflect.Descriptor instead.
func (*HyperparameterOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{3}
}

func (x *HyperparameterOutput) GetTrialId() string {
	if x != nil {
		return x.TrialId
	}
	return ""
}

func (x *HyperparameterOutput) GetHyperparameters() map[string]string {
	if x != nil {
		return x.Hyperparameters
	}
	return nil
}

func (x *HyperparameterOutput) GetFinalMetric() *HyperparameterOutput_HyperparameterMetric {
	if x != nil {
		return x.FinalMetric
	}
	return nil
}

func (x *HyperparameterOutput) GetAllMetrics() []*HyperparameterOutput_HyperparameterMetric {
	if x != nil {
		return x.AllMetrics
	}
	return nil
}

// Represents results of a training job. Output only.
type TrainingOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of hyperparameter tuning trials that completed successfully.
	// Only set for hyperparameter tuning jobs.
	CompletedTrialCount int64 `protobuf:"varint,1,opt,name=completed_trial_count,json=completedTrialCount,proto3" json:"completed_trial_count,omitempty"`
	// Results for individual Hyperparameter trials.
	// Only set for hyperparameter tuning jobs.
	Trials []*HyperparameterOutput `protobuf:"bytes,2,rep,name=trials,proto3" json:"trials,omitempty"`
	// The amount of ML units consumed by the job.
	ConsumedMlUnits float64 `protobuf:"fixed64,3,opt,name=consumed_ml_units,json=consumedMlUnits,proto3" json:"consumed_ml_units,omitempty"`
	// Whether this job is a hyperparameter tuning job.
	IsHyperparameterTuningJob bool `protobuf:"varint,4,opt,name=is_hyperparameter_tuning_job,json=isHyperparameterTuningJob,proto3" json:"is_hyperparameter_tuning_job,omitempty"`
}

func (x *TrainingOutput) Reset() {
	*x = TrainingOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainingOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainingOutput) ProtoMessage() {}

func (x *TrainingOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainingOutput.ProtoReflect.Descriptor instead.
func (*TrainingOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{4}
}

func (x *TrainingOutput) GetCompletedTrialCount() int64 {
	if x != nil {
		return x.CompletedTrialCount
	}
	return 0
}

func (x *TrainingOutput) GetTrials() []*HyperparameterOutput {
	if x != nil {
		return x.Trials
	}
	return nil
}

func (x *TrainingOutput) GetConsumedMlUnits() float64 {
	if x != nil {
		return x.ConsumedMlUnits
	}
	return 0
}

func (x *TrainingOutput) GetIsHyperparameterTuningJob() bool {
	if x != nil {
		return x.IsHyperparameterTuningJob
	}
	return false
}

// Represents input parameters for a prediction job.
type PredictionInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model or the version to use for prediction.
	//
	// Types that are assignable to ModelVersion:
	//	*PredictionInput_ModelName
	//	*PredictionInput_VersionName
	//	*PredictionInput_Uri
	ModelVersion isPredictionInput_ModelVersion `protobuf_oneof:"model_version"`
	// Required. The format of the input data files.
	DataFormat PredictionInput_DataFormat `protobuf:"varint,3,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.ml.v1.PredictionInput_DataFormat" json:"data_format,omitempty"`
	// Required. The Google Cloud Storage location of the input data files.
	// May contain wildcards.
	InputPaths []string `protobuf:"bytes,4,rep,name=input_paths,json=inputPaths,proto3" json:"input_paths,omitempty"`
	// Required. The output Google Cloud Storage location.
	OutputPath string `protobuf:"bytes,5,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
	// Optional. The maximum number of workers to be used for parallel processing.
	// Defaults to 10 if not specified.
	MaxWorkerCount int64 `protobuf:"varint,6,opt,name=max_worker_count,json=maxWorkerCount,proto3" json:"max_worker_count,omitempty"`
	// Required. The Google Compute Engine region to run the prediction job in.
	Region string `protobuf:"bytes,7,opt,name=region,proto3" json:"region,omitempty"`
	// Optional. The Google Cloud ML runtime version to use for this batch
	// prediction. If not set, Google Cloud ML will pick the runtime version used
	// during the CreateVersion request for this model version, or choose the
	// latest stable version when model version information is not available
	// such as when the model is specified by uri.
	RuntimeVersion string `protobuf:"bytes,8,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
}

func (x *PredictionInput) Reset() {
	*x = PredictionInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredictionInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictionInput) ProtoMessage() {}

func (x *PredictionInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictionInput.ProtoReflect.Descriptor instead.
func (*PredictionInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{5}
}

func (m *PredictionInput) GetModelVersion() isPredictionInput_ModelVersion {
	if m != nil {
		return m.ModelVersion
	}
	return nil
}

func (x *PredictionInput) GetModelName() string {
	if x, ok := x.GetModelVersion().(*PredictionInput_ModelName); ok {
		return x.ModelName
	}
	return ""
}

func (x *PredictionInput) GetVersionName() string {
	if x, ok := x.GetModelVersion().(*PredictionInput_VersionName); ok {
		return x.VersionName
	}
	return ""
}

func (x *PredictionInput) GetUri() string {
	if x, ok := x.GetModelVersion().(*PredictionInput_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *PredictionInput) GetDataFormat() PredictionInput_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return PredictionInput_DATA_FORMAT_UNSPECIFIED
}

func (x *PredictionInput) GetInputPaths() []string {
	if x != nil {
		return x.InputPaths
	}
	return nil
}

func (x *PredictionInput) GetOutputPath() string {
	if x != nil {
		return x.OutputPath
	}
	return ""
}

func (x *PredictionInput) GetMaxWorkerCount() int64 {
	if x != nil {
		return x.MaxWorkerCount
	}
	return 0
}

func (x *PredictionInput) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *PredictionInput) GetRuntimeVersion() string {
	if x != nil {
		return x.RuntimeVersion
	}
	return ""
}

type isPredictionInput_ModelVersion interface {
	isPredictionInput_ModelVersion()
}

type PredictionInput_ModelName struct {
	// Use this field if you want to use the default version for the specified
	// model. The string must use the following format:
	//
	// `"projects/<var>[YOUR_PROJECT]</var>/models/<var>[YOUR_MODEL]</var>"`
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3,oneof"`
}

type PredictionInput_VersionName struct {
	// Use this field if you want to specify a version of the model to use. The
	// string is formatted the same way as `model_version`, with the addition
	// of the version information:
	//
	// `"projects/<var>[YOUR_PROJECT]</var>/models/<var>YOUR_MODEL/versions/<var>[YOUR_VERSION]</var>"`
	VersionName string `protobuf:"bytes,2,opt,name=version_name,json=versionName,proto3,oneof"`
}

type PredictionInput_Uri struct {
	// Use this field if you want to specify a Google Cloud Storage path for
	// the model to use.
	Uri string `protobuf:"bytes,9,opt,name=uri,proto3,oneof"`
}

func (*PredictionInput_ModelName) isPredictionInput_ModelVersion() {}

func (*PredictionInput_VersionName) isPredictionInput_ModelVersion() {}

func (*PredictionInput_Uri) isPredictionInput_ModelVersion() {}

// Represents results of a prediction job.
type PredictionOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output Google Cloud Storage location provided at the job creation time.
	OutputPath string `protobuf:"bytes,1,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
	// The number of generated predictions.
	PredictionCount int64 `protobuf:"varint,2,opt,name=prediction_count,json=predictionCount,proto3" json:"prediction_count,omitempty"`
	// The number of data instances which resulted in errors.
	ErrorCount int64 `protobuf:"varint,3,opt,name=error_count,json=errorCount,proto3" json:"error_count,omitempty"`
	// Node hours used by the batch prediction job.
	NodeHours float64 `protobuf:"fixed64,4,opt,name=node_hours,json=nodeHours,proto3" json:"node_hours,omitempty"`
}

func (x *PredictionOutput) Reset() {
	*x = PredictionOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PredictionOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictionOutput) ProtoMessage() {}

func (x *PredictionOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictionOutput.ProtoReflect.Descriptor instead.
func (*PredictionOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{6}
}

func (x *PredictionOutput) GetOutputPath() string {
	if x != nil {
		return x.OutputPath
	}
	return ""
}

func (x *PredictionOutput) GetPredictionCount() int64 {
	if x != nil {
		return x.PredictionCount
	}
	return 0
}

func (x *PredictionOutput) GetErrorCount() int64 {
	if x != nil {
		return x.ErrorCount
	}
	return 0
}

func (x *PredictionOutput) GetNodeHours() float64 {
	if x != nil {
		return x.NodeHours
	}
	return 0
}

// Represents a training or prediction job.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user-specified id of the job.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Required. Parameters to create a job.
	//
	// Types that are assignable to Input:
	//	*Job_TrainingInput
	//	*Job_PredictionInput
	Input isJob_Input `protobuf_oneof:"input"`
	// Output only. When the job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. When the job processing was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. When the job processing was completed.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The detailed state of a job.
	State Job_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.ml.v1.Job_State" json:"state,omitempty"`
	// Output only. The details of a failure or a cancellation.
	ErrorMessage string `protobuf:"bytes,8,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Output only. The current result of the job.
	//
	// Types that are assignable to Output:
	//	*Job_TrainingOutput
	//	*Job_PredictionOutput
	Output isJob_Output `protobuf_oneof:"output"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{7}
}

func (x *Job) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (m *Job) GetInput() isJob_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *Job) GetTrainingInput() *TrainingInput {
	if x, ok := x.GetInput().(*Job_TrainingInput); ok {
		return x.TrainingInput
	}
	return nil
}

func (x *Job) GetPredictionInput() *PredictionInput {
	if x, ok := x.GetInput().(*Job_PredictionInput); ok {
		return x.PredictionInput
	}
	return nil
}

func (x *Job) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Job) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Job) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Job) GetState() Job_State {
	if x != nil {
		return x.State
	}
	return Job_STATE_UNSPECIFIED
}

func (x *Job) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (m *Job) GetOutput() isJob_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *Job) GetTrainingOutput() *TrainingOutput {
	if x, ok := x.GetOutput().(*Job_TrainingOutput); ok {
		return x.TrainingOutput
	}
	return nil
}

func (x *Job) GetPredictionOutput() *PredictionOutput {
	if x, ok := x.GetOutput().(*Job_PredictionOutput); ok {
		return x.PredictionOutput
	}
	return nil
}

type isJob_Input interface {
	isJob_Input()
}

type Job_TrainingInput struct {
	// Input parameters to create a training job.
	TrainingInput *TrainingInput `protobuf:"bytes,2,opt,name=training_input,json=trainingInput,proto3,oneof"`
}

type Job_PredictionInput struct {
	// Input parameters to create a prediction job.
	PredictionInput *PredictionInput `protobuf:"bytes,3,opt,name=prediction_input,json=predictionInput,proto3,oneof"`
}

func (*Job_TrainingInput) isJob_Input() {}

func (*Job_PredictionInput) isJob_Input() {}

type isJob_Output interface {
	isJob_Output()
}

type Job_TrainingOutput struct {
	// The current training job result.
	TrainingOutput *TrainingOutput `protobuf:"bytes,9,opt,name=training_output,json=trainingOutput,proto3,oneof"`
}

type Job_PredictionOutput struct {
	// The current prediction job result.
	PredictionOutput *PredictionOutput `protobuf:"bytes,10,opt,name=prediction_output,json=predictionOutput,proto3,oneof"`
}

func (*Job_TrainingOutput) isJob_Output() {}

func (*Job_PredictionOutput) isJob_Output() {}

// Request message for the CreateJob method.
type CreateJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project name.
	//
	// Authorization: requires `Editor` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The job to create.
	Job *Job `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *CreateJobRequest) Reset() {
	*x = CreateJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateJobRequest) ProtoMessage() {}

func (x *CreateJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateJobRequest.ProtoReflect.Descriptor instead.
func (*CreateJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{8}
}

func (x *CreateJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateJobRequest) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Request message for the ListJobs method.
type ListJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project for which to list jobs.
	//
	// Authorization: requires `Viewer` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Specifies the subset of jobs to retrieve.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. A page token to request the next page of results.
	//
	// You get the token from the `next_page_token` field of the response from
	// the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The number of jobs to retrieve per "page" of results. If there
	// are more remaining results than this number, the response message will
	// contain a valid value in the `next_page_token` field.
	//
	// The default value is 20, and the maximum page size is 100.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListJobsRequest) Reset() {
	*x = ListJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobsRequest) ProtoMessage() {}

func (x *ListJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobsRequest.ProtoReflect.Descriptor instead.
func (*ListJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for the ListJobs method.
type ListJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of jobs.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Optional. Pass this token as the `page_token` field of the request for a
	// subsequent call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListJobsResponse) Reset() {
	*x = ListJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobsResponse) ProtoMessage() {}

func (x *ListJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobsResponse.ProtoReflect.Descriptor instead.
func (*ListJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListJobsResponse) GetJobs() []*Job {
	if x != nil {
		return x.Jobs
	}
	return nil
}

func (x *ListJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the GetJob method.
type GetJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the job to get the description of.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetJobRequest) Reset() {
	*x = GetJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobRequest) ProtoMessage() {}

func (x *GetJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobRequest.ProtoReflect.Descriptor instead.
func (*GetJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{11}
}

func (x *GetJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the CancelJob method.
type CancelJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the job to cancel.
	//
	// Authorization: requires `Editor` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelJobRequest) Reset() {
	*x = CancelJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelJobRequest) ProtoMessage() {}

func (x *CancelJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelJobRequest.ProtoReflect.Descriptor instead.
func (*CancelJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{12}
}

func (x *CancelJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An observed value of a metric.
type HyperparameterOutput_HyperparameterMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The global training step for this metric.
	TrainingStep int64 `protobuf:"varint,1,opt,name=training_step,json=trainingStep,proto3" json:"training_step,omitempty"`
	// The objective value at this training step.
	ObjectiveValue float64 `protobuf:"fixed64,2,opt,name=objective_value,json=objectiveValue,proto3" json:"objective_value,omitempty"`
}

func (x *HyperparameterOutput_HyperparameterMetric) Reset() {
	*x = HyperparameterOutput_HyperparameterMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HyperparameterOutput_HyperparameterMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HyperparameterOutput_HyperparameterMetric) ProtoMessage() {}

func (x *HyperparameterOutput_HyperparameterMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_ml_v1_job_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HyperparameterOutput_HyperparameterMetric.ProtoReflect.Descriptor instead.
func (*HyperparameterOutput_HyperparameterMetric) Descriptor() ([]byte, []int) {
	return file_google_cloud_ml_v1_job_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *HyperparameterOutput_HyperparameterMetric) GetTrainingStep() int64 {
	if x != nil {
		return x.TrainingStep
	}
	return 0
}

func (x *HyperparameterOutput_HyperparameterMetric) GetObjectiveValue() float64 {
	if x != nil {
		return x.ObjectiveValue
	}
	return 0
}

var File_google_cloud_ml_v1_job_service_proto protoreflect.FileDescriptor

var file_google_cloud_ml_v1_job_service_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x84, 0x05,
	0x0a, 0x0d, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x4a, 0x0a, 0x0a, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x69, 0x65, 0x72,
	0x52, 0x09, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x69, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x32, 0x0a,
	0x15, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x50, 0x0a, 0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x0a, 0x07, 0x6a, 0x6f, 0x62, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6a, 0x6f, 0x62, 0x44, 0x69, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x50, 0x0a, 0x09, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x69, 0x65, 0x72, 0x12,
	0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x54,
	0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x31, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52,
	0x45, 0x4d, 0x49, 0x55, 0x4d, 0x5f, 0x31, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x41, 0x53,
	0x49, 0x43, 0x5f, 0x47, 0x50, 0x55, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54,
	0x4f, 0x4d, 0x10, 0x05, 0x22, 0xe2, 0x02, 0x0a, 0x12, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x43, 0x0a, 0x04, 0x67,
	0x6f, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x67, 0x6f, 0x61, 0x6c,
	0x12, 0x39, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6d,
	0x61, 0x78, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x6d, 0x61, 0x78, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61,
	0x78, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x61,
	0x6c, 0x6c, 0x65, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x3a, 0x0a, 0x19, 0x68, 0x79,
	0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x68,
	0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x54, 0x61, 0x67, 0x22, 0x41, 0x0a, 0x08, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x4f, 0x41, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x4d, 0x41, 0x58, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4d,
	0x49, 0x4e, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x10, 0x02, 0x22, 0xa0, 0x04, 0x0a, 0x0d, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x25, 0x0a, 0x0e, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x63, 0x72, 0x65, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x01, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x63, 0x72,
	0x65, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0a, 0x73, 0x63, 0x61,
	0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x73, 0x63, 0x61, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x67, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45,
	0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x02, 0x12,
	0x0f, 0x0a, 0x0b, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x03,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x43, 0x52, 0x45, 0x54, 0x45, 0x10, 0x04, 0x22, 0x5c,
	0x0a, 0x09, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e,
	0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x55, 0x4e, 0x49, 0x54, 0x5f, 0x4c, 0x49,
	0x4e, 0x45, 0x41, 0x52, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e,
	0x55, 0x4e, 0x49, 0x54, 0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x02,
	0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x49, 0x54, 0x5f, 0x52, 0x45, 0x56, 0x45, 0x52, 0x53, 0x45,
	0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x03, 0x22, 0x86, 0x04, 0x0a,
	0x14, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49, 0x64,
	0x12, 0x67, 0x0a, 0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x60, 0x0a, 0x0c, 0x66, 0x69, 0x6e,
	0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0b,
	0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x5e, 0x0a, 0x0b, 0x61,
	0x6c, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52,
	0x0a, 0x61, 0x6c, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0x64, 0x0a, 0x14, 0x48,
	0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x65, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x0e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x1a, 0x42, 0x0a, 0x14, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xf3, 0x01, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x06,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x5f, 0x6d, 0x6c, 0x5f, 0x75, 0x6e,
	0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x64, 0x4d, 0x6c, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x1c, 0x69, 0x73,
	0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f,
	0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x19, 0x69, 0x73, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x22, 0xd2, 0x03, 0x0a, 0x0f,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x1f, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x4f, 0x0a, 0x0b, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x28, 0x0a, 0x10,
	0x6d, 0x61, 0x78, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x27,
	0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x56, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f,
	0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45, 0x58, 0x54, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x54, 0x46, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x54,
	0x46, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x5f, 0x47, 0x5a, 0x49, 0x50, 0x10, 0x03, 0x42,
	0x0f, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x9e, 0x01, 0x0a, 0x10, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x48, 0x6f, 0x75, 0x72,
	0x73, 0x22, 0xfd, 0x05, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64,
	0x12, 0x4a, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x50, 0x0a, 0x10,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x48, 0x01, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x53, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x48, 0x01, 0x52, 0x10, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x80, 0x01, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x45, 0x50,
	0x41, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12,
	0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x42, 0x07,
	0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x22, 0x55, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a,
	0x03, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x7d, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74,
	0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x67, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4a,
	0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x04, 0x6a,
	0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x52, 0x04, 0x6a, 0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x23, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x26, 0x0a, 0x10, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xe7, 0x03,
	0x0a, 0x0a, 0x4a, 0x6f, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x75, 0x0a, 0x09,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23,
	0x22, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x3a, 0x03,
	0x6a, 0x6f, 0x62, 0x12, 0x7b, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73,
	0x12, 0x6a, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x79, 0x0a, 0x09,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4a, 0x6f, 0x62, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x22,
	0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x3a, 0x01, 0x2a, 0x42, 0x65, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6c, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x4a, 0x6f, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x6d, 0x6c, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_ml_v1_job_service_proto_rawDescOnce sync.Once
	file_google_cloud_ml_v1_job_service_proto_rawDescData = file_google_cloud_ml_v1_job_service_proto_rawDesc
)

func file_google_cloud_ml_v1_job_service_proto_rawDescGZIP() []byte {
	file_google_cloud_ml_v1_job_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_ml_v1_job_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_ml_v1_job_service_proto_rawDescData)
	})
	return file_google_cloud_ml_v1_job_service_proto_rawDescData
}

var file_google_cloud_ml_v1_job_service_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_ml_v1_job_service_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_ml_v1_job_service_proto_goTypes = []interface{}{
	(TrainingInput_ScaleTier)(0),                      // 0: google.cloud.ml.v1.TrainingInput.ScaleTier
	(HyperparameterSpec_GoalType)(0),                  // 1: google.cloud.ml.v1.HyperparameterSpec.GoalType
	(ParameterSpec_ParameterType)(0),                  // 2: google.cloud.ml.v1.ParameterSpec.ParameterType
	(ParameterSpec_ScaleType)(0),                      // 3: google.cloud.ml.v1.ParameterSpec.ScaleType
	(PredictionInput_DataFormat)(0),                   // 4: google.cloud.ml.v1.PredictionInput.DataFormat
	(Job_State)(0),                                    // 5: google.cloud.ml.v1.Job.State
	(*TrainingInput)(nil),                             // 6: google.cloud.ml.v1.TrainingInput
	(*HyperparameterSpec)(nil),                        // 7: google.cloud.ml.v1.HyperparameterSpec
	(*ParameterSpec)(nil),                             // 8: google.cloud.ml.v1.ParameterSpec
	(*HyperparameterOutput)(nil),                      // 9: google.cloud.ml.v1.HyperparameterOutput
	(*TrainingOutput)(nil),                            // 10: google.cloud.ml.v1.TrainingOutput
	(*PredictionInput)(nil),                           // 11: google.cloud.ml.v1.PredictionInput
	(*PredictionOutput)(nil),                          // 12: google.cloud.ml.v1.PredictionOutput
	(*Job)(nil),                                       // 13: google.cloud.ml.v1.Job
	(*CreateJobRequest)(nil),                          // 14: google.cloud.ml.v1.CreateJobRequest
	(*ListJobsRequest)(nil),                           // 15: google.cloud.ml.v1.ListJobsRequest
	(*ListJobsResponse)(nil),                          // 16: google.cloud.ml.v1.ListJobsResponse
	(*GetJobRequest)(nil),                             // 17: google.cloud.ml.v1.GetJobRequest
	(*CancelJobRequest)(nil),                          // 18: google.cloud.ml.v1.CancelJobRequest
	(*HyperparameterOutput_HyperparameterMetric)(nil), // 19: google.cloud.ml.v1.HyperparameterOutput.HyperparameterMetric
	nil,                           // 20: google.cloud.ml.v1.HyperparameterOutput.HyperparametersEntry
	(*timestamppb.Timestamp)(nil), // 21: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),         // 22: google.protobuf.Empty
}
var file_google_cloud_ml_v1_job_service_proto_depIdxs = []int32{
	0,  // 0: google.cloud.ml.v1.TrainingInput.scale_tier:type_name -> google.cloud.ml.v1.TrainingInput.ScaleTier
	7,  // 1: google.cloud.ml.v1.TrainingInput.hyperparameters:type_name -> google.cloud.ml.v1.HyperparameterSpec
	1,  // 2: google.cloud.ml.v1.HyperparameterSpec.goal:type_name -> google.cloud.ml.v1.HyperparameterSpec.GoalType
	8,  // 3: google.cloud.ml.v1.HyperparameterSpec.params:type_name -> google.cloud.ml.v1.ParameterSpec
	2,  // 4: google.cloud.ml.v1.ParameterSpec.type:type_name -> google.cloud.ml.v1.ParameterSpec.ParameterType
	3,  // 5: google.cloud.ml.v1.ParameterSpec.scale_type:type_name -> google.cloud.ml.v1.ParameterSpec.ScaleType
	20, // 6: google.cloud.ml.v1.HyperparameterOutput.hyperparameters:type_name -> google.cloud.ml.v1.HyperparameterOutput.HyperparametersEntry
	19, // 7: google.cloud.ml.v1.HyperparameterOutput.final_metric:type_name -> google.cloud.ml.v1.HyperparameterOutput.HyperparameterMetric
	19, // 8: google.cloud.ml.v1.HyperparameterOutput.all_metrics:type_name -> google.cloud.ml.v1.HyperparameterOutput.HyperparameterMetric
	9,  // 9: google.cloud.ml.v1.TrainingOutput.trials:type_name -> google.cloud.ml.v1.HyperparameterOutput
	4,  // 10: google.cloud.ml.v1.PredictionInput.data_format:type_name -> google.cloud.ml.v1.PredictionInput.DataFormat
	6,  // 11: google.cloud.ml.v1.Job.training_input:type_name -> google.cloud.ml.v1.TrainingInput
	11, // 12: google.cloud.ml.v1.Job.prediction_input:type_name -> google.cloud.ml.v1.PredictionInput
	21, // 13: google.cloud.ml.v1.Job.create_time:type_name -> google.protobuf.Timestamp
	21, // 14: google.cloud.ml.v1.Job.start_time:type_name -> google.protobuf.Timestamp
	21, // 15: google.cloud.ml.v1.Job.end_time:type_name -> google.protobuf.Timestamp
	5,  // 16: google.cloud.ml.v1.Job.state:type_name -> google.cloud.ml.v1.Job.State
	10, // 17: google.cloud.ml.v1.Job.training_output:type_name -> google.cloud.ml.v1.TrainingOutput
	12, // 18: google.cloud.ml.v1.Job.prediction_output:type_name -> google.cloud.ml.v1.PredictionOutput
	13, // 19: google.cloud.ml.v1.CreateJobRequest.job:type_name -> google.cloud.ml.v1.Job
	13, // 20: google.cloud.ml.v1.ListJobsResponse.jobs:type_name -> google.cloud.ml.v1.Job
	14, // 21: google.cloud.ml.v1.JobService.CreateJob:input_type -> google.cloud.ml.v1.CreateJobRequest
	15, // 22: google.cloud.ml.v1.JobService.ListJobs:input_type -> google.cloud.ml.v1.ListJobsRequest
	17, // 23: google.cloud.ml.v1.JobService.GetJob:input_type -> google.cloud.ml.v1.GetJobRequest
	18, // 24: google.cloud.ml.v1.JobService.CancelJob:input_type -> google.cloud.ml.v1.CancelJobRequest
	13, // 25: google.cloud.ml.v1.JobService.CreateJob:output_type -> google.cloud.ml.v1.Job
	16, // 26: google.cloud.ml.v1.JobService.ListJobs:output_type -> google.cloud.ml.v1.ListJobsResponse
	13, // 27: google.cloud.ml.v1.JobService.GetJob:output_type -> google.cloud.ml.v1.Job
	22, // 28: google.cloud.ml.v1.JobService.CancelJob:output_type -> google.protobuf.Empty
	25, // [25:29] is the sub-list for method output_type
	21, // [21:25] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_ml_v1_job_service_proto_init() }
func file_google_cloud_ml_v1_job_service_proto_init() {
	if File_google_cloud_ml_v1_job_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_ml_v1_job_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainingInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HyperparameterSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ParameterSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HyperparameterOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainingOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredictionInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PredictionOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_ml_v1_job_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HyperparameterOutput_HyperparameterMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_ml_v1_job_service_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*PredictionInput_ModelName)(nil),
		(*PredictionInput_VersionName)(nil),
		(*PredictionInput_Uri)(nil),
	}
	file_google_cloud_ml_v1_job_service_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Job_TrainingInput)(nil),
		(*Job_PredictionInput)(nil),
		(*Job_TrainingOutput)(nil),
		(*Job_PredictionOutput)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_ml_v1_job_service_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_ml_v1_job_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_ml_v1_job_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_ml_v1_job_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_ml_v1_job_service_proto_msgTypes,
	}.Build()
	File_google_cloud_ml_v1_job_service_proto = out.File
	file_google_cloud_ml_v1_job_service_proto_rawDesc = nil
	file_google_cloud_ml_v1_job_service_proto_goTypes = nil
	file_google_cloud_ml_v1_job_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Creates a training or a batch prediction job.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Lists the jobs in the project.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Describes a job.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Cancels a running job.
	CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type jobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewJobServiceClient(cc grpc.ClientConnInterface) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.JobService/CreateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.JobService/ListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.JobService/GetJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.JobService/CancelJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Creates a training or a batch prediction job.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Lists the jobs in the project.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Describes a job.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Cancels a running job.
	CancelJob(context.Context, *CancelJobRequest) (*emptypb.Empty, error)
}

// UnimplementedJobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedJobServiceServer struct {
}

func (*UnimplementedJobServiceServer) CreateJob(context.Context, *CreateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJob not implemented")
}
func (*UnimplementedJobServiceServer) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (*UnimplementedJobServiceServer) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (*UnimplementedJobServiceServer) CancelJob(context.Context, *CancelJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelJob not implemented")
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.JobService/CreateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.JobService/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.JobService/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CancelJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CancelJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.JobService/CancelJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CancelJob(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.ml.v1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobService_CreateJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobService_ListJobs_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobService_GetJob_Handler,
		},
		{
			MethodName: "CancelJob",
			Handler:    _JobService_CancelJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/ml/v1/job_service.proto",
}
