// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package servicequotasiface provides an interface to enable mocking the Service Quotas service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package servicequotasiface

import (
	"github.com/aws/aws-sdk-go-v2/service/servicequotas"
)

// ClientAPI provides an interface to enable mocking the
// servicequotas.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Service Quotas.
//    func myFunc(svc servicequotasiface.ClientAPI) bool {
//        // Make svc.AssociateServiceQuotaTemplate request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := servicequotas.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        servicequotasiface.ClientPI
//    }
//    func (m *mockClientClient) AssociateServiceQuotaTemplate(input *servicequotas.AssociateServiceQuotaTemplateInput) (*servicequotas.AssociateServiceQuotaTemplateOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateServiceQuotaTemplateRequest(*servicequotas.AssociateServiceQuotaTemplateInput) servicequotas.AssociateServiceQuotaTemplateRequest

	DeleteServiceQuotaIncreaseRequestFromTemplateRequest(*servicequotas.DeleteServiceQuotaIncreaseRequestFromTemplateInput) servicequotas.DeleteServiceQuotaIncreaseRequestFromTemplateRequest

	DisassociateServiceQuotaTemplateRequest(*servicequotas.DisassociateServiceQuotaTemplateInput) servicequotas.DisassociateServiceQuotaTemplateRequest

	GetAWSDefaultServiceQuotaRequest(*servicequotas.GetAWSDefaultServiceQuotaInput) servicequotas.GetAWSDefaultServiceQuotaRequest

	GetAssociationForServiceQuotaTemplateRequest(*servicequotas.GetAssociationForServiceQuotaTemplateInput) servicequotas.GetAssociationForServiceQuotaTemplateRequest

	GetRequestedServiceQuotaChangeRequest(*servicequotas.GetRequestedServiceQuotaChangeInput) servicequotas.GetRequestedServiceQuotaChangeRequest

	GetServiceQuotaRequest(*servicequotas.GetServiceQuotaInput) servicequotas.GetServiceQuotaRequest

	GetServiceQuotaIncreaseRequestFromTemplateRequest(*servicequotas.GetServiceQuotaIncreaseRequestFromTemplateInput) servicequotas.GetServiceQuotaIncreaseRequestFromTemplateRequest

	ListAWSDefaultServiceQuotasRequest(*servicequotas.ListAWSDefaultServiceQuotasInput) servicequotas.ListAWSDefaultServiceQuotasRequest

	ListRequestedServiceQuotaChangeHistoryRequest(*servicequotas.ListRequestedServiceQuotaChangeHistoryInput) servicequotas.ListRequestedServiceQuotaChangeHistoryRequest

	ListRequestedServiceQuotaChangeHistoryByQuotaRequest(*servicequotas.ListRequestedServiceQuotaChangeHistoryByQuotaInput) servicequotas.ListRequestedServiceQuotaChangeHistoryByQuotaRequest

	ListServiceQuotaIncreaseRequestsInTemplateRequest(*servicequotas.ListServiceQuotaIncreaseRequestsInTemplateInput) servicequotas.ListServiceQuotaIncreaseRequestsInTemplateRequest

	ListServiceQuotasRequest(*servicequotas.ListServiceQuotasInput) servicequotas.ListServiceQuotasRequest

	ListServicesRequest(*servicequotas.ListServicesInput) servicequotas.ListServicesRequest

	PutServiceQuotaIncreaseRequestIntoTemplateRequest(*servicequotas.PutServiceQuotaIncreaseRequestIntoTemplateInput) servicequotas.PutServiceQuotaIncreaseRequestIntoTemplateRequest

	RequestServiceQuotaIncreaseRequest(*servicequotas.RequestServiceQuotaIncreaseInput) servicequotas.RequestServiceQuotaIncreaseRequest
}

var _ ClientAPI = (*servicequotas.Client)(nil)
