// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetSystemTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system to get. This ID must be in the user's namespace.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The number that specifies the revision of the system to get.
	RevisionNumber *int64 `locationName:"revisionNumber" type:"long"`
}

// String returns the string representation
func (s GetSystemTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSystemTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSystemTemplateInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetSystemTemplateOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains summary data about the system.
	Description *SystemTemplateDescription `locationName:"description" type:"structure"`
}

// String returns the string representation
func (s GetSystemTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSystemTemplate = "GetSystemTemplate"

// GetSystemTemplateRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Gets a system.
//
//    // Example sending a request using GetSystemTemplateRequest.
//    req := client.GetSystemTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate
func (c *Client) GetSystemTemplateRequest(input *GetSystemTemplateInput) GetSystemTemplateRequest {
	op := &aws.Operation{
		Name:       opGetSystemTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSystemTemplateInput{}
	}

	req := c.newRequest(op, input, &GetSystemTemplateOutput{})
	return GetSystemTemplateRequest{Request: req, Input: input, Copy: c.GetSystemTemplateRequest}
}

// GetSystemTemplateRequest is the request type for the
// GetSystemTemplate API operation.
type GetSystemTemplateRequest struct {
	*aws.Request
	Input *GetSystemTemplateInput
	Copy  func(*GetSystemTemplateInput) GetSystemTemplateRequest
}

// Send marshals and sends the GetSystemTemplate API request.
func (r GetSystemTemplateRequest) Send(ctx context.Context) (*GetSystemTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSystemTemplateResponse{
		GetSystemTemplateOutput: r.Request.Data.(*GetSystemTemplateOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSystemTemplateResponse is the response type for the
// GetSystemTemplate API operation.
type GetSystemTemplateResponse struct {
	*GetSystemTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSystemTemplate request.
func (r *GetSystemTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
