// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloud9_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/cloud9"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// CreateEnvironmentEC2
//

func ExampleClient_CreateEnvironmentEC2Request_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.CreateEnvironmentEC2Input{
		AutomaticStopTimeMinutes: aws.Int64(60),
		Description:              aws.String("This is my demonstration environment."),
		InstanceType:             aws.String("t2.micro"),
		Name:                     aws.String("my-demo-environment"),
		OwnerArn:                 aws.String("arn:aws:iam::123456789012:user/MyDemoUser"),
		SubnetId:                 aws.String("subnet-1fab8aEX"),
	}

	req := svc.CreateEnvironmentEC2Request(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateEnvironmentMembership
//

func ExampleClient_CreateEnvironmentMembershipRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.CreateEnvironmentMembershipInput{
		EnvironmentId: aws.String("8d9967e2f0624182b74e7690ad69ebEX"),
		Permissions:   cloud9.MemberPermissionsReadWrite,
		UserArn:       aws.String("arn:aws:iam::123456789012:user/AnotherDemoUser"),
	}

	req := svc.CreateEnvironmentMembershipRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DeleteEnvironment
//

func ExampleClient_DeleteEnvironmentRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.DeleteEnvironmentInput{
		EnvironmentId: aws.String("8d9967e2f0624182b74e7690ad69ebEX"),
	}

	req := svc.DeleteEnvironmentRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DeleteEnvironmentMembership
//

func ExampleClient_DeleteEnvironmentMembershipRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.DeleteEnvironmentMembershipInput{
		EnvironmentId: aws.String("8d9967e2f0624182b74e7690ad69ebEX"),
		UserArn:       aws.String("arn:aws:iam::123456789012:user/AnotherDemoUser"),
	}

	req := svc.DeleteEnvironmentMembershipRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeEnvironmentMemberships1
//
// The following example gets information about all of the environment members for the
// specified AWS Cloud9 development environment.
func ExampleClient_DescribeEnvironmentMembershipsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.DescribeEnvironmentMembershipsInput{
		EnvironmentId: aws.String("8d9967e2f0624182b74e7690ad69ebEX"),
	}

	req := svc.DescribeEnvironmentMembershipsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeEnvironmentMemberships2
//
// The following example gets information about the owner of the specified AWS Cloud9
// development environment.
func ExampleClient_DescribeEnvironmentMembershipsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.DescribeEnvironmentMembershipsInput{
		EnvironmentId: aws.String("8d9967e2f0624182b74e7690ad69ebEX"),
		Permissions: []cloud9.Permissions{
			cloud9.Permissions("owner"),
		},
	}

	req := svc.DescribeEnvironmentMembershipsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeEnvironmentMemberships3
//
// The following example gets AWS Cloud9 development environment membership information
// for the specified user.
func ExampleClient_DescribeEnvironmentMembershipsRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.DescribeEnvironmentMembershipsInput{
		UserArn: aws.String("arn:aws:iam::123456789012:user/MyDemoUser"),
	}

	req := svc.DescribeEnvironmentMembershipsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeEnvironmentStatus
//

func ExampleClient_DescribeEnvironmentStatusRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.DescribeEnvironmentStatusInput{
		EnvironmentId: aws.String("8d9967e2f0624182b74e7690ad69ebEX"),
	}

	req := svc.DescribeEnvironmentStatusRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeEnvironments
//

func ExampleClient_DescribeEnvironmentsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.DescribeEnvironmentsInput{
		EnvironmentIds: []string{
			"8d9967e2f0624182b74e7690ad69ebEX",
			"349c86d4579e4e7298d500ff57a6b2EX",
		},
	}

	req := svc.DescribeEnvironmentsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ListEnvironments
//

func ExampleClient_ListEnvironmentsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.ListEnvironmentsInput{}

	req := svc.ListEnvironmentsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// UpdateEnvironment
//

func ExampleClient_UpdateEnvironmentRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.UpdateEnvironmentInput{
		Description:   aws.String("This is my changed demonstration environment."),
		EnvironmentId: aws.String("8d9967e2f0624182b74e7690ad69ebEX"),
		Name:          aws.String("my-changed-demo-environment"),
	}

	req := svc.UpdateEnvironmentRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// UpdateEnvironmentMembership
//

func ExampleClient_UpdateEnvironmentMembershipRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := cloud9.New(cfg)
	input := &cloud9.UpdateEnvironmentMembershipInput{
		EnvironmentId: aws.String("8d9967e2f0624182b74e7690ad69ebEX"),
		Permissions:   cloud9.MemberPermissionsReadOnly,
		UserArn:       aws.String("arn:aws:iam::123456789012:user/AnotherDemoUser"),
	}

	req := svc.UpdateEnvironmentMembershipRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloud9.ErrCodeBadRequestException:
				fmt.Println(cloud9.ErrCodeBadRequestException, aerr.Error())
			case cloud9.ErrCodeConflictException:
				fmt.Println(cloud9.ErrCodeConflictException, aerr.Error())
			case cloud9.ErrCodeNotFoundException:
				fmt.Println(cloud9.ErrCodeNotFoundException, aerr.Error())
			case cloud9.ErrCodeForbiddenException:
				fmt.Println(cloud9.ErrCodeForbiddenException, aerr.Error())
			case cloud9.ErrCodeTooManyRequestsException:
				fmt.Println(cloud9.ErrCodeTooManyRequestsException, aerr.Error())
			case cloud9.ErrCodeLimitExceededException:
				fmt.Println(cloud9.ErrCodeLimitExceededException, aerr.Error())
			case cloud9.ErrCodeInternalServerErrorException:
				fmt.Println(cloud9.ErrCodeInternalServerErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
