// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetachLoadBalancerTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Names (ARN) of the target groups. You can specify up
	// to 10 target groups.
	//
	// TargetGroupARNs is a required field
	TargetGroupARNs []string `type:"list" required:"true"`
}

// String returns the string representation
func (s DetachLoadBalancerTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachLoadBalancerTargetGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachLoadBalancerTargetGroupsInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.TargetGroupARNs == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetGroupARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetachLoadBalancerTargetGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachLoadBalancerTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetachLoadBalancerTargetGroups = "DetachLoadBalancerTargetGroups"

// DetachLoadBalancerTargetGroupsRequest returns a request value for making API operation for
// Auto Scaling.
//
// Detaches one or more target groups from the specified Auto Scaling group.
//
//    // Example sending a request using DetachLoadBalancerTargetGroupsRequest.
//    req := client.DetachLoadBalancerTargetGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups
func (c *Client) DetachLoadBalancerTargetGroupsRequest(input *DetachLoadBalancerTargetGroupsInput) DetachLoadBalancerTargetGroupsRequest {
	op := &aws.Operation{
		Name:       opDetachLoadBalancerTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachLoadBalancerTargetGroupsInput{}
	}

	req := c.newRequest(op, input, &DetachLoadBalancerTargetGroupsOutput{})
	return DetachLoadBalancerTargetGroupsRequest{Request: req, Input: input, Copy: c.DetachLoadBalancerTargetGroupsRequest}
}

// DetachLoadBalancerTargetGroupsRequest is the request type for the
// DetachLoadBalancerTargetGroups API operation.
type DetachLoadBalancerTargetGroupsRequest struct {
	*aws.Request
	Input *DetachLoadBalancerTargetGroupsInput
	Copy  func(*DetachLoadBalancerTargetGroupsInput) DetachLoadBalancerTargetGroupsRequest
}

// Send marshals and sends the DetachLoadBalancerTargetGroups API request.
func (r DetachLoadBalancerTargetGroupsRequest) Send(ctx context.Context) (*DetachLoadBalancerTargetGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachLoadBalancerTargetGroupsResponse{
		DetachLoadBalancerTargetGroupsOutput: r.Request.Data.(*DetachLoadBalancerTargetGroupsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachLoadBalancerTargetGroupsResponse is the response type for the
// DetachLoadBalancerTargetGroups API operation.
type DetachLoadBalancerTargetGroupsResponse struct {
	*DetachLoadBalancerTargetGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachLoadBalancerTargetGroups request.
func (r *DetachLoadBalancerTargetGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
