// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v2/services/mutate_job_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for [MutateJobService.CreateMutateJobRequest][]
type CreateMutateJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer for which to create a mutate job.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
}

func (x *CreateMutateJobRequest) Reset() {
	*x = CreateMutateJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMutateJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMutateJobRequest) ProtoMessage() {}

func (x *CreateMutateJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMutateJobRequest.ProtoReflect.Descriptor instead.
func (*CreateMutateJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateMutateJobRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

// Response message for [MutateJobService.CreateMutateJobResponse][]
type CreateMutateJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MutateJob.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *CreateMutateJobResponse) Reset() {
	*x = CreateMutateJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMutateJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMutateJobResponse) ProtoMessage() {}

func (x *CreateMutateJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMutateJobResponse.ProtoReflect.Descriptor instead.
func (*CreateMutateJobResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateMutateJobResponse) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.GetMutateJob][google.ads.googleads.v2.services.MutateJobService.GetMutateJob]
type GetMutateJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MutateJob to get.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *GetMutateJobRequest) Reset() {
	*x = GetMutateJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMutateJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMutateJobRequest) ProtoMessage() {}

func (x *GetMutateJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMutateJobRequest.ProtoReflect.Descriptor instead.
func (*GetMutateJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetMutateJobRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.RunMutateJob][google.ads.googleads.v2.services.MutateJobService.RunMutateJob]
type RunMutateJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MutateJob to run.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *RunMutateJobRequest) Reset() {
	*x = RunMutateJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunMutateJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunMutateJobRequest) ProtoMessage() {}

func (x *RunMutateJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunMutateJobRequest.ProtoReflect.Descriptor instead.
func (*RunMutateJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{3}
}

func (x *RunMutateJobRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.AddMutateJobOperations][google.ads.googleads.v2.services.MutateJobService.AddMutateJobOperations]
type AddMutateJobOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MutateJob.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// A token used to enforce sequencing.
	//
	// The first AddMutateJobOperations request for a MutateJob should not set
	// sequence_token. Subsequent requests must set sequence_token to the value of
	// next_sequence_token received in the previous AddMutateJobOperations
	// response.
	SequenceToken string `protobuf:"bytes,2,opt,name=sequence_token,json=sequenceToken,proto3" json:"sequence_token,omitempty"`
	// Required. The list of mutates being added.
	//
	// Operations can use negative integers as temp ids to signify dependencies
	// between entities created in this MutateJob. For example, a customer with
	// id = 1234 can create a campaign and an ad group in that same campaign by
	// creating a campaign in the first operation with the resource name
	// explicitly set to "customers/1234/campaigns/-1", and creating an ad group
	// in the second operation with the campaign field also set to
	// "customers/1234/campaigns/-1".
	MutateOperations []*MutateOperation `protobuf:"bytes,3,rep,name=mutate_operations,json=mutateOperations,proto3" json:"mutate_operations,omitempty"`
}

func (x *AddMutateJobOperationsRequest) Reset() {
	*x = AddMutateJobOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddMutateJobOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddMutateJobOperationsRequest) ProtoMessage() {}

func (x *AddMutateJobOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddMutateJobOperationsRequest.ProtoReflect.Descriptor instead.
func (*AddMutateJobOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{4}
}

func (x *AddMutateJobOperationsRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *AddMutateJobOperationsRequest) GetSequenceToken() string {
	if x != nil {
		return x.SequenceToken
	}
	return ""
}

func (x *AddMutateJobOperationsRequest) GetMutateOperations() []*MutateOperation {
	if x != nil {
		return x.MutateOperations
	}
	return nil
}

// Response message for [MutateJobService.AddMutateJobOperations][google.ads.googleads.v2.services.MutateJobService.AddMutateJobOperations]
type AddMutateJobOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of operations added so far for this job.
	TotalOperations int64 `protobuf:"varint,1,opt,name=total_operations,json=totalOperations,proto3" json:"total_operations,omitempty"`
	// The sequence token to be used when calling AddMutateJobOperations again if
	// more operations need to be added. The next AddMutateJobOperations request
	// must set the sequence_token field to the value of this field.
	NextSequenceToken string `protobuf:"bytes,2,opt,name=next_sequence_token,json=nextSequenceToken,proto3" json:"next_sequence_token,omitempty"`
}

func (x *AddMutateJobOperationsResponse) Reset() {
	*x = AddMutateJobOperationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddMutateJobOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddMutateJobOperationsResponse) ProtoMessage() {}

func (x *AddMutateJobOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddMutateJobOperationsResponse.ProtoReflect.Descriptor instead.
func (*AddMutateJobOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{5}
}

func (x *AddMutateJobOperationsResponse) GetTotalOperations() int64 {
	if x != nil {
		return x.TotalOperations
	}
	return 0
}

func (x *AddMutateJobOperationsResponse) GetNextSequenceToken() string {
	if x != nil {
		return x.NextSequenceToken
	}
	return ""
}

// Request message for [MutateJobService.ListMutateJobResults][google.ads.googleads.v2.services.MutateJobService.ListMutateJobResults].
type ListMutateJobResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MutateJob whose results are being listed.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request
	// the next page of results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When a page request is too large, the server may decide to
	// further limit the number of returned resources.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListMutateJobResultsRequest) Reset() {
	*x = ListMutateJobResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMutateJobResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMutateJobResultsRequest) ProtoMessage() {}

func (x *ListMutateJobResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMutateJobResultsRequest.ProtoReflect.Descriptor instead.
func (*ListMutateJobResultsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListMutateJobResultsRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *ListMutateJobResultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMutateJobResultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for [MutateJobService.ListMutateJobResults][google.ads.googleads.v2.services.MutateJobService.ListMutateJobResults].
type ListMutateJobResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of rows that matched the query.
	Results []*MutateJobResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMutateJobResultsResponse) Reset() {
	*x = ListMutateJobResultsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMutateJobResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMutateJobResultsResponse) ProtoMessage() {}

func (x *ListMutateJobResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMutateJobResultsResponse.ProtoReflect.Descriptor instead.
func (*ListMutateJobResultsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListMutateJobResultsResponse) GetResults() []*MutateJobResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *ListMutateJobResultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// MutateJob result.
type MutateJobResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the mutate operation.
	OperationIndex int64 `protobuf:"varint,1,opt,name=operation_index,json=operationIndex,proto3" json:"operation_index,omitempty"`
	// Response for the mutate.
	// May be empty if errors occurred.
	MutateOperationResponse *MutateOperationResponse `protobuf:"bytes,2,opt,name=mutate_operation_response,json=mutateOperationResponse,proto3" json:"mutate_operation_response,omitempty"`
	// Details of the errors when processing the operation.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *MutateJobResult) Reset() {
	*x = MutateJobResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateJobResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateJobResult) ProtoMessage() {}

func (x *MutateJobResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateJobResult.ProtoReflect.Descriptor instead.
func (*MutateJobResult) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP(), []int{8}
}

func (x *MutateJobResult) GetOperationIndex() int64 {
	if x != nil {
		return x.OperationIndex
	}
	return 0
}

func (x *MutateJobResult) GetMutateOperationResponse() *MutateOperationResponse {
	if x != nil {
		return x.MutateOperationResponse
	}
	return nil
}

func (x *MutateJobResult) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

var File_google_ads_googleads_v2_services_mutate_job_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x32, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3e, 0x0a,
	0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x22, 0x3e, 0x0a,
	0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x13, 0x52, 0x75, 0x6e, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0d,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xfc, 0x01,
	0x0a, 0x1d, 0x41, 0x64, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4f, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x63, 0x0a, 0x11, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x7b, 0x0a, 0x1e,
	0x41, 0x64, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaa, 0x01, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdd, 0x01, 0x0a,
	0x0f, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x75, 0x0a, 0x19, 0x6d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x17, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x32, 0xef, 0x09, 0x0a,
	0x10, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xd0, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x34, 0x22, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d, 0x2a,
	0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x3a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x12, 0xb9, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xe7, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a,
	0x12, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0xda, 0x41, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x8b, 0x02, 0x0a, 0x0c, 0x52,
	0x75, 0x6e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x52,
	0x75, 0x6e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xa4, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x30, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0xca,
	0x41, 0x56, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb6, 0x02, 0x0a, 0x16, 0x41, 0x64, 0x64,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74,
	0x65, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x98, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x22,
	0x3a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64,
	0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x2c, 0x6d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda,
	0x41, 0x1f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xfc,
	0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x15, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a,
	0x6f, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41,
	0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73,
	0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x32, 0x5c, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a,
	0x3a, 0x56, 0x32, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescData = file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDesc
)

func file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDescData
}

var file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_ads_googleads_v2_services_mutate_job_service_proto_goTypes = []interface{}{
	(*CreateMutateJobRequest)(nil),         // 0: google.ads.googleads.v2.services.CreateMutateJobRequest
	(*CreateMutateJobResponse)(nil),        // 1: google.ads.googleads.v2.services.CreateMutateJobResponse
	(*GetMutateJobRequest)(nil),            // 2: google.ads.googleads.v2.services.GetMutateJobRequest
	(*RunMutateJobRequest)(nil),            // 3: google.ads.googleads.v2.services.RunMutateJobRequest
	(*AddMutateJobOperationsRequest)(nil),  // 4: google.ads.googleads.v2.services.AddMutateJobOperationsRequest
	(*AddMutateJobOperationsResponse)(nil), // 5: google.ads.googleads.v2.services.AddMutateJobOperationsResponse
	(*ListMutateJobResultsRequest)(nil),    // 6: google.ads.googleads.v2.services.ListMutateJobResultsRequest
	(*ListMutateJobResultsResponse)(nil),   // 7: google.ads.googleads.v2.services.ListMutateJobResultsResponse
	(*MutateJobResult)(nil),                // 8: google.ads.googleads.v2.services.MutateJobResult
	(*MutateOperation)(nil),                // 9: google.ads.googleads.v2.services.MutateOperation
	(*MutateOperationResponse)(nil),        // 10: google.ads.googleads.v2.services.MutateOperationResponse
	(*status.Status)(nil),                  // 11: google.rpc.Status
	(*resources.MutateJob)(nil),            // 12: google.ads.googleads.v2.resources.MutateJob
	(*longrunning.Operation)(nil),          // 13: google.longrunning.Operation
}
var file_google_ads_googleads_v2_services_mutate_job_service_proto_depIdxs = []int32{
	9,  // 0: google.ads.googleads.v2.services.AddMutateJobOperationsRequest.mutate_operations:type_name -> google.ads.googleads.v2.services.MutateOperation
	8,  // 1: google.ads.googleads.v2.services.ListMutateJobResultsResponse.results:type_name -> google.ads.googleads.v2.services.MutateJobResult
	10, // 2: google.ads.googleads.v2.services.MutateJobResult.mutate_operation_response:type_name -> google.ads.googleads.v2.services.MutateOperationResponse
	11, // 3: google.ads.googleads.v2.services.MutateJobResult.status:type_name -> google.rpc.Status
	0,  // 4: google.ads.googleads.v2.services.MutateJobService.CreateMutateJob:input_type -> google.ads.googleads.v2.services.CreateMutateJobRequest
	2,  // 5: google.ads.googleads.v2.services.MutateJobService.GetMutateJob:input_type -> google.ads.googleads.v2.services.GetMutateJobRequest
	6,  // 6: google.ads.googleads.v2.services.MutateJobService.ListMutateJobResults:input_type -> google.ads.googleads.v2.services.ListMutateJobResultsRequest
	3,  // 7: google.ads.googleads.v2.services.MutateJobService.RunMutateJob:input_type -> google.ads.googleads.v2.services.RunMutateJobRequest
	4,  // 8: google.ads.googleads.v2.services.MutateJobService.AddMutateJobOperations:input_type -> google.ads.googleads.v2.services.AddMutateJobOperationsRequest
	1,  // 9: google.ads.googleads.v2.services.MutateJobService.CreateMutateJob:output_type -> google.ads.googleads.v2.services.CreateMutateJobResponse
	12, // 10: google.ads.googleads.v2.services.MutateJobService.GetMutateJob:output_type -> google.ads.googleads.v2.resources.MutateJob
	7,  // 11: google.ads.googleads.v2.services.MutateJobService.ListMutateJobResults:output_type -> google.ads.googleads.v2.services.ListMutateJobResultsResponse
	13, // 12: google.ads.googleads.v2.services.MutateJobService.RunMutateJob:output_type -> google.longrunning.Operation
	5,  // 13: google.ads.googleads.v2.services.MutateJobService.AddMutateJobOperations:output_type -> google.ads.googleads.v2.services.AddMutateJobOperationsResponse
	9,  // [9:14] is the sub-list for method output_type
	4,  // [4:9] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v2_services_mutate_job_service_proto_init() }
func file_google_ads_googleads_v2_services_mutate_job_service_proto_init() {
	if File_google_ads_googleads_v2_services_mutate_job_service_proto != nil {
		return
	}
	file_google_ads_googleads_v2_services_google_ads_service_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMutateJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMutateJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMutateJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunMutateJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddMutateJobOperationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddMutateJobOperationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMutateJobResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMutateJobResultsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateJobResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v2_services_mutate_job_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v2_services_mutate_job_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v2_services_mutate_job_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v2_services_mutate_job_service_proto = out.File
	file_google_ads_googleads_v2_services_mutate_job_service_proto_rawDesc = nil
	file_google_ads_googleads_v2_services_mutate_job_service_proto_goTypes = nil
	file_google_ads_googleads_v2_services_mutate_job_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MutateJobServiceClient is the client API for MutateJobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MutateJobServiceClient interface {
	// Creates a mutate job.
	CreateMutateJob(ctx context.Context, in *CreateMutateJobRequest, opts ...grpc.CallOption) (*CreateMutateJobResponse, error)
	// Returns the mutate job.
	GetMutateJob(ctx context.Context, in *GetMutateJobRequest, opts ...grpc.CallOption) (*resources.MutateJob, error)
	// Returns the results of the mutate job. The job must be done.
	// Supports standard list paging.
	ListMutateJobResults(ctx context.Context, in *ListMutateJobResultsRequest, opts ...grpc.CallOption) (*ListMutateJobResultsResponse, error)
	// Runs the mutate job.
	//
	// The Operation.metadata field type is MutateJobMetadata. When finished, the
	// long running operation will not contain errors or a response. Instead, use
	// ListMutateJobResults to get the results of the job.
	RunMutateJob(ctx context.Context, in *RunMutateJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Add operations to the mutate job.
	AddMutateJobOperations(ctx context.Context, in *AddMutateJobOperationsRequest, opts ...grpc.CallOption) (*AddMutateJobOperationsResponse, error)
}

type mutateJobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMutateJobServiceClient(cc grpc.ClientConnInterface) MutateJobServiceClient {
	return &mutateJobServiceClient{cc}
}

func (c *mutateJobServiceClient) CreateMutateJob(ctx context.Context, in *CreateMutateJobRequest, opts ...grpc.CallOption) (*CreateMutateJobResponse, error) {
	out := new(CreateMutateJobResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/CreateMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) GetMutateJob(ctx context.Context, in *GetMutateJobRequest, opts ...grpc.CallOption) (*resources.MutateJob, error) {
	out := new(resources.MutateJob)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/GetMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) ListMutateJobResults(ctx context.Context, in *ListMutateJobResultsRequest, opts ...grpc.CallOption) (*ListMutateJobResultsResponse, error) {
	out := new(ListMutateJobResultsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/ListMutateJobResults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) RunMutateJob(ctx context.Context, in *RunMutateJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/RunMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) AddMutateJobOperations(ctx context.Context, in *AddMutateJobOperationsRequest, opts ...grpc.CallOption) (*AddMutateJobOperationsResponse, error) {
	out := new(AddMutateJobOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.MutateJobService/AddMutateJobOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MutateJobServiceServer is the server API for MutateJobService service.
type MutateJobServiceServer interface {
	// Creates a mutate job.
	CreateMutateJob(context.Context, *CreateMutateJobRequest) (*CreateMutateJobResponse, error)
	// Returns the mutate job.
	GetMutateJob(context.Context, *GetMutateJobRequest) (*resources.MutateJob, error)
	// Returns the results of the mutate job. The job must be done.
	// Supports standard list paging.
	ListMutateJobResults(context.Context, *ListMutateJobResultsRequest) (*ListMutateJobResultsResponse, error)
	// Runs the mutate job.
	//
	// The Operation.metadata field type is MutateJobMetadata. When finished, the
	// long running operation will not contain errors or a response. Instead, use
	// ListMutateJobResults to get the results of the job.
	RunMutateJob(context.Context, *RunMutateJobRequest) (*longrunning.Operation, error)
	// Add operations to the mutate job.
	AddMutateJobOperations(context.Context, *AddMutateJobOperationsRequest) (*AddMutateJobOperationsResponse, error)
}

// UnimplementedMutateJobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMutateJobServiceServer struct {
}

func (*UnimplementedMutateJobServiceServer) CreateMutateJob(context.Context, *CreateMutateJobRequest) (*CreateMutateJobResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateMutateJob not implemented")
}
func (*UnimplementedMutateJobServiceServer) GetMutateJob(context.Context, *GetMutateJobRequest) (*resources.MutateJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetMutateJob not implemented")
}
func (*UnimplementedMutateJobServiceServer) ListMutateJobResults(context.Context, *ListMutateJobResultsRequest) (*ListMutateJobResultsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListMutateJobResults not implemented")
}
func (*UnimplementedMutateJobServiceServer) RunMutateJob(context.Context, *RunMutateJobRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RunMutateJob not implemented")
}
func (*UnimplementedMutateJobServiceServer) AddMutateJobOperations(context.Context, *AddMutateJobOperationsRequest) (*AddMutateJobOperationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddMutateJobOperations not implemented")
}

func RegisterMutateJobServiceServer(s *grpc.Server, srv MutateJobServiceServer) {
	s.RegisterService(&_MutateJobService_serviceDesc, srv)
}

func _MutateJobService_CreateMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).CreateMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/CreateMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).CreateMutateJob(ctx, req.(*CreateMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_GetMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).GetMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/GetMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).GetMutateJob(ctx, req.(*GetMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_ListMutateJobResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMutateJobResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).ListMutateJobResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/ListMutateJobResults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).ListMutateJobResults(ctx, req.(*ListMutateJobResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_RunMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).RunMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/RunMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).RunMutateJob(ctx, req.(*RunMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_AddMutateJobOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddMutateJobOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).AddMutateJobOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.MutateJobService/AddMutateJobOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).AddMutateJobOperations(ctx, req.(*AddMutateJobOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MutateJobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.MutateJobService",
	HandlerType: (*MutateJobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMutateJob",
			Handler:    _MutateJobService_CreateMutateJob_Handler,
		},
		{
			MethodName: "GetMutateJob",
			Handler:    _MutateJobService_GetMutateJob_Handler,
		},
		{
			MethodName: "ListMutateJobResults",
			Handler:    _MutateJobService_ListMutateJobResults_Handler,
		},
		{
			MethodName: "RunMutateJob",
			Handler:    _MutateJobService_RunMutateJob_Handler,
		},
		{
			MethodName: "AddMutateJobOperations",
			Handler:    _MutateJobService_AddMutateJobOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/mutate_job_service.proto",
}
