// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package globalaccelerator

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateAccelerator = "CreateAccelerator"

// CreateAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccelerator for more information on using the CreateAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAcceleratorRequest method.
//    req, resp := client.CreateAcceleratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator
func (c *GlobalAccelerator) CreateAcceleratorRequest(input *CreateAcceleratorInput) (req *request.Request, output *CreateAcceleratorOutput) {
	op := &request.Operation{
		Name:       opCreateAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAcceleratorInput{}
	}

	output = &CreateAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccelerator API operation for AWS Global Accelerator.
//
// Create an accelerator. An accelerator includes one or more listeners that
// process inbound connections and direct traffic to one or more endpoint groups,
// each of which includes endpoints, such as Network Load Balancers. To see
// an AWS CLI example of creating an accelerator, scroll down to Example.
//
// You must specify the US-West-2 (Oregon) Region to create or update accelerators.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateAccelerator for usage and error information.
//
// Returned Error Types:
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * LimitExceededException
//   Processing your request would cause you to exceed an AWS Global Accelerator
//   limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator
func (c *GlobalAccelerator) CreateAccelerator(input *CreateAcceleratorInput) (*CreateAcceleratorOutput, error) {
	req, out := c.CreateAcceleratorRequest(input)
	return out, req.Send()
}

// CreateAcceleratorWithContext is the same as CreateAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateAcceleratorWithContext(ctx aws.Context, input *CreateAcceleratorInput, opts ...request.Option) (*CreateAcceleratorOutput, error) {
	req, out := c.CreateAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpointGroup = "CreateEndpointGroup"

// CreateEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpointGroup for more information on using the CreateEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointGroupRequest method.
//    req, resp := client.CreateEndpointGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup
func (c *GlobalAccelerator) CreateEndpointGroupRequest(input *CreateEndpointGroupInput) (req *request.Request, output *CreateEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opCreateEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointGroupInput{}
	}

	output = &CreateEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpointGroup API operation for AWS Global Accelerator.
//
// Create an endpoint group for the specified listener. An endpoint group is
// a collection of endpoints in one AWS Region. To see an AWS CLI example of
// creating an endpoint group, scroll down to Example.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateEndpointGroup for usage and error information.
//
// Returned Error Types:
//   * AcceleratorNotFoundException
//   The accelerator that you specified doesn't exist.
//
//   * EndpointGroupAlreadyExistsException
//   The endpoint group that you specified already exists.
//
//   * ListenerNotFoundException
//   The listener that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * LimitExceededException
//   Processing your request would cause you to exceed an AWS Global Accelerator
//   limit.
//
//   * AccessDeniedException
//   You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup
func (c *GlobalAccelerator) CreateEndpointGroup(input *CreateEndpointGroupInput) (*CreateEndpointGroupOutput, error) {
	req, out := c.CreateEndpointGroupRequest(input)
	return out, req.Send()
}

// CreateEndpointGroupWithContext is the same as CreateEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateEndpointGroupWithContext(ctx aws.Context, input *CreateEndpointGroupInput, opts ...request.Option) (*CreateEndpointGroupOutput, error) {
	req, out := c.CreateEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateListener = "CreateListener"

// CreateListenerRequest generates a "aws/request.Request" representing the
// client's request for the CreateListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateListener for more information on using the CreateListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateListenerRequest method.
//    req, resp := client.CreateListenerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener
func (c *GlobalAccelerator) CreateListenerRequest(input *CreateListenerInput) (req *request.Request, output *CreateListenerOutput) {
	op := &request.Operation{
		Name:       opCreateListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateListenerInput{}
	}

	output = &CreateListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateListener API operation for AWS Global Accelerator.
//
// Create a listener to process inbound connections from clients to an accelerator.
// Connections arrive to assigned static IP addresses on a port, port range,
// or list of port ranges that you specify. To see an AWS CLI example of creating
// a listener, scroll down to Example.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation CreateListener for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * AcceleratorNotFoundException
//   The accelerator that you specified doesn't exist.
//
//   * InvalidPortRangeException
//   The port numbers that you specified are not valid numbers or are not unique
//   for this accelerator.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * LimitExceededException
//   Processing your request would cause you to exceed an AWS Global Accelerator
//   limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener
func (c *GlobalAccelerator) CreateListener(input *CreateListenerInput) (*CreateListenerOutput, error) {
	req, out := c.CreateListenerRequest(input)
	return out, req.Send()
}

// CreateListenerWithContext is the same as CreateListener with the addition of
// the ability to pass a context and additional request options.
//
// See CreateListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) CreateListenerWithContext(ctx aws.Context, input *CreateListenerInput, opts ...request.Option) (*CreateListenerOutput, error) {
	req, out := c.CreateListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccelerator = "DeleteAccelerator"

// DeleteAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccelerator for more information on using the DeleteAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAcceleratorRequest method.
//    req, resp := client.DeleteAcceleratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator
func (c *GlobalAccelerator) DeleteAcceleratorRequest(input *DeleteAcceleratorInput) (req *request.Request, output *DeleteAcceleratorOutput) {
	op := &request.Operation{
		Name:       opDeleteAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAcceleratorInput{}
	}

	output = &DeleteAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccelerator API operation for AWS Global Accelerator.
//
// Delete an accelerator. Note: before you can delete an accelerator, you must
// disable it and remove all dependent resources (listeners and endpoint groups).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteAccelerator for usage and error information.
//
// Returned Error Types:
//   * AcceleratorNotFoundException
//   The accelerator that you specified doesn't exist.
//
//   * AcceleratorNotDisabledException
//   The accelerator that you specified could not be disabled.
//
//   * AssociatedListenerFoundException
//   The accelerator that you specified has a listener associated with it. You
//   must remove all dependent resources from an accelerator before you can delete
//   it.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator
func (c *GlobalAccelerator) DeleteAccelerator(input *DeleteAcceleratorInput) (*DeleteAcceleratorOutput, error) {
	req, out := c.DeleteAcceleratorRequest(input)
	return out, req.Send()
}

// DeleteAcceleratorWithContext is the same as DeleteAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteAcceleratorWithContext(ctx aws.Context, input *DeleteAcceleratorInput, opts ...request.Option) (*DeleteAcceleratorOutput, error) {
	req, out := c.DeleteAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpointGroup = "DeleteEndpointGroup"

// DeleteEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpointGroup for more information on using the DeleteEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointGroupRequest method.
//    req, resp := client.DeleteEndpointGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup
func (c *GlobalAccelerator) DeleteEndpointGroupRequest(input *DeleteEndpointGroupInput) (req *request.Request, output *DeleteEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointGroupInput{}
	}

	output = &DeleteEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpointGroup API operation for AWS Global Accelerator.
//
// Delete an endpoint group from a listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteEndpointGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * EndpointGroupNotFoundException
//   The endpoint group that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup
func (c *GlobalAccelerator) DeleteEndpointGroup(input *DeleteEndpointGroupInput) (*DeleteEndpointGroupOutput, error) {
	req, out := c.DeleteEndpointGroupRequest(input)
	return out, req.Send()
}

// DeleteEndpointGroupWithContext is the same as DeleteEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteEndpointGroupWithContext(ctx aws.Context, input *DeleteEndpointGroupInput, opts ...request.Option) (*DeleteEndpointGroupOutput, error) {
	req, out := c.DeleteEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteListener = "DeleteListener"

// DeleteListenerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteListener for more information on using the DeleteListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteListenerRequest method.
//    req, resp := client.DeleteListenerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener
func (c *GlobalAccelerator) DeleteListenerRequest(input *DeleteListenerInput) (req *request.Request, output *DeleteListenerOutput) {
	op := &request.Operation{
		Name:       opDeleteListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteListenerInput{}
	}

	output = &DeleteListenerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteListener API operation for AWS Global Accelerator.
//
// Delete a listener from an accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DeleteListener for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * ListenerNotFoundException
//   The listener that you specified doesn't exist.
//
//   * AssociatedEndpointGroupFoundException
//   The listener that you specified has an endpoint group associated with it.
//   You must remove all dependent resources from a listener before you can delete
//   it.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener
func (c *GlobalAccelerator) DeleteListener(input *DeleteListenerInput) (*DeleteListenerOutput, error) {
	req, out := c.DeleteListenerRequest(input)
	return out, req.Send()
}

// DeleteListenerWithContext is the same as DeleteListener with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DeleteListenerWithContext(ctx aws.Context, input *DeleteListenerInput, opts ...request.Option) (*DeleteListenerOutput, error) {
	req, out := c.DeleteListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccelerator = "DescribeAccelerator"

// DescribeAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccelerator for more information on using the DescribeAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAcceleratorRequest method.
//    req, resp := client.DescribeAcceleratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator
func (c *GlobalAccelerator) DescribeAcceleratorRequest(input *DescribeAcceleratorInput) (req *request.Request, output *DescribeAcceleratorOutput) {
	op := &request.Operation{
		Name:       opDescribeAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAcceleratorInput{}
	}

	output = &DescribeAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccelerator API operation for AWS Global Accelerator.
//
// Describe an accelerator. To see an AWS CLI example of describing an accelerator,
// scroll down to Example.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeAccelerator for usage and error information.
//
// Returned Error Types:
//   * AcceleratorNotFoundException
//   The accelerator that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator
func (c *GlobalAccelerator) DescribeAccelerator(input *DescribeAcceleratorInput) (*DescribeAcceleratorOutput, error) {
	req, out := c.DescribeAcceleratorRequest(input)
	return out, req.Send()
}

// DescribeAcceleratorWithContext is the same as DescribeAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeAcceleratorWithContext(ctx aws.Context, input *DescribeAcceleratorInput, opts ...request.Option) (*DescribeAcceleratorOutput, error) {
	req, out := c.DescribeAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAcceleratorAttributes = "DescribeAcceleratorAttributes"

// DescribeAcceleratorAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAcceleratorAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAcceleratorAttributes for more information on using the DescribeAcceleratorAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAcceleratorAttributesRequest method.
//    req, resp := client.DescribeAcceleratorAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes
func (c *GlobalAccelerator) DescribeAcceleratorAttributesRequest(input *DescribeAcceleratorAttributesInput) (req *request.Request, output *DescribeAcceleratorAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAcceleratorAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAcceleratorAttributesInput{}
	}

	output = &DescribeAcceleratorAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAcceleratorAttributes API operation for AWS Global Accelerator.
//
// Describe the attributes of an accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeAcceleratorAttributes for usage and error information.
//
// Returned Error Types:
//   * AcceleratorNotFoundException
//   The accelerator that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes
func (c *GlobalAccelerator) DescribeAcceleratorAttributes(input *DescribeAcceleratorAttributesInput) (*DescribeAcceleratorAttributesOutput, error) {
	req, out := c.DescribeAcceleratorAttributesRequest(input)
	return out, req.Send()
}

// DescribeAcceleratorAttributesWithContext is the same as DescribeAcceleratorAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAcceleratorAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeAcceleratorAttributesWithContext(ctx aws.Context, input *DescribeAcceleratorAttributesInput, opts ...request.Option) (*DescribeAcceleratorAttributesOutput, error) {
	req, out := c.DescribeAcceleratorAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpointGroup = "DescribeEndpointGroup"

// DescribeEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointGroup for more information on using the DescribeEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointGroupRequest method.
//    req, resp := client.DescribeEndpointGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup
func (c *GlobalAccelerator) DescribeEndpointGroupRequest(input *DescribeEndpointGroupInput) (req *request.Request, output *DescribeEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointGroupInput{}
	}

	output = &DescribeEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointGroup API operation for AWS Global Accelerator.
//
// Describe an endpoint group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeEndpointGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * EndpointGroupNotFoundException
//   The endpoint group that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup
func (c *GlobalAccelerator) DescribeEndpointGroup(input *DescribeEndpointGroupInput) (*DescribeEndpointGroupOutput, error) {
	req, out := c.DescribeEndpointGroupRequest(input)
	return out, req.Send()
}

// DescribeEndpointGroupWithContext is the same as DescribeEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeEndpointGroupWithContext(ctx aws.Context, input *DescribeEndpointGroupInput, opts ...request.Option) (*DescribeEndpointGroupOutput, error) {
	req, out := c.DescribeEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeListener = "DescribeListener"

// DescribeListenerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeListener for more information on using the DescribeListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeListenerRequest method.
//    req, resp := client.DescribeListenerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener
func (c *GlobalAccelerator) DescribeListenerRequest(input *DescribeListenerInput) (req *request.Request, output *DescribeListenerOutput) {
	op := &request.Operation{
		Name:       opDescribeListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeListenerInput{}
	}

	output = &DescribeListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeListener API operation for AWS Global Accelerator.
//
// Describe a listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation DescribeListener for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * ListenerNotFoundException
//   The listener that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener
func (c *GlobalAccelerator) DescribeListener(input *DescribeListenerInput) (*DescribeListenerOutput, error) {
	req, out := c.DescribeListenerRequest(input)
	return out, req.Send()
}

// DescribeListenerWithContext is the same as DescribeListener with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) DescribeListenerWithContext(ctx aws.Context, input *DescribeListenerInput, opts ...request.Option) (*DescribeListenerOutput, error) {
	req, out := c.DescribeListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccelerators = "ListAccelerators"

// ListAcceleratorsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccelerators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccelerators for more information on using the ListAccelerators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAcceleratorsRequest method.
//    req, resp := client.ListAcceleratorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators
func (c *GlobalAccelerator) ListAcceleratorsRequest(input *ListAcceleratorsInput) (req *request.Request, output *ListAcceleratorsOutput) {
	op := &request.Operation{
		Name:       opListAccelerators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAcceleratorsInput{}
	}

	output = &ListAcceleratorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccelerators API operation for AWS Global Accelerator.
//
// List the accelerators for an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListAccelerators for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * InvalidNextTokenException
//   There isn't another item to return.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators
func (c *GlobalAccelerator) ListAccelerators(input *ListAcceleratorsInput) (*ListAcceleratorsOutput, error) {
	req, out := c.ListAcceleratorsRequest(input)
	return out, req.Send()
}

// ListAcceleratorsWithContext is the same as ListAccelerators with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccelerators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListAcceleratorsWithContext(ctx aws.Context, input *ListAcceleratorsInput, opts ...request.Option) (*ListAcceleratorsOutput, error) {
	req, out := c.ListAcceleratorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEndpointGroups = "ListEndpointGroups"

// ListEndpointGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpointGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpointGroups for more information on using the ListEndpointGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointGroupsRequest method.
//    req, resp := client.ListEndpointGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups
func (c *GlobalAccelerator) ListEndpointGroupsRequest(input *ListEndpointGroupsInput) (req *request.Request, output *ListEndpointGroupsOutput) {
	op := &request.Operation{
		Name:       opListEndpointGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEndpointGroupsInput{}
	}

	output = &ListEndpointGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpointGroups API operation for AWS Global Accelerator.
//
// List the endpoint groups that are associated with a listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListEndpointGroups for usage and error information.
//
// Returned Error Types:
//   * ListenerNotFoundException
//   The listener that you specified doesn't exist.
//
//   * InvalidNextTokenException
//   There isn't another item to return.
//
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups
func (c *GlobalAccelerator) ListEndpointGroups(input *ListEndpointGroupsInput) (*ListEndpointGroupsOutput, error) {
	req, out := c.ListEndpointGroupsRequest(input)
	return out, req.Send()
}

// ListEndpointGroupsWithContext is the same as ListEndpointGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpointGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListEndpointGroupsWithContext(ctx aws.Context, input *ListEndpointGroupsInput, opts ...request.Option) (*ListEndpointGroupsOutput, error) {
	req, out := c.ListEndpointGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListListeners = "ListListeners"

// ListListenersRequest generates a "aws/request.Request" representing the
// client's request for the ListListeners operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListListeners for more information on using the ListListeners
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListListenersRequest method.
//    req, resp := client.ListListenersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners
func (c *GlobalAccelerator) ListListenersRequest(input *ListListenersInput) (req *request.Request, output *ListListenersOutput) {
	op := &request.Operation{
		Name:       opListListeners,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListListenersInput{}
	}

	output = &ListListenersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListListeners API operation for AWS Global Accelerator.
//
// List the listeners for an accelerator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation ListListeners for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * AcceleratorNotFoundException
//   The accelerator that you specified doesn't exist.
//
//   * InvalidNextTokenException
//   There isn't another item to return.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners
func (c *GlobalAccelerator) ListListeners(input *ListListenersInput) (*ListListenersOutput, error) {
	req, out := c.ListListenersRequest(input)
	return out, req.Send()
}

// ListListenersWithContext is the same as ListListeners with the addition of
// the ability to pass a context and additional request options.
//
// See ListListeners for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) ListListenersWithContext(ctx aws.Context, input *ListListenersInput, opts ...request.Option) (*ListListenersOutput, error) {
	req, out := c.ListListenersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccelerator = "UpdateAccelerator"

// UpdateAcceleratorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccelerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccelerator for more information on using the UpdateAccelerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAcceleratorRequest method.
//    req, resp := client.UpdateAcceleratorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator
func (c *GlobalAccelerator) UpdateAcceleratorRequest(input *UpdateAcceleratorInput) (req *request.Request, output *UpdateAcceleratorOutput) {
	op := &request.Operation{
		Name:       opUpdateAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAcceleratorInput{}
	}

	output = &UpdateAcceleratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccelerator API operation for AWS Global Accelerator.
//
// Update an accelerator. To see an AWS CLI example of updating an accelerator,
// scroll down to Example.
//
// You must specify the US-West-2 (Oregon) Region to create or update accelerators.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateAccelerator for usage and error information.
//
// Returned Error Types:
//   * AcceleratorNotFoundException
//   The accelerator that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator
func (c *GlobalAccelerator) UpdateAccelerator(input *UpdateAcceleratorInput) (*UpdateAcceleratorOutput, error) {
	req, out := c.UpdateAcceleratorRequest(input)
	return out, req.Send()
}

// UpdateAcceleratorWithContext is the same as UpdateAccelerator with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccelerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateAcceleratorWithContext(ctx aws.Context, input *UpdateAcceleratorInput, opts ...request.Option) (*UpdateAcceleratorOutput, error) {
	req, out := c.UpdateAcceleratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAcceleratorAttributes = "UpdateAcceleratorAttributes"

// UpdateAcceleratorAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAcceleratorAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAcceleratorAttributes for more information on using the UpdateAcceleratorAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAcceleratorAttributesRequest method.
//    req, resp := client.UpdateAcceleratorAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes
func (c *GlobalAccelerator) UpdateAcceleratorAttributesRequest(input *UpdateAcceleratorAttributesInput) (req *request.Request, output *UpdateAcceleratorAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateAcceleratorAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAcceleratorAttributesInput{}
	}

	output = &UpdateAcceleratorAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAcceleratorAttributes API operation for AWS Global Accelerator.
//
// Update the attributes for an accelerator. To see an AWS CLI example of updating
// an accelerator to enable flow logs, scroll down to Example.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateAcceleratorAttributes for usage and error information.
//
// Returned Error Types:
//   * AcceleratorNotFoundException
//   The accelerator that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * AccessDeniedException
//   You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes
func (c *GlobalAccelerator) UpdateAcceleratorAttributes(input *UpdateAcceleratorAttributesInput) (*UpdateAcceleratorAttributesOutput, error) {
	req, out := c.UpdateAcceleratorAttributesRequest(input)
	return out, req.Send()
}

// UpdateAcceleratorAttributesWithContext is the same as UpdateAcceleratorAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAcceleratorAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateAcceleratorAttributesWithContext(ctx aws.Context, input *UpdateAcceleratorAttributesInput, opts ...request.Option) (*UpdateAcceleratorAttributesOutput, error) {
	req, out := c.UpdateAcceleratorAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointGroup = "UpdateEndpointGroup"

// UpdateEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointGroup for more information on using the UpdateEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointGroupRequest method.
//    req, resp := client.UpdateEndpointGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup
func (c *GlobalAccelerator) UpdateEndpointGroupRequest(input *UpdateEndpointGroupInput) (req *request.Request, output *UpdateEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointGroupInput{}
	}

	output = &UpdateEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointGroup API operation for AWS Global Accelerator.
//
// Update an endpoint group. To see an AWS CLI example of updating an endpoint
// group, scroll down to Example.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateEndpointGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * EndpointGroupNotFoundException
//   The endpoint group that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * LimitExceededException
//   Processing your request would cause you to exceed an AWS Global Accelerator
//   limit.
//
//   * AccessDeniedException
//   You don't have access permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup
func (c *GlobalAccelerator) UpdateEndpointGroup(input *UpdateEndpointGroupInput) (*UpdateEndpointGroupOutput, error) {
	req, out := c.UpdateEndpointGroupRequest(input)
	return out, req.Send()
}

// UpdateEndpointGroupWithContext is the same as UpdateEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateEndpointGroupWithContext(ctx aws.Context, input *UpdateEndpointGroupInput, opts ...request.Option) (*UpdateEndpointGroupOutput, error) {
	req, out := c.UpdateEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateListener = "UpdateListener"

// UpdateListenerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateListener operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateListener for more information on using the UpdateListener
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateListenerRequest method.
//    req, resp := client.UpdateListenerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener
func (c *GlobalAccelerator) UpdateListenerRequest(input *UpdateListenerInput) (req *request.Request, output *UpdateListenerOutput) {
	op := &request.Operation{
		Name:       opUpdateListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateListenerInput{}
	}

	output = &UpdateListenerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateListener API operation for AWS Global Accelerator.
//
// Update a listener.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Global Accelerator's
// API operation UpdateListener for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   An argument that you specified is invalid.
//
//   * InvalidPortRangeException
//   The port numbers that you specified are not valid numbers or are not unique
//   for this accelerator.
//
//   * ListenerNotFoundException
//   The listener that you specified doesn't exist.
//
//   * InternalServiceErrorException
//   There was an internal error for AWS Global Accelerator.
//
//   * LimitExceededException
//   Processing your request would cause you to exceed an AWS Global Accelerator
//   limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener
func (c *GlobalAccelerator) UpdateListener(input *UpdateListenerInput) (*UpdateListenerOutput, error) {
	req, out := c.UpdateListenerRequest(input)
	return out, req.Send()
}

// UpdateListenerWithContext is the same as UpdateListener with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateListener for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GlobalAccelerator) UpdateListenerWithContext(ctx aws.Context, input *UpdateListenerInput, opts ...request.Option) (*UpdateListenerOutput, error) {
	req, out := c.UpdateListenerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An accelerator is a complex type that includes one or more listeners that
// process inbound connections and then direct traffic to one or more endpoint
// groups, each of which includes endpoints, such as load balancers.
type Accelerator struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator.
	AcceleratorArn *string `type:"string"`

	// The date and time that the accelerator was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The Domain Name System (DNS) name that Global Accelerator creates that points
	// to your accelerator's static IP addresses.
	//
	// The naming convention for the DNS name is: a lower case letter a, followed
	// by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For
	// example: a1234567890abcdef.awsglobalaccelerator.com.
	//
	// For more information about the default DNS name, see Support for DNS Addressing
	// in Global Accelerator (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing)
	// in the AWS Global Accelerator Developer Guide.
	DnsName *string `type:"string"`

	// Indicates whether the accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, the accelerator cannot be deleted. If set to
	// false, accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// The value for the address type must be IPv4.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// The static IP addresses that Global Accelerator associates with the accelerator.
	IpSets []*IpSet `type:"list"`

	// The date and time that the accelerator was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the accelerator. The name must contain only alphanumeric characters
	// or hyphens (-), and must not begin or end with a hyphen.
	Name *string `type:"string"`

	// Describes the deployment status of the accelerator.
	Status *string `type:"string" enum:"AcceleratorStatus"`
}

// String returns the string representation
func (s Accelerator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Accelerator) GoString() string {
	return s.String()
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *Accelerator) SetAcceleratorArn(v string) *Accelerator {
	s.AcceleratorArn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Accelerator) SetCreatedTime(v time.Time) *Accelerator {
	s.CreatedTime = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *Accelerator) SetDnsName(v string) *Accelerator {
	s.DnsName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Accelerator) SetEnabled(v bool) *Accelerator {
	s.Enabled = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *Accelerator) SetIpAddressType(v string) *Accelerator {
	s.IpAddressType = &v
	return s
}

// SetIpSets sets the IpSets field's value.
func (s *Accelerator) SetIpSets(v []*IpSet) *Accelerator {
	s.IpSets = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Accelerator) SetLastModifiedTime(v time.Time) *Accelerator {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Accelerator) SetName(v string) *Accelerator {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Accelerator) SetStatus(v string) *Accelerator {
	s.Status = &v
	return s
}

// Attributes of an accelerator.
type AcceleratorAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether flow logs are enabled. The default value is false. If the
	// value is true, FlowLogsS3Bucket and FlowLogsS3Prefix must be specified.
	//
	// For more information, see Flow Logs (https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html)
	// in the AWS Global Accelerator Developer Guide.
	FlowLogsEnabled *bool `type:"boolean"`

	// The name of the Amazon S3 bucket for the flow logs. Attribute is required
	// if FlowLogsEnabled is true. The bucket must exist and have a bucket policy
	// that grants AWS Global Accelerator permission to write to the bucket.
	FlowLogsS3Bucket *string `type:"string"`

	// The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute
	// is required if FlowLogsEnabled is true. If you don’t specify a prefix,
	// the flow logs are stored in the root of the bucket.
	FlowLogsS3Prefix *string `type:"string"`
}

// String returns the string representation
func (s AcceleratorAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceleratorAttributes) GoString() string {
	return s.String()
}

// SetFlowLogsEnabled sets the FlowLogsEnabled field's value.
func (s *AcceleratorAttributes) SetFlowLogsEnabled(v bool) *AcceleratorAttributes {
	s.FlowLogsEnabled = &v
	return s
}

// SetFlowLogsS3Bucket sets the FlowLogsS3Bucket field's value.
func (s *AcceleratorAttributes) SetFlowLogsS3Bucket(v string) *AcceleratorAttributes {
	s.FlowLogsS3Bucket = &v
	return s
}

// SetFlowLogsS3Prefix sets the FlowLogsS3Prefix field's value.
func (s *AcceleratorAttributes) SetFlowLogsS3Prefix(v string) *AcceleratorAttributes {
	s.FlowLogsS3Prefix = &v
	return s
}

// The accelerator that you specified could not be disabled.
type AcceleratorNotDisabledException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AcceleratorNotDisabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceleratorNotDisabledException) GoString() string {
	return s.String()
}

func newErrorAcceleratorNotDisabledException(v protocol.ResponseMetadata) error {
	return &AcceleratorNotDisabledException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AcceleratorNotDisabledException) Code() string {
	return "AcceleratorNotDisabledException"
}

// Message returns the exception's message.
func (s AcceleratorNotDisabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AcceleratorNotDisabledException) OrigErr() error {
	return nil
}

func (s AcceleratorNotDisabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s AcceleratorNotDisabledException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AcceleratorNotDisabledException) RequestID() string {
	return s.respMetadata.RequestID
}

// The accelerator that you specified doesn't exist.
type AcceleratorNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AcceleratorNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceleratorNotFoundException) GoString() string {
	return s.String()
}

func newErrorAcceleratorNotFoundException(v protocol.ResponseMetadata) error {
	return &AcceleratorNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AcceleratorNotFoundException) Code() string {
	return "AcceleratorNotFoundException"
}

// Message returns the exception's message.
func (s AcceleratorNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AcceleratorNotFoundException) OrigErr() error {
	return nil
}

func (s AcceleratorNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s AcceleratorNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AcceleratorNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// You don't have access permission.
type AccessDeniedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AccessDeniedException) OrigErr() error {
	return nil
}

func (s AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s AccessDeniedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AccessDeniedException) RequestID() string {
	return s.respMetadata.RequestID
}

// The listener that you specified has an endpoint group associated with it.
// You must remove all dependent resources from a listener before you can delete
// it.
type AssociatedEndpointGroupFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AssociatedEndpointGroupFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatedEndpointGroupFoundException) GoString() string {
	return s.String()
}

func newErrorAssociatedEndpointGroupFoundException(v protocol.ResponseMetadata) error {
	return &AssociatedEndpointGroupFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AssociatedEndpointGroupFoundException) Code() string {
	return "AssociatedEndpointGroupFoundException"
}

// Message returns the exception's message.
func (s AssociatedEndpointGroupFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AssociatedEndpointGroupFoundException) OrigErr() error {
	return nil
}

func (s AssociatedEndpointGroupFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s AssociatedEndpointGroupFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AssociatedEndpointGroupFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// The accelerator that you specified has a listener associated with it. You
// must remove all dependent resources from an accelerator before you can delete
// it.
type AssociatedListenerFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AssociatedListenerFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatedListenerFoundException) GoString() string {
	return s.String()
}

func newErrorAssociatedListenerFoundException(v protocol.ResponseMetadata) error {
	return &AssociatedListenerFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AssociatedListenerFoundException) Code() string {
	return "AssociatedListenerFoundException"
}

// Message returns the exception's message.
func (s AssociatedListenerFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AssociatedListenerFoundException) OrigErr() error {
	return nil
}

func (s AssociatedListenerFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s AssociatedListenerFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AssociatedListenerFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

type CreateAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether an accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, an accelerator cannot be deleted. If set to
	// false, the accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of an accelerator.
	//
	// IdempotencyToken is a required field
	IdempotencyToken *string `type:"string" required:"true"`

	// The value for the address type must be IPv4.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// The name of an accelerator. The name can have a maximum of 32 characters,
	// must contain only alphanumeric characters or hyphens (-), and must not begin
	// or end with a hyphen.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAcceleratorInput"}
	if s.IdempotencyToken == nil {
		invalidParams.Add(request.NewErrParamRequired("IdempotencyToken"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateAcceleratorInput) SetEnabled(v bool) *CreateAcceleratorInput {
	s.Enabled = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateAcceleratorInput) SetIdempotencyToken(v string) *CreateAcceleratorInput {
	s.IdempotencyToken = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CreateAcceleratorInput) SetIpAddressType(v string) *CreateAcceleratorInput {
	s.IpAddressType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAcceleratorInput) SetName(v string) *CreateAcceleratorInput {
	s.Name = &v
	return s
}

type CreateAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// The accelerator that is created by specifying a listener and the supported
	// IP address types.
	Accelerator *Accelerator `type:"structure"`
}

// String returns the string representation
func (s CreateAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *CreateAcceleratorOutput) SetAccelerator(v *Accelerator) *CreateAcceleratorOutput {
	s.Accelerator = v
	return s
}

type CreateEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects.
	EndpointConfigurations []*EndpointConfiguration `type:"list"`

	// The name of the AWS Region where the endpoint group is located. A listener
	// can have only one endpoint group in a specific Region.
	//
	// EndpointGroupRegion is a required field
	EndpointGroupRegion *string `type:"string" required:"true"`

	// The time—10 seconds or 30 seconds—between each health check for an endpoint.
	// The default value is 30.
	HealthCheckIntervalSeconds *int64 `min:"10" type:"integer"`

	// If the protocol is HTTP/S, then this specifies the path that is the destination
	// for health check targets. The default value is slash (/).
	HealthCheckPath *string `type:"string"`

	// The port that AWS Global Accelerator uses to check the health of endpoints
	// that are part of this endpoint group. The default port is the listener port
	// that this endpoint group is associated with. If listener port is a list of
	// ports, Global Accelerator uses the first port in the list.
	HealthCheckPort *int64 `min:"1" type:"integer"`

	// The protocol that AWS Global Accelerator uses to check the health of endpoints
	// that are part of this endpoint group. The default value is TCP.
	HealthCheckProtocol *string `type:"string" enum:"HealthCheckProtocol"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of the request.
	//
	// IdempotencyToken is a required field
	IdempotencyToken *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The number of consecutive health checks required to set the state of a healthy
	// endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default
	// value is 3.
	ThresholdCount *int64 `min:"1" type:"integer"`

	// The percentage of traffic to send to an AWS Region. Additional traffic is
	// distributed to other endpoint groups for this listener.
	//
	// Use this action to increase (dial up) or decrease (dial down) traffic to
	// a specific Region. The percentage is applied to the traffic that would otherwise
	// have been routed to the Region based on optimal routing.
	//
	// The default value is 100.
	TrafficDialPercentage *float64 `type:"float"`
}

// String returns the string representation
func (s CreateEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointGroupInput"}
	if s.EndpointGroupRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupRegion"))
	}
	if s.HealthCheckIntervalSeconds != nil && *s.HealthCheckIntervalSeconds < 10 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckIntervalSeconds", 10))
	}
	if s.HealthCheckPort != nil && *s.HealthCheckPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckPort", 1))
	}
	if s.IdempotencyToken == nil {
		invalidParams.Add(request.NewErrParamRequired("IdempotencyToken"))
	}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.ThresholdCount != nil && *s.ThresholdCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ThresholdCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigurations sets the EndpointConfigurations field's value.
func (s *CreateEndpointGroupInput) SetEndpointConfigurations(v []*EndpointConfiguration) *CreateEndpointGroupInput {
	s.EndpointConfigurations = v
	return s
}

// SetEndpointGroupRegion sets the EndpointGroupRegion field's value.
func (s *CreateEndpointGroupInput) SetEndpointGroupRegion(v string) *CreateEndpointGroupInput {
	s.EndpointGroupRegion = &v
	return s
}

// SetHealthCheckIntervalSeconds sets the HealthCheckIntervalSeconds field's value.
func (s *CreateEndpointGroupInput) SetHealthCheckIntervalSeconds(v int64) *CreateEndpointGroupInput {
	s.HealthCheckIntervalSeconds = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *CreateEndpointGroupInput) SetHealthCheckPath(v string) *CreateEndpointGroupInput {
	s.HealthCheckPath = &v
	return s
}

// SetHealthCheckPort sets the HealthCheckPort field's value.
func (s *CreateEndpointGroupInput) SetHealthCheckPort(v int64) *CreateEndpointGroupInput {
	s.HealthCheckPort = &v
	return s
}

// SetHealthCheckProtocol sets the HealthCheckProtocol field's value.
func (s *CreateEndpointGroupInput) SetHealthCheckProtocol(v string) *CreateEndpointGroupInput {
	s.HealthCheckProtocol = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateEndpointGroupInput) SetIdempotencyToken(v string) *CreateEndpointGroupInput {
	s.IdempotencyToken = &v
	return s
}

// SetListenerArn sets the ListenerArn field's value.
func (s *CreateEndpointGroupInput) SetListenerArn(v string) *CreateEndpointGroupInput {
	s.ListenerArn = &v
	return s
}

// SetThresholdCount sets the ThresholdCount field's value.
func (s *CreateEndpointGroupInput) SetThresholdCount(v int64) *CreateEndpointGroupInput {
	s.ThresholdCount = &v
	return s
}

// SetTrafficDialPercentage sets the TrafficDialPercentage field's value.
func (s *CreateEndpointGroupInput) SetTrafficDialPercentage(v float64) *CreateEndpointGroupInput {
	s.TrafficDialPercentage = &v
	return s
}

type CreateEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The information about the endpoint group that was created.
	EndpointGroup *EndpointGroup `type:"structure"`
}

// String returns the string representation
func (s CreateEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetEndpointGroup sets the EndpointGroup field's value.
func (s *CreateEndpointGroupOutput) SetEndpointGroup(v *EndpointGroup) *CreateEndpointGroupOutput {
	s.EndpointGroup = v
	return s
}

type CreateListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of your accelerator.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// Client affinity lets you direct all requests from a user to the same endpoint,
	// if you have stateful applications, regardless of the port and protocol of
	// the client request. Clienty affinity gives you control over whether to always
	// route each client to the same specific endpoint.
	//
	// AWS Global Accelerator uses a consistent-flow hashing algorithm to choose
	// the optimal endpoint for a connection. If client affinity is NONE, Global
	// Accelerator uses the "five-tuple" (5-tuple) properties—source IP address,
	// source port, destination IP address, destination port, and protocol—to
	// select the hash value, and then chooses the best endpoint. However, with
	// this setting, if someone uses different ports to connect to Global Accelerator,
	// their connections might not be always routed to the same endpoint because
	// the hash value changes.
	//
	// If you want a given client to always be routed to the same endpoint, set
	// client affinity to SOURCE_IP instead. When you use the SOURCE_IP setting,
	// Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client)
	// IP address and destination IP address—to select the hash value.
	//
	// The default value is NONE.
	ClientAffinity *string `type:"string" enum:"ClientAffinity"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency—that
	// is, the uniqueness—of the request.
	//
	// IdempotencyToken is a required field
	IdempotencyToken *string `type:"string" required:"true"`

	// The list of port ranges to support for connections from clients to your accelerator.
	//
	// PortRanges is a required field
	PortRanges []*PortRange `min:"1" type:"list" required:"true"`

	// The protocol for connections from clients to your accelerator.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"Protocol"`
}

// String returns the string representation
func (s CreateListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateListenerInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}
	if s.IdempotencyToken == nil {
		invalidParams.Add(request.NewErrParamRequired("IdempotencyToken"))
	}
	if s.PortRanges == nil {
		invalidParams.Add(request.NewErrParamRequired("PortRanges"))
	}
	if s.PortRanges != nil && len(s.PortRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortRanges", 1))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.PortRanges != nil {
		for i, v := range s.PortRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *CreateListenerInput) SetAcceleratorArn(v string) *CreateListenerInput {
	s.AcceleratorArn = &v
	return s
}

// SetClientAffinity sets the ClientAffinity field's value.
func (s *CreateListenerInput) SetClientAffinity(v string) *CreateListenerInput {
	s.ClientAffinity = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateListenerInput) SetIdempotencyToken(v string) *CreateListenerInput {
	s.IdempotencyToken = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *CreateListenerInput) SetPortRanges(v []*PortRange) *CreateListenerInput {
	s.PortRanges = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateListenerInput) SetProtocol(v string) *CreateListenerInput {
	s.Protocol = &v
	return s
}

type CreateListenerOutput struct {
	_ struct{} `type:"structure"`

	// The listener that you've created.
	Listener *Listener `type:"structure"`
}

// String returns the string representation
func (s CreateListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *CreateListenerOutput) SetListener(v *Listener) *CreateListenerOutput {
	s.Listener = v
	return s
}

type DeleteAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an accelerator.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DeleteAcceleratorInput) SetAcceleratorArn(v string) *DeleteAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

type DeleteAcceleratorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAcceleratorOutput) GoString() string {
	return s.String()
}

type DeleteEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group to delete.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointGroupInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *DeleteEndpointGroupInput) SetEndpointGroupArn(v string) *DeleteEndpointGroupInput {
	s.EndpointGroupArn = &v
	return s
}

type DeleteEndpointGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointGroupOutput) GoString() string {
	return s.String()
}

type DeleteListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *DeleteListenerInput) SetListenerArn(v string) *DeleteListenerInput {
	s.ListenerArn = &v
	return s
}

type DeleteListenerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteListenerOutput) GoString() string {
	return s.String()
}

type DescribeAcceleratorAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator with the attributes that
	// you want to describe.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAcceleratorAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAcceleratorAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAcceleratorAttributesInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DescribeAcceleratorAttributesInput) SetAcceleratorArn(v string) *DescribeAcceleratorAttributesInput {
	s.AcceleratorArn = &v
	return s
}

type DescribeAcceleratorAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes of the accelerator.
	AcceleratorAttributes *AcceleratorAttributes `type:"structure"`
}

// String returns the string representation
func (s DescribeAcceleratorAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorAttributesOutput) GoString() string {
	return s.String()
}

// SetAcceleratorAttributes sets the AcceleratorAttributes field's value.
func (s *DescribeAcceleratorAttributesOutput) SetAcceleratorAttributes(v *AcceleratorAttributes) *DescribeAcceleratorAttributesOutput {
	s.AcceleratorAttributes = v
	return s
}

type DescribeAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to describe.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *DescribeAcceleratorInput) SetAcceleratorArn(v string) *DescribeAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

type DescribeAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// The description of the accelerator.
	Accelerator *Accelerator `type:"structure"`
}

// String returns the string representation
func (s DescribeAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *DescribeAcceleratorOutput) SetAccelerator(v *Accelerator) *DescribeAcceleratorOutput {
	s.Accelerator = v
	return s
}

type DescribeEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint group to describe.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointGroupInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *DescribeEndpointGroupInput) SetEndpointGroupArn(v string) *DescribeEndpointGroupInput {
	s.EndpointGroupArn = &v
	return s
}

type DescribeEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The description of an endpoint group.
	EndpointGroup *EndpointGroup `type:"structure"`
}

// String returns the string representation
func (s DescribeEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetEndpointGroup sets the EndpointGroup field's value.
func (s *DescribeEndpointGroupOutput) SetEndpointGroup(v *EndpointGroup) *DescribeEndpointGroupOutput {
	s.EndpointGroup = v
	return s
}

type DescribeListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener to describe.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *DescribeListenerInput) SetListenerArn(v string) *DescribeListenerInput {
	s.ListenerArn = &v
	return s
}

type DescribeListenerOutput struct {
	_ struct{} `type:"structure"`

	// The description of a listener.
	Listener *Listener `type:"structure"`
}

// String returns the string representation
func (s DescribeListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *DescribeListenerOutput) SetListener(v *Listener) *DescribeListenerOutput {
	s.Listener = v
	return s
}

// A complex type for endpoints.
type EndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether client IP address preservation is enabled for an Application
	// Load Balancer endpoint. The value is true or false. The default value is
	// true for new accelerators.
	//
	// If the value is set to true, the client's IP address is preserved in the
	// X-Forwarded-For request header as traffic travels to applications on the
	// Application Load Balancer endpoint fronted by the accelerator.
	//
	// For more information, see Viewing Client IP Addresses in AWS Global Accelerator
	// (https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html)
	// in the AWS Global Accelerator Developer Guide.
	ClientIPPreservationEnabled *bool `type:"boolean"`

	// An ID for the endpoint. If the endpoint is a Network Load Balancer or Application
	// Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If
	// the endpoint is an Elastic IP address, this is the Elastic IP address allocation
	// ID.
	EndpointId *string `type:"string"`

	// The weight associated with the endpoint. When you add weights to endpoints,
	// you configure AWS Global Accelerator to route traffic based on proportions
	// that you specify. For example, you might specify endpoint weights of 4, 5,
	// 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is
	// routed to the first endpoint, 5/20 is routed both to the second and third
	// endpoints, and 6/20 is routed to the last endpoint. For more information,
	// see Endpoint Weights (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html)
	// in the AWS Global Accelerator Developer Guide.
	Weight *int64 `type:"integer"`
}

// String returns the string representation
func (s EndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointConfiguration) GoString() string {
	return s.String()
}

// SetClientIPPreservationEnabled sets the ClientIPPreservationEnabled field's value.
func (s *EndpointConfiguration) SetClientIPPreservationEnabled(v bool) *EndpointConfiguration {
	s.ClientIPPreservationEnabled = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *EndpointConfiguration) SetEndpointId(v string) *EndpointConfiguration {
	s.EndpointId = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *EndpointConfiguration) SetWeight(v int64) *EndpointConfiguration {
	s.Weight = &v
	return s
}

// A complex type for an endpoint. Each endpoint group can include one or more
// endpoints, such as load balancers.
type EndpointDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether client IP address preservation is enabled for an Application
	// Load Balancer endpoint. The value is true or false. The default value is
	// true for new accelerators.
	//
	// If the value is set to true, the client's IP address is preserved in the
	// X-Forwarded-For request header as traffic travels to applications on the
	// Application Load Balancer endpoint fronted by the accelerator.
	//
	// For more information, see Viewing Client IP Addresses in AWS Global Accelerator
	// (https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html)
	// in the AWS Global Accelerator Developer Guide.
	ClientIPPreservationEnabled *bool `type:"boolean"`

	// An ID for the endpoint. If the endpoint is a Network Load Balancer or Application
	// Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If
	// the endpoint is an Elastic IP address, this is the Elastic IP address allocation
	// ID. An Application Load Balancer can be either internal or internet-facing.
	EndpointId *string `type:"string"`

	// The reason code associated with why the endpoint is not healthy. If the endpoint
	// state is healthy, a reason code is not provided.
	//
	// If the endpoint state is unhealthy, the reason code can be one of the following
	// values:
	//
	//    * Timeout: The health check requests to the endpoint are timing out before
	//    returning a status.
	//
	//    * Failed: The health check failed, for example because the endpoint response
	//    was invalid (malformed).
	//
	// If the endpoint state is initial, the reason code can be one of the following
	// values:
	//
	//    * ProvisioningInProgress: The endpoint is in the process of being provisioned.
	//
	//    * InitialHealthChecking: Global Accelerator is still setting up the minimum
	//    number of health checks for the endpoint that are required to determine
	//    its health status.
	HealthReason *string `type:"string"`

	// The health status of the endpoint.
	HealthState *string `type:"string" enum:"HealthState"`

	// The weight associated with the endpoint. When you add weights to endpoints,
	// you configure AWS Global Accelerator to route traffic based on proportions
	// that you specify. For example, you might specify endpoint weights of 4, 5,
	// 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is
	// routed to the first endpoint, 5/20 is routed both to the second and third
	// endpoints, and 6/20 is routed to the last endpoint. For more information,
	// see Endpoint Weights (https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html)
	// in the AWS Global Accelerator Developer Guide.
	Weight *int64 `type:"integer"`
}

// String returns the string representation
func (s EndpointDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointDescription) GoString() string {
	return s.String()
}

// SetClientIPPreservationEnabled sets the ClientIPPreservationEnabled field's value.
func (s *EndpointDescription) SetClientIPPreservationEnabled(v bool) *EndpointDescription {
	s.ClientIPPreservationEnabled = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *EndpointDescription) SetEndpointId(v string) *EndpointDescription {
	s.EndpointId = &v
	return s
}

// SetHealthReason sets the HealthReason field's value.
func (s *EndpointDescription) SetHealthReason(v string) *EndpointDescription {
	s.HealthReason = &v
	return s
}

// SetHealthState sets the HealthState field's value.
func (s *EndpointDescription) SetHealthState(v string) *EndpointDescription {
	s.HealthState = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *EndpointDescription) SetWeight(v int64) *EndpointDescription {
	s.Weight = &v
	return s
}

// A complex type for the endpoint group. An AWS Region can have only one endpoint
// group for a specific listener.
type EndpointGroup struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects.
	EndpointDescriptions []*EndpointDescription `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	EndpointGroupArn *string `type:"string"`

	// The AWS Region that this endpoint group belongs.
	EndpointGroupRegion *string `type:"string"`

	// The time—10 seconds or 30 seconds—between health checks for each endpoint.
	// The default value is 30.
	HealthCheckIntervalSeconds *int64 `min:"10" type:"integer"`

	// If the protocol is HTTP/S, then this value provides the ping path that Global
	// Accelerator uses for the destination on the endpoints for health checks.
	// The default is slash (/).
	HealthCheckPath *string `type:"string"`

	// The port that Global Accelerator uses to perform health checks on endpoints
	// that are part of this endpoint group.
	//
	// The default port is the port for the listener that this endpoint group is
	// associated with. If the listener port is a list, Global Accelerator uses
	// the first specified port in the list of ports.
	HealthCheckPort *int64 `min:"1" type:"integer"`

	// The protocol that Global Accelerator uses to perform health checks on endpoints
	// that are part of this endpoint group. The default value is TCP.
	HealthCheckProtocol *string `type:"string" enum:"HealthCheckProtocol"`

	// The number of consecutive health checks required to set the state of a healthy
	// endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default
	// value is 3.
	ThresholdCount *int64 `min:"1" type:"integer"`

	// The percentage of traffic to send to an AWS Region. Additional traffic is
	// distributed to other endpoint groups for this listener.
	//
	// Use this action to increase (dial up) or decrease (dial down) traffic to
	// a specific Region. The percentage is applied to the traffic that would otherwise
	// have been routed to the Region based on optimal routing.
	//
	// The default value is 100.
	TrafficDialPercentage *float64 `type:"float"`
}

// String returns the string representation
func (s EndpointGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointGroup) GoString() string {
	return s.String()
}

// SetEndpointDescriptions sets the EndpointDescriptions field's value.
func (s *EndpointGroup) SetEndpointDescriptions(v []*EndpointDescription) *EndpointGroup {
	s.EndpointDescriptions = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *EndpointGroup) SetEndpointGroupArn(v string) *EndpointGroup {
	s.EndpointGroupArn = &v
	return s
}

// SetEndpointGroupRegion sets the EndpointGroupRegion field's value.
func (s *EndpointGroup) SetEndpointGroupRegion(v string) *EndpointGroup {
	s.EndpointGroupRegion = &v
	return s
}

// SetHealthCheckIntervalSeconds sets the HealthCheckIntervalSeconds field's value.
func (s *EndpointGroup) SetHealthCheckIntervalSeconds(v int64) *EndpointGroup {
	s.HealthCheckIntervalSeconds = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *EndpointGroup) SetHealthCheckPath(v string) *EndpointGroup {
	s.HealthCheckPath = &v
	return s
}

// SetHealthCheckPort sets the HealthCheckPort field's value.
func (s *EndpointGroup) SetHealthCheckPort(v int64) *EndpointGroup {
	s.HealthCheckPort = &v
	return s
}

// SetHealthCheckProtocol sets the HealthCheckProtocol field's value.
func (s *EndpointGroup) SetHealthCheckProtocol(v string) *EndpointGroup {
	s.HealthCheckProtocol = &v
	return s
}

// SetThresholdCount sets the ThresholdCount field's value.
func (s *EndpointGroup) SetThresholdCount(v int64) *EndpointGroup {
	s.ThresholdCount = &v
	return s
}

// SetTrafficDialPercentage sets the TrafficDialPercentage field's value.
func (s *EndpointGroup) SetTrafficDialPercentage(v float64) *EndpointGroup {
	s.TrafficDialPercentage = &v
	return s
}

// The endpoint group that you specified already exists.
type EndpointGroupAlreadyExistsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EndpointGroupAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointGroupAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorEndpointGroupAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &EndpointGroupAlreadyExistsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s EndpointGroupAlreadyExistsException) Code() string {
	return "EndpointGroupAlreadyExistsException"
}

// Message returns the exception's message.
func (s EndpointGroupAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s EndpointGroupAlreadyExistsException) OrigErr() error {
	return nil
}

func (s EndpointGroupAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s EndpointGroupAlreadyExistsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s EndpointGroupAlreadyExistsException) RequestID() string {
	return s.respMetadata.RequestID
}

// The endpoint group that you specified doesn't exist.
type EndpointGroupNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s EndpointGroupNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointGroupNotFoundException) GoString() string {
	return s.String()
}

func newErrorEndpointGroupNotFoundException(v protocol.ResponseMetadata) error {
	return &EndpointGroupNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s EndpointGroupNotFoundException) Code() string {
	return "EndpointGroupNotFoundException"
}

// Message returns the exception's message.
func (s EndpointGroupNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s EndpointGroupNotFoundException) OrigErr() error {
	return nil
}

func (s EndpointGroupNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s EndpointGroupNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s EndpointGroupNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// There was an internal error for AWS Global Accelerator.
type InternalServiceErrorException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalServiceErrorException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalServiceErrorException) RequestID() string {
	return s.respMetadata.RequestID
}

// An argument that you specified is invalid.
type InvalidArgumentException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidArgumentException) OrigErr() error {
	return nil
}

func (s InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidArgumentException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidArgumentException) RequestID() string {
	return s.respMetadata.RequestID
}

// There isn't another item to return.
type InvalidNextTokenException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidNextTokenException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidNextTokenException) RequestID() string {
	return s.respMetadata.RequestID
}

// The port numbers that you specified are not valid numbers or are not unique
// for this accelerator.
type InvalidPortRangeException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidPortRangeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPortRangeException) GoString() string {
	return s.String()
}

func newErrorInvalidPortRangeException(v protocol.ResponseMetadata) error {
	return &InvalidPortRangeException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidPortRangeException) Code() string {
	return "InvalidPortRangeException"
}

// Message returns the exception's message.
func (s InvalidPortRangeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidPortRangeException) OrigErr() error {
	return nil
}

func (s InvalidPortRangeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidPortRangeException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidPortRangeException) RequestID() string {
	return s.respMetadata.RequestID
}

// A complex type for the set of IP addresses for an accelerator.
type IpSet struct {
	_ struct{} `type:"structure"`

	// The array of IP addresses in the IP address set. An IP address set can have
	// a maximum of two IP addresses.
	IpAddresses []*string `type:"list"`

	// The types of IP addresses included in this IP set.
	IpFamily *string `type:"string"`
}

// String returns the string representation
func (s IpSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpSet) GoString() string {
	return s.String()
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *IpSet) SetIpAddresses(v []*string) *IpSet {
	s.IpAddresses = v
	return s
}

// SetIpFamily sets the IpFamily field's value.
func (s *IpSet) SetIpFamily(v string) *IpSet {
	s.IpFamily = &v
	return s
}

// Processing your request would cause you to exceed an AWS Global Accelerator
// limit.
type LimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s LimitExceededException) OrigErr() error {
	return nil
}

func (s LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s LimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s LimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListAcceleratorsInput struct {
	_ struct{} `type:"structure"`

	// The number of Global Accelerator objects that you want to return with this
	// call. The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAcceleratorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAcceleratorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAcceleratorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAcceleratorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAcceleratorsInput) SetMaxResults(v int64) *ListAcceleratorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAcceleratorsInput) SetNextToken(v string) *ListAcceleratorsInput {
	s.NextToken = &v
	return s
}

type ListAcceleratorsOutput struct {
	_ struct{} `type:"structure"`

	// The list of accelerators for a customer account.
	Accelerators []*Accelerator `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAcceleratorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAcceleratorsOutput) GoString() string {
	return s.String()
}

// SetAccelerators sets the Accelerators field's value.
func (s *ListAcceleratorsOutput) SetAccelerators(v []*Accelerator) *ListAcceleratorsOutput {
	s.Accelerators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAcceleratorsOutput) SetNextToken(v string) *ListAcceleratorsOutput {
	s.NextToken = &v
	return s
}

type ListEndpointGroupsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The number of endpoint group objects that you want to return with this call.
	// The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEndpointGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointGroupsInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetListenerArn sets the ListenerArn field's value.
func (s *ListEndpointGroupsInput) SetListenerArn(v string) *ListEndpointGroupsInput {
	s.ListenerArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointGroupsInput) SetMaxResults(v int64) *ListEndpointGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointGroupsInput) SetNextToken(v string) *ListEndpointGroupsInput {
	s.NextToken = &v
	return s
}

type ListEndpointGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the endpoint groups associated with a listener.
	EndpointGroups []*EndpointGroup `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEndpointGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointGroupsOutput) GoString() string {
	return s.String()
}

// SetEndpointGroups sets the EndpointGroups field's value.
func (s *ListEndpointGroupsOutput) SetEndpointGroups(v []*EndpointGroup) *ListEndpointGroupsOutput {
	s.EndpointGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointGroupsOutput) SetNextToken(v string) *ListEndpointGroupsOutput {
	s.NextToken = &v
	return s
}

type ListListenersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator for which you want to list
	// listener objects.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// The number of listener objects that you want to return with this call. The
	// default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListListenersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListListenersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListListenersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListListenersInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *ListListenersInput) SetAcceleratorArn(v string) *ListListenersInput {
	s.AcceleratorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListListenersInput) SetMaxResults(v int64) *ListListenersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListListenersInput) SetNextToken(v string) *ListListenersInput {
	s.NextToken = &v
	return s
}

type ListListenersOutput struct {
	_ struct{} `type:"structure"`

	// The list of listeners for an accelerator.
	Listeners []*Listener `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListListenersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListListenersOutput) GoString() string {
	return s.String()
}

// SetListeners sets the Listeners field's value.
func (s *ListListenersOutput) SetListeners(v []*Listener) *ListListenersOutput {
	s.Listeners = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListListenersOutput) SetNextToken(v string) *ListListenersOutput {
	s.NextToken = &v
	return s
}

// A complex type for a listener.
type Listener struct {
	_ struct{} `type:"structure"`

	// Client affinity lets you direct all requests from a user to the same endpoint,
	// if you have stateful applications, regardless of the port and protocol of
	// the client request. Clienty affinity gives you control over whether to always
	// route each client to the same specific endpoint.
	//
	// AWS Global Accelerator uses a consistent-flow hashing algorithm to choose
	// the optimal endpoint for a connection. If client affinity is NONE, Global
	// Accelerator uses the "five-tuple" (5-tuple) properties—source IP address,
	// source port, destination IP address, destination port, and protocol—to
	// select the hash value, and then chooses the best endpoint. However, with
	// this setting, if someone uses different ports to connect to Global Accelerator,
	// their connections might not be always routed to the same endpoint because
	// the hash value changes.
	//
	// If you want a given client to always be routed to the same endpoint, set
	// client affinity to SOURCE_IP instead. When you use the SOURCE_IP setting,
	// Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client)
	// IP address and destination IP address—to select the hash value.
	//
	// The default value is NONE.
	ClientAffinity *string `type:"string" enum:"ClientAffinity"`

	// The Amazon Resource Name (ARN) of the listener.
	ListenerArn *string `type:"string"`

	// The list of port ranges for the connections from clients to the accelerator.
	PortRanges []*PortRange `min:"1" type:"list"`

	// The protocol for the connections from clients to the accelerator.
	Protocol *string `type:"string" enum:"Protocol"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Listener) GoString() string {
	return s.String()
}

// SetClientAffinity sets the ClientAffinity field's value.
func (s *Listener) SetClientAffinity(v string) *Listener {
	s.ClientAffinity = &v
	return s
}

// SetListenerArn sets the ListenerArn field's value.
func (s *Listener) SetListenerArn(v string) *Listener {
	s.ListenerArn = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *Listener) SetPortRanges(v []*PortRange) *Listener {
	s.PortRanges = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Listener) SetProtocol(v string) *Listener {
	s.Protocol = &v
	return s
}

// The listener that you specified doesn't exist.
type ListenerNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ListenerNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListenerNotFoundException) GoString() string {
	return s.String()
}

func newErrorListenerNotFoundException(v protocol.ResponseMetadata) error {
	return &ListenerNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ListenerNotFoundException) Code() string {
	return "ListenerNotFoundException"
}

// Message returns the exception's message.
func (s ListenerNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ListenerNotFoundException) OrigErr() error {
	return nil
}

func (s ListenerNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ListenerNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ListenerNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// A complex type for a range of ports for a listener.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The first port in the range of ports, inclusive.
	FromPort *int64 `min:"1" type:"integer"`

	// The last port in the range of ports, inclusive.
	ToPort *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortRange"}
	if s.FromPort != nil && *s.FromPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FromPort", 1))
	}
	if s.ToPort != nil && *s.ToPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ToPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromPort sets the FromPort field's value.
func (s *PortRange) SetFromPort(v int64) *PortRange {
	s.FromPort = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *PortRange) SetToPort(v int64) *PortRange {
	s.ToPort = &v
	return s
}

type UpdateAcceleratorAttributesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator that you want to update.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// Update whether flow logs are enabled. The default value is false. If the
	// value is true, FlowLogsS3Bucket and FlowLogsS3Prefix must be specified.
	//
	// For more information, see Flow Logs (https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html)
	// in the AWS Global Accelerator Developer Guide.
	FlowLogsEnabled *bool `type:"boolean"`

	// The name of the Amazon S3 bucket for the flow logs. Attribute is required
	// if FlowLogsEnabled is true. The bucket must exist and have a bucket policy
	// that grants AWS Global Accelerator permission to write to the bucket.
	FlowLogsS3Bucket *string `type:"string"`

	// Update the prefix for the location in the Amazon S3 bucket for the flow logs.
	// Attribute is required if FlowLogsEnabled is true. If you don’t specify
	// a prefix, the flow logs are stored in the root of the bucket.
	FlowLogsS3Prefix *string `type:"string"`
}

// String returns the string representation
func (s UpdateAcceleratorAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAcceleratorAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAcceleratorAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAcceleratorAttributesInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *UpdateAcceleratorAttributesInput) SetAcceleratorArn(v string) *UpdateAcceleratorAttributesInput {
	s.AcceleratorArn = &v
	return s
}

// SetFlowLogsEnabled sets the FlowLogsEnabled field's value.
func (s *UpdateAcceleratorAttributesInput) SetFlowLogsEnabled(v bool) *UpdateAcceleratorAttributesInput {
	s.FlowLogsEnabled = &v
	return s
}

// SetFlowLogsS3Bucket sets the FlowLogsS3Bucket field's value.
func (s *UpdateAcceleratorAttributesInput) SetFlowLogsS3Bucket(v string) *UpdateAcceleratorAttributesInput {
	s.FlowLogsS3Bucket = &v
	return s
}

// SetFlowLogsS3Prefix sets the FlowLogsS3Prefix field's value.
func (s *UpdateAcceleratorAttributesInput) SetFlowLogsS3Prefix(v string) *UpdateAcceleratorAttributesInput {
	s.FlowLogsS3Prefix = &v
	return s
}

type UpdateAcceleratorAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Updated attributes for the accelerator.
	AcceleratorAttributes *AcceleratorAttributes `type:"structure"`
}

// String returns the string representation
func (s UpdateAcceleratorAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAcceleratorAttributesOutput) GoString() string {
	return s.String()
}

// SetAcceleratorAttributes sets the AcceleratorAttributes field's value.
func (s *UpdateAcceleratorAttributesOutput) SetAcceleratorAttributes(v *AcceleratorAttributes) *UpdateAcceleratorAttributesOutput {
	s.AcceleratorAttributes = v
	return s
}

type UpdateAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to update.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`

	// Indicates whether an accelerator is enabled. The value is true or false.
	// The default value is true.
	//
	// If the value is set to true, the accelerator cannot be deleted. If set to
	// false, the accelerator can be deleted.
	Enabled *bool `type:"boolean"`

	// The value for the address type must be IPv4.
	IpAddressType *string `type:"string" enum:"IpAddressType"`

	// The name of the accelerator. The name can have a maximum of 32 characters,
	// must contain only alphanumeric characters or hyphens (-), and must not begin
	// or end with a hyphen.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAcceleratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAcceleratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAcceleratorInput"}
	if s.AcceleratorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorArn sets the AcceleratorArn field's value.
func (s *UpdateAcceleratorInput) SetAcceleratorArn(v string) *UpdateAcceleratorInput {
	s.AcceleratorArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateAcceleratorInput) SetEnabled(v bool) *UpdateAcceleratorInput {
	s.Enabled = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *UpdateAcceleratorInput) SetIpAddressType(v string) *UpdateAcceleratorInput {
	s.IpAddressType = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAcceleratorInput) SetName(v string) *UpdateAcceleratorInput {
	s.Name = &v
	return s
}

type UpdateAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated accelerator.
	Accelerator *Accelerator `type:"structure"`
}

// String returns the string representation
func (s UpdateAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAcceleratorOutput) GoString() string {
	return s.String()
}

// SetAccelerator sets the Accelerator field's value.
func (s *UpdateAcceleratorOutput) SetAccelerator(v *Accelerator) *UpdateAcceleratorOutput {
	s.Accelerator = v
	return s
}

type UpdateEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// The list of endpoint objects.
	EndpointConfigurations []*EndpointConfiguration `type:"list"`

	// The Amazon Resource Name (ARN) of the endpoint group.
	//
	// EndpointGroupArn is a required field
	EndpointGroupArn *string `type:"string" required:"true"`

	// The time—10 seconds or 30 seconds—between each health check for an endpoint.
	// The default value is 30.
	HealthCheckIntervalSeconds *int64 `min:"10" type:"integer"`

	// If the protocol is HTTP/S, then this specifies the path that is the destination
	// for health check targets. The default value is slash (/).
	HealthCheckPath *string `type:"string"`

	// The port that AWS Global Accelerator uses to check the health of endpoints
	// that are part of this endpoint group. The default port is the listener port
	// that this endpoint group is associated with. If the listener port is a list
	// of ports, Global Accelerator uses the first port in the list.
	HealthCheckPort *int64 `min:"1" type:"integer"`

	// The protocol that AWS Global Accelerator uses to check the health of endpoints
	// that are part of this endpoint group. The default value is TCP.
	HealthCheckProtocol *string `type:"string" enum:"HealthCheckProtocol"`

	// The number of consecutive health checks required to set the state of a healthy
	// endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default
	// value is 3.
	ThresholdCount *int64 `min:"1" type:"integer"`

	// The percentage of traffic to send to an AWS Region. Additional traffic is
	// distributed to other endpoint groups for this listener.
	//
	// Use this action to increase (dial up) or decrease (dial down) traffic to
	// a specific Region. The percentage is applied to the traffic that would otherwise
	// have been routed to the Region based on optimal routing.
	//
	// The default value is 100.
	TrafficDialPercentage *float64 `type:"float"`
}

// String returns the string representation
func (s UpdateEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointGroupInput"}
	if s.EndpointGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointGroupArn"))
	}
	if s.HealthCheckIntervalSeconds != nil && *s.HealthCheckIntervalSeconds < 10 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckIntervalSeconds", 10))
	}
	if s.HealthCheckPort != nil && *s.HealthCheckPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("HealthCheckPort", 1))
	}
	if s.ThresholdCount != nil && *s.ThresholdCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ThresholdCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointConfigurations sets the EndpointConfigurations field's value.
func (s *UpdateEndpointGroupInput) SetEndpointConfigurations(v []*EndpointConfiguration) *UpdateEndpointGroupInput {
	s.EndpointConfigurations = v
	return s
}

// SetEndpointGroupArn sets the EndpointGroupArn field's value.
func (s *UpdateEndpointGroupInput) SetEndpointGroupArn(v string) *UpdateEndpointGroupInput {
	s.EndpointGroupArn = &v
	return s
}

// SetHealthCheckIntervalSeconds sets the HealthCheckIntervalSeconds field's value.
func (s *UpdateEndpointGroupInput) SetHealthCheckIntervalSeconds(v int64) *UpdateEndpointGroupInput {
	s.HealthCheckIntervalSeconds = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *UpdateEndpointGroupInput) SetHealthCheckPath(v string) *UpdateEndpointGroupInput {
	s.HealthCheckPath = &v
	return s
}

// SetHealthCheckPort sets the HealthCheckPort field's value.
func (s *UpdateEndpointGroupInput) SetHealthCheckPort(v int64) *UpdateEndpointGroupInput {
	s.HealthCheckPort = &v
	return s
}

// SetHealthCheckProtocol sets the HealthCheckProtocol field's value.
func (s *UpdateEndpointGroupInput) SetHealthCheckProtocol(v string) *UpdateEndpointGroupInput {
	s.HealthCheckProtocol = &v
	return s
}

// SetThresholdCount sets the ThresholdCount field's value.
func (s *UpdateEndpointGroupInput) SetThresholdCount(v int64) *UpdateEndpointGroupInput {
	s.ThresholdCount = &v
	return s
}

// SetTrafficDialPercentage sets the TrafficDialPercentage field's value.
func (s *UpdateEndpointGroupInput) SetTrafficDialPercentage(v float64) *UpdateEndpointGroupInput {
	s.TrafficDialPercentage = &v
	return s
}

type UpdateEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// The information about the endpoint group that was updated.
	EndpointGroup *EndpointGroup `type:"structure"`
}

// String returns the string representation
func (s UpdateEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetEndpointGroup sets the EndpointGroup field's value.
func (s *UpdateEndpointGroupOutput) SetEndpointGroup(v *EndpointGroup) *UpdateEndpointGroupOutput {
	s.EndpointGroup = v
	return s
}

type UpdateListenerInput struct {
	_ struct{} `type:"structure"`

	// Client affinity lets you direct all requests from a user to the same endpoint,
	// if you have stateful applications, regardless of the port and protocol of
	// the client request. Clienty affinity gives you control over whether to always
	// route each client to the same specific endpoint.
	//
	// AWS Global Accelerator uses a consistent-flow hashing algorithm to choose
	// the optimal endpoint for a connection. If client affinity is NONE, Global
	// Accelerator uses the "five-tuple" (5-tuple) properties—source IP address,
	// source port, destination IP address, destination port, and protocol—to
	// select the hash value, and then chooses the best endpoint. However, with
	// this setting, if someone uses different ports to connect to Global Accelerator,
	// their connections might not be always routed to the same endpoint because
	// the hash value changes.
	//
	// If you want a given client to always be routed to the same endpoint, set
	// client affinity to SOURCE_IP instead. When you use the SOURCE_IP setting,
	// Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client)
	// IP address and destination IP address—to select the hash value.
	//
	// The default value is NONE.
	ClientAffinity *string `type:"string" enum:"ClientAffinity"`

	// The Amazon Resource Name (ARN) of the listener to update.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The updated list of port ranges for the connections from clients to the accelerator.
	PortRanges []*PortRange `min:"1" type:"list"`

	// The updated protocol for the connections from clients to the accelerator.
	Protocol *string `type:"string" enum:"Protocol"`
}

// String returns the string representation
func (s UpdateListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateListenerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateListenerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateListenerInput"}
	if s.ListenerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ListenerArn"))
	}
	if s.PortRanges != nil && len(s.PortRanges) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortRanges", 1))
	}
	if s.PortRanges != nil {
		for i, v := range s.PortRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientAffinity sets the ClientAffinity field's value.
func (s *UpdateListenerInput) SetClientAffinity(v string) *UpdateListenerInput {
	s.ClientAffinity = &v
	return s
}

// SetListenerArn sets the ListenerArn field's value.
func (s *UpdateListenerInput) SetListenerArn(v string) *UpdateListenerInput {
	s.ListenerArn = &v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *UpdateListenerInput) SetPortRanges(v []*PortRange) *UpdateListenerInput {
	s.PortRanges = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateListenerInput) SetProtocol(v string) *UpdateListenerInput {
	s.Protocol = &v
	return s
}

type UpdateListenerOutput struct {
	_ struct{} `type:"structure"`

	// Information for the updated listener.
	Listener *Listener `type:"structure"`
}

// String returns the string representation
func (s UpdateListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateListenerOutput) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *UpdateListenerOutput) SetListener(v *Listener) *UpdateListenerOutput {
	s.Listener = v
	return s
}

const (
	// AcceleratorStatusDeployed is a AcceleratorStatus enum value
	AcceleratorStatusDeployed = "DEPLOYED"

	// AcceleratorStatusInProgress is a AcceleratorStatus enum value
	AcceleratorStatusInProgress = "IN_PROGRESS"
)

const (
	// ClientAffinityNone is a ClientAffinity enum value
	ClientAffinityNone = "NONE"

	// ClientAffinitySourceIp is a ClientAffinity enum value
	ClientAffinitySourceIp = "SOURCE_IP"
)

const (
	// HealthCheckProtocolTcp is a HealthCheckProtocol enum value
	HealthCheckProtocolTcp = "TCP"

	// HealthCheckProtocolHttp is a HealthCheckProtocol enum value
	HealthCheckProtocolHttp = "HTTP"

	// HealthCheckProtocolHttps is a HealthCheckProtocol enum value
	HealthCheckProtocolHttps = "HTTPS"
)

const (
	// HealthStateInitial is a HealthState enum value
	HealthStateInitial = "INITIAL"

	// HealthStateHealthy is a HealthState enum value
	HealthStateHealthy = "HEALTHY"

	// HealthStateUnhealthy is a HealthState enum value
	HealthStateUnhealthy = "UNHEALTHY"
)

const (
	// IpAddressTypeIpv4 is a IpAddressType enum value
	IpAddressTypeIpv4 = "IPV4"
)

const (
	// ProtocolTcp is a Protocol enum value
	ProtocolTcp = "TCP"

	// ProtocolUdp is a Protocol enum value
	ProtocolUdp = "UDP"
)
