// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetMaintenanceWindowExecutionTaskInvocationInput struct {
	_ struct{} `type:"structure"`

	// The invocation ID to retrieve.
	//
	// InvocationId is a required field
	InvocationId *string `min:"36" type:"string" required:"true"`

	// The ID of the specific task in the maintenance window task that should be
	// retrieved.
	//
	// TaskId is a required field
	TaskId *string `min:"36" type:"string" required:"true"`

	// The ID of the maintenance window execution for which the task is a part.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMaintenanceWindowExecutionTaskInvocationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMaintenanceWindowExecutionTaskInvocationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMaintenanceWindowExecutionTaskInvocationInput"}

	if s.InvocationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InvocationId"))
	}
	if s.InvocationId != nil && len(*s.InvocationId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("InvocationId", 36))
	}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 36))
	}

	if s.WindowExecutionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("WindowExecutionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetMaintenanceWindowExecutionTaskInvocationOutput struct {
	_ struct{} `type:"structure"`

	// The time that the task finished running on the target.
	EndTime *time.Time `type:"timestamp"`

	// The execution ID.
	ExecutionId *string `type:"string"`

	// The invocation ID.
	InvocationId *string `min:"36" type:"string"`

	// User-provided value to be included in any CloudWatch events raised while
	// running tasks for these targets in this maintenance window.
	OwnerInformation *string `min:"1" type:"string" sensitive:"true"`

	// The parameters used at the time that the task ran.
	Parameters *string `type:"string" sensitive:"true"`

	// The time that the task started running on the target.
	StartTime *time.Time `type:"timestamp"`

	// The task status for an invocation.
	Status MaintenanceWindowExecutionStatus `type:"string" enum:"true"`

	// The details explaining the status. Details are only available for certain
	// status values.
	StatusDetails *string `type:"string"`

	// The task execution ID.
	TaskExecutionId *string `min:"36" type:"string"`

	// Retrieves the task type for a maintenance window. Task types include the
	// following: LAMBDA, STEP_FUNCTIONS, AUTOMATION, RUN_COMMAND.
	TaskType MaintenanceWindowTaskType `type:"string" enum:"true"`

	// The maintenance window execution ID.
	WindowExecutionId *string `min:"36" type:"string"`

	// The maintenance window target ID.
	WindowTargetId *string `type:"string"`
}

// String returns the string representation
func (s GetMaintenanceWindowExecutionTaskInvocationOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetMaintenanceWindowExecutionTaskInvocation = "GetMaintenanceWindowExecutionTaskInvocation"

// GetMaintenanceWindowExecutionTaskInvocationRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Retrieves information about a specific task running on a specific target.
//
//    // Example sending a request using GetMaintenanceWindowExecutionTaskInvocationRequest.
//    req := client.GetMaintenanceWindowExecutionTaskInvocationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation
func (c *Client) GetMaintenanceWindowExecutionTaskInvocationRequest(input *GetMaintenanceWindowExecutionTaskInvocationInput) GetMaintenanceWindowExecutionTaskInvocationRequest {
	op := &aws.Operation{
		Name:       opGetMaintenanceWindowExecutionTaskInvocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowExecutionTaskInvocationInput{}
	}

	req := c.newRequest(op, input, &GetMaintenanceWindowExecutionTaskInvocationOutput{})
	return GetMaintenanceWindowExecutionTaskInvocationRequest{Request: req, Input: input, Copy: c.GetMaintenanceWindowExecutionTaskInvocationRequest}
}

// GetMaintenanceWindowExecutionTaskInvocationRequest is the request type for the
// GetMaintenanceWindowExecutionTaskInvocation API operation.
type GetMaintenanceWindowExecutionTaskInvocationRequest struct {
	*aws.Request
	Input *GetMaintenanceWindowExecutionTaskInvocationInput
	Copy  func(*GetMaintenanceWindowExecutionTaskInvocationInput) GetMaintenanceWindowExecutionTaskInvocationRequest
}

// Send marshals and sends the GetMaintenanceWindowExecutionTaskInvocation API request.
func (r GetMaintenanceWindowExecutionTaskInvocationRequest) Send(ctx context.Context) (*GetMaintenanceWindowExecutionTaskInvocationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMaintenanceWindowExecutionTaskInvocationResponse{
		GetMaintenanceWindowExecutionTaskInvocationOutput: r.Request.Data.(*GetMaintenanceWindowExecutionTaskInvocationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMaintenanceWindowExecutionTaskInvocationResponse is the response type for the
// GetMaintenanceWindowExecutionTaskInvocation API operation.
type GetMaintenanceWindowExecutionTaskInvocationResponse struct {
	*GetMaintenanceWindowExecutionTaskInvocationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMaintenanceWindowExecutionTaskInvocation request.
func (r *GetMaintenanceWindowExecutionTaskInvocationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
