// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package snsiface provides an interface to enable mocking the Amazon Simple Notification Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package snsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/sns"
)

// ClientAPI provides an interface to enable mocking the
// sns.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon SNS.
//    func myFunc(svc snsiface.ClientAPI) bool {
//        // Make svc.AddPermission request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := sns.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        snsiface.ClientPI
//    }
//    func (m *mockClientClient) AddPermission(input *sns.AddPermissionInput) (*sns.AddPermissionOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AddPermissionRequest(*sns.AddPermissionInput) sns.AddPermissionRequest

	CheckIfPhoneNumberIsOptedOutRequest(*sns.CheckIfPhoneNumberIsOptedOutInput) sns.CheckIfPhoneNumberIsOptedOutRequest

	ConfirmSubscriptionRequest(*sns.ConfirmSubscriptionInput) sns.ConfirmSubscriptionRequest

	CreatePlatformApplicationRequest(*sns.CreatePlatformApplicationInput) sns.CreatePlatformApplicationRequest

	CreatePlatformEndpointRequest(*sns.CreatePlatformEndpointInput) sns.CreatePlatformEndpointRequest

	CreateTopicRequest(*sns.CreateTopicInput) sns.CreateTopicRequest

	DeleteEndpointRequest(*sns.DeleteEndpointInput) sns.DeleteEndpointRequest

	DeletePlatformApplicationRequest(*sns.DeletePlatformApplicationInput) sns.DeletePlatformApplicationRequest

	DeleteTopicRequest(*sns.DeleteTopicInput) sns.DeleteTopicRequest

	GetEndpointAttributesRequest(*sns.GetEndpointAttributesInput) sns.GetEndpointAttributesRequest

	GetPlatformApplicationAttributesRequest(*sns.GetPlatformApplicationAttributesInput) sns.GetPlatformApplicationAttributesRequest

	GetSMSAttributesRequest(*sns.GetSMSAttributesInput) sns.GetSMSAttributesRequest

	GetSubscriptionAttributesRequest(*sns.GetSubscriptionAttributesInput) sns.GetSubscriptionAttributesRequest

	GetTopicAttributesRequest(*sns.GetTopicAttributesInput) sns.GetTopicAttributesRequest

	ListEndpointsByPlatformApplicationRequest(*sns.ListEndpointsByPlatformApplicationInput) sns.ListEndpointsByPlatformApplicationRequest

	ListPhoneNumbersOptedOutRequest(*sns.ListPhoneNumbersOptedOutInput) sns.ListPhoneNumbersOptedOutRequest

	ListPlatformApplicationsRequest(*sns.ListPlatformApplicationsInput) sns.ListPlatformApplicationsRequest

	ListSubscriptionsRequest(*sns.ListSubscriptionsInput) sns.ListSubscriptionsRequest

	ListSubscriptionsByTopicRequest(*sns.ListSubscriptionsByTopicInput) sns.ListSubscriptionsByTopicRequest

	ListTagsForResourceRequest(*sns.ListTagsForResourceInput) sns.ListTagsForResourceRequest

	ListTopicsRequest(*sns.ListTopicsInput) sns.ListTopicsRequest

	OptInPhoneNumberRequest(*sns.OptInPhoneNumberInput) sns.OptInPhoneNumberRequest

	PublishRequest(*sns.PublishInput) sns.PublishRequest

	RemovePermissionRequest(*sns.RemovePermissionInput) sns.RemovePermissionRequest

	SetEndpointAttributesRequest(*sns.SetEndpointAttributesInput) sns.SetEndpointAttributesRequest

	SetPlatformApplicationAttributesRequest(*sns.SetPlatformApplicationAttributesInput) sns.SetPlatformApplicationAttributesRequest

	SetSMSAttributesRequest(*sns.SetSMSAttributesInput) sns.SetSMSAttributesRequest

	SetSubscriptionAttributesRequest(*sns.SetSubscriptionAttributesInput) sns.SetSubscriptionAttributesRequest

	SetTopicAttributesRequest(*sns.SetTopicAttributesInput) sns.SetTopicAttributesRequest

	SubscribeRequest(*sns.SubscribeInput) sns.SubscribeRequest

	TagResourceRequest(*sns.TagResourceInput) sns.TagResourceRequest

	UnsubscribeRequest(*sns.UnsubscribeInput) sns.UnsubscribeRequest

	UntagResourceRequest(*sns.UntagResourceInput) sns.UntagResourceRequest
}

var _ ClientAPI = (*sns.Client)(nil)
