// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteModelPackageInput struct {
	_ struct{} `type:"structure"`

	// The name of the model package. The name must have 1 to 63 characters. Valid
	// characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// ModelPackageName is a required field
	ModelPackageName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteModelPackageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelPackageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteModelPackageInput"}

	if s.ModelPackageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelPackageName"))
	}
	if s.ModelPackageName != nil && len(*s.ModelPackageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelPackageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteModelPackageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteModelPackageOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteModelPackage = "DeleteModelPackage"

// DeleteModelPackageRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Deletes a model package.
//
// A model package is used to create Amazon SageMaker models or list on AWS
// Marketplace. Buyers can subscribe to model packages listed on AWS Marketplace
// to create models in Amazon SageMaker.
//
//    // Example sending a request using DeleteModelPackageRequest.
//    req := client.DeleteModelPackageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage
func (c *Client) DeleteModelPackageRequest(input *DeleteModelPackageInput) DeleteModelPackageRequest {
	op := &aws.Operation{
		Name:       opDeleteModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelPackageInput{}
	}

	req := c.newRequest(op, input, &DeleteModelPackageOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteModelPackageRequest{Request: req, Input: input, Copy: c.DeleteModelPackageRequest}
}

// DeleteModelPackageRequest is the request type for the
// DeleteModelPackage API operation.
type DeleteModelPackageRequest struct {
	*aws.Request
	Input *DeleteModelPackageInput
	Copy  func(*DeleteModelPackageInput) DeleteModelPackageRequest
}

// Send marshals and sends the DeleteModelPackage API request.
func (r DeleteModelPackageRequest) Send(ctx context.Context) (*DeleteModelPackageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteModelPackageResponse{
		DeleteModelPackageOutput: r.Request.Data.(*DeleteModelPackageOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteModelPackageResponse is the response type for the
// DeleteModelPackage API operation.
type DeleteModelPackageResponse struct {
	*DeleteModelPackageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteModelPackage request.
func (r *DeleteModelPackageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
