// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type PutBucketAccelerateConfigurationInput struct {
	_ struct{} `type:"structure" payload:"AccelerateConfiguration"`

	// Container for setting the transfer acceleration state.
	//
	// AccelerateConfiguration is a required field
	AccelerateConfiguration *AccelerateConfiguration `locationName:"AccelerateConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Name of the bucket for which the accelerate configuration is set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketAccelerateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAccelerateConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketAccelerateConfigurationInput"}

	if s.AccelerateConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccelerateConfiguration"))
	}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketAccelerateConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAccelerateConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.AccelerateConfiguration != nil {
		v := s.AccelerateConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "AccelerateConfiguration", v, metadata)
	}
	return nil
}

type PutBucketAccelerateConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAccelerateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketAccelerateConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketAccelerateConfiguration = "PutBucketAccelerateConfiguration"

// PutBucketAccelerateConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the accelerate configuration of an existing bucket. Amazon S3 Transfer
// Acceleration is a bucket-level feature that enables you to perform faster
// data transfers to Amazon S3.
//
// To use this operation, you must have permission to perform the s3:PutAccelerateConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html).
//
// The Transfer Acceleration state of a bucket can be set to one of the following
// two values:
//
//    * Enabled – Enables accelerated data transfers to the bucket.
//
//    * Suspended – Disables accelerated data transfers to the bucket.
//
// The GetBucketAccelerateConfiguration operation returns the transfer acceleration
// state of a bucket.
//
// After setting the Transfer Acceleration state of a bucket to Enabled, it
// might take up to thirty minutes before the data transfer rates to the bucket
// increase.
//
// The name of the bucket used for Transfer Acceleration must be DNS-compliant
// and must not contain periods (".").
//
// For more information about transfer acceleration, see Transfer Acceleration
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html).
//
// The following operations are related to PutBucketAccelerateConfiguration:
//
//    * GetBucketAccelerateConfiguration
//
//    * CreateBucket
//
//    // Example sending a request using PutBucketAccelerateConfigurationRequest.
//    req := client.PutBucketAccelerateConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfiguration
func (c *Client) PutBucketAccelerateConfigurationRequest(input *PutBucketAccelerateConfigurationInput) PutBucketAccelerateConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketAccelerateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &PutBucketAccelerateConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutBucketAccelerateConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketAccelerateConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketAccelerateConfigurationRequest}
}

// PutBucketAccelerateConfigurationRequest is the request type for the
// PutBucketAccelerateConfiguration API operation.
type PutBucketAccelerateConfigurationRequest struct {
	*aws.Request
	Input *PutBucketAccelerateConfigurationInput
	Copy  func(*PutBucketAccelerateConfigurationInput) PutBucketAccelerateConfigurationRequest
}

// Send marshals and sends the PutBucketAccelerateConfiguration API request.
func (r PutBucketAccelerateConfigurationRequest) Send(ctx context.Context) (*PutBucketAccelerateConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketAccelerateConfigurationResponse{
		PutBucketAccelerateConfigurationOutput: r.Request.Data.(*PutBucketAccelerateConfigurationOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketAccelerateConfigurationResponse is the response type for the
// PutBucketAccelerateConfiguration API operation.
type PutBucketAccelerateConfigurationResponse struct {
	*PutBucketAccelerateConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketAccelerateConfiguration request.
func (r *PutBucketAccelerateConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
