// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RestoreTableFromClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift cluster to restore the table to.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the table to create as a result of the current request.
	//
	// NewTableName is a required field
	NewTableName *string `type:"string" required:"true"`

	// The identifier of the snapshot to restore the table from. This snapshot must
	// have been created from the Amazon Redshift cluster specified by the ClusterIdentifier
	// parameter.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// The name of the source database that contains the table to restore from.
	//
	// SourceDatabaseName is a required field
	SourceDatabaseName *string `type:"string" required:"true"`

	// The name of the source schema that contains the table to restore from. If
	// you do not specify a SourceSchemaName value, the default is public.
	SourceSchemaName *string `type:"string"`

	// The name of the source table to restore from.
	//
	// SourceTableName is a required field
	SourceTableName *string `type:"string" required:"true"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `type:"string"`
}

// String returns the string representation
func (s RestoreTableFromClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableFromClusterSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreTableFromClusterSnapshotInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if s.NewTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NewTableName"))
	}

	if s.SnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotIdentifier"))
	}

	if s.SourceDatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceDatabaseName"))
	}

	if s.SourceTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceTableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RestoreTableFromClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes the status of a RestoreTableFromClusterSnapshot operation.
	TableRestoreStatus *TableRestoreStatus `type:"structure"`
}

// String returns the string representation
func (s RestoreTableFromClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opRestoreTableFromClusterSnapshot = "RestoreTableFromClusterSnapshot"

// RestoreTableFromClusterSnapshotRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Creates a new table from a table in an Amazon Redshift cluster snapshot.
// You must create the new table within the Amazon Redshift cluster that the
// snapshot was taken from.
//
// You cannot use RestoreTableFromClusterSnapshot to restore a table with the
// same name as an existing table in an Amazon Redshift cluster. That is, you
// cannot overwrite an existing table in a cluster with a restored table. If
// you want to replace your original table with a new, restored table, then
// rename or drop your original table before you call RestoreTableFromClusterSnapshot.
// When you have renamed your original table, then you can pass the original
// name of the table as the NewTableName parameter value in the call to RestoreTableFromClusterSnapshot.
// This way, you can replace the original table with the table created from
// the snapshot.
//
//    // Example sending a request using RestoreTableFromClusterSnapshotRequest.
//    req := client.RestoreTableFromClusterSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshot
func (c *Client) RestoreTableFromClusterSnapshotRequest(input *RestoreTableFromClusterSnapshotInput) RestoreTableFromClusterSnapshotRequest {
	op := &aws.Operation{
		Name:       opRestoreTableFromClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableFromClusterSnapshotInput{}
	}

	req := c.newRequest(op, input, &RestoreTableFromClusterSnapshotOutput{})
	return RestoreTableFromClusterSnapshotRequest{Request: req, Input: input, Copy: c.RestoreTableFromClusterSnapshotRequest}
}

// RestoreTableFromClusterSnapshotRequest is the request type for the
// RestoreTableFromClusterSnapshot API operation.
type RestoreTableFromClusterSnapshotRequest struct {
	*aws.Request
	Input *RestoreTableFromClusterSnapshotInput
	Copy  func(*RestoreTableFromClusterSnapshotInput) RestoreTableFromClusterSnapshotRequest
}

// Send marshals and sends the RestoreTableFromClusterSnapshot API request.
func (r RestoreTableFromClusterSnapshotRequest) Send(ctx context.Context) (*RestoreTableFromClusterSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreTableFromClusterSnapshotResponse{
		RestoreTableFromClusterSnapshotOutput: r.Request.Data.(*RestoreTableFromClusterSnapshotOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreTableFromClusterSnapshotResponse is the response type for the
// RestoreTableFromClusterSnapshot API operation.
type RestoreTableFromClusterSnapshotResponse struct {
	*RestoreTableFromClusterSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreTableFromClusterSnapshot request.
func (r *RestoreTableFromClusterSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
