// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListTemplatesInput struct {
	_ struct{} `type:"structure"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	TemplateType *string `location:"querystring" locationName:"template-type" type:"string"`
}

// String returns the string representation
func (s ListTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTemplatesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "page-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateType != nil {
		v := *s.TemplateType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "template-type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListTemplatesOutput struct {
	_ struct{} `type:"structure" payload:"TemplatesResponse"`

	// Provides information about all the message templates that are associated
	// with your Amazon Pinpoint account.
	//
	// TemplatesResponse is a required field
	TemplatesResponse *TemplatesResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTemplatesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.TemplatesResponse != nil {
		v := s.TemplatesResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "TemplatesResponse", v, metadata)
	}
	return nil
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about all the message templates that are associated
// with your Amazon Pinpoint account.
//
//    // Example sending a request using ListTemplatesRequest.
//    req := client.ListTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplates
func (c *Client) ListTemplatesRequest(input *ListTemplatesInput) ListTemplatesRequest {
	op := &aws.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/templates",
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	req := c.newRequest(op, input, &ListTemplatesOutput{})
	return ListTemplatesRequest{Request: req, Input: input, Copy: c.ListTemplatesRequest}
}

// ListTemplatesRequest is the request type for the
// ListTemplates API operation.
type ListTemplatesRequest struct {
	*aws.Request
	Input *ListTemplatesInput
	Copy  func(*ListTemplatesInput) ListTemplatesRequest
}

// Send marshals and sends the ListTemplates API request.
func (r ListTemplatesRequest) Send(ctx context.Context) (*ListTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTemplatesResponse{
		ListTemplatesOutput: r.Request.Data.(*ListTemplatesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListTemplatesResponse is the response type for the
// ListTemplates API operation.
type ListTemplatesResponse struct {
	*ListTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTemplates request.
func (r *ListTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
