// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetSegmentVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSegmentVersionInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.SegmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentId"))
	}

	if s.Version == nil {
		invalidParams.Add(aws.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSegmentVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SegmentId != nil {
		v := *s.SegmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "segment-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetSegmentVersionOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSegmentVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SegmentResponse != nil {
		v := s.SegmentResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "SegmentResponse", v, metadata)
	}
	return nil
}

const opGetSegmentVersion = "GetSegmentVersion"

// GetSegmentVersionRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for a specific version of a segment that's associated with an application.
//
//    // Example sending a request using GetSegmentVersionRequest.
//    req := client.GetSegmentVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion
func (c *Client) GetSegmentVersionRequest(input *GetSegmentVersionInput) GetSegmentVersionRequest {
	op := &aws.Operation{
		Name:       opGetSegmentVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}",
	}

	if input == nil {
		input = &GetSegmentVersionInput{}
	}

	req := c.newRequest(op, input, &GetSegmentVersionOutput{})
	return GetSegmentVersionRequest{Request: req, Input: input, Copy: c.GetSegmentVersionRequest}
}

// GetSegmentVersionRequest is the request type for the
// GetSegmentVersion API operation.
type GetSegmentVersionRequest struct {
	*aws.Request
	Input *GetSegmentVersionInput
	Copy  func(*GetSegmentVersionInput) GetSegmentVersionRequest
}

// Send marshals and sends the GetSegmentVersion API request.
func (r GetSegmentVersionRequest) Send(ctx context.Context) (*GetSegmentVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSegmentVersionResponse{
		GetSegmentVersionOutput: r.Request.Data.(*GetSegmentVersionOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSegmentVersionResponse is the response type for the
// GetSegmentVersion API operation.
type GetSegmentVersionResponse struct {
	*GetSegmentVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSegmentVersion request.
func (r *GetSegmentVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
