// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package outposts

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetOutpostInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Outpost.
	//
	// OutpostId is a required field
	OutpostId *string `location:"uri" locationName:"OutpostId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOutpostInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutpostInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetOutpostInput"}

	if s.OutpostId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutpostId"))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetOutpostInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.OutpostId != nil {
		v := *s.OutpostId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "OutpostId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetOutpostOutput struct {
	_ struct{} `type:"structure"`

	// Information about an Outpost.
	Outpost *Outpost `type:"structure"`
}

// String returns the string representation
func (s GetOutpostOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetOutpostOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Outpost != nil {
		v := s.Outpost

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Outpost", v, metadata)
	}
	return nil
}

const opGetOutpost = "GetOutpost"

// GetOutpostRequest returns a request value for making API operation for
// AWS Outposts.
//
// Gets information about the specified Outpost.
//
//    // Example sending a request using GetOutpostRequest.
//    req := client.GetOutpostRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost
func (c *Client) GetOutpostRequest(input *GetOutpostInput) GetOutpostRequest {
	op := &aws.Operation{
		Name:       opGetOutpost,
		HTTPMethod: "GET",
		HTTPPath:   "/outposts/{OutpostId}",
	}

	if input == nil {
		input = &GetOutpostInput{}
	}

	req := c.newRequest(op, input, &GetOutpostOutput{})
	return GetOutpostRequest{Request: req, Input: input, Copy: c.GetOutpostRequest}
}

// GetOutpostRequest is the request type for the
// GetOutpost API operation.
type GetOutpostRequest struct {
	*aws.Request
	Input *GetOutpostInput
	Copy  func(*GetOutpostInput) GetOutpostRequest
}

// Send marshals and sends the GetOutpost API request.
func (r GetOutpostRequest) Send(ctx context.Context) (*GetOutpostResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetOutpostResponse{
		GetOutpostOutput: r.Request.Data.(*GetOutpostOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetOutpostResponse is the response type for the
// GetOutpost API operation.
type GetOutpostResponse struct {
	*GetOutpostOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetOutpost request.
func (r *GetOutpostResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
