// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworkscm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateBackupInput struct {
	_ struct{} `type:"structure"`

	// A user-defined description of the backup.
	Description *string `type:"string"`

	// The name of the server that you want to back up.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBackupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateBackupInput"}

	if s.ServerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateBackupOutput struct {
	_ struct{} `type:"structure"`

	// Backup created by request.
	Backup *Backup `type:"structure"`
}

// String returns the string representation
func (s CreateBackupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateBackup = "CreateBackup"

// CreateBackupRequest returns a request value for making API operation for
// AWS OpsWorks CM.
//
// Creates an application-level backup of a server. While the server is in the
// BACKING_UP state, the server cannot be changed, and no additional backup
// can be created.
//
// Backups can be created for servers in RUNNING, HEALTHY, and UNHEALTHY states.
// By default, you can create a maximum of 50 manual backups.
//
// This operation is asynchronous.
//
// A LimitExceededException is thrown when the maximum number of manual backups
// is reached. An InvalidStateException is thrown when the server is not in
// any of the following states: RUNNING, HEALTHY, or UNHEALTHY. A ResourceNotFoundException
// is thrown when the server is not found. A ValidationException is thrown when
// parameters of the request are not valid.
//
//    // Example sending a request using CreateBackupRequest.
//    req := client.CreateBackupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateBackup
func (c *Client) CreateBackupRequest(input *CreateBackupInput) CreateBackupRequest {
	op := &aws.Operation{
		Name:       opCreateBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBackupInput{}
	}

	req := c.newRequest(op, input, &CreateBackupOutput{})
	return CreateBackupRequest{Request: req, Input: input, Copy: c.CreateBackupRequest}
}

// CreateBackupRequest is the request type for the
// CreateBackup API operation.
type CreateBackupRequest struct {
	*aws.Request
	Input *CreateBackupInput
	Copy  func(*CreateBackupInput) CreateBackupRequest
}

// Send marshals and sends the CreateBackup API request.
func (r CreateBackupRequest) Send(ctx context.Context) (*CreateBackupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateBackupResponse{
		CreateBackupOutput: r.Request.Data.(*CreateBackupOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateBackupResponse is the response type for the
// CreateBackup API operation.
type CreateBackupResponse struct {
	*CreateBackupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateBackup request.
func (r *CreateBackupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
