// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateLinkInput struct {
	_ struct{} `type:"structure"`

	// The upload speed and download speed in Mbps.
	//
	// Bandwidth is a required field
	Bandwidth *Bandwidth `type:"structure" required:"true"`

	// A description of the link.
	//
	// Length Constraints: Maximum length of 256 characters.
	Description *string `type:"string"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The provider of the link.
	//
	// Constraints: Cannot include the following characters: | \ ^
	//
	// Length Constraints: Maximum length of 128 characters.
	Provider *string `type:"string"`

	// The ID of the site.
	//
	// SiteId is a required field
	SiteId *string `type:"string" required:"true"`

	// The tags to apply to the resource during creation.
	Tags []Tag `type:"list"`

	// The type of the link.
	//
	// Constraints: Cannot include the following characters: | \ ^
	//
	// Length Constraints: Maximum length of 128 characters.
	Type *string `type:"string"`
}

// String returns the string representation
func (s CreateLinkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLinkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateLinkInput"}

	if s.Bandwidth == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bandwidth"))
	}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if s.SiteId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SiteId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateLinkInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Bandwidth != nil {
		v := s.Bandwidth

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Bandwidth", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Provider != nil {
		v := *s.Provider

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Provider", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateLinkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the link.
	Link *Link `type:"structure"`
}

// String returns the string representation
func (s CreateLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateLinkOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Link != nil {
		v := s.Link

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Link", v, metadata)
	}
	return nil
}

const opCreateLink = "CreateLink"

// CreateLinkRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Creates a new link for a specified site.
//
//    // Example sending a request using CreateLinkRequest.
//    req := client.CreateLinkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateLink
func (c *Client) CreateLinkRequest(input *CreateLinkInput) CreateLinkRequest {
	op := &aws.Operation{
		Name:       opCreateLink,
		HTTPMethod: "POST",
		HTTPPath:   "/global-networks/{globalNetworkId}/links",
	}

	if input == nil {
		input = &CreateLinkInput{}
	}

	req := c.newRequest(op, input, &CreateLinkOutput{})
	return CreateLinkRequest{Request: req, Input: input, Copy: c.CreateLinkRequest}
}

// CreateLinkRequest is the request type for the
// CreateLink API operation.
type CreateLinkRequest struct {
	*aws.Request
	Input *CreateLinkInput
	Copy  func(*CreateLinkInput) CreateLinkRequest
}

// Send marshals and sends the CreateLink API request.
func (r CreateLinkRequest) Send(ctx context.Context) (*CreateLinkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateLinkResponse{
		CreateLinkOutput: r.Request.Data.(*CreateLinkOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateLinkResponse is the response type for the
// CreateLink API operation.
type CreateLinkResponse struct {
	*CreateLinkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateLink request.
func (r *CreateLinkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
