// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListQualificationRequestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The ID of the QualificationType.
	QualificationTypeId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListQualificationRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQualificationRequestsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListQualificationRequestsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListQualificationRequestsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of Qualification requests on this page in the filtered results
	// list, equivalent to the number of Qualification requests being returned by
	// this call.
	NumResults *int64 `type:"integer"`

	// The Qualification request. The response includes one QualificationRequest
	// element for each Qualification request returned by the query.
	QualificationRequests []QualificationRequest `type:"list"`
}

// String returns the string representation
func (s ListQualificationRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListQualificationRequests = "ListQualificationRequests"

// ListQualificationRequestsRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The ListQualificationRequests operation retrieves requests for Qualifications
// of a particular Qualification type. The owner of the Qualification type calls
// this operation to poll for pending requests, and accepts them using the AcceptQualification
// operation.
//
//    // Example sending a request using ListQualificationRequestsRequest.
//    req := client.ListQualificationRequestsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests
func (c *Client) ListQualificationRequestsRequest(input *ListQualificationRequestsInput) ListQualificationRequestsRequest {
	op := &aws.Operation{
		Name:       opListQualificationRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQualificationRequestsInput{}
	}

	req := c.newRequest(op, input, &ListQualificationRequestsOutput{})
	return ListQualificationRequestsRequest{Request: req, Input: input, Copy: c.ListQualificationRequestsRequest}
}

// ListQualificationRequestsRequest is the request type for the
// ListQualificationRequests API operation.
type ListQualificationRequestsRequest struct {
	*aws.Request
	Input *ListQualificationRequestsInput
	Copy  func(*ListQualificationRequestsInput) ListQualificationRequestsRequest
}

// Send marshals and sends the ListQualificationRequests API request.
func (r ListQualificationRequestsRequest) Send(ctx context.Context) (*ListQualificationRequestsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListQualificationRequestsResponse{
		ListQualificationRequestsOutput: r.Request.Data.(*ListQualificationRequestsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListQualificationRequestsRequestPaginator returns a paginator for ListQualificationRequests.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListQualificationRequestsRequest(input)
//   p := mturk.NewListQualificationRequestsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListQualificationRequestsPaginator(req ListQualificationRequestsRequest) ListQualificationRequestsPaginator {
	return ListQualificationRequestsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListQualificationRequestsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListQualificationRequestsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListQualificationRequestsPaginator struct {
	aws.Pager
}

func (p *ListQualificationRequestsPaginator) CurrentPage() *ListQualificationRequestsOutput {
	return p.Pager.CurrentPage().(*ListQualificationRequestsOutput)
}

// ListQualificationRequestsResponse is the response type for the
// ListQualificationRequests API operation.
type ListQualificationRequestsResponse struct {
	*ListQualificationRequestsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListQualificationRequests request.
func (r *ListQualificationRequestsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
