// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCorsPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that the policy is assigned to.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCorsPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCorsPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCorsPolicyInput"}

	if s.ContainerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCorsPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The CORS policy assigned to the container.
	//
	// CorsPolicy is a required field
	CorsPolicy []CorsRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s GetCorsPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCorsPolicy = "GetCorsPolicy"

// GetCorsPolicyRequest returns a request value for making API operation for
// AWS Elemental MediaStore.
//
// Returns the cross-origin resource sharing (CORS) configuration information
// that is set for the container.
//
// To use this operation, you must have permission to perform the MediaStore:GetCorsPolicy
// action. By default, the container owner has this permission and can grant
// it to others.
//
//    // Example sending a request using GetCorsPolicyRequest.
//    req := client.GetCorsPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetCorsPolicy
func (c *Client) GetCorsPolicyRequest(input *GetCorsPolicyInput) GetCorsPolicyRequest {
	op := &aws.Operation{
		Name:       opGetCorsPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCorsPolicyInput{}
	}

	req := c.newRequest(op, input, &GetCorsPolicyOutput{})
	return GetCorsPolicyRequest{Request: req, Input: input, Copy: c.GetCorsPolicyRequest}
}

// GetCorsPolicyRequest is the request type for the
// GetCorsPolicy API operation.
type GetCorsPolicyRequest struct {
	*aws.Request
	Input *GetCorsPolicyInput
	Copy  func(*GetCorsPolicyInput) GetCorsPolicyRequest
}

// Send marshals and sends the GetCorsPolicy API request.
func (r GetCorsPolicyRequest) Send(ctx context.Context) (*GetCorsPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCorsPolicyResponse{
		GetCorsPolicyOutput: r.Request.Data.(*GetCorsPolicyOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCorsPolicyResponse is the response type for the
// GetCorsPolicy API operation.
type GetCorsPolicyResponse struct {
	*GetCorsPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCorsPolicy request.
func (r *GetCorsPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
