// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package machinelearning

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteMLModelInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the MLModel.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMLModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMLModelInput"}

	if s.MLModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a DeleteMLModel operation.
//
// You can use the GetMLModel operation and check the value of the Status parameter
// to see whether an MLModel is marked as DELETED.
type DeleteMLModelOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelID in the request.
	MLModelId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteMLModel = "DeleteMLModel"

// DeleteMLModelRequest returns a request value for making API operation for
// Amazon Machine Learning.
//
// Assigns the DELETED status to an MLModel, rendering it unusable.
//
// After using the DeleteMLModel operation, you can use the GetMLModel operation
// to verify that the status of the MLModel changed to DELETED.
//
// Caution: The result of the DeleteMLModel operation is irreversible.
//
//    // Example sending a request using DeleteMLModelRequest.
//    req := client.DeleteMLModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteMLModelRequest(input *DeleteMLModelInput) DeleteMLModelRequest {
	op := &aws.Operation{
		Name:       opDeleteMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMLModelInput{}
	}

	req := c.newRequest(op, input, &DeleteMLModelOutput{})
	return DeleteMLModelRequest{Request: req, Input: input, Copy: c.DeleteMLModelRequest}
}

// DeleteMLModelRequest is the request type for the
// DeleteMLModel API operation.
type DeleteMLModelRequest struct {
	*aws.Request
	Input *DeleteMLModelInput
	Copy  func(*DeleteMLModelInput) DeleteMLModelRequest
}

// Send marshals and sends the DeleteMLModel API request.
func (r DeleteMLModelRequest) Send(ctx context.Context) (*DeleteMLModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMLModelResponse{
		DeleteMLModelOutput: r.Request.Data.(*DeleteMLModelOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMLModelResponse is the response type for the
// DeleteMLModel API operation.
type DeleteMLModelResponse struct {
	*DeleteMLModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMLModel request.
func (r *DeleteMLModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
