// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteProvisioningTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet provisioning template version to delete.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`

	// The fleet provisioning template version ID to delete.
	//
	// VersionId is a required field
	VersionId *int64 `location:"uri" locationName:"versionId" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeleteProvisioningTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisioningTemplateVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteProvisioningTemplateVersionInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}

	if s.VersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteProvisioningTemplateVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "templateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "versionId", protocol.Int64Value(v), metadata)
	}
	return nil
}

type DeleteProvisioningTemplateVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProvisioningTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteProvisioningTemplateVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteProvisioningTemplateVersion = "DeleteProvisioningTemplateVersion"

// DeleteProvisioningTemplateVersionRequest returns a request value for making API operation for
// AWS IoT.
//
// Deletes a fleet provisioning template version.
//
//    // Example sending a request using DeleteProvisioningTemplateVersionRequest.
//    req := client.DeleteProvisioningTemplateVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteProvisioningTemplateVersionRequest(input *DeleteProvisioningTemplateVersionInput) DeleteProvisioningTemplateVersionRequest {
	op := &aws.Operation{
		Name:       opDeleteProvisioningTemplateVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/provisioning-templates/{templateName}/versions/{versionId}",
	}

	if input == nil {
		input = &DeleteProvisioningTemplateVersionInput{}
	}

	req := c.newRequest(op, input, &DeleteProvisioningTemplateVersionOutput{})
	return DeleteProvisioningTemplateVersionRequest{Request: req, Input: input, Copy: c.DeleteProvisioningTemplateVersionRequest}
}

// DeleteProvisioningTemplateVersionRequest is the request type for the
// DeleteProvisioningTemplateVersion API operation.
type DeleteProvisioningTemplateVersionRequest struct {
	*aws.Request
	Input *DeleteProvisioningTemplateVersionInput
	Copy  func(*DeleteProvisioningTemplateVersionInput) DeleteProvisioningTemplateVersionRequest
}

// Send marshals and sends the DeleteProvisioningTemplateVersion API request.
func (r DeleteProvisioningTemplateVersionRequest) Send(ctx context.Context) (*DeleteProvisioningTemplateVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteProvisioningTemplateVersionResponse{
		DeleteProvisioningTemplateVersionOutput: r.Request.Data.(*DeleteProvisioningTemplateVersionOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteProvisioningTemplateVersionResponse is the response type for the
// DeleteProvisioningTemplateVersion API operation.
type DeleteProvisioningTemplateVersionResponse struct {
	*DeleteProvisioningTemplateVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteProvisioningTemplateVersion request.
func (r *DeleteProvisioningTemplateVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
