// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListComponentBuildVersionsInput struct {
	_ struct{} `type:"structure"`

	// The component version arn whose versions you wish to list.
	//
	// ComponentVersionArn is a required field
	ComponentVersionArn *string `locationName:"componentVersionArn" type:"string" required:"true"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListComponentBuildVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentBuildVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListComponentBuildVersionsInput"}

	if s.ComponentVersionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComponentVersionArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListComponentBuildVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ComponentVersionArn != nil {
		v := *s.ComponentVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "componentVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListComponentBuildVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of component summaries for the specified semantic version.
	ComponentSummaryList []ComponentSummary `locationName:"componentSummaryList" type:"list"`

	// The next token used for paginated responses. When this is not empty then
	// there are additional elements that the service that not include in this request.
	// Use this token with the next request to retrieve additional object.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s ListComponentBuildVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListComponentBuildVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComponentSummaryList != nil {
		v := s.ComponentSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "componentSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListComponentBuildVersions = "ListComponentBuildVersions"

// ListComponentBuildVersionsRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Returns the list of component build versions for the specified semantic version.
//
//    // Example sending a request using ListComponentBuildVersionsRequest.
//    req := client.ListComponentBuildVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions
func (c *Client) ListComponentBuildVersionsRequest(input *ListComponentBuildVersionsInput) ListComponentBuildVersionsRequest {
	op := &aws.Operation{
		Name:       opListComponentBuildVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListComponentBuildVersions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentBuildVersionsInput{}
	}

	req := c.newRequest(op, input, &ListComponentBuildVersionsOutput{})
	return ListComponentBuildVersionsRequest{Request: req, Input: input, Copy: c.ListComponentBuildVersionsRequest}
}

// ListComponentBuildVersionsRequest is the request type for the
// ListComponentBuildVersions API operation.
type ListComponentBuildVersionsRequest struct {
	*aws.Request
	Input *ListComponentBuildVersionsInput
	Copy  func(*ListComponentBuildVersionsInput) ListComponentBuildVersionsRequest
}

// Send marshals and sends the ListComponentBuildVersions API request.
func (r ListComponentBuildVersionsRequest) Send(ctx context.Context) (*ListComponentBuildVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListComponentBuildVersionsResponse{
		ListComponentBuildVersionsOutput: r.Request.Data.(*ListComponentBuildVersionsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListComponentBuildVersionsRequestPaginator returns a paginator for ListComponentBuildVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListComponentBuildVersionsRequest(input)
//   p := imagebuilder.NewListComponentBuildVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListComponentBuildVersionsPaginator(req ListComponentBuildVersionsRequest) ListComponentBuildVersionsPaginator {
	return ListComponentBuildVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListComponentBuildVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListComponentBuildVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListComponentBuildVersionsPaginator struct {
	aws.Pager
}

func (p *ListComponentBuildVersionsPaginator) CurrentPage() *ListComponentBuildVersionsOutput {
	return p.Pager.CurrentPage().(*ListComponentBuildVersionsOutput)
}

// ListComponentBuildVersionsResponse is the response type for the
// ListComponentBuildVersions API operation.
type ListComponentBuildVersionsResponse struct {
	*ListComponentBuildVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListComponentBuildVersions request.
func (r *ListComponentBuildVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
