// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListCoreDefinitionsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListCoreDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListCoreDefinitionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListCoreDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	Definitions []DefinitionInformation `type:"list"`

	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCoreDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListCoreDefinitionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Definitions != nil {
		v := s.Definitions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Definitions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListCoreDefinitions = "ListCoreDefinitions"

// ListCoreDefinitionsRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Retrieves a list of core definitions.
//
//    // Example sending a request using ListCoreDefinitionsRequest.
//    req := client.ListCoreDefinitionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions
func (c *Client) ListCoreDefinitionsRequest(input *ListCoreDefinitionsInput) ListCoreDefinitionsRequest {
	op := &aws.Operation{
		Name:       opListCoreDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/cores",
	}

	if input == nil {
		input = &ListCoreDefinitionsInput{}
	}

	req := c.newRequest(op, input, &ListCoreDefinitionsOutput{})
	return ListCoreDefinitionsRequest{Request: req, Input: input, Copy: c.ListCoreDefinitionsRequest}
}

// ListCoreDefinitionsRequest is the request type for the
// ListCoreDefinitions API operation.
type ListCoreDefinitionsRequest struct {
	*aws.Request
	Input *ListCoreDefinitionsInput
	Copy  func(*ListCoreDefinitionsInput) ListCoreDefinitionsRequest
}

// Send marshals and sends the ListCoreDefinitions API request.
func (r ListCoreDefinitionsRequest) Send(ctx context.Context) (*ListCoreDefinitionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCoreDefinitionsResponse{
		ListCoreDefinitionsOutput: r.Request.Data.(*ListCoreDefinitionsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListCoreDefinitionsResponse is the response type for the
// ListCoreDefinitions API operation.
type ListCoreDefinitionsResponse struct {
	*ListCoreDefinitionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCoreDefinitions request.
func (r *ListCoreDefinitionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
