// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that summarize each dataset's properties.
	Datasets []DatasetSummary `type:"list"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Returns a list of datasets created using the CreateDataset operation. For
// each dataset, a summary of its properties, including its Amazon Resource
// Name (ARN), is returned. To retrieve the complete set of properties, use
// the ARN with the DescribeDataset operation.
//
//    // Example sending a request using ListDatasetsRequest.
//    req := client.ListDatasetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasets
func (c *Client) ListDatasetsRequest(input *ListDatasetsInput) ListDatasetsRequest {
	op := &aws.Operation{
		Name:       opListDatasets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	req := c.newRequest(op, input, &ListDatasetsOutput{})
	return ListDatasetsRequest{Request: req, Input: input, Copy: c.ListDatasetsRequest}
}

// ListDatasetsRequest is the request type for the
// ListDatasets API operation.
type ListDatasetsRequest struct {
	*aws.Request
	Input *ListDatasetsInput
	Copy  func(*ListDatasetsInput) ListDatasetsRequest
}

// Send marshals and sends the ListDatasets API request.
func (r ListDatasetsRequest) Send(ctx context.Context) (*ListDatasetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDatasetsResponse{
		ListDatasetsOutput: r.Request.Data.(*ListDatasetsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDatasetsRequestPaginator returns a paginator for ListDatasets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDatasetsRequest(input)
//   p := forecast.NewListDatasetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDatasetsPaginator(req ListDatasetsRequest) ListDatasetsPaginator {
	return ListDatasetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDatasetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDatasetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDatasetsPaginator struct {
	aws.Pager
}

func (p *ListDatasetsPaginator) CurrentPage() *ListDatasetsOutput {
	return p.Pager.CurrentPage().(*ListDatasetsOutput)
}

// ListDatasetsResponse is the response type for the
// ListDatasets API operation.
type ListDatasetsResponse struct {
	*ListDatasetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDatasets request.
func (r *ListDatasetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
