// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutBlockPublicAccessConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A configuration for Amazon EMR block public access. The configuration applies
	// to all clusters created in your account for the current Region. The configuration
	// specifies whether block public access is enabled. If block public access
	// is enabled, security groups associated with the cluster cannot have rules
	// that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port
	// is specified as an exception using PermittedPublicSecurityGroupRuleRanges
	// in the BlockPublicAccessConfiguration. By default, Port 22 (SSH) is an exception,
	// and public access is allowed on this port. You can change this by updating
	// BlockPublicSecurityGroupRules to remove the exception.
	//
	// BlockPublicAccessConfiguration is a required field
	BlockPublicAccessConfiguration *BlockPublicAccessConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBlockPublicAccessConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBlockPublicAccessConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBlockPublicAccessConfigurationInput"}

	if s.BlockPublicAccessConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("BlockPublicAccessConfiguration"))
	}
	if s.BlockPublicAccessConfiguration != nil {
		if err := s.BlockPublicAccessConfiguration.Validate(); err != nil {
			invalidParams.AddNested("BlockPublicAccessConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutBlockPublicAccessConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBlockPublicAccessConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutBlockPublicAccessConfiguration = "PutBlockPublicAccessConfiguration"

// PutBlockPublicAccessConfigurationRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Creates or updates an Amazon EMR block public access configuration for your
// AWS account in the current Region. For more information see Configure Block
// Public Access for Amazon EMR (https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html)
// in the Amazon EMR Management Guide.
//
//    // Example sending a request using PutBlockPublicAccessConfigurationRequest.
//    req := client.PutBlockPublicAccessConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutBlockPublicAccessConfiguration
func (c *Client) PutBlockPublicAccessConfigurationRequest(input *PutBlockPublicAccessConfigurationInput) PutBlockPublicAccessConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBlockPublicAccessConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutBlockPublicAccessConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutBlockPublicAccessConfigurationOutput{})
	return PutBlockPublicAccessConfigurationRequest{Request: req, Input: input, Copy: c.PutBlockPublicAccessConfigurationRequest}
}

// PutBlockPublicAccessConfigurationRequest is the request type for the
// PutBlockPublicAccessConfiguration API operation.
type PutBlockPublicAccessConfigurationRequest struct {
	*aws.Request
	Input *PutBlockPublicAccessConfigurationInput
	Copy  func(*PutBlockPublicAccessConfigurationInput) PutBlockPublicAccessConfigurationRequest
}

// Send marshals and sends the PutBlockPublicAccessConfiguration API request.
func (r PutBlockPublicAccessConfigurationRequest) Send(ctx context.Context) (*PutBlockPublicAccessConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBlockPublicAccessConfigurationResponse{
		PutBlockPublicAccessConfigurationOutput: r.Request.Data.(*PutBlockPublicAccessConfigurationOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBlockPublicAccessConfigurationResponse is the response type for the
// PutBlockPublicAccessConfiguration API operation.
type PutBlockPublicAccessConfigurationResponse struct {
	*PutBlockPublicAccessConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBlockPublicAccessConfiguration request.
func (r *PutBlockPublicAccessConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
