// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Result message containing all of the configuration settings for a specified
// solution stack or configuration template.
type DescribeConfigurationSettingsInput struct {
	_ struct{} `type:"structure"`

	// The application for the environment or configuration template.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the environment to describe.
	//
	// Condition: You must specify either this or a TemplateName, but not both.
	// If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination
	// error. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The name of the configuration template to describe.
	//
	// Conditional: You must specify either this parameter or an EnvironmentName,
	// but not both. If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination
	// error. If you do not specify either, AWS Elastic Beanstalk returns a MissingRequiredParameter
	// error.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeConfigurationSettingsInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("EnvironmentName", 4))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The results from a request to change the configuration settings of an environment.
type DescribeConfigurationSettingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ConfigurationSettingsDescription.
	ConfigurationSettings []ConfigurationSettingsDescription `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConfigurationSettings = "DescribeConfigurationSettings"

// DescribeConfigurationSettingsRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Returns a description of the settings for the specified configuration set,
// that is, either a configuration template or the configuration set associated
// with a running environment.
//
// When describing the settings for the configuration set associated with a
// running environment, it is possible to receive two sets of setting descriptions.
// One is the deployed configuration set, and the other is a draft configuration
// of an environment that is either in the process of deployment or that failed
// to deploy.
//
// Related Topics
//
//    * DeleteEnvironmentConfiguration
//
//    // Example sending a request using DescribeConfigurationSettingsRequest.
//    req := client.DescribeConfigurationSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationSettings
func (c *Client) DescribeConfigurationSettingsRequest(input *DescribeConfigurationSettingsInput) DescribeConfigurationSettingsRequest {
	op := &aws.Operation{
		Name:       opDescribeConfigurationSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationSettingsInput{}
	}

	req := c.newRequest(op, input, &DescribeConfigurationSettingsOutput{})
	return DescribeConfigurationSettingsRequest{Request: req, Input: input, Copy: c.DescribeConfigurationSettingsRequest}
}

// DescribeConfigurationSettingsRequest is the request type for the
// DescribeConfigurationSettings API operation.
type DescribeConfigurationSettingsRequest struct {
	*aws.Request
	Input *DescribeConfigurationSettingsInput
	Copy  func(*DescribeConfigurationSettingsInput) DescribeConfigurationSettingsRequest
}

// Send marshals and sends the DescribeConfigurationSettings API request.
func (r DescribeConfigurationSettingsRequest) Send(ctx context.Context) (*DescribeConfigurationSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConfigurationSettingsResponse{
		DescribeConfigurationSettingsOutput: r.Request.Data.(*DescribeConfigurationSettingsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConfigurationSettingsResponse is the response type for the
// DescribeConfigurationSettings API operation.
type DescribeConfigurationSettingsResponse struct {
	*DescribeConfigurationSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConfigurationSettings request.
func (r *DescribeConfigurationSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
