// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyEbsDefaultKmsKeyIdInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The identifier of the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) to use for Amazon EBS encryption. If this parameter is not specified,
	// your AWS managed CMK for EBS is used. If KmsKeyId is specified, the encrypted
	// state must be true.
	//
	// You can specify the CMK using any of the following:
	//
	//    * Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	//    * Key alias. For example, alias/ExampleAlias.
	//
	//    * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
	//
	//    * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
	//
	// AWS authenticates the CMK asynchronously. Therefore, if you specify an ID,
	// alias, or ARN that is not valid, the action can appear to complete, but eventually
	// fails.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEbsDefaultKmsKeyIdInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEbsDefaultKmsKeyIdInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyEbsDefaultKmsKeyIdInput"}

	if s.KmsKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KmsKeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyEbsDefaultKmsKeyIdOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the default CMK for encryption by default.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`
}

// String returns the string representation
func (s ModifyEbsDefaultKmsKeyIdOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyEbsDefaultKmsKeyId = "ModifyEbsDefaultKmsKeyId"

// ModifyEbsDefaultKmsKeyIdRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Changes the default customer master key (CMK) for EBS encryption by default
// for your account in this Region.
//
// AWS creates a unique AWS managed CMK in each Region for use with encryption
// by default. If you change the default CMK to a customer managed CMK, it is
// used instead of the AWS managed CMK. To reset the default CMK to the AWS
// managed CMK for EBS, use ResetEbsDefaultKmsKeyId.
//
// If you delete or disable the customer managed CMK that you specified for
// use with encryption by default, your instances will fail to launch.
//
// For more information, see Amazon EBS Encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using ModifyEbsDefaultKmsKeyIdRequest.
//    req := client.ModifyEbsDefaultKmsKeyIdRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyEbsDefaultKmsKeyId
func (c *Client) ModifyEbsDefaultKmsKeyIdRequest(input *ModifyEbsDefaultKmsKeyIdInput) ModifyEbsDefaultKmsKeyIdRequest {
	op := &aws.Operation{
		Name:       opModifyEbsDefaultKmsKeyId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEbsDefaultKmsKeyIdInput{}
	}

	req := c.newRequest(op, input, &ModifyEbsDefaultKmsKeyIdOutput{})
	return ModifyEbsDefaultKmsKeyIdRequest{Request: req, Input: input, Copy: c.ModifyEbsDefaultKmsKeyIdRequest}
}

// ModifyEbsDefaultKmsKeyIdRequest is the request type for the
// ModifyEbsDefaultKmsKeyId API operation.
type ModifyEbsDefaultKmsKeyIdRequest struct {
	*aws.Request
	Input *ModifyEbsDefaultKmsKeyIdInput
	Copy  func(*ModifyEbsDefaultKmsKeyIdInput) ModifyEbsDefaultKmsKeyIdRequest
}

// Send marshals and sends the ModifyEbsDefaultKmsKeyId API request.
func (r ModifyEbsDefaultKmsKeyIdRequest) Send(ctx context.Context) (*ModifyEbsDefaultKmsKeyIdResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyEbsDefaultKmsKeyIdResponse{
		ModifyEbsDefaultKmsKeyIdOutput: r.Request.Data.(*ModifyEbsDefaultKmsKeyIdOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyEbsDefaultKmsKeyIdResponse is the response type for the
// ModifyEbsDefaultKmsKeyId API operation.
type ModifyEbsDefaultKmsKeyIdResponse struct {
	*ModifyEbsDefaultKmsKeyIdOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyEbsDefaultKmsKeyId request.
func (r *ModifyEbsDefaultKmsKeyIdResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
