// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeImportImageTasksInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// Filter tasks using the task-state filter and one of the following values:
	// active, completed, deleting, or deleted.
	Filters []Filter `locationNameList:"Filter" type:"list"`

	// The IDs of the import image tasks.
	ImportTaskIds []string `locationName:"ImportTaskId" locationNameList:"ImportTaskId" type:"list"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// A token that indicates the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeImportImageTasksInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeImportImageTasksOutput struct {
	_ struct{} `type:"structure"`

	// A list of zero or more import image tasks that are currently active or were
	// completed or canceled in the previous 7 days.
	ImportImageTasks []ImportImageTask `locationName:"importImageTaskSet" locationNameList:"item" type:"list"`

	// The token to use to get the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeImportImageTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeImportImageTasks = "DescribeImportImageTasks"

// DescribeImportImageTasksRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Displays details about an import virtual machine or import snapshot tasks
// that are already created.
//
//    // Example sending a request using DescribeImportImageTasksRequest.
//    req := client.DescribeImportImageTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks
func (c *Client) DescribeImportImageTasksRequest(input *DescribeImportImageTasksInput) DescribeImportImageTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeImportImageTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImportImageTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeImportImageTasksOutput{})
	return DescribeImportImageTasksRequest{Request: req, Input: input, Copy: c.DescribeImportImageTasksRequest}
}

// DescribeImportImageTasksRequest is the request type for the
// DescribeImportImageTasks API operation.
type DescribeImportImageTasksRequest struct {
	*aws.Request
	Input *DescribeImportImageTasksInput
	Copy  func(*DescribeImportImageTasksInput) DescribeImportImageTasksRequest
}

// Send marshals and sends the DescribeImportImageTasks API request.
func (r DescribeImportImageTasksRequest) Send(ctx context.Context) (*DescribeImportImageTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeImportImageTasksResponse{
		DescribeImportImageTasksOutput: r.Request.Data.(*DescribeImportImageTasksOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeImportImageTasksRequestPaginator returns a paginator for DescribeImportImageTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeImportImageTasksRequest(input)
//   p := ec2.NewDescribeImportImageTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeImportImageTasksPaginator(req DescribeImportImageTasksRequest) DescribeImportImageTasksPaginator {
	return DescribeImportImageTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeImportImageTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeImportImageTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeImportImageTasksPaginator struct {
	aws.Pager
}

func (p *DescribeImportImageTasksPaginator) CurrentPage() *DescribeImportImageTasksOutput {
	return p.Pager.CurrentPage().(*DescribeImportImageTasksOutput)
}

// DescribeImportImageTasksResponse is the response type for the
// DescribeImportImageTasks API operation.
type DescribeImportImageTasksResponse struct {
	*DescribeImportImageTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeImportImageTasks request.
func (r *DescribeImportImageTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
