// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeClientVpnEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Client VPN endpoint.
	ClientVpnEndpointIds []string `locationName:"ClientVpnEndpointId" locationNameList:"item" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters. Filter names and values are case-sensitive.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results can be seen by sending another request with the nextToken
	// value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeClientVpnEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClientVpnEndpointsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeClientVpnEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeClientVpnEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Client VPN endpoints.
	ClientVpnEndpoints []VpnEndpoint `locationName:"clientVpnEndpoint" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeClientVpnEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeClientVpnEndpoints = "DescribeClientVpnEndpoints"

// DescribeClientVpnEndpointsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more Client VPN endpoints in the account.
//
//    // Example sending a request using DescribeClientVpnEndpointsRequest.
//    req := client.DescribeClientVpnEndpointsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints
func (c *Client) DescribeClientVpnEndpointsRequest(input *DescribeClientVpnEndpointsInput) DescribeClientVpnEndpointsRequest {
	op := &aws.Operation{
		Name:       opDescribeClientVpnEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnEndpointsInput{}
	}

	req := c.newRequest(op, input, &DescribeClientVpnEndpointsOutput{})
	return DescribeClientVpnEndpointsRequest{Request: req, Input: input, Copy: c.DescribeClientVpnEndpointsRequest}
}

// DescribeClientVpnEndpointsRequest is the request type for the
// DescribeClientVpnEndpoints API operation.
type DescribeClientVpnEndpointsRequest struct {
	*aws.Request
	Input *DescribeClientVpnEndpointsInput
	Copy  func(*DescribeClientVpnEndpointsInput) DescribeClientVpnEndpointsRequest
}

// Send marshals and sends the DescribeClientVpnEndpoints API request.
func (r DescribeClientVpnEndpointsRequest) Send(ctx context.Context) (*DescribeClientVpnEndpointsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClientVpnEndpointsResponse{
		DescribeClientVpnEndpointsOutput: r.Request.Data.(*DescribeClientVpnEndpointsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeClientVpnEndpointsRequestPaginator returns a paginator for DescribeClientVpnEndpoints.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeClientVpnEndpointsRequest(input)
//   p := ec2.NewDescribeClientVpnEndpointsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeClientVpnEndpointsPaginator(req DescribeClientVpnEndpointsRequest) DescribeClientVpnEndpointsPaginator {
	return DescribeClientVpnEndpointsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeClientVpnEndpointsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeClientVpnEndpointsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeClientVpnEndpointsPaginator struct {
	aws.Pager
}

func (p *DescribeClientVpnEndpointsPaginator) CurrentPage() *DescribeClientVpnEndpointsOutput {
	return p.Pager.CurrentPage().(*DescribeClientVpnEndpointsOutput)
}

// DescribeClientVpnEndpointsResponse is the response type for the
// DescribeClientVpnEndpoints API operation.
type DescribeClientVpnEndpointsResponse struct {
	*DescribeClientVpnEndpointsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClientVpnEndpoints request.
func (r *DescribeClientVpnEndpointsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
