// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteFlowLogsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more flow log IDs.
	//
	// Constraint: Maximum of 1000 flow log IDs.
	//
	// FlowLogIds is a required field
	FlowLogIds []string `locationName:"FlowLogId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteFlowLogsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowLogsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFlowLogsInput"}

	if s.FlowLogIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("FlowLogIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the flow logs that could not be deleted successfully.
	Unsuccessful []UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteFlowLogsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteFlowLogs = "DeleteFlowLogs"

// DeleteFlowLogsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes one or more flow logs.
//
//    // Example sending a request using DeleteFlowLogsRequest.
//    req := client.DeleteFlowLogsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs
func (c *Client) DeleteFlowLogsRequest(input *DeleteFlowLogsInput) DeleteFlowLogsRequest {
	op := &aws.Operation{
		Name:       opDeleteFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlowLogsInput{}
	}

	req := c.newRequest(op, input, &DeleteFlowLogsOutput{})
	return DeleteFlowLogsRequest{Request: req, Input: input, Copy: c.DeleteFlowLogsRequest}
}

// DeleteFlowLogsRequest is the request type for the
// DeleteFlowLogs API operation.
type DeleteFlowLogsRequest struct {
	*aws.Request
	Input *DeleteFlowLogsInput
	Copy  func(*DeleteFlowLogsInput) DeleteFlowLogsRequest
}

// Send marshals and sends the DeleteFlowLogs API request.
func (r DeleteFlowLogsRequest) Send(ctx context.Context) (*DeleteFlowLogsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFlowLogsResponse{
		DeleteFlowLogsOutput: r.Request.Data.(*DeleteFlowLogsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFlowLogsResponse is the response type for the
// DeleteFlowLogs API operation.
type DeleteFlowLogsResponse struct {
	*DeleteFlowLogsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFlowLogs request.
func (r *DeleteFlowLogsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
