// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateTransitGatewayVpcAttachmentInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The VPC attachment options.
	Options *CreateTransitGatewayVpcAttachmentRequestOptions `type:"structure"`

	// The IDs of one or more subnets. You can specify only one subnet per Availability
	// Zone. You must specify at least one subnet, but we recommend that you specify
	// two subnets for better availability. The transit gateway uses one IP address
	// from each specified subnet.
	//
	// SubnetIds is a required field
	SubnetIds []string `locationNameList:"item" type:"list" required:"true"`

	// The tags to apply to the VPC attachment.
	TagSpecifications []TagSpecification `locationNameList:"item" type:"list"`

	// The ID of the transit gateway.
	//
	// TransitGatewayId is a required field
	TransitGatewayId *string `type:"string" required:"true"`

	// The ID of the VPC.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTransitGatewayVpcAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTransitGatewayVpcAttachmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTransitGatewayVpcAttachmentInput"}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}

	if s.TransitGatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransitGatewayId"))
	}

	if s.VpcId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTransitGatewayVpcAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC attachment.
	TransitGatewayVpcAttachment *TransitGatewayVpcAttachment `locationName:"transitGatewayVpcAttachment" type:"structure"`
}

// String returns the string representation
func (s CreateTransitGatewayVpcAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTransitGatewayVpcAttachment = "CreateTransitGatewayVpcAttachment"

// CreateTransitGatewayVpcAttachmentRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Attaches the specified VPC to the specified transit gateway.
//
// If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC
// that is already attached, the new VPC CIDR range is not propagated to the
// default propagation route table.
//
// To send VPC traffic to an attached transit gateway, add a route to the VPC
// route table using CreateRoute.
//
//    // Example sending a request using CreateTransitGatewayVpcAttachmentRequest.
//    req := client.CreateTransitGatewayVpcAttachmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment
func (c *Client) CreateTransitGatewayVpcAttachmentRequest(input *CreateTransitGatewayVpcAttachmentInput) CreateTransitGatewayVpcAttachmentRequest {
	op := &aws.Operation{
		Name:       opCreateTransitGatewayVpcAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayVpcAttachmentInput{}
	}

	req := c.newRequest(op, input, &CreateTransitGatewayVpcAttachmentOutput{})
	return CreateTransitGatewayVpcAttachmentRequest{Request: req, Input: input, Copy: c.CreateTransitGatewayVpcAttachmentRequest}
}

// CreateTransitGatewayVpcAttachmentRequest is the request type for the
// CreateTransitGatewayVpcAttachment API operation.
type CreateTransitGatewayVpcAttachmentRequest struct {
	*aws.Request
	Input *CreateTransitGatewayVpcAttachmentInput
	Copy  func(*CreateTransitGatewayVpcAttachmentInput) CreateTransitGatewayVpcAttachmentRequest
}

// Send marshals and sends the CreateTransitGatewayVpcAttachment API request.
func (r CreateTransitGatewayVpcAttachmentRequest) Send(ctx context.Context) (*CreateTransitGatewayVpcAttachmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTransitGatewayVpcAttachmentResponse{
		CreateTransitGatewayVpcAttachmentOutput: r.Request.Data.(*CreateTransitGatewayVpcAttachmentOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTransitGatewayVpcAttachmentResponse is the response type for the
// CreateTransitGatewayVpcAttachment API operation.
type CreateTransitGatewayVpcAttachmentResponse struct {
	*CreateTransitGatewayVpcAttachmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTransitGatewayVpcAttachment request.
func (r *CreateTransitGatewayVpcAttachmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
