// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about the associated gateway.
type AssociatedGateway struct {
	_ struct{} `type:"structure"`

	// The ID of the associated gateway.
	Id *string `locationName:"id" type:"string"`

	// The ID of the AWS account that owns the associated virtual private gateway
	// or transit gateway.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The Region where the associated gateway is located.
	Region *string `locationName:"region" type:"string"`

	// The type of associated gateway.
	Type GatewayType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s AssociatedGateway) String() string {
	return awsutil.Prettify(s)
}

// Information about a BGP peer.
type BGPPeer struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The Direct Connect endpoint on which the BGP peer terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The ID of the BGP peer.
	BgpPeerId *string `locationName:"bgpPeerId" type:"string"`

	// The state of the BGP peer. The following are the possible values:
	//
	//    * verifying: The BGP peering addresses or ASN require validation before
	//    the BGP peer can be created. This state applies only to public virtual
	//    interfaces.
	//
	//    * pending: The BGP peer is created, and remains in this state until it
	//    is ready to be established.
	//
	//    * available: The BGP peer is ready to be established.
	//
	//    * deleting: The BGP peer is being deleted.
	//
	//    * deleted: The BGP peer is deleted and cannot be established.
	BgpPeerState BGPPeerState `locationName:"bgpPeerState" type:"string" enum:"true"`

	// The status of the BGP peer. The following are the possible values:
	//
	//    * up: The BGP peer is established. This state does not indicate the state
	//    of the routing function. Ensure that you are receiving routes over the
	//    BGP session.
	//
	//    * down: The BGP peer is down.
	//
	//    * unknown: The BGP peer status is not available.
	BgpStatus BGPStatus `locationName:"bgpStatus" type:"string" enum:"true"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`
}

// String returns the string representation
func (s BGPPeer) String() string {
	return awsutil.Prettify(s)
}

// Information about an AWS Direct Connect connection.
type Connection struct {
	_ struct{} `type:"structure"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The bandwidth of the connection.
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The name of the connection.
	ConnectionName *string `locationName:"connectionName" type:"string"`

	// The state of the connection. The following are the possible values:
	//
	//    * ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * pending: The connection has been approved and is being initialized.
	//
	//    * available: The network link is up and the connection is ready for use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The connection is being deleted.
	//
	//    * deleted: The connection has been deleted.
	//
	//    * rejected: A hosted connection in the ordering state enters the rejected
	//    state if it is deleted by the customer.
	//
	//    * unknown: The state of the connection is not available.
	ConnectionState ConnectionState `locationName:"connectionState" type:"string" enum:"true"`

	// Indicates whether the connection supports a secondary BGP peer in the same
	// address family (IPv4/IPv6).
	HasLogicalRedundancy HasLogicalRedundancy `locationName:"hasLogicalRedundancy" type:"string" enum:"true"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The time of the most recent call to DescribeLoa for this connection.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The ID of the AWS account that owns the connection.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the AWS Direct Connect service provider associated with the connection.
	PartnerName *string `locationName:"partnerName" type:"string"`

	// The name of the service provider associated with the connection.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The tags associated with the connection.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// Information about a Direct Connect gateway, which enables you to connect
// virtual interfaces and virtual private gateway or transit gateways.
type DirectConnectGateway struct {
	_ struct{} `type:"structure"`

	// The autonomous system number (ASN) for the Amazon side of the connection.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The name of the Direct Connect gateway.
	DirectConnectGatewayName *string `locationName:"directConnectGatewayName" type:"string"`

	// The state of the Direct Connect gateway. The following are the possible values:
	//
	//    * pending: The initial state after calling CreateDirectConnectGateway.
	//
	//    * available: The Direct Connect gateway is ready for use.
	//
	//    * deleting: The initial state after calling DeleteDirectConnectGateway.
	//
	//    * deleted: The Direct Connect gateway is deleted and cannot pass traffic.
	DirectConnectGatewayState DirectConnectGatewayState `locationName:"directConnectGatewayState" type:"string" enum:"true"`

	// The ID of the AWS account that owns the Direct Connect gateway.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The error message if the state of an object failed to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`
}

// String returns the string representation
func (s DirectConnectGateway) String() string {
	return awsutil.Prettify(s)
}

// Information about an association between a Direct Connect gateway and a virtual
// private gateway or transit gateway.
type DirectConnectGatewayAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway.
	AllowedPrefixesToDirectConnectGateway []RouteFilterPrefix `locationName:"allowedPrefixesToDirectConnectGateway" type:"list"`

	// Information about the associated gateway.
	AssociatedGateway *AssociatedGateway `locationName:"associatedGateway" type:"structure"`

	// The ID of the Direct Connect gateway association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The state of the association. The following are the possible values:
	//
	//    * associating: The initial state after calling CreateDirectConnectGatewayAssociation.
	//
	//    * associated: The Direct Connect gateway and virtual private gateway or
	//    transit gateway are successfully associated and ready to pass traffic.
	//
	//    * disassociating: The initial state after calling DeleteDirectConnectGatewayAssociation.
	//
	//    * disassociated: The virtual private gateway or transit gateway is disassociated
	//    from the Direct Connect gateway. Traffic flow between the Direct Connect
	//    gateway and virtual private gateway or transit gateway is stopped.
	AssociationState DirectConnectGatewayAssociationState `locationName:"associationState" type:"string" enum:"true"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The ID of the AWS account that owns the associated gateway.
	DirectConnectGatewayOwnerAccount *string `locationName:"directConnectGatewayOwnerAccount" type:"string"`

	// The error message if the state of an object failed to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`

	// The ID of the virtual private gateway. Applies only to private virtual interfaces.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The ID of the AWS account that owns the virtual private gateway.
	VirtualGatewayOwnerAccount *string `locationName:"virtualGatewayOwnerAccount" type:"string"`

	// The AWS Region where the virtual private gateway is located.
	VirtualGatewayRegion *string `locationName:"virtualGatewayRegion" deprecated:"true" type:"string"`
}

// String returns the string representation
func (s DirectConnectGatewayAssociation) String() string {
	return awsutil.Prettify(s)
}

// Information about the proposal request to attach a virtual private gateway
// to a Direct Connect gateway.
type DirectConnectGatewayAssociationProposal struct {
	_ struct{} `type:"structure"`

	// Information about the associated gateway.
	AssociatedGateway *AssociatedGateway `locationName:"associatedGateway" type:"structure"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The ID of the AWS account that owns the Direct Connect gateway.
	DirectConnectGatewayOwnerAccount *string `locationName:"directConnectGatewayOwnerAccount" type:"string"`

	// The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
	ExistingAllowedPrefixesToDirectConnectGateway []RouteFilterPrefix `locationName:"existingAllowedPrefixesToDirectConnectGateway" type:"list"`

	// The ID of the association proposal.
	ProposalId *string `locationName:"proposalId" type:"string"`

	// The state of the proposal. The following are possible values:
	//
	//    * accepted: The proposal has been accepted. The Direct Connect gateway
	//    association is available to use in this state.
	//
	//    * deleted: The proposal has been deleted by the owner that made the proposal.
	//    The Direct Connect gateway association cannot be used in this state.
	//
	//    * requested: The proposal has been requested. The Direct Connect gateway
	//    association cannot be used in this state.
	ProposalState DirectConnectGatewayAssociationProposalState `locationName:"proposalState" type:"string" enum:"true"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway.
	RequestedAllowedPrefixesToDirectConnectGateway []RouteFilterPrefix `locationName:"requestedAllowedPrefixesToDirectConnectGateway" type:"list"`
}

// String returns the string representation
func (s DirectConnectGatewayAssociationProposal) String() string {
	return awsutil.Prettify(s)
}

// Information about an attachment between a Direct Connect gateway and a virtual
// interface.
type DirectConnectGatewayAttachment struct {
	_ struct{} `type:"structure"`

	// The state of the attachment. The following are the possible values:
	//
	//    * attaching: The initial state after a virtual interface is created using
	//    the Direct Connect gateway.
	//
	//    * attached: The Direct Connect gateway and virtual interface are attached
	//    and ready to pass traffic.
	//
	//    * detaching: The initial state after calling DeleteVirtualInterface.
	//
	//    * detached: The virtual interface is detached from the Direct Connect
	//    gateway. Traffic flow between the Direct Connect gateway and virtual interface
	//    is stopped.
	AttachmentState DirectConnectGatewayAttachmentState `locationName:"attachmentState" type:"string" enum:"true"`

	// The type of attachment.
	AttachmentType DirectConnectGatewayAttachmentType `locationName:"attachmentType" type:"string" enum:"true"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The error message if the state of an object failed to advance.
	StateChangeError *string `locationName:"stateChangeError" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The ID of the AWS account that owns the virtual interface.
	VirtualInterfaceOwnerAccount *string `locationName:"virtualInterfaceOwnerAccount" type:"string"`

	// The AWS Region where the virtual interface is located.
	VirtualInterfaceRegion *string `locationName:"virtualInterfaceRegion" type:"string"`
}

// String returns the string representation
func (s DirectConnectGatewayAttachment) String() string {
	return awsutil.Prettify(s)
}

// Information about an interconnect.
type Interconnect struct {
	_ struct{} `type:"structure"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The bandwidth of the connection.
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// Indicates whether the interconnect supports a secondary BGP in the same address
	// family (IPv4/IPv6).
	HasLogicalRedundancy HasLogicalRedundancy `locationName:"hasLogicalRedundancy" type:"string" enum:"true"`

	// The ID of the interconnect.
	InterconnectId *string `locationName:"interconnectId" type:"string"`

	// The name of the interconnect.
	InterconnectName *string `locationName:"interconnectName" type:"string"`

	// The state of the interconnect. The following are the possible values:
	//
	//    * requested: The initial state of an interconnect. The interconnect stays
	//    in the requested state until the Letter of Authorization (LOA) is sent
	//    to the customer.
	//
	//    * pending: The interconnect is approved, and is being initialized.
	//
	//    * available: The network link is up, and the interconnect is ready for
	//    use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The interconnect is being deleted.
	//
	//    * deleted: The interconnect is deleted.
	//
	//    * unknown: The state of the interconnect is not available.
	InterconnectState InterconnectState `locationName:"interconnectState" type:"string" enum:"true"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The time of the most recent call to DescribeLoa for this connection.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The name of the service provider associated with the interconnect.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The tags associated with the interconnect.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s Interconnect) String() string {
	return awsutil.Prettify(s)
}

// Information about a link aggregation group (LAG).
type Lag struct {
	_ struct{} `type:"structure"`

	// Indicates whether the LAG can host other connections.
	AllowsHostedConnections *bool `locationName:"allowsHostedConnections" type:"boolean"`

	// The AWS Direct Connect endpoint that hosts the LAG.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The AWS Direct Connect endpoint that hosts the LAG.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The connections bundled by the LAG.
	Connections []Connection `locationName:"connections" type:"list"`

	// The individual bandwidth of the physical connections bundled by the LAG.
	// The possible values are 1Gbps and 10Gbps.
	ConnectionsBandwidth *string `locationName:"connectionsBandwidth" type:"string"`

	// Indicates whether the LAG supports a secondary BGP peer in the same address
	// family (IPv4/IPv6).
	HasLogicalRedundancy HasLogicalRedundancy `locationName:"hasLogicalRedundancy" type:"string" enum:"true"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The name of the LAG.
	LagName *string `locationName:"lagName" type:"string"`

	// The state of the LAG. The following are the possible values:
	//
	//    * requested: The initial state of a LAG. The LAG stays in the requested
	//    state until the Letter of Authorization (LOA) is available.
	//
	//    * pending: The LAG has been approved and is being initialized.
	//
	//    * available: The network link is established and the LAG is ready for
	//    use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The LAG is being deleted.
	//
	//    * deleted: The LAG is deleted.
	//
	//    * unknown: The state of the LAG is not available.
	LagState LagState `locationName:"lagState" type:"string" enum:"true"`

	// The location of the LAG.
	Location *string `locationName:"location" type:"string"`

	// The minimum number of physical connections that must be operational for the
	// LAG itself to be operational.
	MinimumLinks *int64 `locationName:"minimumLinks" type:"integer"`

	// The number of physical connections bundled by the LAG, up to a maximum of
	// 10.
	NumberOfConnections *int64 `locationName:"numberOfConnections" type:"integer"`

	// The ID of the AWS account that owns the LAG.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the service provider associated with the LAG.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The tags associated with the LAG.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s Lag) String() string {
	return awsutil.Prettify(s)
}

// Information about a Letter of Authorization - Connecting Facility Assignment
// (LOA-CFA) for a connection.
type Loa struct {
	_ struct{} `type:"structure"`

	// The binary contents of the LOA-CFA document.
	//
	// LoaContent is automatically base64 encoded/decoded by the SDK.
	LoaContent []byte `locationName:"loaContent" type:"blob"`

	// The standard media type for the LOA-CFA document. The only supported value
	// is application/pdf.
	LoaContentType LoaContentType `locationName:"loaContentType" type:"string" enum:"true"`
}

// String returns the string representation
func (s Loa) String() string {
	return awsutil.Prettify(s)
}

// Information about an AWS Direct Connect location.
type Location struct {
	_ struct{} `type:"structure"`

	// The available port speeds for the location.
	AvailablePortSpeeds []string `locationName:"availablePortSpeeds" type:"list"`

	// The name of the service provider for the location.
	AvailableProviders []string `locationName:"availableProviders" type:"list"`

	// The code for the location.
	LocationCode *string `locationName:"locationCode" type:"string"`

	// The name of the location. This includes the name of the colocation partner
	// and the physical site of the building.
	LocationName *string `locationName:"locationName" type:"string"`

	// The AWS Region for the location.
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// Information about a new BGP peer.
type NewBGPPeer struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`
}

// String returns the string representation
func (s NewBGPPeer) String() string {
	return awsutil.Prettify(s)
}

// Information about a private virtual interface.
type NewPrivateVirtualInterface struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The tags associated with the private virtual interface.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The name of the virtual interface assigned by the customer network.
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The ID of the VLAN.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPrivateVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPrivateVirtualInterface) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NewPrivateVirtualInterface"}

	if s.Asn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Asn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if s.VirtualInterfaceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualInterfaceName"))
	}

	if s.Vlan == nil {
		invalidParams.Add(aws.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a private virtual interface to be provisioned on a connection.
type NewPrivateVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The tags associated with the private virtual interface.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The ID of the VLAN.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPrivateVirtualInterfaceAllocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NewPrivateVirtualInterfaceAllocation"}

	if s.Asn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Asn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if s.VirtualInterfaceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualInterfaceName"))
	}

	if s.Vlan == nil {
		invalidParams.Add(aws.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a public virtual interface.
type NewPublicVirtualInterface struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The routes to be advertised to the AWS network in this Region. Applies to
	// public virtual interfaces.
	RouteFilterPrefixes []RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The tags associated with the public virtual interface.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The ID of the VLAN.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPublicVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPublicVirtualInterface) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NewPublicVirtualInterface"}

	if s.Asn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Asn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if s.VirtualInterfaceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualInterfaceName"))
	}

	if s.Vlan == nil {
		invalidParams.Add(aws.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a public virtual interface to be provisioned on a connection.
type NewPublicVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The routes to be advertised to the AWS network in this Region. Applies to
	// public virtual interfaces.
	RouteFilterPrefixes []RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The tags associated with the public virtual interface.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The ID of the VLAN.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPublicVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPublicVirtualInterfaceAllocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NewPublicVirtualInterfaceAllocation"}

	if s.Asn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Asn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}

	if s.VirtualInterfaceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualInterfaceName"))
	}

	if s.Vlan == nil {
		invalidParams.Add(aws.NewErrParamRequired("Vlan"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a transit virtual interface.
type NewTransitVirtualInterface struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The tags associated with the transitive virtual interface.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s NewTransitVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewTransitVirtualInterface) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NewTransitVirtualInterface"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a transit virtual interface to be provisioned on a connection.
type NewTransitVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The tags associated with the transitive virtual interface.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The name of the virtual interface assigned by the customer network.
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s NewTransitVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewTransitVirtualInterfaceAllocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NewTransitVirtualInterfaceAllocation"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a tag associated with an AWS Direct Connect resource.
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The tags.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// Information about a route filter prefix that a customer can advertise through
// Border Gateway Protocol (BGP) over a public virtual interface.
type RouteFilterPrefix struct {
	_ struct{} `type:"structure"`

	// The CIDR block for the advertised route. Separate multiple routes using commas.
	// An IPv6 CIDR must use /64 or shorter.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s RouteFilterPrefix) String() string {
	return awsutil.Prettify(s)
}

// Information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a virtual private gateway for a private virtual interface.
type VirtualGateway struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The state of the virtual private gateway. The following are the possible
	// values:
	//
	//    * pending: Initial state after creating the virtual private gateway.
	//
	//    * available: Ready for use by a private virtual interface.
	//
	//    * deleting: Initial state after deleting the virtual private gateway.
	//
	//    * deleted: The virtual private gateway is deleted. The private virtual
	//    interface is unable to send traffic over this gateway.
	VirtualGatewayState *string `locationName:"virtualGatewayState" type:"string"`
}

// String returns the string representation
func (s VirtualGateway) String() string {
	return awsutil.Prettify(s)
}

// Information about a virtual interface.
type VirtualInterface struct {
	_ struct{} `type:"structure"`

	// The address family for the BGP peer.
	AddressFamily AddressFamily `locationName:"addressFamily" type:"string" enum:"true"`

	// The IP address assigned to the Amazon interface.
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// The autonomous system number (ASN) for the Amazon side of the connection.
	AmazonSideAsn *int64 `locationName:"amazonSideAsn" type:"long"`

	// The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// The valid values are 1-2147483647.
	Asn *int64 `locationName:"asn" type:"integer"`

	// The authentication key for BGP configuration. This string has a minimum length
	// of 6 characters and and a maximun lenth of 80 characters.
	AuthKey *string `locationName:"authKey" type:"string"`

	// The Direct Connect endpoint on which the virtual interface terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The BGP peers configured on this virtual interface.
	BgpPeers []BGPPeer `locationName:"bgpPeers" type:"list"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The IP address assigned to the customer interface.
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The customer router configuration.
	CustomerRouterConfig *string `locationName:"customerRouterConfig" type:"string"`

	// The ID of the Direct Connect gateway.
	DirectConnectGatewayId *string `locationName:"directConnectGatewayId" type:"string"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The maximum transmission unit (MTU), in bytes. The supported values are 1500
	// and 9001. The default value is 1500.
	Mtu *int64 `locationName:"mtu" type:"integer"`

	// The ID of the AWS account that owns the virtual interface.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The AWS Region where the virtual interface is located.
	Region *string `locationName:"region" type:"string"`

	// The routes to be advertised to the AWS network in this Region. Applies to
	// public virtual interfaces.
	RouteFilterPrefixes []RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The tags associated with the virtual interface.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`

	// The ID of the virtual private gateway. Applies only to private virtual interfaces.
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// The ID of the virtual interface.
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The name of the virtual interface assigned by the customer network.
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// The state of the virtual interface. The following are the possible values:
	//
	//    * confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * available: A virtual interface that is able to forward traffic.
	//
	//    * down: A virtual interface that is BGP down.
	//
	//    * deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * deleted: A virtual interface that cannot forward traffic.
	//
	//    * rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the Confirming state is deleted by
	//    the virtual interface owner, the virtual interface enters the Rejected
	//    state.
	//
	//    * unknown: The state of the virtual interface is not available.
	VirtualInterfaceState VirtualInterfaceState `locationName:"virtualInterfaceState" type:"string" enum:"true"`

	// The type of virtual interface. The possible values are private and public.
	VirtualInterfaceType *string `locationName:"virtualInterfaceType" type:"string"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s VirtualInterface) String() string {
	return awsutil.Prettify(s)
}
