// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the update device pool operation.
type UpdateDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Device Farm device pool you wish to
	// update.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// Sets whether the maxDevices parameter applies to your device pool. If you
	// set this parameter to true, the maxDevices parameter does not apply, and
	// Device Farm does not limit the number of devices that it adds to your device
	// pool. In this case, Device Farm adds all available devices that meet the
	// criteria that are specified for the rules parameter.
	//
	// If you use this parameter in your request, you cannot use the maxDevices
	// parameter in the same request.
	ClearMaxDevices *bool `locationName:"clearMaxDevices" type:"boolean"`

	// A description of the device pool you wish to update.
	Description *string `locationName:"description" type:"string"`

	// The number of devices that Device Farm can add to your device pool. Device
	// Farm adds devices that are available and that meet the criteria that you
	// assign for the rules parameter. Depending on how many devices meet these
	// constraints, your device pool might contain fewer devices than the value
	// for this parameter.
	//
	// By specifying the maximum number of devices, you can control the costs that
	// you incur by running tests.
	//
	// If you use this parameter in your request, you cannot use the clearMaxDevices
	// parameter in the same request.
	MaxDevices *int64 `locationName:"maxDevices" type:"integer"`

	// A string representing the name of the device pool you wish to update.
	Name *string `locationName:"name" type:"string"`

	// Represents the rules you wish to modify for the device pool. Updating rules
	// is optional; however, if you choose to update rules for your request, the
	// update will replace the existing rules.
	Rules []Rule `locationName:"rules" type:"list"`
}

// String returns the string representation
func (s UpdateDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDevicePoolInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDevicePoolInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of an update device pool request.
type UpdateDevicePoolOutput struct {
	_ struct{} `type:"structure"`

	// The device pool you just updated.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`
}

// String returns the string representation
func (s UpdateDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDevicePool = "UpdateDevicePool"

// UpdateDevicePoolRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Modifies the name, description, and rules in a device pool given the attributes
// and the pool ARN. Rule updates are all-or-nothing, meaning they can only
// be updated as a whole (or not at all).
//
//    // Example sending a request using UpdateDevicePoolRequest.
//    req := client.UpdateDevicePoolRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool
func (c *Client) UpdateDevicePoolRequest(input *UpdateDevicePoolInput) UpdateDevicePoolRequest {
	op := &aws.Operation{
		Name:       opUpdateDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDevicePoolInput{}
	}

	req := c.newRequest(op, input, &UpdateDevicePoolOutput{})
	return UpdateDevicePoolRequest{Request: req, Input: input, Copy: c.UpdateDevicePoolRequest}
}

// UpdateDevicePoolRequest is the request type for the
// UpdateDevicePool API operation.
type UpdateDevicePoolRequest struct {
	*aws.Request
	Input *UpdateDevicePoolInput
	Copy  func(*UpdateDevicePoolInput) UpdateDevicePoolRequest
}

// Send marshals and sends the UpdateDevicePool API request.
func (r UpdateDevicePoolRequest) Send(ctx context.Context) (*UpdateDevicePoolResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDevicePoolResponse{
		UpdateDevicePoolOutput: r.Request.Data.(*UpdateDevicePoolOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDevicePoolResponse is the response type for the
// UpdateDevicePool API operation.
type UpdateDevicePoolResponse struct {
	*UpdateDevicePoolOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDevicePool request.
func (r *UpdateDevicePoolResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
