// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListBuildsForProjectInput struct {
	_ struct{} `type:"structure"`

	// During a previous call, if there are more than 100 items in the list, only
	// the first 100 items are returned, along with a unique string called a nextToken.
	// To get the next batch of items in the list, call this operation again, adding
	// the next token to the call. To get all of the items in the list, keep calling
	// this operation with each subsequent next token that is returned, until no
	// more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the AWS CodeBuild project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The order to list build IDs. Valid values include:
	//
	//    * ASCENDING: List the build IDs in ascending order by build ID.
	//
	//    * DESCENDING: List the build IDs in descending order by build ID.
	SortOrder SortOrderType `locationName:"sortOrder" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListBuildsForProjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBuildsForProjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBuildsForProjectInput"}

	if s.ProjectName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListBuildsForProjectOutput struct {
	_ struct{} `type:"structure"`

	// A list of build IDs for the specified build project, with each build ID representing
	// a single build.
	Ids []string `locationName:"ids" min:"1" type:"list"`

	// If there are more than 100 items in the list, only the first 100 items are
	// returned, along with a unique string called a nextToken. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBuildsForProjectOutput) String() string {
	return awsutil.Prettify(s)
}

const opListBuildsForProject = "ListBuildsForProject"

// ListBuildsForProjectRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Gets a list of build IDs for the specified build project, with each build
// ID representing a single build.
//
//    // Example sending a request using ListBuildsForProjectRequest.
//    req := client.ListBuildsForProjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject
func (c *Client) ListBuildsForProjectRequest(input *ListBuildsForProjectInput) ListBuildsForProjectRequest {
	op := &aws.Operation{
		Name:       opListBuildsForProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsForProjectInput{}
	}

	req := c.newRequest(op, input, &ListBuildsForProjectOutput{})
	return ListBuildsForProjectRequest{Request: req, Input: input, Copy: c.ListBuildsForProjectRequest}
}

// ListBuildsForProjectRequest is the request type for the
// ListBuildsForProject API operation.
type ListBuildsForProjectRequest struct {
	*aws.Request
	Input *ListBuildsForProjectInput
	Copy  func(*ListBuildsForProjectInput) ListBuildsForProjectRequest
}

// Send marshals and sends the ListBuildsForProject API request.
func (r ListBuildsForProjectRequest) Send(ctx context.Context) (*ListBuildsForProjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBuildsForProjectResponse{
		ListBuildsForProjectOutput: r.Request.Data.(*ListBuildsForProjectOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListBuildsForProjectResponse is the response type for the
// ListBuildsForProject API operation.
type ListBuildsForProjectResponse struct {
	*ListBuildsForProjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBuildsForProject request.
func (r *ListBuildsForProjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
