// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type EnableInsightRulesInput struct {
	_ struct{} `type:"structure"`

	// An array of the rule names to enable. If you need to find out the names of
	// your rules, use DescribeInsightRules.
	//
	// RuleNames is a required field
	RuleNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s EnableInsightRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableInsightRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableInsightRulesInput"}

	if s.RuleNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableInsightRulesOutput struct {
	_ struct{} `type:"structure"`

	// An array listing the rules that could not be enabled. You cannot disable
	// or enable built-in rules.
	Failures []PartialFailure `type:"list"`
}

// String returns the string representation
func (s EnableInsightRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableInsightRules = "EnableInsightRules"

// EnableInsightRulesRequest returns a request value for making API operation for
// Amazon CloudWatch.
//
// Enables the specified Contributor Insights rules. When rules are enabled,
// they immediately begin analyzing log data.
//
//    // Example sending a request using EnableInsightRulesRequest.
//    req := client.EnableInsightRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/EnableInsightRules
func (c *Client) EnableInsightRulesRequest(input *EnableInsightRulesInput) EnableInsightRulesRequest {
	op := &aws.Operation{
		Name:       opEnableInsightRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableInsightRulesInput{}
	}

	req := c.newRequest(op, input, &EnableInsightRulesOutput{})
	return EnableInsightRulesRequest{Request: req, Input: input, Copy: c.EnableInsightRulesRequest}
}

// EnableInsightRulesRequest is the request type for the
// EnableInsightRules API operation.
type EnableInsightRulesRequest struct {
	*aws.Request
	Input *EnableInsightRulesInput
	Copy  func(*EnableInsightRulesInput) EnableInsightRulesRequest
}

// Send marshals and sends the EnableInsightRules API request.
func (r EnableInsightRulesRequest) Send(ctx context.Context) (*EnableInsightRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableInsightRulesResponse{
		EnableInsightRulesOutput: r.Request.Data.(*EnableInsightRulesOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableInsightRulesResponse is the response type for the
// EnableInsightRules API operation.
type EnableInsightRulesResponse struct {
	*EnableInsightRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableInsightRules request.
func (r *EnableInsightRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
