// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// Access rules for a domain's document or search service endpoints. For more
	// information, see Configuring Access for a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html)
	// in the Amazon CloudSearch Developer Guide. The maximum size of a policy document
	// is 100 KB.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// Synonyms, stopwords, and stemming options for an analysis scheme. Includes
// tokenization dictionary for Japanese.
type AnalysisOptions struct {
	_ struct{} `type:"structure"`

	// The level of algorithmic stemming to perform: none, minimal, light, or full.
	// The available levels vary depending on the language. For more information,
	// see Language Specific Text Processing Settings (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings)
	// in the Amazon CloudSearch Developer Guide
	AlgorithmicStemming AlgorithmicStemming `type:"string" enum:"true"`

	// A JSON array that contains a collection of terms, tokens, readings and part
	// of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary
	// enables you to override the default tokenization for selected terms. This
	// is only valid for Japanese language fields.
	JapaneseTokenizationDictionary *string `type:"string"`

	// A JSON object that contains a collection of string:value pairs that each
	// map a term to its stem. For example, {"term1": "stem1", "term2": "stem2",
	// "term3": "stem3"}. The stemming dictionary is applied in addition to any
	// algorithmic stemming. This enables you to override the results of the algorithmic
	// stemming to correct specific cases of overstemming or understemming. The
	// maximum size of a stemming dictionary is 500 KB.
	StemmingDictionary *string `type:"string"`

	// A JSON array of terms to ignore during indexing and searching. For example,
	// ["a", "an", "the", "of"]. The stopwords dictionary must explicitly list each
	// word you want to ignore. Wildcards and regular expressions are not supported.
	Stopwords *string `type:"string"`

	// A JSON object that defines synonym groups and aliases. A synonym group is
	// an array of arrays, where each sub-array is a group of terms where each term
	// in the group is considered a synonym of every other term in the group. The
	// aliases value is an object that contains a collection of string:value pairs
	// where the string specifies a term and the array of values specifies each
	// of the aliases for that term. An alias is considered a synonym of the specified
	// term, but the term is not considered a synonym of the alias. For more information
	// about specifying synonyms, see Synonyms (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms)
	// in the Amazon CloudSearch Developer Guide.
	Synonyms *string `type:"string"`
}

// String returns the string representation
func (s AnalysisOptions) String() string {
	return awsutil.Prettify(s)
}

// Configuration information for an analysis scheme. Each analysis scheme has
// a unique name and specifies the language of the text to be processed. The
// following options can be configured for an analysis scheme: Synonyms, Stopwords,
// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
type AnalysisScheme struct {
	_ struct{} `type:"structure"`

	// Synonyms, stopwords, and stemming options for an analysis scheme. Includes
	// tokenization dictionary for Japanese.
	AnalysisOptions *AnalysisOptions `type:"structure"`

	// An IETF RFC 4646 (http://tools.ietf.org/html/rfc4646) language code or mul
	// for multiple languages.
	//
	// AnalysisSchemeLanguage is a required field
	AnalysisSchemeLanguage AnalysisSchemeLanguage `type:"string" required:"true" enum:"true"`

	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	//
	// AnalysisSchemeName is a required field
	AnalysisSchemeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AnalysisScheme) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisScheme) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalysisScheme"}
	if len(s.AnalysisSchemeLanguage) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AnalysisSchemeLanguage"))
	}

	if s.AnalysisSchemeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalysisSchemeName"))
	}
	if s.AnalysisSchemeName != nil && len(*s.AnalysisSchemeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AnalysisSchemeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status and configuration of an AnalysisScheme.
type AnalysisSchemeStatus struct {
	_ struct{} `type:"structure"`

	// Configuration information for an analysis scheme. Each analysis scheme has
	// a unique name and specifies the language of the text to be processed. The
	// following options can be configured for an analysis scheme: Synonyms, Stopwords,
	// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
	//
	// Options is a required field
	Options *AnalysisScheme `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalysisSchemeStatus) String() string {
	return awsutil.Prettify(s)
}

// The status and configuration of the domain's availability options.
type AvailabilityOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The availability options configured for the domain.
	//
	// Options is a required field
	Options *bool `type:"boolean" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AvailabilityOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// Options for a field that contains an array of dates. Present if IndexFieldType
// specifies the field is of type date-array. All options are enabled by default.
type DateArrayOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s DateArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// Options for a date field. Dates and times are specified in UTC (Coordinated
// Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z. Present
// if IndexFieldType specifies the field is of type date. All options are enabled
// by default.
type DateOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DateOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DateOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Options for a search suggester.
type DocumentSuggesterOptions struct {
	_ struct{} `type:"structure"`

	// The level of fuzziness allowed when suggesting matches for a string: none,
	// low, or high. With none, the specified string is treated as an exact prefix.
	// With low, suggestions must differ from the specified string by no more than
	// one character. With high, suggestions can differ by up to two characters.
	// The default is none.
	FuzzyMatching SuggesterFuzzyMatching `type:"string" enum:"true"`

	// An expression that computes a score for each suggestion to control how they
	// are sorted. The scores are rounded to the nearest integer, with a floor of
	// 0 and a ceiling of 2^31-1. A document's relevance score is not computed for
	// suggestions, so sort expressions cannot reference the _score value. To sort
	// suggestions using a numeric field or existing expression, simply specify
	// the name of the field or expression. If no expression is configured for the
	// suggester, the suggestions are sorted with the closest matches listed first.
	SortExpression *string `type:"string"`

	// The name of the index field you want to use for suggestions.
	//
	// SourceField is a required field
	SourceField *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DocumentSuggesterOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentSuggesterOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentSuggesterOptions"}

	if s.SourceField == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceField"))
	}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The domain's endpoint options.
type DomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// Whether the domain is HTTPS only enabled.
	EnforceHTTPS *bool `type:"boolean"`

	// The minimum required TLS version
	TLSSecurityPolicy TLSSecurityPolicy `type:"string" enum:"true"`
}

// String returns the string representation
func (s DomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// The configuration and status of the domain's endpoint options.
type DomainEndpointOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The domain endpoint options configured for the domain.
	//
	// Options is a required field
	Options *DomainEndpointOptions `type:"structure" required:"true"`

	// The status of the configured domain endpoint options.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DomainEndpointOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// The current status of the search domain.
type DomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the search domain. See Identifiers for
	// IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
	// in Using AWS Identity and Access Management for more information.
	ARN *string `type:"string"`

	// True if the search domain is created. It can take several minutes to initialize
	// a domain when CreateDomain is called. Newly created search domains are returned
	// from DescribeDomains with a false value for Created until domain creation
	// is complete.
	Created *bool `type:"boolean"`

	// True if the search domain has been deleted. The system must clean up resources
	// dedicated to the search domain when DeleteDomain is called. Newly deleted
	// search domains are returned from DescribeDomains with a true value for IsDeleted
	// for several minutes until resource cleanup is complete.
	Deleted *bool `type:"boolean"`

	// The service endpoint for updating documents in a search domain.
	DocService *ServiceEndpoint `type:"structure"`

	// An internally generated unique identifier for a domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	Limits *Limits `type:"structure"`

	// True if processing is being done to activate the current domain configuration.
	Processing *bool `type:"boolean"`

	// True if IndexDocuments needs to be called to activate the current domain
	// configuration.
	//
	// RequiresIndexDocuments is a required field
	RequiresIndexDocuments *bool `type:"boolean" required:"true"`

	// The number of search instances that are available to process search requests.
	SearchInstanceCount *int64 `min:"1" type:"integer"`

	// The instance type that is being used to process search requests.
	SearchInstanceType *string `type:"string"`

	// The number of partitions across which the search index is spread.
	SearchPartitionCount *int64 `min:"1" type:"integer"`

	// The service endpoint for requesting search results from a search domain.
	SearchService *ServiceEndpoint `type:"structure"`
}

// String returns the string representation
func (s DomainStatus) String() string {
	return awsutil.Prettify(s)
}

// Options for a field that contains an array of double-precision 64-bit floating
// point values. Present if IndexFieldType specifies the field is of type double-array.
// All options are enabled by default.
type DoubleArrayOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *float64 `type:"double"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s DoubleArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// Options for a double-precision 64-bit floating point field. Present if IndexFieldType
// specifies the field is of type double. All options are enabled by default.
type DoubleOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	// This can be important if you are using the field in an expression and that
	// field is not present in every document.
	DefaultValue *float64 `type:"double"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// The name of the source field to map to the field.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DoubleOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DoubleOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DoubleOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A named expression that can be evaluated at search time. Can be used to sort
// the search results, define other expressions, or return computed information
// in the search results.
type Expression struct {
	_ struct{} `type:"structure"`

	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	//
	// ExpressionName is a required field
	ExpressionName *string `min:"1" type:"string" required:"true"`

	// The expression to evaluate for sorting while processing a search request.
	// The Expression syntax is based on JavaScript expressions. For more information,
	// see Configuring Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
	// in the Amazon CloudSearch Developer Guide.
	//
	// ExpressionValue is a required field
	ExpressionValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Expression) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Expression"}

	if s.ExpressionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExpressionName"))
	}
	if s.ExpressionName != nil && len(*s.ExpressionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExpressionName", 1))
	}

	if s.ExpressionValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExpressionValue"))
	}
	if s.ExpressionValue != nil && len(*s.ExpressionValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExpressionValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The value of an Expression and its current status.
type ExpressionStatus struct {
	_ struct{} `type:"structure"`

	// The expression that is evaluated for sorting while processing a search request.
	//
	// Options is a required field
	Options *Expression `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ExpressionStatus) String() string {
	return awsutil.Prettify(s)
}

// Configuration information for a field in the index, including its name, type,
// and options. The supported options depend on the IndexFieldType.
type IndexField struct {
	_ struct{} `type:"structure"`

	// Options for a field that contains an array of dates. Present if IndexFieldType
	// specifies the field is of type date-array. All options are enabled by default.
	DateArrayOptions *DateArrayOptions `type:"structure"`

	// Options for a date field. Dates and times are specified in UTC (Coordinated
	// Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z. Present
	// if IndexFieldType specifies the field is of type date. All options are enabled
	// by default.
	DateOptions *DateOptions `type:"structure"`

	// Options for a field that contains an array of double-precision 64-bit floating
	// point values. Present if IndexFieldType specifies the field is of type double-array.
	// All options are enabled by default.
	DoubleArrayOptions *DoubleArrayOptions `type:"structure"`

	// Options for a double-precision 64-bit floating point field. Present if IndexFieldType
	// specifies the field is of type double. All options are enabled by default.
	DoubleOptions *DoubleOptions `type:"structure"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	//
	// IndexFieldName is a required field
	IndexFieldName *string `min:"1" type:"string" required:"true"`

	// The type of field. The valid options for a field depend on the field type.
	// For more information about the supported field types, see Configuring Index
	// Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
	// in the Amazon CloudSearch Developer Guide.
	//
	// IndexFieldType is a required field
	IndexFieldType IndexFieldType `type:"string" required:"true" enum:"true"`

	// Options for a field that contains an array of 64-bit signed integers. Present
	// if IndexFieldType specifies the field is of type int-array. All options are
	// enabled by default.
	IntArrayOptions *IntArrayOptions `type:"structure"`

	// Options for a 64-bit signed integer field. Present if IndexFieldType specifies
	// the field is of type int. All options are enabled by default.
	IntOptions *IntOptions `type:"structure"`

	// Options for a latlon field. A latlon field contains a location stored as
	// a latitude and longitude value pair. Present if IndexFieldType specifies
	// the field is of type latlon. All options are enabled by default.
	LatLonOptions *LatLonOptions `type:"structure"`

	// Options for a field that contains an array of literal strings. Present if
	// IndexFieldType specifies the field is of type literal-array. All options
	// are enabled by default.
	LiteralArrayOptions *LiteralArrayOptions `type:"structure"`

	// Options for literal field. Present if IndexFieldType specifies the field
	// is of type literal. All options are enabled by default.
	LiteralOptions *LiteralOptions `type:"structure"`

	// Options for a field that contains an array of text strings. Present if IndexFieldType
	// specifies the field is of type text-array. A text-array field is always searchable.
	// All options are enabled by default.
	TextArrayOptions *TextArrayOptions `type:"structure"`

	// Options for text field. Present if IndexFieldType specifies the field is
	// of type text. A text field is always searchable. All options are enabled
	// by default.
	TextOptions *TextOptions `type:"structure"`
}

// String returns the string representation
func (s IndexField) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexField) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IndexField"}

	if s.IndexFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexFieldName"))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexFieldName", 1))
	}
	if len(s.IndexFieldType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("IndexFieldType"))
	}
	if s.DateOptions != nil {
		if err := s.DateOptions.Validate(); err != nil {
			invalidParams.AddNested("DateOptions", err.(aws.ErrInvalidParams))
		}
	}
	if s.DoubleOptions != nil {
		if err := s.DoubleOptions.Validate(); err != nil {
			invalidParams.AddNested("DoubleOptions", err.(aws.ErrInvalidParams))
		}
	}
	if s.IntOptions != nil {
		if err := s.IntOptions.Validate(); err != nil {
			invalidParams.AddNested("IntOptions", err.(aws.ErrInvalidParams))
		}
	}
	if s.LatLonOptions != nil {
		if err := s.LatLonOptions.Validate(); err != nil {
			invalidParams.AddNested("LatLonOptions", err.(aws.ErrInvalidParams))
		}
	}
	if s.LiteralOptions != nil {
		if err := s.LiteralOptions.Validate(); err != nil {
			invalidParams.AddNested("LiteralOptions", err.(aws.ErrInvalidParams))
		}
	}
	if s.TextOptions != nil {
		if err := s.TextOptions.Validate(); err != nil {
			invalidParams.AddNested("TextOptions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The value of an IndexField and its current status.
type IndexFieldStatus struct {
	_ struct{} `type:"structure"`

	// Configuration information for a field in the index, including its name, type,
	// and options. The supported options depend on the IndexFieldType.
	//
	// Options is a required field
	Options *IndexField `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s IndexFieldStatus) String() string {
	return awsutil.Prettify(s)
}

// Options for a field that contains an array of 64-bit signed integers. Present
// if IndexFieldType specifies the field is of type int-array. All options are
// enabled by default.
type IntArrayOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *int64 `type:"long"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s IntArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// Options for a 64-bit signed integer field. Present if IndexFieldType specifies
// the field is of type int. All options are enabled by default.
type IntOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	// This can be important if you are using the field in an expression and that
	// field is not present in every document.
	DefaultValue *int64 `type:"long"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// The name of the source field to map to the field.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IntOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IntOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Options for a latlon field. A latlon field contains a location stored as
// a latitude and longitude value pair. Present if IndexFieldType specifies
// the field is of type latlon. All options are enabled by default.
type LatLonOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LatLonOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LatLonOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LatLonOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type Limits struct {
	_ struct{} `type:"structure"`

	// MaximumPartitionCount is a required field
	MaximumPartitionCount *int64 `min:"1" type:"integer" required:"true"`

	// MaximumReplicationCount is a required field
	MaximumReplicationCount *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// Options for a field that contains an array of literal strings. Present if
// IndexFieldType specifies the field is of type literal-array. All options
// are enabled by default.
type LiteralArrayOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s LiteralArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// Options for literal field. Present if IndexFieldType specifies the field
// is of type literal. All options are enabled by default.
type LiteralOptions struct {
	_ struct{} `type:"structure"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LiteralOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LiteralOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LiteralOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status of domain configuration option.
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// A timestamp for when this option was created.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// Indicates that the option will be deleted once processing is complete.
	PendingDeletion *bool `type:"boolean"`

	// The state of processing a change to an option. Possible values:
	//
	//    * RequiresIndexDocuments: the option's latest value will not be deployed
	//    until IndexDocuments has been called and indexing is complete.
	//
	//    * Processing: the option's latest value is in the process of being activated.
	//
	//    * Active: the option's latest value is completely deployed.
	//
	//    * FailedToValidate: the option value is not compatible with the domain's
	//    data and cannot be used to index the data. You must either modify the
	//    option value or update or remove the incompatible documents.
	//
	// State is a required field
	State OptionState `type:"string" required:"true" enum:"true"`

	// A timestamp for when this option was last updated.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// A unique integer that indicates when this option was last updated.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// The desired instance type and desired number of replicas of each index partition.
type ScalingParameters struct {
	_ struct{} `type:"structure"`

	// The instance type that you want to preconfigure for your domain. For example,
	// search.m1.small.
	DesiredInstanceType PartitionInstanceType `type:"string" enum:"true"`

	// The number of partitions you want to preconfigure for your domain. Only valid
	// when you select m2.2xlarge as the desired instance type.
	DesiredPartitionCount *int64 `type:"integer"`

	// The number of replicas you want to preconfigure for each index partition.
	DesiredReplicationCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ScalingParameters) String() string {
	return awsutil.Prettify(s)
}

// The status and configuration of a search domain's scaling parameters.
type ScalingParametersStatus struct {
	_ struct{} `type:"structure"`

	// The desired instance type and desired number of replicas of each index partition.
	//
	// Options is a required field
	Options *ScalingParameters `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ScalingParametersStatus) String() string {
	return awsutil.Prettify(s)
}

// The endpoint to which service requests can be submitted.
type ServiceEndpoint struct {
	_ struct{} `type:"structure"`

	// The endpoint to which service requests can be submitted. For example, search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com
	// or doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com.
	Endpoint *string `type:"string"`
}

// String returns the string representation
func (s ServiceEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Configuration information for a search suggester. Each suggester has a unique
// name and specifies the text field you want to use for suggestions. The following
// options can be configured for a suggester: FuzzyMatching, SortExpression.
type Suggester struct {
	_ struct{} `type:"structure"`

	// Options for a search suggester.
	//
	// DocumentSuggesterOptions is a required field
	DocumentSuggesterOptions *DocumentSuggesterOptions `type:"structure" required:"true"`

	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	//
	// SuggesterName is a required field
	SuggesterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Suggester) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Suggester) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Suggester"}

	if s.DocumentSuggesterOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentSuggesterOptions"))
	}

	if s.SuggesterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SuggesterName"))
	}
	if s.SuggesterName != nil && len(*s.SuggesterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SuggesterName", 1))
	}
	if s.DocumentSuggesterOptions != nil {
		if err := s.DocumentSuggesterOptions.Validate(); err != nil {
			invalidParams.AddNested("DocumentSuggesterOptions", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The value of a Suggester and its current status.
type SuggesterStatus struct {
	_ struct{} `type:"structure"`

	// Configuration information for a search suggester. Each suggester has a unique
	// name and specifies the text field you want to use for suggestions. The following
	// options can be configured for a suggester: FuzzyMatching, SortExpression.
	//
	// Options is a required field
	Options *Suggester `type:"structure" required:"true"`

	// The status of domain configuration option.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s SuggesterStatus) String() string {
	return awsutil.Prettify(s)
}

// Options for a field that contains an array of text strings. Present if IndexFieldType
// specifies the field is of type text-array. A text-array field is always searchable.
// All options are enabled by default.
type TextArrayOptions struct {
	_ struct{} `type:"structure"`

	// The name of an analysis scheme for a text-array field.
	AnalysisScheme *string `type:"string"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether highlights can be returned for the field.
	HighlightEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`
}

// String returns the string representation
func (s TextArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// Options for text field. Present if IndexFieldType specifies the field is
// of type text. A text field is always searchable. All options are enabled
// by default.
type TextOptions struct {
	_ struct{} `type:"structure"`

	// The name of an analysis scheme for a text field.
	AnalysisScheme *string `type:"string"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether highlights can be returned for the field.
	HighlightEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TextOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TextOptions"}
	if s.SourceField != nil && len(*s.SourceField) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceField", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
