// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DeleteIndexField operation. Specifies
// the name of the domain you want to update and the name of the index field
// you want to delete.
type DeleteIndexFieldInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The name of the index field your want to remove from the domain's indexing
	// options.
	//
	// IndexFieldName is a required field
	IndexFieldName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIndexFieldInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIndexFieldInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteIndexFieldInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if s.IndexFieldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexFieldName"))
	}
	if s.IndexFieldName != nil && len(*s.IndexFieldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexFieldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteIndexField request.
type DeleteIndexFieldOutput struct {
	_ struct{} `type:"structure"`

	// The status of the index field being deleted.
	//
	// IndexField is a required field
	IndexField *IndexFieldStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteIndexFieldOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteIndexField = "DeleteIndexField"

// DeleteIndexFieldRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Removes an IndexField from the search domain. For more information, see Configuring
// Index Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DeleteIndexFieldRequest.
//    req := client.DeleteIndexFieldRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteIndexFieldRequest(input *DeleteIndexFieldInput) DeleteIndexFieldRequest {
	op := &aws.Operation{
		Name:       opDeleteIndexField,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIndexFieldInput{}
	}

	req := c.newRequest(op, input, &DeleteIndexFieldOutput{})
	return DeleteIndexFieldRequest{Request: req, Input: input, Copy: c.DeleteIndexFieldRequest}
}

// DeleteIndexFieldRequest is the request type for the
// DeleteIndexField API operation.
type DeleteIndexFieldRequest struct {
	*aws.Request
	Input *DeleteIndexFieldInput
	Copy  func(*DeleteIndexFieldInput) DeleteIndexFieldRequest
}

// Send marshals and sends the DeleteIndexField API request.
func (r DeleteIndexFieldRequest) Send(ctx context.Context) (*DeleteIndexFieldResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteIndexFieldResponse{
		DeleteIndexFieldOutput: r.Request.Data.(*DeleteIndexFieldOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteIndexFieldResponse is the response type for the
// DeleteIndexField API operation.
type DeleteIndexFieldResponse struct {
	*DeleteIndexFieldOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteIndexField request.
func (r *DeleteIndexFieldResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
