// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Chime Voice Connector group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Chime Voice Connectors to route inbound calls to.
	VoiceConnectorItems []VoiceConnectorItem `type:"list"`
}

// String returns the string representation
func (s CreateVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVoiceConnectorGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateVoiceConnectorGroupInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.VoiceConnectorItems != nil {
		for i, v := range s.VoiceConnectorItems {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VoiceConnectorItems", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVoiceConnectorGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VoiceConnectorItems != nil {
		v := s.VoiceConnectorItems

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "VoiceConnectorItems", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

type CreateVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector group details.
	VoiceConnectorGroup *VoiceConnectorGroup `type:"structure"`
}

// String returns the string representation
func (s CreateVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVoiceConnectorGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VoiceConnectorGroup != nil {
		v := s.VoiceConnectorGroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceConnectorGroup", v, metadata)
	}
	return nil
}

const opCreateVoiceConnectorGroup = "CreateVoiceConnectorGroup"

// CreateVoiceConnectorGroupRequest returns a request value for making API operation for
// Amazon Chime.
//
// Creates an Amazon Chime Voice Connector group under the administrator's AWS
// account. You can associate up to three existing Amazon Chime Voice Connectors
// with the Amazon Chime Voice Connector group by including VoiceConnectorItems
// in the request.
//
// You can include Amazon Chime Voice Connectors from different AWS Regions
// in your group. This creates a fault tolerant mechanism for fallback in case
// of availability events.
//
//    // Example sending a request using CreateVoiceConnectorGroupRequest.
//    req := client.CreateVoiceConnectorGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnectorGroup
func (c *Client) CreateVoiceConnectorGroupRequest(input *CreateVoiceConnectorGroupInput) CreateVoiceConnectorGroupRequest {
	op := &aws.Operation{
		Name:       opCreateVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups",
	}

	if input == nil {
		input = &CreateVoiceConnectorGroupInput{}
	}

	req := c.newRequest(op, input, &CreateVoiceConnectorGroupOutput{})
	return CreateVoiceConnectorGroupRequest{Request: req, Input: input, Copy: c.CreateVoiceConnectorGroupRequest}
}

// CreateVoiceConnectorGroupRequest is the request type for the
// CreateVoiceConnectorGroup API operation.
type CreateVoiceConnectorGroupRequest struct {
	*aws.Request
	Input *CreateVoiceConnectorGroupInput
	Copy  func(*CreateVoiceConnectorGroupInput) CreateVoiceConnectorGroupRequest
}

// Send marshals and sends the CreateVoiceConnectorGroup API request.
func (r CreateVoiceConnectorGroupRequest) Send(ctx context.Context) (*CreateVoiceConnectorGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateVoiceConnectorGroupResponse{
		CreateVoiceConnectorGroupOutput: r.Request.Data.(*CreateVoiceConnectorGroupOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateVoiceConnectorGroupResponse is the response type for the
// CreateVoiceConnectorGroup API operation.
type CreateVoiceConnectorGroupResponse struct {
	*CreateVoiceConnectorGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateVoiceConnectorGroup request.
func (r *CreateVoiceConnectorGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
