// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK external user ID. Links the attendee to an identity
	// managed by a builder application.
	//
	// ExternalUserId is a required field
	ExternalUserId *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttendeeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAttendeeInput"}

	if s.ExternalUserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExternalUserId"))
	}
	if s.ExternalUserId != nil && len(*s.ExternalUserId) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ExternalUserId", 2))
	}

	if s.MeetingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeetingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAttendeeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ExternalUserId != nil {
		v := *s.ExternalUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalUserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeetingId != nil {
		v := *s.MeetingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meetingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendee ID and join token.
	Attendee *Attendee `type:"structure"`
}

// String returns the string representation
func (s CreateAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAttendeeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attendee != nil {
		v := s.Attendee

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Attendee", v, metadata)
	}
	return nil
}

const opCreateAttendee = "CreateAttendee"

// CreateAttendeeRequest returns a request value for making API operation for
// Amazon Chime.
//
// Creates a new attendee for an active Amazon Chime SDK meeting. For more information
// about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
//    // Example sending a request using CreateAttendeeRequest.
//    req := client.CreateAttendeeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAttendee
func (c *Client) CreateAttendeeRequest(input *CreateAttendeeInput) CreateAttendeeRequest {
	op := &aws.Operation{
		Name:       opCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/attendees",
	}

	if input == nil {
		input = &CreateAttendeeInput{}
	}

	req := c.newRequest(op, input, &CreateAttendeeOutput{})
	return CreateAttendeeRequest{Request: req, Input: input, Copy: c.CreateAttendeeRequest}
}

// CreateAttendeeRequest is the request type for the
// CreateAttendee API operation.
type CreateAttendeeRequest struct {
	*aws.Request
	Input *CreateAttendeeInput
	Copy  func(*CreateAttendeeInput) CreateAttendeeRequest
}

// Send marshals and sends the CreateAttendee API request.
func (r CreateAttendeeRequest) Send(ctx context.Context) (*CreateAttendeeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAttendeeResponse{
		CreateAttendeeOutput: r.Request.Data.(*CreateAttendeeOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAttendeeResponse is the response type for the
// CreateAttendee API operation.
type CreateAttendeeResponse struct {
	*CreateAttendeeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAttendee request.
func (r *CreateAttendeeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
