// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateRecoveryPointLifecycleInput struct {
	_ struct{} `type:"structure"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. AWS Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “expire after days” setting must be
	// 90 days greater than the “transition to cold after days” setting. The
	// “transition to cold after days” setting cannot be changed after a backup
	// has been transitioned to cold.
	Lifecycle *Lifecycle `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"uri" locationName:"recoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRecoveryPointLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecoveryPointLifecycleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRecoveryPointLifecycleInput"}

	if s.BackupVaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupVaultName"))
	}

	if s.RecoveryPointArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecoveryPointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRecoveryPointLifecycleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Lifecycle != nil {
		v := s.Lifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Lifecycle", v, metadata)
	}
	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "backupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "recoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateRecoveryPointLifecycleOutput struct {
	_ struct{} `type:"structure"`

	// An ARN that uniquely identifies a backup vault; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *CalculatedLifecycle `type:"structure"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. AWS Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “expire after days” setting must be
	// 90 days greater than the “transition to cold after days” setting. The
	// “transition to cold after days” setting cannot be changed after a backup
	// has been transitioned to cold.
	Lifecycle *Lifecycle `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateRecoveryPointLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRecoveryPointLifecycleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupVaultArn != nil {
		v := *s.BackupVaultArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CalculatedLifecycle != nil {
		v := s.CalculatedLifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CalculatedLifecycle", v, metadata)
	}
	if s.Lifecycle != nil {
		v := s.Lifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Lifecycle", v, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateRecoveryPointLifecycle = "UpdateRecoveryPointLifecycle"

// UpdateRecoveryPointLifecycleRequest returns a request value for making API operation for
// AWS Backup.
//
// Sets the transition lifecycle of a recovery point.
//
// The lifecycle defines when a protected resource is transitioned to cold storage
// and when it expires. AWS Backup transitions and expires backups automatically
// according to the lifecycle that you define.
//
// Backups transitioned to cold storage must be stored in cold storage for a
// minimum of 90 days. Therefore, the “expire after days” setting must be
// 90 days greater than the “transition to cold after days” setting. The
// “transition to cold after days” setting cannot be changed after a backup
// has been transitioned to cold.
//
//    // Example sending a request using UpdateRecoveryPointLifecycleRequest.
//    req := client.UpdateRecoveryPointLifecycleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle
func (c *Client) UpdateRecoveryPointLifecycleRequest(input *UpdateRecoveryPointLifecycleInput) UpdateRecoveryPointLifecycleRequest {
	op := &aws.Operation{
		Name:       opUpdateRecoveryPointLifecycle,
		HTTPMethod: "POST",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
	}

	if input == nil {
		input = &UpdateRecoveryPointLifecycleInput{}
	}

	req := c.newRequest(op, input, &UpdateRecoveryPointLifecycleOutput{})
	return UpdateRecoveryPointLifecycleRequest{Request: req, Input: input, Copy: c.UpdateRecoveryPointLifecycleRequest}
}

// UpdateRecoveryPointLifecycleRequest is the request type for the
// UpdateRecoveryPointLifecycle API operation.
type UpdateRecoveryPointLifecycleRequest struct {
	*aws.Request
	Input *UpdateRecoveryPointLifecycleInput
	Copy  func(*UpdateRecoveryPointLifecycleInput) UpdateRecoveryPointLifecycleRequest
}

// Send marshals and sends the UpdateRecoveryPointLifecycle API request.
func (r UpdateRecoveryPointLifecycleRequest) Send(ctx context.Context) (*UpdateRecoveryPointLifecycleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRecoveryPointLifecycleResponse{
		UpdateRecoveryPointLifecycleOutput: r.Request.Data.(*UpdateRecoveryPointLifecycleOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRecoveryPointLifecycleResponse is the response type for the
// UpdateRecoveryPointLifecycle API operation.
type UpdateRecoveryPointLifecycleResponse struct {
	*UpdateRecoveryPointLifecycleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRecoveryPointLifecycle request.
func (r *UpdateRecoveryPointLifecycleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
