// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteMeshInput struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMeshInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMeshInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMeshInput"}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMeshInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteMeshOutput struct {
	_ struct{} `type:"structure" payload:"Mesh"`

	// An object that represents a service mesh returned by a describe operation.
	//
	// Mesh is a required field
	Mesh *MeshData `locationName:"mesh" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteMeshOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMeshOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Mesh != nil {
		v := s.Mesh

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "mesh", v, metadata)
	}
	return nil
}

const opDeleteMesh = "DeleteMesh"

// DeleteMeshRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Deletes an existing service mesh.
//
// You must delete all resources (virtual services, routes, virtual routers,
// and virtual nodes) in the service mesh before you can delete the mesh itself.
//
//    // Example sending a request using DeleteMeshRequest.
//    req := client.DeleteMeshRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DeleteMesh
func (c *Client) DeleteMeshRequest(input *DeleteMeshInput) DeleteMeshRequest {
	op := &aws.Operation{
		Name:       opDeleteMesh,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20190125/meshes/{meshName}",
	}

	if input == nil {
		input = &DeleteMeshInput{}
	}

	req := c.newRequest(op, input, &DeleteMeshOutput{})
	return DeleteMeshRequest{Request: req, Input: input, Copy: c.DeleteMeshRequest}
}

// DeleteMeshRequest is the request type for the
// DeleteMesh API operation.
type DeleteMeshRequest struct {
	*aws.Request
	Input *DeleteMeshInput
	Copy  func(*DeleteMeshInput) DeleteMeshRequest
}

// Send marshals and sends the DeleteMesh API request.
func (r DeleteMeshRequest) Send(ctx context.Context) (*DeleteMeshResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMeshResponse{
		DeleteMeshOutput: r.Request.Data.(*DeleteMeshOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMeshResponse is the response type for the
// DeleteMesh API operation.
type DeleteMeshResponse struct {
	*DeleteMeshOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMesh request.
func (r *DeleteMeshResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
