// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartImportTaskInput struct {
	_ struct{} `type:"structure"`

	// Optional. A unique token that you can provide to prevent the same import
	// request from occurring more than once. If you don't provide a token, a token
	// is automatically generated.
	//
	// Sending more than one StartImportTask request with the same client request
	// token will return information about the original import task with that client
	// request token.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The URL for your import file that you've uploaded to Amazon S3.
	//
	// If you're using the AWS CLI, this URL is structured as follows: s3://BucketName/ImportFileName.CSV
	//
	// ImportUrl is a required field
	ImportUrl *string `locationName:"importUrl" min:"1" type:"string" required:"true"`

	// A descriptive name for this request. You can use this name to filter future
	// requests related to this import task, such as identifying applications and
	// servers that were included in this import task. We recommend that you use
	// a meaningful name for each import task.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartImportTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImportTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartImportTaskInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.ImportUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImportUrl"))
	}
	if s.ImportUrl != nil && len(*s.ImportUrl) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ImportUrl", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartImportTaskOutput struct {
	_ struct{} `type:"structure"`

	// An array of information related to the import task request including status
	// information, times, IDs, the Amazon S3 Object URL for the import file, and
	// more.
	Task *ImportTask `locationName:"task" type:"structure"`
}

// String returns the string representation
func (s StartImportTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartImportTask = "StartImportTask"

// StartImportTaskRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Starts an import task, which allows you to import details of your on-premises
// environment directly into AWS without having to use the Application Discovery
// Service (ADS) tools such as the Discovery Connector or Discovery Agent. This
// gives you the option to perform migration assessment and planning directly
// from your imported data, including the ability to group your devices as applications
// and track their migration status.
//
// To start an import request, do this:
//
// Download the specially formatted comma separated value (CSV) import template,
// which you can find here: https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv
// (https://s3-us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv).
//
// Fill out the template with your server and application data.
//
// Upload your import file to an Amazon S3 bucket, and make a note of it's Object
// URL. Your import file must be in the CSV format.
//
// Use the console or the StartImportTask command with the AWS CLI or one of
// the AWS SDKs to import the records from your file.
//
// For more information, including step-by-step procedures, see Migration Hub
// Import (https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html)
// in the AWS Application Discovery Service User Guide.
//
// There are limits to the number of import tasks you can create (and delete)
// in an AWS account. For more information, see AWS Application Discovery Service
// Limits (https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html)
// in the AWS Application Discovery Service User Guide.
//
//    // Example sending a request using StartImportTaskRequest.
//    req := client.StartImportTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/StartImportTask
func (c *Client) StartImportTaskRequest(input *StartImportTaskInput) StartImportTaskRequest {
	op := &aws.Operation{
		Name:       opStartImportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartImportTaskInput{}
	}

	req := c.newRequest(op, input, &StartImportTaskOutput{})
	return StartImportTaskRequest{Request: req, Input: input, Copy: c.StartImportTaskRequest}
}

// StartImportTaskRequest is the request type for the
// StartImportTask API operation.
type StartImportTaskRequest struct {
	*aws.Request
	Input *StartImportTaskInput
	Copy  func(*StartImportTaskInput) StartImportTaskRequest
}

// Send marshals and sends the StartImportTask API request.
func (r StartImportTaskRequest) Send(ctx context.Context) (*StartImportTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartImportTaskResponse{
		StartImportTaskOutput: r.Request.Data.(*StartImportTaskOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartImportTaskResponse is the response type for the
// StartImportTask API operation.
type StartImportTaskResponse struct {
	*StartImportTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartImportTask request.
func (r *StartImportTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
