// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// A request to delete the ClientCertificate resource.
type DeleteClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of the ClientCertificate resource to be deleted.
	//
	// ClientCertificateId is a required field
	ClientCertificateId *string `location:"uri" locationName:"clientcertificate_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClientCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteClientCertificateInput"}

	if s.ClientCertificateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientCertificateId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteClientCertificateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "clientcertificate_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteClientCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteClientCertificateOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteClientCertificate = "DeleteClientCertificate"

// DeleteClientCertificateRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Deletes the ClientCertificate resource.
//
//    // Example sending a request using DeleteClientCertificateRequest.
//    req := client.DeleteClientCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteClientCertificateRequest(input *DeleteClientCertificateInput) DeleteClientCertificateRequest {
	op := &aws.Operation{
		Name:       opDeleteClientCertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clientcertificates/{clientcertificate_id}",
	}

	if input == nil {
		input = &DeleteClientCertificateInput{}
	}

	req := c.newRequest(op, input, &DeleteClientCertificateOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteClientCertificateRequest{Request: req, Input: input, Copy: c.DeleteClientCertificateRequest}
}

// DeleteClientCertificateRequest is the request type for the
// DeleteClientCertificate API operation.
type DeleteClientCertificateRequest struct {
	*aws.Request
	Input *DeleteClientCertificateInput
	Copy  func(*DeleteClientCertificateInput) DeleteClientCertificateRequest
}

// Send marshals and sends the DeleteClientCertificate API request.
func (r DeleteClientCertificateRequest) Send(ctx context.Context) (*DeleteClientCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteClientCertificateResponse{
		DeleteClientCertificateOutput: r.Request.Data.(*DeleteClientCertificateOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteClientCertificateResponse is the response type for the
// DeleteClientCertificate API operation.
type DeleteClientCertificateResponse struct {
	*DeleteClientCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteClientCertificate request.
func (r *DeleteClientCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
