// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/osconfig/agentendpoint/v1beta/guest_policies.proto

package agentendpoint

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The desired state that the OS Config agent will maintain on the VM.
type DesiredState int32

const (
	// The default is to ensure the package is installed.
	DesiredState_DESIRED_STATE_UNSPECIFIED DesiredState = 0
	// The agent ensures that the package is installed.
	DesiredState_INSTALLED DesiredState = 1
	// The agent ensures that the package is installed and
	// periodically checks for and install any updates.
	DesiredState_UPDATED DesiredState = 2
	// The agent ensures that the package is not installed and uninstall it
	// if detected.
	DesiredState_REMOVED DesiredState = 3
)

var DesiredState_name = map[int32]string{
	0: "DESIRED_STATE_UNSPECIFIED",
	1: "INSTALLED",
	2: "UPDATED",
	3: "REMOVED",
}

var DesiredState_value = map[string]int32{
	"DESIRED_STATE_UNSPECIFIED": 0,
	"INSTALLED":                 1,
	"UPDATED":                   2,
	"REMOVED":                   3,
}

func (x DesiredState) String() string {
	return proto.EnumName(DesiredState_name, int32(x))
}

func (DesiredState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{0}
}

// Types of package managers that may be used to manage this package.
type Package_Manager int32

const (
	// The default behavior is ANY.
	Package_MANAGER_UNSPECIFIED Package_Manager = 0
	// Apply this package config using the default system package manager.
	Package_ANY Package_Manager = 1
	// Apply this package config only if Apt is available on the system.
	Package_APT Package_Manager = 2
	// Apply this package config only if Yum is available on the system.
	Package_YUM Package_Manager = 3
	// Apply this package config only if Zypper is available on the system.
	Package_ZYPPER Package_Manager = 4
	// Apply this package config only if GooGet is available on the system.
	Package_GOO Package_Manager = 5
)

var Package_Manager_name = map[int32]string{
	0: "MANAGER_UNSPECIFIED",
	1: "ANY",
	2: "APT",
	3: "YUM",
	4: "ZYPPER",
	5: "GOO",
}

var Package_Manager_value = map[string]int32{
	"MANAGER_UNSPECIFIED": 0,
	"ANY":                 1,
	"APT":                 2,
	"YUM":                 3,
	"ZYPPER":              4,
	"GOO":                 5,
}

func (x Package_Manager) String() string {
	return proto.EnumName(Package_Manager_name, int32(x))
}

func (Package_Manager) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{0, 0}
}

// Type of archive.
type AptRepository_ArchiveType int32

const (
	// Unspecified.
	AptRepository_ARCHIVE_TYPE_UNSPECIFIED AptRepository_ArchiveType = 0
	// DEB indicates that the archive contains binary files.
	AptRepository_DEB AptRepository_ArchiveType = 1
	// DEB_SRC indicates that the archive contains source files.
	AptRepository_DEB_SRC AptRepository_ArchiveType = 2
)

var AptRepository_ArchiveType_name = map[int32]string{
	0: "ARCHIVE_TYPE_UNSPECIFIED",
	1: "DEB",
	2: "DEB_SRC",
}

var AptRepository_ArchiveType_value = map[string]int32{
	"ARCHIVE_TYPE_UNSPECIFIED": 0,
	"DEB":                      1,
	"DEB_SRC":                  2,
}

func (x AptRepository_ArchiveType) String() string {
	return proto.EnumName(AptRepository_ArchiveType_name, int32(x))
}

func (AptRepository_ArchiveType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{1, 0}
}

// Specifying the type of archive.
type SoftwareRecipe_Step_ExtractArchive_ArchiveType int32

const (
	// Indicates that the archive type isn't specified.
	SoftwareRecipe_Step_ExtractArchive_ARCHIVE_TYPE_UNSPECIFIED SoftwareRecipe_Step_ExtractArchive_ArchiveType = 0
	// Indicates that the archive is a tar archive with no encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR SoftwareRecipe_Step_ExtractArchive_ArchiveType = 1
	// Indicates that the archive is a tar archive with gzip encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_GZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 2
	// Indicates that the archive is a tar archive with bzip encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_BZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 3
	// Indicates that the archive is a tar archive with lzma encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_LZMA SoftwareRecipe_Step_ExtractArchive_ArchiveType = 4
	// Indicates that the archive is a tar archive with xz encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_XZ SoftwareRecipe_Step_ExtractArchive_ArchiveType = 5
	// Indicates that the archive is a zip archive.
	SoftwareRecipe_Step_ExtractArchive_ZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 11
)

var SoftwareRecipe_Step_ExtractArchive_ArchiveType_name = map[int32]string{
	0:  "ARCHIVE_TYPE_UNSPECIFIED",
	1:  "TAR",
	2:  "TAR_GZIP",
	3:  "TAR_BZIP",
	4:  "TAR_LZMA",
	5:  "TAR_XZ",
	11: "ZIP",
}

var SoftwareRecipe_Step_ExtractArchive_ArchiveType_value = map[string]int32{
	"ARCHIVE_TYPE_UNSPECIFIED": 0,
	"TAR":                      1,
	"TAR_GZIP":                 2,
	"TAR_BZIP":                 3,
	"TAR_LZMA":                 4,
	"TAR_XZ":                   5,
	"ZIP":                      11,
}

func (x SoftwareRecipe_Step_ExtractArchive_ArchiveType) String() string {
	return proto.EnumName(SoftwareRecipe_Step_ExtractArchive_ArchiveType_name, int32(x))
}

func (SoftwareRecipe_Step_ExtractArchive_ArchiveType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 1, 0}
}

// The interpreter used to execute a script.
type SoftwareRecipe_Step_RunScript_Interpreter int32

const (
	// Default value for ScriptType.
	SoftwareRecipe_Step_RunScript_INTERPRETER_UNSPECIFIED SoftwareRecipe_Step_RunScript_Interpreter = 0
	// Indicates that the script is run with `/bin/sh` on Linux and `cmd`
	// on windows.
	SoftwareRecipe_Step_RunScript_SHELL SoftwareRecipe_Step_RunScript_Interpreter = 1
	// Indicates that the script is run with powershell.
	SoftwareRecipe_Step_RunScript_POWERSHELL SoftwareRecipe_Step_RunScript_Interpreter = 3
)

var SoftwareRecipe_Step_RunScript_Interpreter_name = map[int32]string{
	0: "INTERPRETER_UNSPECIFIED",
	1: "SHELL",
	3: "POWERSHELL",
}

var SoftwareRecipe_Step_RunScript_Interpreter_value = map[string]int32{
	"INTERPRETER_UNSPECIFIED": 0,
	"SHELL":                   1,
	"POWERSHELL":              3,
}

func (x SoftwareRecipe_Step_RunScript_Interpreter) String() string {
	return proto.EnumName(SoftwareRecipe_Step_RunScript_Interpreter_name, int32(x))
}

func (SoftwareRecipe_Step_RunScript_Interpreter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 6, 0}
}

// Package is a reference to the software package to be installed or removed.
// The agent on the VM instance uses the system package manager to apply the
// config.
//
//
// These are the commands that the agent uses to install or remove
// packages.
//
// Apt
// install: `apt-get update && apt-get -y install package1 package2 package3`
// remove: `apt-get -y remove package1 package2 package3`
//
// Yum
// install: `yum -y install package1 package2 package3`
// remove: `yum -y remove package1 package2 package3`
//
// Zypper
// install: `zypper install package1 package2 package3`
// remove: `zypper rm package1 package2`
//
// Googet
// install: `googet -noconfirm install package1 package2 package3`
// remove: `googet -noconfirm remove package1 package2 package3`
type Package struct {
	// The name of the package. A package is uniquely identified for conflict
	// validation by checking the package name and the manager(s) that the
	// package targets.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The desired_state the agent should maintain for this package. The
	// default is to ensure the package is installed.
	DesiredState DesiredState `protobuf:"varint,2,opt,name=desired_state,json=desiredState,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.DesiredState" json:"desired_state,omitempty"`
	// Type of package manager that can be used to install this package.
	// If a system does not have the package manager, the package is not
	// installed or removed no error message is returned. By default,
	// or if you specify `ANY`,
	// the agent attempts to install and remove this package using the default
	// package manager. This is useful when creating a policy that applies to
	// different types of systems.
	//
	// The default behavior is ANY.
	Manager              Package_Manager `protobuf:"varint,3,opt,name=manager,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.Package_Manager" json:"manager,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Package) Reset()         { *m = Package{} }
func (m *Package) String() string { return proto.CompactTextString(m) }
func (*Package) ProtoMessage()    {}
func (*Package) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{0}
}

func (m *Package) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Package.Unmarshal(m, b)
}
func (m *Package) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Package.Marshal(b, m, deterministic)
}
func (m *Package) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Package.Merge(m, src)
}
func (m *Package) XXX_Size() int {
	return xxx_messageInfo_Package.Size(m)
}
func (m *Package) XXX_DiscardUnknown() {
	xxx_messageInfo_Package.DiscardUnknown(m)
}

var xxx_messageInfo_Package proto.InternalMessageInfo

func (m *Package) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Package) GetDesiredState() DesiredState {
	if m != nil {
		return m.DesiredState
	}
	return DesiredState_DESIRED_STATE_UNSPECIFIED
}

func (m *Package) GetManager() Package_Manager {
	if m != nil {
		return m.Manager
	}
	return Package_MANAGER_UNSPECIFIED
}

// Represents a single Apt package repository. This repository is added to
// a repo file that is stored at
// `/etc/apt/sources.list.d/google_osconfig.list`.
type AptRepository struct {
	// Type of archive files in this repository. The default behavior is DEB.
	ArchiveType AptRepository_ArchiveType `protobuf:"varint,1,opt,name=archive_type,json=archiveType,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.AptRepository_ArchiveType" json:"archive_type,omitempty"`
	// URI for this repository.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Distribution of this repository.
	Distribution string `protobuf:"bytes,3,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// List of components for this repository. Must contain at least one item.
	Components []string `protobuf:"bytes,4,rep,name=components,proto3" json:"components,omitempty"`
	// URI of the key file for this repository. The agent maintains
	// a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg` containing
	// all the keys in any applied guest policy.
	GpgKey               string   `protobuf:"bytes,5,opt,name=gpg_key,json=gpgKey,proto3" json:"gpg_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AptRepository) Reset()         { *m = AptRepository{} }
func (m *AptRepository) String() string { return proto.CompactTextString(m) }
func (*AptRepository) ProtoMessage()    {}
func (*AptRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{1}
}

func (m *AptRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AptRepository.Unmarshal(m, b)
}
func (m *AptRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AptRepository.Marshal(b, m, deterministic)
}
func (m *AptRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AptRepository.Merge(m, src)
}
func (m *AptRepository) XXX_Size() int {
	return xxx_messageInfo_AptRepository.Size(m)
}
func (m *AptRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_AptRepository.DiscardUnknown(m)
}

var xxx_messageInfo_AptRepository proto.InternalMessageInfo

func (m *AptRepository) GetArchiveType() AptRepository_ArchiveType {
	if m != nil {
		return m.ArchiveType
	}
	return AptRepository_ARCHIVE_TYPE_UNSPECIFIED
}

func (m *AptRepository) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *AptRepository) GetDistribution() string {
	if m != nil {
		return m.Distribution
	}
	return ""
}

func (m *AptRepository) GetComponents() []string {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *AptRepository) GetGpgKey() string {
	if m != nil {
		return m.GpgKey
	}
	return ""
}

// Represents a single Yum package repository. This repository is added to a
// repo file that is stored at `/etc/yum.repos.d/google_osconfig.repo`.
type YumRepository struct {
	// A one word, unique name for this repository. This is
	// the `repo id` in the Yum config file and also the `display_name` if
	// `display_name` is omitted. This id is also used as the unique identifier
	// when checking for guest policy conflicts.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the repository.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The location of the repository directory.
	BaseUrl string `protobuf:"bytes,3,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// URIs of GPG keys.
	GpgKeys              []string `protobuf:"bytes,4,rep,name=gpg_keys,json=gpgKeys,proto3" json:"gpg_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *YumRepository) Reset()         { *m = YumRepository{} }
func (m *YumRepository) String() string { return proto.CompactTextString(m) }
func (*YumRepository) ProtoMessage()    {}
func (*YumRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{2}
}

func (m *YumRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YumRepository.Unmarshal(m, b)
}
func (m *YumRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YumRepository.Marshal(b, m, deterministic)
}
func (m *YumRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YumRepository.Merge(m, src)
}
func (m *YumRepository) XXX_Size() int {
	return xxx_messageInfo_YumRepository.Size(m)
}
func (m *YumRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_YumRepository.DiscardUnknown(m)
}

var xxx_messageInfo_YumRepository proto.InternalMessageInfo

func (m *YumRepository) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *YumRepository) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *YumRepository) GetBaseUrl() string {
	if m != nil {
		return m.BaseUrl
	}
	return ""
}

func (m *YumRepository) GetGpgKeys() []string {
	if m != nil {
		return m.GpgKeys
	}
	return nil
}

// Represents a single Zypper package repository. This repository is added to a
// repo file that is stored at `/etc/zypp/repos.d/google_osconfig.repo`.
type ZypperRepository struct {
	// A one word, unique name for this repository. This is
	// the `repo id` in the zypper config file and also the `display_name` if
	// `display_name` is omitted. This id is also used as the unique identifier
	// when checking for guest policy conflicts.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the repository.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The location of the repository directory.
	BaseUrl string `protobuf:"bytes,3,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// URIs of GPG keys.
	GpgKeys              []string `protobuf:"bytes,4,rep,name=gpg_keys,json=gpgKeys,proto3" json:"gpg_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZypperRepository) Reset()         { *m = ZypperRepository{} }
func (m *ZypperRepository) String() string { return proto.CompactTextString(m) }
func (*ZypperRepository) ProtoMessage()    {}
func (*ZypperRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{3}
}

func (m *ZypperRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZypperRepository.Unmarshal(m, b)
}
func (m *ZypperRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZypperRepository.Marshal(b, m, deterministic)
}
func (m *ZypperRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZypperRepository.Merge(m, src)
}
func (m *ZypperRepository) XXX_Size() int {
	return xxx_messageInfo_ZypperRepository.Size(m)
}
func (m *ZypperRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_ZypperRepository.DiscardUnknown(m)
}

var xxx_messageInfo_ZypperRepository proto.InternalMessageInfo

func (m *ZypperRepository) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ZypperRepository) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ZypperRepository) GetBaseUrl() string {
	if m != nil {
		return m.BaseUrl
	}
	return ""
}

func (m *ZypperRepository) GetGpgKeys() []string {
	if m != nil {
		return m.GpgKeys
	}
	return nil
}

// Represents a Goo package repository. These is added to a repo file
// that is stored at C:/ProgramData/GooGet/repos/google_osconfig.repo.
type GooRepository struct {
	// The name of the repository.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The url of the repository.
	Url                  string   `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GooRepository) Reset()         { *m = GooRepository{} }
func (m *GooRepository) String() string { return proto.CompactTextString(m) }
func (*GooRepository) ProtoMessage()    {}
func (*GooRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{4}
}

func (m *GooRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GooRepository.Unmarshal(m, b)
}
func (m *GooRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GooRepository.Marshal(b, m, deterministic)
}
func (m *GooRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GooRepository.Merge(m, src)
}
func (m *GooRepository) XXX_Size() int {
	return xxx_messageInfo_GooRepository.Size(m)
}
func (m *GooRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_GooRepository.DiscardUnknown(m)
}

var xxx_messageInfo_GooRepository proto.InternalMessageInfo

func (m *GooRepository) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GooRepository) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// A package repository.
type PackageRepository struct {
	// A specific type of repository.
	//
	// Types that are valid to be assigned to Repository:
	//	*PackageRepository_Apt
	//	*PackageRepository_Yum
	//	*PackageRepository_Zypper
	//	*PackageRepository_Goo
	Repository           isPackageRepository_Repository `protobuf_oneof:"repository"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *PackageRepository) Reset()         { *m = PackageRepository{} }
func (m *PackageRepository) String() string { return proto.CompactTextString(m) }
func (*PackageRepository) ProtoMessage()    {}
func (*PackageRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{5}
}

func (m *PackageRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PackageRepository.Unmarshal(m, b)
}
func (m *PackageRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PackageRepository.Marshal(b, m, deterministic)
}
func (m *PackageRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PackageRepository.Merge(m, src)
}
func (m *PackageRepository) XXX_Size() int {
	return xxx_messageInfo_PackageRepository.Size(m)
}
func (m *PackageRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_PackageRepository.DiscardUnknown(m)
}

var xxx_messageInfo_PackageRepository proto.InternalMessageInfo

type isPackageRepository_Repository interface {
	isPackageRepository_Repository()
}

type PackageRepository_Apt struct {
	Apt *AptRepository `protobuf:"bytes,1,opt,name=apt,proto3,oneof"`
}

type PackageRepository_Yum struct {
	Yum *YumRepository `protobuf:"bytes,2,opt,name=yum,proto3,oneof"`
}

type PackageRepository_Zypper struct {
	Zypper *ZypperRepository `protobuf:"bytes,3,opt,name=zypper,proto3,oneof"`
}

type PackageRepository_Goo struct {
	Goo *GooRepository `protobuf:"bytes,4,opt,name=goo,proto3,oneof"`
}

func (*PackageRepository_Apt) isPackageRepository_Repository() {}

func (*PackageRepository_Yum) isPackageRepository_Repository() {}

func (*PackageRepository_Zypper) isPackageRepository_Repository() {}

func (*PackageRepository_Goo) isPackageRepository_Repository() {}

func (m *PackageRepository) GetRepository() isPackageRepository_Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *PackageRepository) GetApt() *AptRepository {
	if x, ok := m.GetRepository().(*PackageRepository_Apt); ok {
		return x.Apt
	}
	return nil
}

func (m *PackageRepository) GetYum() *YumRepository {
	if x, ok := m.GetRepository().(*PackageRepository_Yum); ok {
		return x.Yum
	}
	return nil
}

func (m *PackageRepository) GetZypper() *ZypperRepository {
	if x, ok := m.GetRepository().(*PackageRepository_Zypper); ok {
		return x.Zypper
	}
	return nil
}

func (m *PackageRepository) GetGoo() *GooRepository {
	if x, ok := m.GetRepository().(*PackageRepository_Goo); ok {
		return x.Goo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PackageRepository) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PackageRepository_Apt)(nil),
		(*PackageRepository_Yum)(nil),
		(*PackageRepository_Zypper)(nil),
		(*PackageRepository_Goo)(nil),
	}
}

// A software recipe is a set of instructions for installing and configuring a
// piece of software. It consists of a set of artifacts that are
// downloaded, and a set of steps that install, configure, and/or update the
// software.
//
// Recipes support installing and updating software from artifacts in the
// following formats:
// Zip archive, Tar archive, Windows MSI, Debian package, and RPM package.
//
// Additionally, recipes support executing a script (either defined in a file or
// directly in this api) in bash, sh, cmd, and powershell.
//
// Updating a software recipe
//
// If a recipe is assigned to an instance and there is a recipe with the same
// name but a lower version already installed and the assigned state
// of the recipe is `INSTALLED_KEEP_UPDATED`, then the recipe is updated to
// the new version.
//
// Script Working Directories
//
// Each script or execution step is run in its own temporary directory which
// is deleted after completing the step.
type SoftwareRecipe struct {
	// Unique identifier for the recipe. Only one recipe with a given name is
	// installed on an instance.
	//
	// Names are also used to identify resources which helps to determine whether
	// guest policies have conflicts. This means that requests to create multiple
	// recipes with the same name and version are rejected since they
	// could potentially have conflicting assignments.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version of this software recipe. Version can be up to 4 period
	// separated numbers (e.g. 12.34.56.78).
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Resources available to be used in the steps in the recipe.
	Artifacts []*SoftwareRecipe_Artifact `protobuf:"bytes,3,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Actions to be taken for installing this recipe. On failure it stops
	// executing steps and does not attempt another installation. Any steps taken
	// (including partially completed steps) are not rolled back.  Install steps
	// must be specified and are used on first installation.
	InstallSteps []*SoftwareRecipe_Step `protobuf:"bytes,4,rep,name=install_steps,json=installSteps,proto3" json:"install_steps,omitempty"`
	// Actions to be taken for updating this recipe. On failure it stops
	// executing steps and  does not attempt another update for this recipe. Any
	// steps taken (including partially completed steps) are not rolled back.
	// Upgrade steps are not mandatory and are only used when upgrading.
	UpdateSteps []*SoftwareRecipe_Step `protobuf:"bytes,5,rep,name=update_steps,json=updateSteps,proto3" json:"update_steps,omitempty"`
	// Default is INSTALLED. The desired state the agent should maintain for this
	// recipe.
	//
	// INSTALLED: The software recipe is installed on the instance but won't be
	//                         updated to new versions.
	// UPDATED: The software recipe is installed on the instance. The recipe is
	//                         updated to a higher version, if a higher version of
	//                         the recipe is assigned to this instance.
	// REMOVE: Remove is unsupported for software recipes and attempts to
	//         create or update a recipe to the REMOVE state is rejected.
	DesiredState         DesiredState `protobuf:"varint,6,opt,name=desired_state,json=desiredState,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.DesiredState" json:"desired_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SoftwareRecipe) Reset()         { *m = SoftwareRecipe{} }
func (m *SoftwareRecipe) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe) ProtoMessage()    {}
func (*SoftwareRecipe) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6}
}

func (m *SoftwareRecipe) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe.Unmarshal(m, b)
}
func (m *SoftwareRecipe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe.Merge(m, src)
}
func (m *SoftwareRecipe) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe.Size(m)
}
func (m *SoftwareRecipe) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe proto.InternalMessageInfo

func (m *SoftwareRecipe) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SoftwareRecipe) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *SoftwareRecipe) GetArtifacts() []*SoftwareRecipe_Artifact {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (m *SoftwareRecipe) GetInstallSteps() []*SoftwareRecipe_Step {
	if m != nil {
		return m.InstallSteps
	}
	return nil
}

func (m *SoftwareRecipe) GetUpdateSteps() []*SoftwareRecipe_Step {
	if m != nil {
		return m.UpdateSteps
	}
	return nil
}

func (m *SoftwareRecipe) GetDesiredState() DesiredState {
	if m != nil {
		return m.DesiredState
	}
	return DesiredState_DESIRED_STATE_UNSPECIFIED
}

// Specifies a resource to be used in the recipe.
type SoftwareRecipe_Artifact struct {
	// Id of the artifact, which the installation and update steps of this
	// recipe can reference. Artifacts in a recipe cannot have the same id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A specific type of artifact.
	//
	// Types that are valid to be assigned to Artifact:
	//	*SoftwareRecipe_Artifact_Remote_
	//	*SoftwareRecipe_Artifact_Gcs_
	Artifact isSoftwareRecipe_Artifact_Artifact `protobuf_oneof:"artifact"`
	// Defaults to false. When false, recipes are subject to validations
	// based on the artifact type:
	//
	// Remote: A checksum must be specified, and only protocols with
	//         transport-layer security are permitted.
	// GCS:    An object generation number must be specified.
	AllowInsecure        bool     `protobuf:"varint,4,opt,name=allow_insecure,json=allowInsecure,proto3" json:"allow_insecure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Artifact) Reset()         { *m = SoftwareRecipe_Artifact{} }
func (m *SoftwareRecipe_Artifact) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Artifact) ProtoMessage()    {}
func (*SoftwareRecipe_Artifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 0}
}

func (m *SoftwareRecipe_Artifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Artifact.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Artifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Artifact.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Artifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Artifact.Merge(m, src)
}
func (m *SoftwareRecipe_Artifact) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Artifact.Size(m)
}
func (m *SoftwareRecipe_Artifact) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Artifact.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Artifact proto.InternalMessageInfo

func (m *SoftwareRecipe_Artifact) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type isSoftwareRecipe_Artifact_Artifact interface {
	isSoftwareRecipe_Artifact_Artifact()
}

type SoftwareRecipe_Artifact_Remote_ struct {
	Remote *SoftwareRecipe_Artifact_Remote `protobuf:"bytes,2,opt,name=remote,proto3,oneof"`
}

type SoftwareRecipe_Artifact_Gcs_ struct {
	Gcs *SoftwareRecipe_Artifact_Gcs `protobuf:"bytes,3,opt,name=gcs,proto3,oneof"`
}

func (*SoftwareRecipe_Artifact_Remote_) isSoftwareRecipe_Artifact_Artifact() {}

func (*SoftwareRecipe_Artifact_Gcs_) isSoftwareRecipe_Artifact_Artifact() {}

func (m *SoftwareRecipe_Artifact) GetArtifact() isSoftwareRecipe_Artifact_Artifact {
	if m != nil {
		return m.Artifact
	}
	return nil
}

func (m *SoftwareRecipe_Artifact) GetRemote() *SoftwareRecipe_Artifact_Remote {
	if x, ok := m.GetArtifact().(*SoftwareRecipe_Artifact_Remote_); ok {
		return x.Remote
	}
	return nil
}

func (m *SoftwareRecipe_Artifact) GetGcs() *SoftwareRecipe_Artifact_Gcs {
	if x, ok := m.GetArtifact().(*SoftwareRecipe_Artifact_Gcs_); ok {
		return x.Gcs
	}
	return nil
}

func (m *SoftwareRecipe_Artifact) GetAllowInsecure() bool {
	if m != nil {
		return m.AllowInsecure
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SoftwareRecipe_Artifact) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SoftwareRecipe_Artifact_Remote_)(nil),
		(*SoftwareRecipe_Artifact_Gcs_)(nil),
	}
}

// Specifies an artifact available via some URI.
type SoftwareRecipe_Artifact_Remote struct {
	// URI from which to fetch the object. It should contain both the protocol
	// and path following the format {protocol}://{location}.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Must be provided if `allow_insecure` is `false`.
	// SHA256 checksum in hex format, to compare to the checksum of the
	// artifact. If the checksum is not empty and it doesn't match the
	// artifact then the recipe installation fails before running any of the
	// steps.
	Checksum             string   `protobuf:"bytes,2,opt,name=checksum,proto3" json:"checksum,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Artifact_Remote) Reset()         { *m = SoftwareRecipe_Artifact_Remote{} }
func (m *SoftwareRecipe_Artifact_Remote) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Artifact_Remote) ProtoMessage()    {}
func (*SoftwareRecipe_Artifact_Remote) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 0, 0}
}

func (m *SoftwareRecipe_Artifact_Remote) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Remote.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Artifact_Remote) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Remote.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Artifact_Remote) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Artifact_Remote.Merge(m, src)
}
func (m *SoftwareRecipe_Artifact_Remote) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Remote.Size(m)
}
func (m *SoftwareRecipe_Artifact_Remote) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Artifact_Remote.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Artifact_Remote proto.InternalMessageInfo

func (m *SoftwareRecipe_Artifact_Remote) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *SoftwareRecipe_Artifact_Remote) GetChecksum() string {
	if m != nil {
		return m.Checksum
	}
	return ""
}

// Specifies an artifact available as a Cloud Storage object.
type SoftwareRecipe_Artifact_Gcs struct {
	// Bucket of the Cloud Storage object.
	// Given an example URL:
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `my-bucket`.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Name of the Cloud Storage object.
	// As specified [here]
	// (https://cloud.google.com/storage/docs/naming#objectnames)
	// Given an example URL:
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `foo/bar`.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Must be provided if allow_insecure is false.
	// Generation number of the Cloud Storage object.
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `1234567`.
	Generation           int64    `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Artifact_Gcs) Reset()         { *m = SoftwareRecipe_Artifact_Gcs{} }
func (m *SoftwareRecipe_Artifact_Gcs) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Artifact_Gcs) ProtoMessage()    {}
func (*SoftwareRecipe_Artifact_Gcs) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 0, 1}
}

func (m *SoftwareRecipe_Artifact_Gcs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Artifact_Gcs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Artifact_Gcs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.Merge(m, src)
}
func (m *SoftwareRecipe_Artifact_Gcs) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.Size(m)
}
func (m *SoftwareRecipe_Artifact_Gcs) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Artifact_Gcs proto.InternalMessageInfo

func (m *SoftwareRecipe_Artifact_Gcs) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *SoftwareRecipe_Artifact_Gcs) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *SoftwareRecipe_Artifact_Gcs) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

// An action that can be taken as part of installing or updating a recipe.
type SoftwareRecipe_Step struct {
	// A specific type of step.
	//
	// Types that are valid to be assigned to Step:
	//	*SoftwareRecipe_Step_FileCopy
	//	*SoftwareRecipe_Step_ArchiveExtraction
	//	*SoftwareRecipe_Step_MsiInstallation
	//	*SoftwareRecipe_Step_DpkgInstallation
	//	*SoftwareRecipe_Step_RpmInstallation
	//	*SoftwareRecipe_Step_FileExec
	//	*SoftwareRecipe_Step_ScriptRun
	Step                 isSoftwareRecipe_Step_Step `protobuf_oneof:"step"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SoftwareRecipe_Step) Reset()         { *m = SoftwareRecipe_Step{} }
func (m *SoftwareRecipe_Step) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step) ProtoMessage()    {}
func (*SoftwareRecipe_Step) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1}
}

func (m *SoftwareRecipe_Step) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step.Merge(m, src)
}
func (m *SoftwareRecipe_Step) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step.Size(m)
}
func (m *SoftwareRecipe_Step) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step proto.InternalMessageInfo

type isSoftwareRecipe_Step_Step interface {
	isSoftwareRecipe_Step_Step()
}

type SoftwareRecipe_Step_FileCopy struct {
	FileCopy *SoftwareRecipe_Step_CopyFile `protobuf:"bytes,1,opt,name=file_copy,json=fileCopy,proto3,oneof"`
}

type SoftwareRecipe_Step_ArchiveExtraction struct {
	ArchiveExtraction *SoftwareRecipe_Step_ExtractArchive `protobuf:"bytes,2,opt,name=archive_extraction,json=archiveExtraction,proto3,oneof"`
}

type SoftwareRecipe_Step_MsiInstallation struct {
	MsiInstallation *SoftwareRecipe_Step_InstallMsi `protobuf:"bytes,3,opt,name=msi_installation,json=msiInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_DpkgInstallation struct {
	DpkgInstallation *SoftwareRecipe_Step_InstallDpkg `protobuf:"bytes,4,opt,name=dpkg_installation,json=dpkgInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_RpmInstallation struct {
	RpmInstallation *SoftwareRecipe_Step_InstallRpm `protobuf:"bytes,5,opt,name=rpm_installation,json=rpmInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_FileExec struct {
	FileExec *SoftwareRecipe_Step_ExecFile `protobuf:"bytes,6,opt,name=file_exec,json=fileExec,proto3,oneof"`
}

type SoftwareRecipe_Step_ScriptRun struct {
	ScriptRun *SoftwareRecipe_Step_RunScript `protobuf:"bytes,7,opt,name=script_run,json=scriptRun,proto3,oneof"`
}

func (*SoftwareRecipe_Step_FileCopy) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_ArchiveExtraction) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_MsiInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_DpkgInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_RpmInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_FileExec) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_ScriptRun) isSoftwareRecipe_Step_Step() {}

func (m *SoftwareRecipe_Step) GetStep() isSoftwareRecipe_Step_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetFileCopy() *SoftwareRecipe_Step_CopyFile {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_FileCopy); ok {
		return x.FileCopy
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetArchiveExtraction() *SoftwareRecipe_Step_ExtractArchive {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_ArchiveExtraction); ok {
		return x.ArchiveExtraction
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetMsiInstallation() *SoftwareRecipe_Step_InstallMsi {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_MsiInstallation); ok {
		return x.MsiInstallation
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetDpkgInstallation() *SoftwareRecipe_Step_InstallDpkg {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_DpkgInstallation); ok {
		return x.DpkgInstallation
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetRpmInstallation() *SoftwareRecipe_Step_InstallRpm {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_RpmInstallation); ok {
		return x.RpmInstallation
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetFileExec() *SoftwareRecipe_Step_ExecFile {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_FileExec); ok {
		return x.FileExec
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetScriptRun() *SoftwareRecipe_Step_RunScript {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_ScriptRun); ok {
		return x.ScriptRun
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SoftwareRecipe_Step) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SoftwareRecipe_Step_FileCopy)(nil),
		(*SoftwareRecipe_Step_ArchiveExtraction)(nil),
		(*SoftwareRecipe_Step_MsiInstallation)(nil),
		(*SoftwareRecipe_Step_DpkgInstallation)(nil),
		(*SoftwareRecipe_Step_RpmInstallation)(nil),
		(*SoftwareRecipe_Step_FileExec)(nil),
		(*SoftwareRecipe_Step_ScriptRun)(nil),
	}
}

// Copies the artifact to the specified path on the instance.
type SoftwareRecipe_Step_CopyFile struct {
	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// The absolute path on the instance to put the file.
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Whether to allow this step to overwrite existing files. If this is
	// false and the file already exists the file is not overwritten
	// and the step is considered a success. Defaults to false.
	Overwrite bool `protobuf:"varint,3,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
	// Consists of three octal digits which represent, in
	// order, the permissions of the owner, group, and other users for the
	// file (similarly to the numeric mode used in the linux chmod utility).
	// Each digit represents a three bit number with the 4 bit
	// corresponding to the read permissions, the 2 bit corresponds to the
	// write bit, and the one bit corresponds to the execute permission.
	// Default behavior is 755.
	//
	// Below are some examples of permissions and their associated values:
	// read, write, and execute: 7
	// read and execute: 5
	// read and write: 6
	// read only: 4
	Permissions          string   `protobuf:"bytes,4,opt,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_CopyFile) Reset()         { *m = SoftwareRecipe_Step_CopyFile{} }
func (m *SoftwareRecipe_Step_CopyFile) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_CopyFile) ProtoMessage()    {}
func (*SoftwareRecipe_Step_CopyFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 0}
}

func (m *SoftwareRecipe_Step_CopyFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_CopyFile.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_CopyFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_CopyFile.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_CopyFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_CopyFile.Merge(m, src)
}
func (m *SoftwareRecipe_Step_CopyFile) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_CopyFile.Size(m)
}
func (m *SoftwareRecipe_Step_CopyFile) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_CopyFile.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_CopyFile proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_CopyFile) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

func (m *SoftwareRecipe_Step_CopyFile) GetDestination() string {
	if m != nil {
		return m.Destination
	}
	return ""
}

func (m *SoftwareRecipe_Step_CopyFile) GetOverwrite() bool {
	if m != nil {
		return m.Overwrite
	}
	return false
}

func (m *SoftwareRecipe_Step_CopyFile) GetPermissions() string {
	if m != nil {
		return m.Permissions
	}
	return ""
}

// Extracts an archive of the type specified in the specified directory.
type SoftwareRecipe_Step_ExtractArchive struct {
	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// Directory to extract archive to.
	// Defaults to `/` on Linux or `C:\` on Windows.
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// The type of the archive to extract.
	Type                 SoftwareRecipe_Step_ExtractArchive_ArchiveType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe_Step_ExtractArchive_ArchiveType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *SoftwareRecipe_Step_ExtractArchive) Reset()         { *m = SoftwareRecipe_Step_ExtractArchive{} }
func (m *SoftwareRecipe_Step_ExtractArchive) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_ExtractArchive) ProtoMessage()    {}
func (*SoftwareRecipe_Step_ExtractArchive) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 1}
}

func (m *SoftwareRecipe_Step_ExtractArchive) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_ExtractArchive) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_ExtractArchive) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.Merge(m, src)
}
func (m *SoftwareRecipe_Step_ExtractArchive) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.Size(m)
}
func (m *SoftwareRecipe_Step_ExtractArchive) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_ExtractArchive) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

func (m *SoftwareRecipe_Step_ExtractArchive) GetDestination() string {
	if m != nil {
		return m.Destination
	}
	return ""
}

func (m *SoftwareRecipe_Step_ExtractArchive) GetType() SoftwareRecipe_Step_ExtractArchive_ArchiveType {
	if m != nil {
		return m.Type
	}
	return SoftwareRecipe_Step_ExtractArchive_ARCHIVE_TYPE_UNSPECIFIED
}

// Installs an MSI file.
type SoftwareRecipe_Step_InstallMsi struct {
	// The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// The flags to use when installing the MSI
	// defaults to ["/i"] (i.e. the install flag).
	Flags []string `protobuf:"bytes,2,rep,name=flags,proto3" json:"flags,omitempty"`
	// Return codes that indicate that the software installed or updated
	// successfully. Behaviour defaults to [0]
	AllowedExitCodes     []int32  `protobuf:"varint,3,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_InstallMsi) Reset()         { *m = SoftwareRecipe_Step_InstallMsi{} }
func (m *SoftwareRecipe_Step_InstallMsi) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_InstallMsi) ProtoMessage()    {}
func (*SoftwareRecipe_Step_InstallMsi) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 2}
}

func (m *SoftwareRecipe_Step_InstallMsi) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_InstallMsi) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_InstallMsi) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.Merge(m, src)
}
func (m *SoftwareRecipe_Step_InstallMsi) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.Size(m)
}
func (m *SoftwareRecipe_Step_InstallMsi) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_InstallMsi proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_InstallMsi) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

func (m *SoftwareRecipe_Step_InstallMsi) GetFlags() []string {
	if m != nil {
		return m.Flags
	}
	return nil
}

func (m *SoftwareRecipe_Step_InstallMsi) GetAllowedExitCodes() []int32 {
	if m != nil {
		return m.AllowedExitCodes
	}
	return nil
}

// Installs a deb via dpkg.
type SoftwareRecipe_Step_InstallDpkg struct {
	// The id of the relevant artifact in the recipe.
	ArtifactId           string   `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_InstallDpkg) Reset()         { *m = SoftwareRecipe_Step_InstallDpkg{} }
func (m *SoftwareRecipe_Step_InstallDpkg) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_InstallDpkg) ProtoMessage()    {}
func (*SoftwareRecipe_Step_InstallDpkg) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 3}
}

func (m *SoftwareRecipe_Step_InstallDpkg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_InstallDpkg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_InstallDpkg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.Merge(m, src)
}
func (m *SoftwareRecipe_Step_InstallDpkg) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.Size(m)
}
func (m *SoftwareRecipe_Step_InstallDpkg) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_InstallDpkg) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

// Installs an rpm file via the rpm utility.
type SoftwareRecipe_Step_InstallRpm struct {
	// The id of the relevant artifact in the recipe.
	ArtifactId           string   `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_InstallRpm) Reset()         { *m = SoftwareRecipe_Step_InstallRpm{} }
func (m *SoftwareRecipe_Step_InstallRpm) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_InstallRpm) ProtoMessage()    {}
func (*SoftwareRecipe_Step_InstallRpm) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 4}
}

func (m *SoftwareRecipe_Step_InstallRpm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_InstallRpm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_InstallRpm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.Merge(m, src)
}
func (m *SoftwareRecipe_Step_InstallRpm) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.Size(m)
}
func (m *SoftwareRecipe_Step_InstallRpm) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_InstallRpm proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_InstallRpm) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

// Executes an artifact or local file.
type SoftwareRecipe_Step_ExecFile struct {
	// Location of the file to execute.
	//
	// Types that are valid to be assigned to LocationType:
	//	*SoftwareRecipe_Step_ExecFile_ArtifactId
	//	*SoftwareRecipe_Step_ExecFile_LocalPath
	LocationType isSoftwareRecipe_Step_ExecFile_LocationType `protobuf_oneof:"location_type"`
	// Arguments to be passed to the provided executable.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Defaults to [0]. A list of possible return values that the program
	// can return to indicate a success.
	AllowedExitCodes     []int32  `protobuf:"varint,4,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_ExecFile) Reset()         { *m = SoftwareRecipe_Step_ExecFile{} }
func (m *SoftwareRecipe_Step_ExecFile) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_ExecFile) ProtoMessage()    {}
func (*SoftwareRecipe_Step_ExecFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 5}
}

func (m *SoftwareRecipe_Step_ExecFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_ExecFile.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_ExecFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_ExecFile.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_ExecFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_ExecFile.Merge(m, src)
}
func (m *SoftwareRecipe_Step_ExecFile) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_ExecFile.Size(m)
}
func (m *SoftwareRecipe_Step_ExecFile) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_ExecFile.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_ExecFile proto.InternalMessageInfo

type isSoftwareRecipe_Step_ExecFile_LocationType interface {
	isSoftwareRecipe_Step_ExecFile_LocationType()
}

type SoftwareRecipe_Step_ExecFile_ArtifactId struct {
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3,oneof"`
}

type SoftwareRecipe_Step_ExecFile_LocalPath struct {
	LocalPath string `protobuf:"bytes,2,opt,name=local_path,json=localPath,proto3,oneof"`
}

func (*SoftwareRecipe_Step_ExecFile_ArtifactId) isSoftwareRecipe_Step_ExecFile_LocationType() {}

func (*SoftwareRecipe_Step_ExecFile_LocalPath) isSoftwareRecipe_Step_ExecFile_LocationType() {}

func (m *SoftwareRecipe_Step_ExecFile) GetLocationType() isSoftwareRecipe_Step_ExecFile_LocationType {
	if m != nil {
		return m.LocationType
	}
	return nil
}

func (m *SoftwareRecipe_Step_ExecFile) GetArtifactId() string {
	if x, ok := m.GetLocationType().(*SoftwareRecipe_Step_ExecFile_ArtifactId); ok {
		return x.ArtifactId
	}
	return ""
}

func (m *SoftwareRecipe_Step_ExecFile) GetLocalPath() string {
	if x, ok := m.GetLocationType().(*SoftwareRecipe_Step_ExecFile_LocalPath); ok {
		return x.LocalPath
	}
	return ""
}

func (m *SoftwareRecipe_Step_ExecFile) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *SoftwareRecipe_Step_ExecFile) GetAllowedExitCodes() []int32 {
	if m != nil {
		return m.AllowedExitCodes
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SoftwareRecipe_Step_ExecFile) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SoftwareRecipe_Step_ExecFile_ArtifactId)(nil),
		(*SoftwareRecipe_Step_ExecFile_LocalPath)(nil),
	}
}

// Runs a script through an interpreter.
type SoftwareRecipe_Step_RunScript struct {
	// The shell script to be executed.
	Script string `protobuf:"bytes,1,opt,name=script,proto3" json:"script,omitempty"`
	// Return codes that indicate that the software installed or updated
	// successfully. Behaviour defaults to [0]
	AllowedExitCodes []int32 `protobuf:"varint,2,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
	// The script interpreter to use to run the script. If no interpreter is
	// specified the script is executed directly, which likely
	// only succeed for scripts with
	// [shebang lines](https://en.wikipedia.org/wiki/Shebang_(Unix)).
	Interpreter          SoftwareRecipe_Step_RunScript_Interpreter `protobuf:"varint,3,opt,name=interpreter,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe_Step_RunScript_Interpreter" json:"interpreter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *SoftwareRecipe_Step_RunScript) Reset()         { *m = SoftwareRecipe_Step_RunScript{} }
func (m *SoftwareRecipe_Step_RunScript) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_RunScript) ProtoMessage()    {}
func (*SoftwareRecipe_Step_RunScript) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{6, 1, 6}
}

func (m *SoftwareRecipe_Step_RunScript) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_RunScript.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_RunScript) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_RunScript.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_RunScript) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_RunScript.Merge(m, src)
}
func (m *SoftwareRecipe_Step_RunScript) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_RunScript.Size(m)
}
func (m *SoftwareRecipe_Step_RunScript) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_RunScript.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_RunScript proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_RunScript) GetScript() string {
	if m != nil {
		return m.Script
	}
	return ""
}

func (m *SoftwareRecipe_Step_RunScript) GetAllowedExitCodes() []int32 {
	if m != nil {
		return m.AllowedExitCodes
	}
	return nil
}

func (m *SoftwareRecipe_Step_RunScript) GetInterpreter() SoftwareRecipe_Step_RunScript_Interpreter {
	if m != nil {
		return m.Interpreter
	}
	return SoftwareRecipe_Step_RunScript_INTERPRETER_UNSPECIFIED
}

// A request message for getting effective policy assigned to the instance.
type LookupEffectiveGuestPolicyRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Short name of the OS running on the instance. The OS Config agent only
	// provideS this field for targeting if OS Inventory is enabled for that
	// instance.
	OsShortName string `protobuf:"bytes,2,opt,name=os_short_name,json=osShortName,proto3" json:"os_short_name,omitempty"`
	// Version of the OS running on the instance. The OS Config agent only
	// provide this field for targeting if OS Inventory is enabled for that
	// VM instance.
	OsVersion string `protobuf:"bytes,3,opt,name=os_version,json=osVersion,proto3" json:"os_version,omitempty"`
	// Architecture of OS running on the instance. The OS Config agent only
	// provide this field for targeting if OS Inventory is enabled for that
	// instance.
	OsArchitecture       string   `protobuf:"bytes,4,opt,name=os_architecture,json=osArchitecture,proto3" json:"os_architecture,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LookupEffectiveGuestPolicyRequest) Reset()         { *m = LookupEffectiveGuestPolicyRequest{} }
func (m *LookupEffectiveGuestPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*LookupEffectiveGuestPolicyRequest) ProtoMessage()    {}
func (*LookupEffectiveGuestPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{7}
}

func (m *LookupEffectiveGuestPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupEffectiveGuestPolicyRequest.Unmarshal(m, b)
}
func (m *LookupEffectiveGuestPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupEffectiveGuestPolicyRequest.Marshal(b, m, deterministic)
}
func (m *LookupEffectiveGuestPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupEffectiveGuestPolicyRequest.Merge(m, src)
}
func (m *LookupEffectiveGuestPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_LookupEffectiveGuestPolicyRequest.Size(m)
}
func (m *LookupEffectiveGuestPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupEffectiveGuestPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LookupEffectiveGuestPolicyRequest proto.InternalMessageInfo

func (m *LookupEffectiveGuestPolicyRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *LookupEffectiveGuestPolicyRequest) GetOsShortName() string {
	if m != nil {
		return m.OsShortName
	}
	return ""
}

func (m *LookupEffectiveGuestPolicyRequest) GetOsVersion() string {
	if m != nil {
		return m.OsVersion
	}
	return ""
}

func (m *LookupEffectiveGuestPolicyRequest) GetOsArchitecture() string {
	if m != nil {
		return m.OsArchitecture
	}
	return ""
}

// The effective guest policy assigned to the instance.
type EffectiveGuestPolicy struct {
	// List of package configurations assigned to the VM instance.
	Packages []*EffectiveGuestPolicy_SourcedPackage `protobuf:"bytes,1,rep,name=packages,proto3" json:"packages,omitempty"`
	// List of package repository configurations assigned to the VM instance.
	PackageRepositories []*EffectiveGuestPolicy_SourcedPackageRepository `protobuf:"bytes,2,rep,name=package_repositories,json=packageRepositories,proto3" json:"package_repositories,omitempty"`
	// List of recipes assigned to the VM instance.
	SoftwareRecipes      []*EffectiveGuestPolicy_SourcedSoftwareRecipe `protobuf:"bytes,3,rep,name=software_recipes,json=softwareRecipes,proto3" json:"software_recipes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *EffectiveGuestPolicy) Reset()         { *m = EffectiveGuestPolicy{} }
func (m *EffectiveGuestPolicy) String() string { return proto.CompactTextString(m) }
func (*EffectiveGuestPolicy) ProtoMessage()    {}
func (*EffectiveGuestPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{8}
}

func (m *EffectiveGuestPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EffectiveGuestPolicy.Unmarshal(m, b)
}
func (m *EffectiveGuestPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EffectiveGuestPolicy.Marshal(b, m, deterministic)
}
func (m *EffectiveGuestPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveGuestPolicy.Merge(m, src)
}
func (m *EffectiveGuestPolicy) XXX_Size() int {
	return xxx_messageInfo_EffectiveGuestPolicy.Size(m)
}
func (m *EffectiveGuestPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveGuestPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveGuestPolicy proto.InternalMessageInfo

func (m *EffectiveGuestPolicy) GetPackages() []*EffectiveGuestPolicy_SourcedPackage {
	if m != nil {
		return m.Packages
	}
	return nil
}

func (m *EffectiveGuestPolicy) GetPackageRepositories() []*EffectiveGuestPolicy_SourcedPackageRepository {
	if m != nil {
		return m.PackageRepositories
	}
	return nil
}

func (m *EffectiveGuestPolicy) GetSoftwareRecipes() []*EffectiveGuestPolicy_SourcedSoftwareRecipe {
	if m != nil {
		return m.SoftwareRecipes
	}
	return nil
}

// A guest policy package including its source.
type EffectiveGuestPolicy_SourcedPackage struct {
	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software package to configure on the VM instance.
	Package              *Package `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EffectiveGuestPolicy_SourcedPackage) Reset()         { *m = EffectiveGuestPolicy_SourcedPackage{} }
func (m *EffectiveGuestPolicy_SourcedPackage) String() string { return proto.CompactTextString(m) }
func (*EffectiveGuestPolicy_SourcedPackage) ProtoMessage()    {}
func (*EffectiveGuestPolicy_SourcedPackage) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{8, 0}
}

func (m *EffectiveGuestPolicy_SourcedPackage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.Unmarshal(m, b)
}
func (m *EffectiveGuestPolicy_SourcedPackage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.Marshal(b, m, deterministic)
}
func (m *EffectiveGuestPolicy_SourcedPackage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.Merge(m, src)
}
func (m *EffectiveGuestPolicy_SourcedPackage) XXX_Size() int {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.Size(m)
}
func (m *EffectiveGuestPolicy_SourcedPackage) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage proto.InternalMessageInfo

func (m *EffectiveGuestPolicy_SourcedPackage) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *EffectiveGuestPolicy_SourcedPackage) GetPackage() *Package {
	if m != nil {
		return m.Package
	}
	return nil
}

// A guest policy package repository including its source.
type EffectiveGuestPolicy_SourcedPackageRepository struct {
	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software package repository to configure on the VM instance.
	PackageRepository    *PackageRepository `protobuf:"bytes,2,opt,name=package_repository,json=packageRepository,proto3" json:"package_repository,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *EffectiveGuestPolicy_SourcedPackageRepository) Reset() {
	*m = EffectiveGuestPolicy_SourcedPackageRepository{}
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) String() string {
	return proto.CompactTextString(m)
}
func (*EffectiveGuestPolicy_SourcedPackageRepository) ProtoMessage() {}
func (*EffectiveGuestPolicy_SourcedPackageRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{8, 1}
}

func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.Unmarshal(m, b)
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.Marshal(b, m, deterministic)
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.Merge(m, src)
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_Size() int {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.Size(m)
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository proto.InternalMessageInfo

func (m *EffectiveGuestPolicy_SourcedPackageRepository) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *EffectiveGuestPolicy_SourcedPackageRepository) GetPackageRepository() *PackageRepository {
	if m != nil {
		return m.PackageRepository
	}
	return nil
}

// A guest policy recipe including its source.
type EffectiveGuestPolicy_SourcedSoftwareRecipe struct {
	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software recipe to configure on the VM instance.
	SoftwareRecipe       *SoftwareRecipe `protobuf:"bytes,2,opt,name=software_recipe,json=softwareRecipe,proto3" json:"software_recipe,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) Reset() {
	*m = EffectiveGuestPolicy_SourcedSoftwareRecipe{}
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) String() string {
	return proto.CompactTextString(m)
}
func (*EffectiveGuestPolicy_SourcedSoftwareRecipe) ProtoMessage() {}
func (*EffectiveGuestPolicy_SourcedSoftwareRecipe) Descriptor() ([]byte, []int) {
	return fileDescriptor_d002ec6df1d698a6, []int{8, 2}
}

func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.Unmarshal(m, b)
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.Marshal(b, m, deterministic)
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.Merge(m, src)
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_Size() int {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.Size(m)
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe proto.InternalMessageInfo

func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) GetSoftwareRecipe() *SoftwareRecipe {
	if m != nil {
		return m.SoftwareRecipe
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1beta.DesiredState", DesiredState_name, DesiredState_value)
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1beta.Package_Manager", Package_Manager_name, Package_Manager_value)
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1beta.AptRepository_ArchiveType", AptRepository_ArchiveType_name, AptRepository_ArchiveType_value)
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe_Step_ExtractArchive_ArchiveType", SoftwareRecipe_Step_ExtractArchive_ArchiveType_name, SoftwareRecipe_Step_ExtractArchive_ArchiveType_value)
	proto.RegisterEnum("google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe_Step_RunScript_Interpreter", SoftwareRecipe_Step_RunScript_Interpreter_name, SoftwareRecipe_Step_RunScript_Interpreter_value)
	proto.RegisterType((*Package)(nil), "google.cloud.osconfig.agentendpoint.v1beta.Package")
	proto.RegisterType((*AptRepository)(nil), "google.cloud.osconfig.agentendpoint.v1beta.AptRepository")
	proto.RegisterType((*YumRepository)(nil), "google.cloud.osconfig.agentendpoint.v1beta.YumRepository")
	proto.RegisterType((*ZypperRepository)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ZypperRepository")
	proto.RegisterType((*GooRepository)(nil), "google.cloud.osconfig.agentendpoint.v1beta.GooRepository")
	proto.RegisterType((*PackageRepository)(nil), "google.cloud.osconfig.agentendpoint.v1beta.PackageRepository")
	proto.RegisterType((*SoftwareRecipe)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe")
	proto.RegisterType((*SoftwareRecipe_Artifact)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact")
	proto.RegisterType((*SoftwareRecipe_Artifact_Remote)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact.Remote")
	proto.RegisterType((*SoftwareRecipe_Artifact_Gcs)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Artifact.Gcs")
	proto.RegisterType((*SoftwareRecipe_Step)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step")
	proto.RegisterType((*SoftwareRecipe_Step_CopyFile)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.CopyFile")
	proto.RegisterType((*SoftwareRecipe_Step_ExtractArchive)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExtractArchive")
	proto.RegisterType((*SoftwareRecipe_Step_InstallMsi)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallMsi")
	proto.RegisterType((*SoftwareRecipe_Step_InstallDpkg)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallDpkg")
	proto.RegisterType((*SoftwareRecipe_Step_InstallRpm)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.InstallRpm")
	proto.RegisterType((*SoftwareRecipe_Step_ExecFile)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.ExecFile")
	proto.RegisterType((*SoftwareRecipe_Step_RunScript)(nil), "google.cloud.osconfig.agentendpoint.v1beta.SoftwareRecipe.Step.RunScript")
	proto.RegisterType((*LookupEffectiveGuestPolicyRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.LookupEffectiveGuestPolicyRequest")
	proto.RegisterType((*EffectiveGuestPolicy)(nil), "google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy")
	proto.RegisterType((*EffectiveGuestPolicy_SourcedPackage)(nil), "google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedPackage")
	proto.RegisterType((*EffectiveGuestPolicy_SourcedPackageRepository)(nil), "google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedPackageRepository")
	proto.RegisterType((*EffectiveGuestPolicy_SourcedSoftwareRecipe)(nil), "google.cloud.osconfig.agentendpoint.v1beta.EffectiveGuestPolicy.SourcedSoftwareRecipe")
}

func init() {
	proto.RegisterFile("google/cloud/osconfig/agentendpoint/v1beta/guest_policies.proto", fileDescriptor_d002ec6df1d698a6)
}

var fileDescriptor_d002ec6df1d698a6 = []byte{
	// 1795 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0x4b, 0x6f, 0x2b, 0x49,
	0x15, 0x8e, 0x1f, 0xf1, 0xe3, 0x38, 0x76, 0x3a, 0x35, 0x77, 0xb8, 0x1e, 0x33, 0xc3, 0xcd, 0xb5,
	0x84, 0xb8, 0x1a, 0x81, 0x2d, 0x3c, 0x02, 0x01, 0x03, 0x1a, 0xd9, 0x71, 0x4f, 0x6c, 0x26, 0x0f,
	0xab, 0xec, 0x64, 0x48, 0x10, 0x6a, 0x75, 0xba, 0x2b, 0x9d, 0x1a, 0xb7, 0xbb, 0x7a, 0xba, 0xca,
	0x49, 0x3c, 0x2c, 0x10, 0x7b, 0x90, 0x40, 0x62, 0xc1, 0x0e, 0x58, 0xb1, 0xe0, 0x0f, 0xb0, 0x64,
	0xcb, 0xbf, 0x60, 0xc5, 0xdf, 0x00, 0x55, 0x75, 0xb7, 0xed, 0xce, 0x43, 0xf7, 0xfa, 0xc6, 0xd2,
	0xec, 0xfa, 0x9c, 0xee, 0xfa, 0xbe, 0x53, 0xe7, 0x51, 0xa7, 0x4e, 0xc3, 0x27, 0x0e, 0x63, 0x8e,
	0x4b, 0x9a, 0x96, 0xcb, 0xa6, 0x76, 0x93, 0x71, 0x8b, 0x79, 0x97, 0xd4, 0x69, 0x9a, 0x0e, 0xf1,
	0x04, 0xf1, 0x6c, 0x9f, 0x51, 0x4f, 0x34, 0xaf, 0xbf, 0x7f, 0x41, 0x84, 0xd9, 0x74, 0xa6, 0x84,
	0x0b, 0xc3, 0x67, 0x2e, 0xb5, 0x28, 0xe1, 0x0d, 0x3f, 0x60, 0x82, 0xa1, 0x0f, 0x43, 0x80, 0x86,
	0x02, 0x68, 0xc4, 0x00, 0x8d, 0x04, 0x40, 0x23, 0x04, 0xa8, 0xbd, 0x88, 0xc8, 0x4c, 0x9f, 0x36,
	0x2f, 0x29, 0x71, 0x6d, 0xe3, 0x82, 0x5c, 0x99, 0xd7, 0x94, 0x05, 0x21, 0x58, 0xfd, 0xef, 0x69,
	0xc8, 0x0f, 0x4c, 0x6b, 0x6c, 0x3a, 0x04, 0x21, 0xc8, 0x7a, 0xe6, 0x84, 0x54, 0x53, 0xbb, 0xa9,
	0x57, 0x45, 0xac, 0x9e, 0xd1, 0xaf, 0xa0, 0x6c, 0x13, 0x4e, 0x03, 0x62, 0x1b, 0x5c, 0x98, 0x82,
	0x54, 0xd3, 0xbb, 0xa9, 0x57, 0x95, 0xd6, 0x8f, 0x1a, 0x6f, 0x6e, 0x44, 0xa3, 0x1b, 0x02, 0x0c,
	0xe5, 0x7a, 0xbc, 0x65, 0x2f, 0x49, 0xe8, 0x04, 0xf2, 0x13, 0xd3, 0x33, 0x1d, 0x12, 0x54, 0x33,
	0x0a, 0xf8, 0xe3, 0x55, 0x80, 0x23, 0xc3, 0x1b, 0x87, 0x21, 0x04, 0x8e, 0xb1, 0xea, 0x18, 0xf2,
	0x91, 0x0e, 0x3d, 0x87, 0x77, 0x0e, 0xdb, 0x47, 0xed, 0x7d, 0x1d, 0x1b, 0x27, 0x47, 0xc3, 0x81,
	0xbe, 0xd7, 0xff, 0xb4, 0xaf, 0x77, 0xb5, 0x0d, 0x94, 0x87, 0x4c, 0xfb, 0xe8, 0x4c, 0x4b, 0xa9,
	0x87, 0xc1, 0x48, 0x4b, 0xcb, 0x87, 0xb3, 0x93, 0x43, 0x2d, 0x83, 0x00, 0x72, 0xe7, 0x67, 0x83,
	0x81, 0x8e, 0xb5, 0xac, 0x54, 0xee, 0x1f, 0x1f, 0x6b, 0x9b, 0xf5, 0x7f, 0xa4, 0xa1, 0xdc, 0xf6,
	0x05, 0x26, 0x3e, 0xe3, 0x54, 0xb0, 0x60, 0x86, 0xae, 0x60, 0xcb, 0x0c, 0xac, 0x2b, 0x7a, 0x4d,
	0x0c, 0x31, 0xf3, 0x43, 0xbf, 0x55, 0x5a, 0xfa, 0x2a, 0x3b, 0x48, 0x00, 0x36, 0xda, 0x21, 0xda,
	0x68, 0xe6, 0x13, 0x5c, 0x32, 0x17, 0x02, 0xd2, 0x20, 0x33, 0x0d, 0xa8, 0xf2, 0x7d, 0x11, 0xcb,
	0x47, 0x54, 0x87, 0x2d, 0x9b, 0x72, 0x11, 0xd0, 0x8b, 0xa9, 0xa0, 0xcc, 0x53, 0xde, 0x2b, 0xe2,
	0x84, 0x0e, 0x7d, 0x0b, 0xc0, 0x62, 0x13, 0x9f, 0x79, 0xc4, 0x13, 0xbc, 0x9a, 0xdd, 0xcd, 0xbc,
	0x2a, 0xe2, 0x25, 0x0d, 0x7a, 0x0e, 0x79, 0xc7, 0x77, 0x8c, 0x31, 0x99, 0x55, 0x37, 0xd5, 0xf2,
	0x9c, 0xe3, 0x3b, 0x9f, 0x91, 0x59, 0xbd, 0x0d, 0xa5, 0x25, 0x53, 0xd0, 0xfb, 0x50, 0x6d, 0xe3,
	0xbd, 0x5e, 0xff, 0x54, 0x37, 0x46, 0x67, 0x03, 0xfd, 0xbe, 0x1f, 0xbb, 0x7a, 0x47, 0x4b, 0xa1,
	0x12, 0xe4, 0xbb, 0x7a, 0xc7, 0x18, 0xe2, 0x3d, 0x2d, 0x5d, 0xbf, 0x85, 0xf2, 0xd9, 0x74, 0xb2,
	0xe4, 0xac, 0x0a, 0xa4, 0xa9, 0x1d, 0xa5, 0x56, 0x9a, 0xda, 0xe8, 0xa5, 0xda, 0x80, 0xef, 0x9a,
	0x33, 0x43, 0x25, 0x5d, 0xb8, 0xb7, 0x52, 0xa4, 0x3b, 0x92, 0xb9, 0xf7, 0x1e, 0x14, 0x2e, 0x4c,
	0x4e, 0x8c, 0x69, 0xe0, 0x46, 0xfb, 0xcb, 0x4b, 0xf9, 0x24, 0x70, 0xe5, 0xab, 0xc8, 0xf4, 0x78,
	0x63, 0xf9, 0xd0, 0x76, 0x5e, 0xff, 0x35, 0x68, 0xe7, 0x33, 0xdf, 0x27, 0xc1, 0xd7, 0x41, 0xfe,
	0x03, 0x28, 0xef, 0x33, 0xb6, 0xc4, 0xfc, 0x50, 0x4d, 0xa9, 0x68, 0xba, 0x8b, 0x68, 0xba, 0xf5,
	0xff, 0xa6, 0x61, 0x27, 0x4a, 0xe6, 0xa5, 0xb5, 0x87, 0x90, 0x31, 0x7d, 0xa1, 0x96, 0x96, 0x5a,
	0x3f, 0x7e, 0xeb, 0xb4, 0xea, 0x6d, 0x60, 0x89, 0x23, 0xe1, 0x66, 0xd3, 0x89, 0xa2, 0x5d, 0x11,
	0x2e, 0x11, 0x49, 0x09, 0x37, 0x9b, 0x4e, 0xd0, 0x29, 0xe4, 0xbe, 0x52, 0x7e, 0x56, 0xee, 0x29,
	0xb5, 0x7e, 0xba, 0x0a, 0xe2, 0xdd, 0x08, 0xf5, 0x36, 0x70, 0x84, 0x26, 0xcd, 0x74, 0x18, 0xab,
	0x66, 0x57, 0x37, 0x33, 0xe1, 0x79, 0x69, 0xa6, 0xc3, 0x58, 0x67, 0x0b, 0x20, 0x98, 0x2b, 0xeb,
	0xff, 0x7b, 0x17, 0x2a, 0x43, 0x76, 0x29, 0x6e, 0xcc, 0x80, 0x60, 0x62, 0x51, 0xff, 0xe1, 0x53,
	0xaf, 0x0a, 0xf9, 0x6b, 0x12, 0x70, 0x59, 0x58, 0x61, 0x94, 0x62, 0x11, 0x99, 0x50, 0x34, 0x03,
	0x41, 0x2f, 0x4d, 0x4b, 0xf0, 0x6a, 0x66, 0x37, 0xf3, 0xaa, 0xd4, 0xda, 0x5b, 0xc5, 0xc6, 0x24,
	0x79, 0xa3, 0x1d, 0x61, 0xe1, 0x05, 0x2a, 0xb2, 0xa1, 0x4c, 0x3d, 0x2e, 0x4c, 0xd7, 0x35, 0xb8,
	0x20, 0x7e, 0x98, 0x63, 0xa5, 0xd6, 0x27, 0x4f, 0xa0, 0x19, 0x0a, 0xe2, 0xe3, 0xad, 0x08, 0x55,
	0x0a, 0x1c, 0x5d, 0xc0, 0xd6, 0xd4, 0xb7, 0x4d, 0x41, 0x22, 0x92, 0xcd, 0xf5, 0x90, 0x94, 0x42,
	0xd0, 0x90, 0xe3, 0x5e, 0xf3, 0xc8, 0xad, 0xb3, 0x79, 0xd4, 0xfe, 0x92, 0x81, 0x42, 0xec, 0xc0,
	0x7b, 0x25, 0x6e, 0x43, 0x2e, 0x20, 0x13, 0x16, 0x75, 0xac, 0x52, 0xeb, 0xe7, 0x6b, 0x88, 0x52,
	0x03, 0x2b, 0x44, 0x99, 0xac, 0x21, 0x36, 0xfa, 0x25, 0x64, 0x1c, 0x8b, 0x47, 0x15, 0xb0, 0xbf,
	0x0e, 0x8a, 0x7d, 0x8b, 0xab, 0xd4, 0xb5, 0x38, 0xfa, 0x36, 0x54, 0x4c, 0xd7, 0x65, 0x37, 0x06,
	0xf5, 0x38, 0xb1, 0xa6, 0x01, 0x51, 0x45, 0x51, 0xc0, 0x65, 0xa5, 0xed, 0x47, 0xca, 0xda, 0x0f,
	0x21, 0x17, 0xda, 0x15, 0xb7, 0x89, 0xd4, 0xa2, 0x4d, 0xd4, 0xa0, 0x60, 0x5d, 0x11, 0x6b, 0xcc,
	0xa3, 0xc2, 0x2f, 0xe2, 0xb9, 0x5c, 0x3b, 0x81, 0xcc, 0xbe, 0xc5, 0xd1, 0x37, 0x20, 0x77, 0x31,
	0xb5, 0xc6, 0x44, 0x44, 0xeb, 0x22, 0x49, 0xea, 0xd9, 0xc5, 0x17, 0xc4, 0x12, 0xd1, 0xc2, 0x48,
	0x92, 0x5d, 0xc5, 0x21, 0x1e, 0x09, 0xcc, 0x79, 0xdf, 0xc9, 0xe0, 0x25, 0x4d, 0x07, 0xa0, 0x10,
	0xe7, 0x72, 0xed, 0x0f, 0xdb, 0x90, 0x95, 0xa9, 0x80, 0x1c, 0x28, 0x5e, 0x52, 0x97, 0x18, 0x16,
	0xf3, 0x67, 0xd1, 0x81, 0xd6, 0x7b, 0x62, 0xaa, 0x35, 0xf6, 0x98, 0x3f, 0xfb, 0x94, 0xba, 0x32,
	0x1c, 0x05, 0x09, 0x2e, 0x65, 0xf4, 0x1b, 0x40, 0x71, 0x4f, 0x26, 0xb7, 0x22, 0x30, 0x2d, 0x11,
	0x17, 0x71, 0xa9, 0x75, 0xf4, 0x54, 0x46, 0x3d, 0x44, 0x8c, 0x7a, 0x63, 0x6f, 0x03, 0xef, 0x44,
	0x5c, 0xfa, 0x9c, 0x0a, 0xdd, 0x80, 0x36, 0xe1, 0xd4, 0x88, 0x6a, 0x6d, 0xe1, 0xa4, 0xa7, 0x65,
	0xa0, 0xa2, 0xef, 0x87, 0x98, 0x87, 0x9c, 0xf6, 0x36, 0xf0, 0xf6, 0x84, 0xd3, 0xfe, 0x12, 0x09,
	0xfa, 0x0a, 0x76, 0x6c, 0x7f, 0xec, 0x24, 0x99, 0xc3, 0x53, 0xf4, 0xb3, 0x35, 0x31, 0x77, 0xfd,
	0xb1, 0xd3, 0xdb, 0xc0, 0x9a, 0xe4, 0x49, 0x70, 0xdf, 0x80, 0x16, 0xf8, 0x93, 0x24, 0xf5, 0xe6,
	0x5a, 0x37, 0x8d, 0xfd, 0x89, 0xdc, 0x74, 0xe0, 0x4f, 0x12, 0xc4, 0x71, 0x5e, 0x91, 0x5b, 0x62,
	0xa9, 0xd3, 0x65, 0x0d, 0x79, 0xa5, 0xdf, 0x12, 0x6b, 0x39, 0xaf, 0xa4, 0x8c, 0xbe, 0x00, 0xe0,
	0x56, 0x40, 0x7d, 0x61, 0x04, 0x53, 0xaf, 0x9a, 0x57, 0x4c, 0xfd, 0xa7, 0x32, 0xe1, 0xa9, 0x37,
	0x54, 0xa0, 0xbd, 0x0d, 0x5c, 0x0c, 0xe1, 0xf1, 0xd4, 0xab, 0xfd, 0x3e, 0x05, 0x85, 0x38, 0xb9,
	0xd1, 0x0b, 0x28, 0xc5, 0xe5, 0x64, 0xcc, 0x0f, 0x38, 0x88, 0x55, 0x7d, 0x1b, 0xed, 0x42, 0xc9,
	0x26, 0x5c, 0x50, 0xcf, 0x14, 0x8b, 0x7e, 0xb5, 0xac, 0x42, 0xef, 0x43, 0x91, 0x5d, 0x93, 0xe0,
	0x26, 0xa0, 0x82, 0xa8, 0x5c, 0x2c, 0xe0, 0x85, 0x42, 0xae, 0xf7, 0x49, 0x30, 0xa1, 0x5c, 0xf6,
	0x37, 0xae, 0x32, 0xa6, 0x88, 0x97, 0x55, 0xb5, 0x7f, 0xa6, 0xa1, 0x92, 0x4c, 0xfd, 0x75, 0x58,
	0xe5, 0x41, 0x56, 0xdd, 0x9a, 0xc3, 0x7b, 0xff, 0xf9, 0x7a, 0x6b, 0x33, 0x71, 0x95, 0x56, 0x3c,
	0x75, 0xbe, 0xe2, 0xa5, 0x76, 0xd4, 0xc6, 0x5a, 0x0a, 0x6d, 0x41, 0x61, 0xd4, 0xc6, 0xc6, 0xfe,
	0x79, 0x7f, 0xa0, 0xa5, 0x63, 0xa9, 0x23, 0xa5, 0x4c, 0x2c, 0x1d, 0x9c, 0x1f, 0xb6, 0xb5, 0xac,
	0x1c, 0x1a, 0xa4, 0xf4, 0x8b, 0x73, 0x6d, 0x53, 0x2e, 0x97, 0x9f, 0x94, 0x6a, 0x5f, 0x02, 0x2c,
	0xaa, 0xf6, 0xf5, 0x5e, 0x7b, 0x06, 0x9b, 0x97, 0xae, 0xe9, 0xf0, 0x6a, 0x5a, 0x5d, 0x2b, 0x43,
	0x01, 0x7d, 0x17, 0x90, 0x3a, 0xf1, 0x89, 0x6d, 0x90, 0x5b, 0x2a, 0x0c, 0x8b, 0xd9, 0x24, 0xbc,
	0x7c, 0x6c, 0x62, 0x2d, 0x7a, 0xa3, 0xdf, 0x52, 0xb1, 0x27, 0xf5, 0xb5, 0x06, 0x94, 0x96, 0xca,
	0xf5, 0xb5, 0x9c, 0xb5, 0xef, 0xcd, 0x4d, 0xc4, 0xfe, 0xe4, 0xf5, 0x9f, 0xff, 0x2d, 0x05, 0x85,
	0xb8, 0x42, 0xd0, 0xcb, 0x07, 0xbe, 0xee, 0x6d, 0x24, 0xb6, 0xf4, 0x02, 0xc0, 0x65, 0x96, 0xe9,
	0x1a, 0xbe, 0x29, 0xae, 0xc2, 0x3c, 0x90, 0xd9, 0xae, 0x74, 0x03, 0x53, 0x5c, 0xc9, 0xfb, 0x97,
	0x19, 0x38, 0xe1, 0x7e, 0x8a, 0x58, 0x3d, 0x3f, 0xb2, 0xe3, 0xec, 0xc3, 0x3b, 0xee, 0x6c, 0x43,
	0x59, 0xc2, 0xc9, 0xac, 0x52, 0x83, 0x58, 0xed, 0x8f, 0x69, 0x28, 0xce, 0x6b, 0x4b, 0x36, 0xb2,
	0xb0, 0xb6, 0xe2, 0x06, 0x17, 0x4a, 0x8f, 0x90, 0xa4, 0x1f, 0x26, 0x41, 0x37, 0x50, 0xa2, 0x9e,
	0x20, 0x81, 0x1f, 0x10, 0x31, 0x9f, 0x56, 0x4f, 0xd6, 0x76, 0x02, 0x34, 0xfa, 0x0b, 0x70, 0xbc,
	0xcc, 0x54, 0xd7, 0x65, 0x3c, 0xe7, 0x22, 0xfa, 0x26, 0x3c, 0xef, 0x1f, 0x8d, 0x74, 0x3c, 0xc0,
	0xfa, 0xe8, 0xde, 0x4c, 0x5b, 0x84, 0xcd, 0x61, 0x4f, 0x3f, 0x38, 0xd0, 0x52, 0xa8, 0x02, 0x30,
	0x38, 0xfe, 0x5c, 0xc7, 0xa1, 0x9c, 0xe9, 0xe4, 0x20, 0x2b, 0x2f, 0x7a, 0xf5, 0x7f, 0xa5, 0xe0,
	0xe5, 0x01, 0x63, 0xe3, 0xa9, 0xaf, 0x5f, 0x5e, 0x12, 0x4b, 0xd0, 0x6b, 0xb2, 0x3f, 0x25, 0x5c,
	0x0c, 0x98, 0x4b, 0xad, 0x19, 0x26, 0x5f, 0x4a, 0x01, 0x35, 0x61, 0x47, 0x1d, 0xe6, 0x9e, 0x45,
	0x0c, 0x6a, 0x1b, 0x82, 0x8d, 0x89, 0x17, 0xba, 0xaf, 0x93, 0xf9, 0x4f, 0x3b, 0x8d, 0xb7, 0xe3,
	0xb7, 0x7d, 0x7b, 0x24, 0xdf, 0xa1, 0x3a, 0x94, 0x19, 0x37, 0xf8, 0x15, 0x0b, 0x44, 0x62, 0xa4,
	0x62, 0x7c, 0x28, 0x75, 0x6a, 0xa4, 0xfa, 0x00, 0x80, 0x71, 0x23, 0xbe, 0x58, 0x87, 0x43, 0x55,
	0x91, 0xf1, 0xd3, 0xe8, 0x6a, 0xfd, 0x1d, 0xd8, 0x66, 0xdc, 0x50, 0x1d, 0x55, 0x10, 0x4b, 0xc4,
	0xf7, 0x9d, 0x22, 0xae, 0x30, 0xde, 0x5e, 0xd2, 0xd6, 0xff, 0x9d, 0x83, 0x67, 0x0f, 0x19, 0x8f,
	0xc6, 0x50, 0xf0, 0xc3, 0x29, 0x8a, 0x57, 0x53, 0xea, 0x3e, 0x7b, 0xbc, 0x4a, 0x80, 0x1e, 0xc2,
	0x6c, 0x0c, 0xd9, 0x34, 0xb0, 0x88, 0x1d, 0x4f, 0x67, 0x73, 0x02, 0xf4, 0xbb, 0x14, 0x3c, 0x8b,
	0x04, 0x63, 0x3e, 0x61, 0xd0, 0x28, 0x83, 0x4a, 0xad, 0xb3, 0x75, 0x33, 0xcf, 0x87, 0x18, 0xfc,
	0x8e, 0x7f, 0x47, 0x45, 0x09, 0x47, 0xbf, 0x4d, 0x81, 0xc6, 0xa3, 0x0c, 0x33, 0x02, 0x95, 0x62,
	0xf1, 0x80, 0x72, 0xba, 0x2e, 0x53, 0x92, 0x19, 0x8c, 0xb7, 0x79, 0x42, 0xe6, 0xb5, 0x1b, 0x39,
	0x5c, 0x2d, 0x1b, 0xad, 0x6a, 0x4f, 0x69, 0xe6, 0xb5, 0xa7, 0x24, 0x74, 0x08, 0xf9, 0x68, 0x13,
	0xd1, 0xdd, 0xec, 0xa3, 0xb7, 0xf8, 0xef, 0x83, 0x63, 0x8c, 0xda, 0x5f, 0x53, 0x50, 0x7d, 0xcc,
	0x5d, 0x8f, 0xda, 0xe0, 0x02, 0xba, 0x17, 0xbf, 0x59, 0x64, 0xce, 0xcf, 0xde, 0xc6, 0x9c, 0x45,
	0x84, 0x76, 0xee, 0x46, 0x68, 0x56, 0xfb, 0x53, 0x0a, 0xde, 0x7d, 0xd0, 0x8d, 0x8f, 0xda, 0x67,
	0xc1, 0xf6, 0x9d, 0x80, 0x46, 0xc6, 0xfd, 0xe4, 0xed, 0x4f, 0x1d, 0x5c, 0x49, 0xc6, 0xec, 0xc3,
	0x53, 0xd8, 0x5a, 0x9e, 0xb0, 0xd0, 0x07, 0xf0, 0x5e, 0x57, 0x1f, 0xf6, 0xb1, 0xde, 0x35, 0x86,
	0xa3, 0xf6, 0xe8, 0x6e, 0x5f, 0x2c, 0x43, 0xb1, 0x7f, 0x34, 0x1c, 0xb5, 0x0f, 0x0e, 0xf4, 0x6e,
	0xf8, 0xcb, 0xe7, 0x64, 0xd0, 0x6d, 0x8f, 0xf4, 0xae, 0x96, 0x96, 0x02, 0xd6, 0x0f, 0x8f, 0x4f,
	0xf5, 0xae, 0x96, 0xe9, 0xfc, 0x39, 0x05, 0x0d, 0x8b, 0x4d, 0x56, 0xb0, 0xb4, 0x53, 0x5e, 0x64,
	0x1c, 0x25, 0xfc, 0xfc, 0xf3, 0x68, 0xa9, 0xc3, 0x5c, 0xd3, 0x73, 0x1a, 0x2c, 0x70, 0x9a, 0x0e,
	0xf1, 0xd4, 0x5f, 0xcb, 0x66, 0xf8, 0xca, 0xf4, 0x29, 0x7f, 0x93, 0xdf, 0xa8, 0x1f, 0x27, 0x94,
	0x17, 0x39, 0x85, 0xf1, 0xd1, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0xd8, 0x89, 0x51, 0x63, 0x89,
	0x15, 0x00, 0x00,
}
