// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/documentai/v1beta2/document_understanding.proto

package documentai

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type OperationMetadata_State int32

const (
	// The default value. This value is used if the state is omitted.
	OperationMetadata_STATE_UNSPECIFIED OperationMetadata_State = 0
	// Request is received.
	OperationMetadata_ACCEPTED OperationMetadata_State = 1
	// Request operation is waiting for scheduling.
	OperationMetadata_WAITING OperationMetadata_State = 2
	// Request is being processed.
	OperationMetadata_RUNNING OperationMetadata_State = 3
	// The batch processing completed successfully.
	OperationMetadata_SUCCEEDED OperationMetadata_State = 4
	// The batch processing was cancelled.
	OperationMetadata_CANCELLED OperationMetadata_State = 5
	// The batch processing has failed.
	OperationMetadata_FAILED OperationMetadata_State = 6
)

var OperationMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ACCEPTED",
	2: "WAITING",
	3: "RUNNING",
	4: "SUCCEEDED",
	5: "CANCELLED",
	6: "FAILED",
}

var OperationMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ACCEPTED":          1,
	"WAITING":           2,
	"RUNNING":           3,
	"SUCCEEDED":         4,
	"CANCELLED":         5,
	"FAILED":            6,
}

func (x OperationMetadata_State) String() string {
	return proto.EnumName(OperationMetadata_State_name, int32(x))
}

func (OperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{15, 0}
}

// Request to batch process documents as an asynchronous operation. The output
// is written to Cloud Storage as JSON in the [Document] format.
type BatchProcessDocumentsRequest struct {
	// Required. Individual requests for each document.
	Requests []*ProcessDocumentRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no location is specified, a region will be chosen automatically.
	Parent               string   `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchProcessDocumentsRequest) Reset()         { *m = BatchProcessDocumentsRequest{} }
func (m *BatchProcessDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchProcessDocumentsRequest) ProtoMessage()    {}
func (*BatchProcessDocumentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{0}
}

func (m *BatchProcessDocumentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchProcessDocumentsRequest.Unmarshal(m, b)
}
func (m *BatchProcessDocumentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchProcessDocumentsRequest.Marshal(b, m, deterministic)
}
func (m *BatchProcessDocumentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchProcessDocumentsRequest.Merge(m, src)
}
func (m *BatchProcessDocumentsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchProcessDocumentsRequest.Size(m)
}
func (m *BatchProcessDocumentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchProcessDocumentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchProcessDocumentsRequest proto.InternalMessageInfo

func (m *BatchProcessDocumentsRequest) GetRequests() []*ProcessDocumentRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

func (m *BatchProcessDocumentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// Request to process one document.
type ProcessDocumentRequest struct {
	// Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no location is specified, a region will be chosen automatically.
	// This field is only populated when used in ProcessDocument method.
	Parent string `protobuf:"bytes,9,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Information about the input file.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Optional. The desired output location. This field is only needed in
	// BatchProcessDocumentsRequest.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Specifies a known document type for deeper structure detection. Valid
	// values are currently "general" and "invoice". If not provided, "general"\
	// is used as default. If any other value is given, the request is rejected.
	DocumentType string `protobuf:"bytes,3,opt,name=document_type,json=documentType,proto3" json:"document_type,omitempty"`
	// Controls table extraction behavior. If not specified, the system will
	// decide reasonable defaults.
	TableExtractionParams *TableExtractionParams `protobuf:"bytes,4,opt,name=table_extraction_params,json=tableExtractionParams,proto3" json:"table_extraction_params,omitempty"`
	// Controls form extraction behavior. If not specified, the system will
	// decide reasonable defaults.
	FormExtractionParams *FormExtractionParams `protobuf:"bytes,5,opt,name=form_extraction_params,json=formExtractionParams,proto3" json:"form_extraction_params,omitempty"`
	// Controls entity extraction behavior. If not specified, the system will
	// decide reasonable defaults.
	EntityExtractionParams *EntityExtractionParams `protobuf:"bytes,6,opt,name=entity_extraction_params,json=entityExtractionParams,proto3" json:"entity_extraction_params,omitempty"`
	// Controls OCR behavior. If not specified, the system will decide reasonable
	// defaults.
	OcrParams *OcrParams `protobuf:"bytes,7,opt,name=ocr_params,json=ocrParams,proto3" json:"ocr_params,omitempty"`
	// Controls AutoML model prediction behavior. AutoMlParams cannot be used
	// together with other Params.
	AutomlParams         *AutoMlParams `protobuf:"bytes,8,opt,name=automl_params,json=automlParams,proto3" json:"automl_params,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ProcessDocumentRequest) Reset()         { *m = ProcessDocumentRequest{} }
func (m *ProcessDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessDocumentRequest) ProtoMessage()    {}
func (*ProcessDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{1}
}

func (m *ProcessDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessDocumentRequest.Unmarshal(m, b)
}
func (m *ProcessDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessDocumentRequest.Marshal(b, m, deterministic)
}
func (m *ProcessDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessDocumentRequest.Merge(m, src)
}
func (m *ProcessDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessDocumentRequest.Size(m)
}
func (m *ProcessDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessDocumentRequest proto.InternalMessageInfo

func (m *ProcessDocumentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ProcessDocumentRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *ProcessDocumentRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

func (m *ProcessDocumentRequest) GetDocumentType() string {
	if m != nil {
		return m.DocumentType
	}
	return ""
}

func (m *ProcessDocumentRequest) GetTableExtractionParams() *TableExtractionParams {
	if m != nil {
		return m.TableExtractionParams
	}
	return nil
}

func (m *ProcessDocumentRequest) GetFormExtractionParams() *FormExtractionParams {
	if m != nil {
		return m.FormExtractionParams
	}
	return nil
}

func (m *ProcessDocumentRequest) GetEntityExtractionParams() *EntityExtractionParams {
	if m != nil {
		return m.EntityExtractionParams
	}
	return nil
}

func (m *ProcessDocumentRequest) GetOcrParams() *OcrParams {
	if m != nil {
		return m.OcrParams
	}
	return nil
}

func (m *ProcessDocumentRequest) GetAutomlParams() *AutoMlParams {
	if m != nil {
		return m.AutomlParams
	}
	return nil
}

// Response to an batch document processing request. This is returned in
// the LRO Operation after the operation is complete.
type BatchProcessDocumentsResponse struct {
	// Responses for each individual document.
	Responses            []*ProcessDocumentResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *BatchProcessDocumentsResponse) Reset()         { *m = BatchProcessDocumentsResponse{} }
func (m *BatchProcessDocumentsResponse) String() string { return proto.CompactTextString(m) }
func (*BatchProcessDocumentsResponse) ProtoMessage()    {}
func (*BatchProcessDocumentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{2}
}

func (m *BatchProcessDocumentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchProcessDocumentsResponse.Unmarshal(m, b)
}
func (m *BatchProcessDocumentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchProcessDocumentsResponse.Marshal(b, m, deterministic)
}
func (m *BatchProcessDocumentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchProcessDocumentsResponse.Merge(m, src)
}
func (m *BatchProcessDocumentsResponse) XXX_Size() int {
	return xxx_messageInfo_BatchProcessDocumentsResponse.Size(m)
}
func (m *BatchProcessDocumentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchProcessDocumentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchProcessDocumentsResponse proto.InternalMessageInfo

func (m *BatchProcessDocumentsResponse) GetResponses() []*ProcessDocumentResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

// Response to a single document processing request.
type ProcessDocumentResponse struct {
	// Information about the input file. This is the same as the corresponding
	// input config in the request.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// The output location of the parsed responses. The responses are written to
	// this location as JSON-serialized `Document` objects.
	OutputConfig         *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ProcessDocumentResponse) Reset()         { *m = ProcessDocumentResponse{} }
func (m *ProcessDocumentResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessDocumentResponse) ProtoMessage()    {}
func (*ProcessDocumentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{3}
}

func (m *ProcessDocumentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessDocumentResponse.Unmarshal(m, b)
}
func (m *ProcessDocumentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessDocumentResponse.Marshal(b, m, deterministic)
}
func (m *ProcessDocumentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessDocumentResponse.Merge(m, src)
}
func (m *ProcessDocumentResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessDocumentResponse.Size(m)
}
func (m *ProcessDocumentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessDocumentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessDocumentResponse proto.InternalMessageInfo

func (m *ProcessDocumentResponse) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *ProcessDocumentResponse) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Parameters to control Optical Character Recognition (OCR) behavior.
type OcrParams struct {
	// List of languages to use for OCR. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Document processing returns an
	// error if one or more of the specified languages is not one of the
	// supported languages.
	LanguageHints        []string `protobuf:"bytes,1,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OcrParams) Reset()         { *m = OcrParams{} }
func (m *OcrParams) String() string { return proto.CompactTextString(m) }
func (*OcrParams) ProtoMessage()    {}
func (*OcrParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{4}
}

func (m *OcrParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OcrParams.Unmarshal(m, b)
}
func (m *OcrParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OcrParams.Marshal(b, m, deterministic)
}
func (m *OcrParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OcrParams.Merge(m, src)
}
func (m *OcrParams) XXX_Size() int {
	return xxx_messageInfo_OcrParams.Size(m)
}
func (m *OcrParams) XXX_DiscardUnknown() {
	xxx_messageInfo_OcrParams.DiscardUnknown(m)
}

var xxx_messageInfo_OcrParams proto.InternalMessageInfo

func (m *OcrParams) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

// Parameters to control table extraction behavior.
type TableExtractionParams struct {
	// Whether to enable table extraction.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. Table bounding box hints that can be provided to complex cases
	// which our algorithm cannot locate the table(s) in.
	TableBoundHints []*TableBoundHint `protobuf:"bytes,2,rep,name=table_bound_hints,json=tableBoundHints,proto3" json:"table_bound_hints,omitempty"`
	// Optional. Table header hints. The extraction will bias towards producing
	// these terms as table headers, which may improve accuracy.
	HeaderHints []string `protobuf:"bytes,3,rep,name=header_hints,json=headerHints,proto3" json:"header_hints,omitempty"`
	// Model version of the table extraction system. Default is "builtin/stable".
	// Specify "builtin/latest" for the latest model.
	ModelVersion         string   `protobuf:"bytes,4,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TableExtractionParams) Reset()         { *m = TableExtractionParams{} }
func (m *TableExtractionParams) String() string { return proto.CompactTextString(m) }
func (*TableExtractionParams) ProtoMessage()    {}
func (*TableExtractionParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{5}
}

func (m *TableExtractionParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableExtractionParams.Unmarshal(m, b)
}
func (m *TableExtractionParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableExtractionParams.Marshal(b, m, deterministic)
}
func (m *TableExtractionParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableExtractionParams.Merge(m, src)
}
func (m *TableExtractionParams) XXX_Size() int {
	return xxx_messageInfo_TableExtractionParams.Size(m)
}
func (m *TableExtractionParams) XXX_DiscardUnknown() {
	xxx_messageInfo_TableExtractionParams.DiscardUnknown(m)
}

var xxx_messageInfo_TableExtractionParams proto.InternalMessageInfo

func (m *TableExtractionParams) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *TableExtractionParams) GetTableBoundHints() []*TableBoundHint {
	if m != nil {
		return m.TableBoundHints
	}
	return nil
}

func (m *TableExtractionParams) GetHeaderHints() []string {
	if m != nil {
		return m.HeaderHints
	}
	return nil
}

func (m *TableExtractionParams) GetModelVersion() string {
	if m != nil {
		return m.ModelVersion
	}
	return ""
}

// A hint for a table bounding box on the page for table parsing.
type TableBoundHint struct {
	// Optional. Page number for multi-paged inputs this hint applies to. If not
	// provided, this hint will apply to all pages by default. This value is
	// 1-based.
	PageNumber int32 `protobuf:"varint,1,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
	// Bounding box hint for a table on this page. The coordinates must be
	// normalized to [0,1] and the bounding box must be an axis-aligned rectangle.
	BoundingBox          *BoundingPoly `protobuf:"bytes,2,opt,name=bounding_box,json=boundingBox,proto3" json:"bounding_box,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *TableBoundHint) Reset()         { *m = TableBoundHint{} }
func (m *TableBoundHint) String() string { return proto.CompactTextString(m) }
func (*TableBoundHint) ProtoMessage()    {}
func (*TableBoundHint) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{6}
}

func (m *TableBoundHint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TableBoundHint.Unmarshal(m, b)
}
func (m *TableBoundHint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TableBoundHint.Marshal(b, m, deterministic)
}
func (m *TableBoundHint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableBoundHint.Merge(m, src)
}
func (m *TableBoundHint) XXX_Size() int {
	return xxx_messageInfo_TableBoundHint.Size(m)
}
func (m *TableBoundHint) XXX_DiscardUnknown() {
	xxx_messageInfo_TableBoundHint.DiscardUnknown(m)
}

var xxx_messageInfo_TableBoundHint proto.InternalMessageInfo

func (m *TableBoundHint) GetPageNumber() int32 {
	if m != nil {
		return m.PageNumber
	}
	return 0
}

func (m *TableBoundHint) GetBoundingBox() *BoundingPoly {
	if m != nil {
		return m.BoundingBox
	}
	return nil
}

// Parameters to control form extraction behavior.
type FormExtractionParams struct {
	// Whether to enable form extraction.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// User can provide pairs of (key text, value type) to improve the parsing
	// result.
	//
	// For example, if a document has a field called "Date" that holds a date
	// value and a field called "Amount" that may hold either a currency value
	// (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
	// following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
	// "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
	//
	// If the value type is unknown, but you want to provide hints for the keys,
	// you can leave the value_types field blank. e.g. {"key": "Date",
	// "value_types": []}
	KeyValuePairHints []*KeyValuePairHint `protobuf:"bytes,2,rep,name=key_value_pair_hints,json=keyValuePairHints,proto3" json:"key_value_pair_hints,omitempty"`
	// Model version of the form extraction system. Default is
	// "builtin/stable". Specify "builtin/latest" for the latest model.
	// For custom form models, specify: “custom/{model_name}". Model name
	// format is "bucket_name/path/to/modeldir" corresponding to
	// "gs://bucket_name/path/to/modeldir" where annotated examples are stored.
	ModelVersion         string   `protobuf:"bytes,3,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FormExtractionParams) Reset()         { *m = FormExtractionParams{} }
func (m *FormExtractionParams) String() string { return proto.CompactTextString(m) }
func (*FormExtractionParams) ProtoMessage()    {}
func (*FormExtractionParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{7}
}

func (m *FormExtractionParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FormExtractionParams.Unmarshal(m, b)
}
func (m *FormExtractionParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FormExtractionParams.Marshal(b, m, deterministic)
}
func (m *FormExtractionParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FormExtractionParams.Merge(m, src)
}
func (m *FormExtractionParams) XXX_Size() int {
	return xxx_messageInfo_FormExtractionParams.Size(m)
}
func (m *FormExtractionParams) XXX_DiscardUnknown() {
	xxx_messageInfo_FormExtractionParams.DiscardUnknown(m)
}

var xxx_messageInfo_FormExtractionParams proto.InternalMessageInfo

func (m *FormExtractionParams) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *FormExtractionParams) GetKeyValuePairHints() []*KeyValuePairHint {
	if m != nil {
		return m.KeyValuePairHints
	}
	return nil
}

func (m *FormExtractionParams) GetModelVersion() string {
	if m != nil {
		return m.ModelVersion
	}
	return ""
}

// User-provided hint for key value pair.
type KeyValuePairHint struct {
	// The key text for the hint.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Type of the value. This is case-insensitive, and could be one of:
	// ADDRESS, LOCATION, ORGANIZATION, PERSON, PHONE_NUMBER,
	// ID, NUMBER, EMAIL, PRICE, TERMS, DATE, NAME. Types not in this list will
	// be ignored.
	ValueTypes           []string `protobuf:"bytes,2,rep,name=value_types,json=valueTypes,proto3" json:"value_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyValuePairHint) Reset()         { *m = KeyValuePairHint{} }
func (m *KeyValuePairHint) String() string { return proto.CompactTextString(m) }
func (*KeyValuePairHint) ProtoMessage()    {}
func (*KeyValuePairHint) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{8}
}

func (m *KeyValuePairHint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeyValuePairHint.Unmarshal(m, b)
}
func (m *KeyValuePairHint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeyValuePairHint.Marshal(b, m, deterministic)
}
func (m *KeyValuePairHint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyValuePairHint.Merge(m, src)
}
func (m *KeyValuePairHint) XXX_Size() int {
	return xxx_messageInfo_KeyValuePairHint.Size(m)
}
func (m *KeyValuePairHint) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyValuePairHint.DiscardUnknown(m)
}

var xxx_messageInfo_KeyValuePairHint proto.InternalMessageInfo

func (m *KeyValuePairHint) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *KeyValuePairHint) GetValueTypes() []string {
	if m != nil {
		return m.ValueTypes
	}
	return nil
}

// Parameters to control entity extraction behavior.
type EntityExtractionParams struct {
	// Whether to enable entity extraction.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Model version of the entity extraction. Default is
	// "builtin/stable". Specify "builtin/latest" for the latest model.
	ModelVersion         string   `protobuf:"bytes,2,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityExtractionParams) Reset()         { *m = EntityExtractionParams{} }
func (m *EntityExtractionParams) String() string { return proto.CompactTextString(m) }
func (*EntityExtractionParams) ProtoMessage()    {}
func (*EntityExtractionParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{9}
}

func (m *EntityExtractionParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityExtractionParams.Unmarshal(m, b)
}
func (m *EntityExtractionParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityExtractionParams.Marshal(b, m, deterministic)
}
func (m *EntityExtractionParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityExtractionParams.Merge(m, src)
}
func (m *EntityExtractionParams) XXX_Size() int {
	return xxx_messageInfo_EntityExtractionParams.Size(m)
}
func (m *EntityExtractionParams) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityExtractionParams.DiscardUnknown(m)
}

var xxx_messageInfo_EntityExtractionParams proto.InternalMessageInfo

func (m *EntityExtractionParams) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *EntityExtractionParams) GetModelVersion() string {
	if m != nil {
		return m.ModelVersion
	}
	return ""
}

// Parameters to control AutoML model prediction behavior.
type AutoMlParams struct {
	// Resource name of the AutoML model.
	//
	// Format: `projects/{project-id}/locations/{location-id}/models/{model-id}`.
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AutoMlParams) Reset()         { *m = AutoMlParams{} }
func (m *AutoMlParams) String() string { return proto.CompactTextString(m) }
func (*AutoMlParams) ProtoMessage()    {}
func (*AutoMlParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{10}
}

func (m *AutoMlParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoMlParams.Unmarshal(m, b)
}
func (m *AutoMlParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoMlParams.Marshal(b, m, deterministic)
}
func (m *AutoMlParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoMlParams.Merge(m, src)
}
func (m *AutoMlParams) XXX_Size() int {
	return xxx_messageInfo_AutoMlParams.Size(m)
}
func (m *AutoMlParams) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoMlParams.DiscardUnknown(m)
}

var xxx_messageInfo_AutoMlParams proto.InternalMessageInfo

func (m *AutoMlParams) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// The desired input location and metadata.
type InputConfig struct {
	// Required.
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_GcsSource
	//	*InputConfig_Contents
	Source isInputConfig_Source `protobuf_oneof:"source"`
	// Required. Mimetype of the input. Current supported mimetypes are application/pdf,
	// image/tiff, and image/gif.
	// In addition, application/json type is supported for requests with
	// [ProcessDocumentRequest.automl_params][google.cloud.documentai.v1beta2.ProcessDocumentRequest.automl_params] field set. The JSON file needs to
	// be in [Document][google.cloud.documentai.v1beta2.Document] format.
	MimeType             string   `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{11}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type InputConfig_Contents struct {
	Contents []byte `protobuf:"bytes,3,opt,name=contents,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (*InputConfig_Contents) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (m *InputConfig) GetContents() []byte {
	if x, ok := m.GetSource().(*InputConfig_Contents); ok {
		return x.Contents
	}
	return nil
}

func (m *InputConfig) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InputConfig_GcsSource)(nil),
		(*InputConfig_Contents)(nil),
	}
}

// The desired output location and metadata.
type OutputConfig struct {
	// Required.
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
	// The max number of pages to include into each output Document shard JSON on
	// Google Cloud Storage.
	//
	// The valid range is [1, 100]. If not specified, the default value is 20.
	//
	// For example, for one pdf file with 100 pages, 100 parsed pages will be
	// produced. If `pages_per_shard` = 20, then 5 Document shard JSON files each
	// containing 20 parsed pages will be written under the prefix
	// [OutputConfig.gcs_destination.uri][] and suffix pages-x-to-y.json where
	// x and y are 1-indexed page numbers.
	//
	// Example GCS outputs with 157 pages and pages_per_shard = 50:
	//
	// <prefix>pages-001-to-050.json
	// <prefix>pages-051-to-100.json
	// <prefix>pages-101-to-150.json
	// <prefix>pages-151-to-157.json
	PagesPerShard        int32    `protobuf:"varint,2,opt,name=pages_per_shard,json=pagesPerShard,proto3" json:"pages_per_shard,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{12}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (m *OutputConfig) GetPagesPerShard() int32 {
	if m != nil {
		return m.PagesPerShard
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
}

// The Google Cloud Storage location where the input file will be read from.
type GcsSource struct {
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{13}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The Google Cloud Storage location where the output file will be written to.
type GcsDestination struct {
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{14}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// Contains metadata for the BatchProcessDocuments operation.
type OperationMetadata struct {
	// The state of the current batch processing.
	State OperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1beta2.OperationMetadata_State" json:"state,omitempty"`
	// A message providing more details about the current state of processing.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The creation time of the operation.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last update time of the operation.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OperationMetadata) Reset()         { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()    {}
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_6f4c8f260ccccbce, []int{15}
}

func (m *OperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationMetadata.Unmarshal(m, b)
}
func (m *OperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationMetadata.Marshal(b, m, deterministic)
}
func (m *OperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationMetadata.Merge(m, src)
}
func (m *OperationMetadata) XXX_Size() int {
	return xxx_messageInfo_OperationMetadata.Size(m)
}
func (m *OperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OperationMetadata proto.InternalMessageInfo

func (m *OperationMetadata) GetState() OperationMetadata_State {
	if m != nil {
		return m.State
	}
	return OperationMetadata_STATE_UNSPECIFIED
}

func (m *OperationMetadata) GetStateMessage() string {
	if m != nil {
		return m.StateMessage
	}
	return ""
}

func (m *OperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.documentai.v1beta2.OperationMetadata_State", OperationMetadata_State_name, OperationMetadata_State_value)
	proto.RegisterType((*BatchProcessDocumentsRequest)(nil), "google.cloud.documentai.v1beta2.BatchProcessDocumentsRequest")
	proto.RegisterType((*ProcessDocumentRequest)(nil), "google.cloud.documentai.v1beta2.ProcessDocumentRequest")
	proto.RegisterType((*BatchProcessDocumentsResponse)(nil), "google.cloud.documentai.v1beta2.BatchProcessDocumentsResponse")
	proto.RegisterType((*ProcessDocumentResponse)(nil), "google.cloud.documentai.v1beta2.ProcessDocumentResponse")
	proto.RegisterType((*OcrParams)(nil), "google.cloud.documentai.v1beta2.OcrParams")
	proto.RegisterType((*TableExtractionParams)(nil), "google.cloud.documentai.v1beta2.TableExtractionParams")
	proto.RegisterType((*TableBoundHint)(nil), "google.cloud.documentai.v1beta2.TableBoundHint")
	proto.RegisterType((*FormExtractionParams)(nil), "google.cloud.documentai.v1beta2.FormExtractionParams")
	proto.RegisterType((*KeyValuePairHint)(nil), "google.cloud.documentai.v1beta2.KeyValuePairHint")
	proto.RegisterType((*EntityExtractionParams)(nil), "google.cloud.documentai.v1beta2.EntityExtractionParams")
	proto.RegisterType((*AutoMlParams)(nil), "google.cloud.documentai.v1beta2.AutoMlParams")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.documentai.v1beta2.InputConfig")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.documentai.v1beta2.OutputConfig")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.documentai.v1beta2.GcsSource")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.documentai.v1beta2.GcsDestination")
	proto.RegisterType((*OperationMetadata)(nil), "google.cloud.documentai.v1beta2.OperationMetadata")
}

func init() {
	proto.RegisterFile("google/cloud/documentai/v1beta2/document_understanding.proto", fileDescriptor_6f4c8f260ccccbce)
}

var fileDescriptor_6f4c8f260ccccbce = []byte{
	// 1423 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0x4f, 0x6f, 0x1b, 0xc5,
	0x1b, 0xce, 0xda, 0x75, 0x1a, 0xbf, 0xb6, 0xf3, 0x67, 0x94, 0xa4, 0x51, 0x94, 0xaa, 0xd1, 0xa6,
	0xbf, 0xfe, 0x42, 0x44, 0xbd, 0x6a, 0x2a, 0xa0, 0x4a, 0xa9, 0x90, 0xed, 0xb8, 0x8d, 0xd5, 0x36,
	0xb5, 0x36, 0x4e, 0x8b, 0x7a, 0x59, 0xc6, 0xeb, 0xc9, 0x66, 0x89, 0x77, 0x67, 0x3b, 0x3b, 0x9b,
	0xd4, 0x20, 0x38, 0xc0, 0x85, 0x23, 0x12, 0x9f, 0x00, 0xc1, 0x97, 0x40, 0x42, 0x9c, 0x38, 0xf5,
	0x08, 0x37, 0x4e, 0x3d, 0xf0, 0x05, 0x10, 0x7c, 0x00, 0x34, 0x33, 0xbb, 0xfe, 0x93, 0x38, 0xb1,
	0x29, 0xdc, 0x76, 0x9e, 0x99, 0xe7, 0x79, 0x9f, 0xf9, 0xf3, 0xce, 0xbe, 0x03, 0xef, 0x3b, 0x94,
	0x3a, 0x6d, 0x62, 0xd8, 0x6d, 0x1a, 0xb5, 0x8c, 0x16, 0xb5, 0x23, 0x8f, 0xf8, 0x1c, 0xbb, 0xc6,
	0xf1, 0xad, 0x26, 0xe1, 0x78, 0xb3, 0x0b, 0x59, 0x91, 0xdf, 0x22, 0x2c, 0xe4, 0xd8, 0x6f, 0xb9,
	0xbe, 0x53, 0x0c, 0x18, 0xe5, 0x14, 0x5d, 0x53, 0xec, 0xa2, 0x64, 0x17, 0x7b, 0xec, 0x62, 0xcc,
	0x5e, 0x5e, 0x89, 0xe5, 0x71, 0xe0, 0x1a, 0xd8, 0xf7, 0x29, 0xc7, 0xdc, 0xa5, 0x7e, 0xa8, 0xe8,
	0xcb, 0x57, 0xfa, 0x7a, 0xed, 0xb6, 0x4b, 0x7c, 0x1e, 0x77, 0x5c, 0xeb, 0xeb, 0x38, 0x70, 0x49,
	0xbb, 0x65, 0x35, 0xc9, 0x21, 0x3e, 0x76, 0x29, 0x8b, 0x07, 0x14, 0xc7, 0xb5, 0x3d, 0xee, 0x78,
	0x87, 0x50, 0x8f, 0x70, 0xd6, 0x89, 0xc7, 0xaf, 0xc5, 0xe3, 0xdb, 0xd4, 0x77, 0x58, 0xe4, 0xfb,
	0xae, 0xef, 0x18, 0x34, 0x20, 0x6c, 0xc0, 0x7e, 0xe2, 0x52, 0xb6, 0x9a, 0xd1, 0x81, 0xc1, 0x5d,
	0x8f, 0x84, 0x1c, 0x7b, 0x81, 0x1a, 0xa0, 0x7f, 0xad, 0xc1, 0x4a, 0x19, 0x73, 0xfb, 0xb0, 0xce,
	0xa8, 0x4d, 0xc2, 0x70, 0x3b, 0x8e, 0x1b, 0x9a, 0xe4, 0x45, 0x44, 0x42, 0x8e, 0x3e, 0x84, 0x29,
	0xa6, 0x3e, 0xc3, 0x25, 0x6d, 0x35, 0xbd, 0x9e, 0xdb, 0x7c, 0xaf, 0x38, 0x62, 0x49, 0x8b, 0xa7,
	0xb4, 0x62, 0xa9, 0x72, 0xfa, 0x75, 0x29, 0x65, 0x76, 0xd5, 0xd0, 0x22, 0x4c, 0x06, 0x98, 0x11,
	0x9f, 0x2f, 0xa5, 0x56, 0xb5, 0xf5, 0xac, 0x19, 0xb7, 0xf4, 0x3f, 0x33, 0xb0, 0x38, 0x5c, 0xa1,
	0x8f, 0x92, 0xed, 0xa7, 0xa0, 0x06, 0xe4, 0x5d, 0x3f, 0x88, 0xb8, 0x65, 0x53, 0xff, 0xc0, 0x75,
	0x96, 0xb4, 0x55, 0x6d, 0x3d, 0xb7, 0xf9, 0xf6, 0x48, 0xa3, 0x35, 0x41, 0xaa, 0x48, 0x8e, 0x72,
	0x97, 0x73, 0x7b, 0x08, 0x7a, 0x06, 0x05, 0x1a, 0xf1, 0x3e, 0xd9, 0x94, 0x94, 0xbd, 0x39, 0x52,
	0xf6, 0x89, 0x64, 0xf5, 0x74, 0x35, 0x33, 0x4f, 0xfb, 0x20, 0xb4, 0x06, 0x85, 0xee, 0x99, 0xe5,
	0x9d, 0x80, 0x2c, 0xa5, 0xe5, 0x6c, 0xf2, 0x09, 0xd8, 0xe8, 0x04, 0x04, 0xf9, 0x70, 0x85, 0xe3,
	0x66, 0x9b, 0x58, 0xe4, 0x25, 0x67, 0xd8, 0x16, 0xbb, 0x6a, 0x05, 0x98, 0x61, 0x2f, 0x5c, 0xba,
	0x24, 0x7d, 0xbc, 0x3b, 0xd2, 0x47, 0x43, 0xf0, 0xab, 0x5d, 0x7a, 0x5d, 0xb2, 0xcd, 0x05, 0x3e,
	0x0c, 0x46, 0x47, 0xb0, 0x78, 0x40, 0x99, 0x37, 0x24, 0x5c, 0x46, 0x86, 0x7b, 0x67, 0x64, 0xb8,
	0xfb, 0x94, 0x79, 0x67, 0xa2, 0xcd, 0x1f, 0x0c, 0x41, 0xd1, 0x0b, 0x58, 0x22, 0x3e, 0x77, 0x79,
	0x67, 0x48, 0xb8, 0x49, 0x19, 0x6e, 0xf4, 0x29, 0xab, 0x4a, 0x81, 0x33, 0x01, 0x17, 0xc9, 0x50,
	0x1c, 0xd5, 0x00, 0xa8, 0xcd, 0x92, 0x20, 0x97, 0x65, 0x90, 0x8d, 0xd1, 0x5b, 0x69, 0xb3, 0x58,
	0x37, 0x4b, 0x93, 0x4f, 0x64, 0x42, 0x01, 0x47, 0x9c, 0x7a, 0xed, 0x44, 0x6d, 0x6a, 0xcc, 0x83,
	0x51, 0x8a, 0x38, 0x7d, 0xdc, 0x8e, 0x05, 0xf3, 0x4a, 0x43, 0xb5, 0xf4, 0x13, 0xb8, 0x7a, 0x4e,
	0x1e, 0x86, 0x01, 0xf5, 0x43, 0x82, 0x9e, 0x42, 0x96, 0xc5, 0xdf, 0x49, 0x26, 0xde, 0xf9, 0xe7,
	0x99, 0xa8, 0x04, 0xcc, 0x9e, 0x94, 0xfe, 0x93, 0x06, 0x57, 0xce, 0x19, 0x86, 0x9e, 0xfc, 0xfb,
	0xbc, 0x1a, 0x4c, 0x29, 0xf3, 0xbf, 0x48, 0xa9, 0xc1, 0x6c, 0xd2, 0x37, 0x21, 0xdb, 0xdd, 0x25,
	0xf4, 0x3f, 0x98, 0x6e, 0x63, 0xdf, 0x89, 0xb0, 0x43, 0xac, 0x43, 0xd7, 0x8f, 0x2f, 0xad, 0xac,
	0x59, 0x48, 0xd0, 0x1d, 0x01, 0xea, 0xaf, 0x35, 0x58, 0x18, 0x9a, 0x1d, 0x68, 0x09, 0x2e, 0x13,
	0x5f, 0xf4, 0xb4, 0xe4, 0x6c, 0xa7, 0xcc, 0xa4, 0x89, 0x3e, 0x82, 0x39, 0x95, 0x90, 0x4d, 0x1a,
	0xf9, 0xad, 0x58, 0x3d, 0x25, 0x37, 0xc2, 0x18, 0x2f, 0x15, 0xcb, 0x82, 0x28, 0x0c, 0xa8, 0x4b,
	0x61, 0x86, 0x0f, 0x80, 0x21, 0xba, 0x01, 0xf9, 0x43, 0x82, 0x5b, 0x84, 0xc5, 0xe2, 0x69, 0x61,
	0x5d, 0x8d, 0xcd, 0xa9, 0x0e, 0x35, 0x6e, 0x0d, 0x0a, 0x1e, 0x6d, 0x91, 0xb6, 0x75, 0x4c, 0x58,
	0xe8, 0x52, 0x5f, 0x5e, 0x08, 0x59, 0x33, 0x2f, 0xc1, 0xa7, 0x0a, 0xd3, 0xbf, 0xd2, 0x60, 0x7a,
	0x30, 0x2a, 0xba, 0x0e, 0xb9, 0x40, 0x2c, 0x8c, 0x1f, 0x79, 0x4d, 0xc2, 0xe4, 0xfc, 0x32, 0x4a,
	0x1e, 0x04, 0xbe, 0x2b, 0x61, 0x54, 0x87, 0xbc, 0x9c, 0xa1, 0xeb, 0x3b, 0x56, 0x93, 0xbe, 0x1c,
	0x7b, 0x8b, 0xca, 0x31, 0xa9, 0x4e, 0xdb, 0x1d, 0x33, 0x97, 0x48, 0x94, 0xe9, 0x4b, 0xfd, 0x07,
	0x0d, 0xe6, 0x87, 0x5d, 0x0e, 0x17, 0x2c, 0x76, 0x13, 0xe6, 0x8f, 0x48, 0xc7, 0x3a, 0xc6, 0xed,
	0x88, 0x58, 0x01, 0x76, 0xd9, 0xc0, 0x7a, 0xdf, 0x1a, 0x69, 0xe6, 0x21, 0xe9, 0x3c, 0x15, 0xdc,
	0x3a, 0x76, 0xe5, 0xa2, 0x99, 0x73, 0x47, 0xa7, 0x90, 0x21, 0xcb, 0x98, 0x1e, 0xb2, 0x8c, 0x55,
	0x98, 0x3d, 0xad, 0x85, 0x66, 0x21, 0x7d, 0x44, 0x3a, 0xd2, 0x72, 0xd6, 0x14, 0x9f, 0xe8, 0x1a,
	0xe4, 0x94, 0x55, 0x71, 0x9d, 0x2b, 0x97, 0x59, 0x13, 0x24, 0x24, 0x2e, 0xf3, 0x50, 0x7f, 0x06,
	0x8b, 0xc3, 0xef, 0xab, 0x0b, 0xd6, 0xe0, 0x8c, 0xbf, 0xd4, 0x10, 0x7f, 0xd7, 0x21, 0xdf, 0x7f,
	0xab, 0xa0, 0x79, 0xc8, 0xc8, 0xfe, 0xd8, 0x9d, 0x6a, 0xe8, 0xdf, 0x6b, 0x90, 0xeb, 0x4b, 0x4a,
	0xf4, 0x10, 0xc0, 0xb1, 0x43, 0x2b, 0xa4, 0x11, 0xb3, 0x49, 0x9c, 0xd6, 0xa3, 0x2f, 0xc3, 0x07,
	0x76, 0xb8, 0x27, 0x19, 0x3b, 0x13, 0x66, 0xd6, 0x49, 0x1a, 0x68, 0x05, 0xa6, 0x6c, 0xea, 0x73,
	0xa2, 0x8e, 0xac, 0xb6, 0x9e, 0xdf, 0x99, 0x30, 0xbb, 0x08, 0x5a, 0x85, 0xac, 0xe7, 0x7a, 0x6a,
	0x65, 0xd4, 0x0c, 0xe2, 0x42, 0x40, 0xa0, 0x62, 0x71, 0xca, 0x53, 0x30, 0xa9, 0x8c, 0xe8, 0xdf,
	0x6a, 0x90, 0xef, 0xcf, 0x74, 0xf4, 0x1c, 0x66, 0x84, 0xcf, 0x16, 0x09, 0xb9, 0xeb, 0xcb, 0xca,
	0x26, 0x36, 0x6b, 0x8c, 0x63, 0x76, 0xbb, 0x47, 0xdb, 0x99, 0x30, 0xa7, 0x9d, 0x01, 0x04, 0xdd,
	0x80, 0x19, 0x71, 0xea, 0x43, 0x2b, 0x20, 0xcc, 0x0a, 0x0f, 0x31, 0x6b, 0x49, 0x7b, 0x19, 0xb3,
	0x20, 0xe1, 0x3a, 0x61, 0x7b, 0x02, 0x2c, 0x17, 0x20, 0xd7, 0x17, 0x5f, 0xd7, 0x21, 0xdb, 0x5d,
	0x07, 0xb4, 0x00, 0xe9, 0x88, 0xb9, 0x6a, 0xad, 0xd5, 0xb4, 0x44, 0x5b, 0xff, 0x3f, 0x4c, 0x0f,
	0x86, 0x3f, 0x6f, 0xe0, 0x5f, 0x29, 0x98, 0x7b, 0x92, 0x14, 0x6d, 0x8f, 0x09, 0xc7, 0x2d, 0xcc,
	0x31, 0xda, 0x85, 0x4c, 0xc8, 0x31, 0x57, 0x1b, 0x33, 0x3d, 0xc6, 0x35, 0x7f, 0x46, 0xa2, 0xb8,
	0x27, 0xf8, 0xa6, 0x92, 0x11, 0x07, 0x49, 0x7e, 0x58, 0x1e, 0x09, 0x43, 0xec, 0x90, 0xe4, 0x20,
	0x49, 0xf0, 0xb1, 0xc2, 0xd0, 0x5d, 0xc8, 0xd9, 0x8c, 0x88, 0x51, 0xa2, 0x46, 0x94, 0x1b, 0x99,
	0xdb, 0x4c, 0xaa, 0xd2, 0x62, 0x52, 0x40, 0x16, 0x1b, 0x49, 0x01, 0x69, 0x82, 0x1a, 0x2e, 0x00,
	0x41, 0x8e, 0x82, 0x56, 0x97, 0x7c, 0x69, 0x34, 0x59, 0x0d, 0x17, 0x80, 0x1e, 0x40, 0x46, 0xda,
	0x45, 0x0b, 0x30, 0xb7, 0xd7, 0x28, 0x35, 0xaa, 0xd6, 0xfe, 0xee, 0x5e, 0xbd, 0x5a, 0xa9, 0xdd,
	0xaf, 0x55, 0xb7, 0x67, 0x27, 0x50, 0x1e, 0xa6, 0x4a, 0x95, 0x4a, 0xb5, 0xde, 0xa8, 0x6e, 0xcf,
	0x6a, 0x28, 0x07, 0x97, 0x9f, 0x95, 0x6a, 0x8d, 0xda, 0xee, 0x83, 0xd9, 0x94, 0x68, 0x98, 0xfb,
	0xbb, 0xbb, 0xa2, 0x91, 0x46, 0x05, 0xc8, 0xee, 0xed, 0x57, 0x2a, 0xd5, 0xea, 0x76, 0x75, 0x7b,
	0xf6, 0x92, 0x68, 0x56, 0x4a, 0xbb, 0x95, 0xea, 0xa3, 0x47, 0xd5, 0xed, 0xd9, 0x0c, 0x02, 0x98,
	0xbc, 0x5f, 0xaa, 0x89, 0xef, 0xc9, 0xcd, 0xef, 0x32, 0xb0, 0x92, 0xfc, 0xec, 0xf6, 0xfb, 0x1f,
	0x0d, 0x7b, 0x84, 0x1d, 0xbb, 0x36, 0x41, 0x3f, 0xa6, 0x60, 0x61, 0xe8, 0xef, 0x18, 0xdd, 0x1b,
	0x7d, 0x0f, 0x5e, 0x50, 0x4e, 0x2f, 0x5f, 0x4d, 0xe8, 0x7d, 0x65, 0x7b, 0x6f, 0xfb, 0xf4, 0x9f,
	0xb5, 0x57, 0xa5, 0xcd, 0x51, 0x95, 0xc0, 0xd9, 0x13, 0xf3, 0x5b, 0xa9, 0x5b, 0x56, 0x7f, 0xf1,
	0xeb, 0xef, 0xdf, 0xa4, 0x3e, 0xd7, 0x3f, 0xe8, 0x3e, 0x1b, 0x3e, 0x55, 0x35, 0xf2, 0xbd, 0x80,
	0xd1, 0x8f, 0x89, 0xcd, 0x43, 0x63, 0xc3, 0x68, 0x53, 0x5b, 0xbd, 0x12, 0x8c, 0x8d, 0xcf, 0xba,
	0x2f, 0x8d, 0x70, 0xab, 0xd9, 0x17, 0x75, 0x4b, 0xdb, 0x78, 0x7e, 0x47, 0xbf, 0x7d, 0x81, 0xca,
	0x05, 0x4c, 0xf4, 0x87, 0x06, 0x33, 0xa7, 0xec, 0xa3, 0x37, 0x7d, 0x36, 0x2c, 0xbf, 0x35, 0x92,
	0x98, 0x30, 0xf4, 0x4f, 0xe4, 0xec, 0xb9, 0xbe, 0xf5, 0x06, 0xb3, 0x0f, 0x7a, 0x13, 0xbf, 0xad,
	0x17, 0xc7, 0x9c, 0x78, 0x8f, 0xb4, 0x5c, 0x7f, 0x55, 0x5a, 0x89, 0xc2, 0x9b, 0x7d, 0xf6, 0x94,
	0x6d, 0x1c, 0xb8, 0x61, 0xd1, 0xa6, 0xde, 0x2f, 0xa5, 0xe2, 0x21, 0xe7, 0x41, 0xb8, 0x65, 0x18,
	0x27, 0x27, 0x27, 0xa7, 0x3a, 0x0d, 0x1c, 0xf1, 0x43, 0xf5, 0xf4, 0xbb, 0x19, 0xb4, 0x31, 0x17,
	0x45, 0x73, 0xf9, 0x4b, 0x0d, 0xd6, 0x6c, 0xea, 0x8d, 0x9a, 0x7e, 0x79, 0x26, 0x99, 0x7f, 0xc9,
	0xad, 0x8b, 0x4c, 0xab, 0x6b, 0xcf, 0x6b, 0x31, 0xc7, 0xa1, 0xa2, 0xee, 0x29, 0x52, 0xe6, 0x18,
	0x0e, 0xf1, 0x65, 0x1e, 0x1a, 0xbd, 0xc8, 0xe7, 0xbe, 0x35, 0xef, 0xf6, 0xa0, 0xe6, 0xa4, 0x64,
	0xdd, 0xfe, 0x3b, 0x00, 0x00, 0xff, 0xff, 0xbe, 0xcf, 0xf5, 0xd6, 0x87, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentUnderstandingServiceClient is the client API for DocumentUnderstandingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentUnderstandingServiceClient interface {
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(ctx context.Context, in *BatchProcessDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Processes a single document.
	ProcessDocument(ctx context.Context, in *ProcessDocumentRequest, opts ...grpc.CallOption) (*Document, error)
}

type documentUnderstandingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentUnderstandingServiceClient(cc grpc.ClientConnInterface) DocumentUnderstandingServiceClient {
	return &documentUnderstandingServiceClient{cc}
}

func (c *documentUnderstandingServiceClient) BatchProcessDocuments(ctx context.Context, in *BatchProcessDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta2.DocumentUnderstandingService/BatchProcessDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentUnderstandingServiceClient) ProcessDocument(ctx context.Context, in *ProcessDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta2.DocumentUnderstandingService/ProcessDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentUnderstandingServiceServer is the server API for DocumentUnderstandingService service.
type DocumentUnderstandingServiceServer interface {
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(context.Context, *BatchProcessDocumentsRequest) (*longrunning.Operation, error)
	// Processes a single document.
	ProcessDocument(context.Context, *ProcessDocumentRequest) (*Document, error)
}

// UnimplementedDocumentUnderstandingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentUnderstandingServiceServer struct {
}

func (*UnimplementedDocumentUnderstandingServiceServer) BatchProcessDocuments(ctx context.Context, req *BatchProcessDocumentsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchProcessDocuments not implemented")
}
func (*UnimplementedDocumentUnderstandingServiceServer) ProcessDocument(ctx context.Context, req *ProcessDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessDocument not implemented")
}

func RegisterDocumentUnderstandingServiceServer(s *grpc.Server, srv DocumentUnderstandingServiceServer) {
	s.RegisterService(&_DocumentUnderstandingService_serviceDesc, srv)
}

func _DocumentUnderstandingService_BatchProcessDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchProcessDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentUnderstandingServiceServer).BatchProcessDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta2.DocumentUnderstandingService/BatchProcessDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentUnderstandingServiceServer).BatchProcessDocuments(ctx, req.(*BatchProcessDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentUnderstandingService_ProcessDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentUnderstandingServiceServer).ProcessDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta2.DocumentUnderstandingService/ProcessDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentUnderstandingServiceServer).ProcessDocument(ctx, req.(*ProcessDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentUnderstandingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.documentai.v1beta2.DocumentUnderstandingService",
	HandlerType: (*DocumentUnderstandingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchProcessDocuments",
			Handler:    _DocumentUnderstandingService_BatchProcessDocuments_Handler,
		},
		{
			MethodName: "ProcessDocument",
			Handler:    _DocumentUnderstandingService_ProcessDocument_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/documentai/v1beta2/document_understanding.proto",
}
