// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListQueuesInput struct {
	_ struct{} `type:"structure"`

	// A string to use for filtering the list results. Only those queues whose name
	// begins with the specified string are returned.
	//
	// Queue URLs and names are case-sensitive.
	QueueNamePrefix *string `type:"string"`
}

// String returns the string representation
func (s ListQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// A list of your queues.
type ListQueuesOutput struct {
	_ struct{} `type:"structure"`

	// A list of queue URLs, up to 1,000 entries.
	QueueUrls []string `locationNameList:"QueueUrl" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListQueues = "ListQueues"

// ListQueuesRequest returns a request value for making API operation for
// Amazon Simple Queue Service.
//
// Returns a list of your queues. The maximum number of queues that can be returned
// is 1,000. If you specify a value for the optional QueueNamePrefix parameter,
// only queues with a name that begins with the specified value are returned.
//
// Cross-account permissions don't apply to this action. For more information,
// see Grant Cross-Account Permissions to a Role and a User Name (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
// in the Amazon Simple Queue Service Developer Guide.
//
//    // Example sending a request using ListQueuesRequest.
//    req := client.ListQueuesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sqs-2012-11-05/ListQueues
func (c *Client) ListQueuesRequest(input *ListQueuesInput) ListQueuesRequest {
	op := &aws.Operation{
		Name:       opListQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListQueuesInput{}
	}

	req := c.newRequest(op, input, &ListQueuesOutput{})
	return ListQueuesRequest{Request: req, Input: input, Copy: c.ListQueuesRequest}
}

// ListQueuesRequest is the request type for the
// ListQueues API operation.
type ListQueuesRequest struct {
	*aws.Request
	Input *ListQueuesInput
	Copy  func(*ListQueuesInput) ListQueuesRequest
}

// Send marshals and sends the ListQueues API request.
func (r ListQueuesRequest) Send(ctx context.Context) (*ListQueuesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListQueuesResponse{
		ListQueuesOutput: r.Request.Data.(*ListQueuesOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListQueuesResponse is the response type for the
// ListQueues API operation.
type ListQueuesResponse struct {
	*ListQueuesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListQueues request.
func (r *ListQueuesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
