// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type RevokeSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The CIDR IP address range. You can't specify this parameter when specifying
	// a source security group.
	CidrIp *string `type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The start of port range for the TCP and UDP protocols, or an ICMP type number.
	// For the ICMP type number, use -1 to specify all ICMP types.
	FromPort *int64 `type:"integer"`

	// The ID of the security group. You must specify either the security group
	// ID or the security group name in the request. For security groups in a nondefault
	// VPC, you must specify the security group ID.
	GroupId *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the security group. You must specify
	// either the security group ID or the security group name in the request.
	GroupName *string `type:"string"`

	// The sets of IP permissions. You can't specify a source security group and
	// a CIDR IP address range in the same set of permissions.
	IpPermissions []IpPermission `locationNameList:"item" type:"list"`

	// The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers (http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
	// Use -1 to specify all.
	IpProtocol *string `type:"string"`

	// [EC2-Classic, default VPC] The name of the source security group. You can't
	// specify this parameter in combination with the following parameters: the
	// CIDR IP address range, the start of the port range, the IP protocol, and
	// the end of the port range. For EC2-VPC, the source security group must be
	// in the same VPC. To revoke a specific rule for an IP protocol and port range,
	// use a set of IP permissions instead.
	SourceSecurityGroupName *string `type:"string"`

	// [EC2-Classic] The AWS account ID of the source security group, if the source
	// security group is in a different account. You can't specify this parameter
	// in combination with the following parameters: the CIDR IP address range,
	// the IP protocol, the start of the port range, and the end of the port range.
	// To revoke a specific rule for an IP protocol and port range, use a set of
	// IP permissions instead.
	SourceSecurityGroupOwnerId *string `type:"string"`

	// The end of port range for the TCP and UDP protocols, or an ICMP code number.
	// For the ICMP code number, use -1 to specify all ICMP codes for the ICMP type.
	ToPort *int64 `type:"integer"`
}

// String returns the string representation
func (s RevokeSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

type RevokeSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

const opRevokeSecurityGroupIngress = "RevokeSecurityGroupIngress"

// RevokeSecurityGroupIngressRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Removes the specified ingress rules from a security group. To remove a rule,
// the values that you specify (for example, ports) must match the existing
// rule's values exactly.
//
// [EC2-Classic only] If the values you specify do not match the existing rule's
// values, no error is returned. Use DescribeSecurityGroups to verify that the
// rule has been removed.
//
// Each rule consists of the protocol and the CIDR range or source security
// group. For the TCP and UDP protocols, you must also specify the destination
// port or range of ports. For the ICMP protocol, you must also specify the
// ICMP type and code. If the security group rule has a description, you do
// not have to specify the description to revoke the rule.
//
// Rule changes are propagated to instances within the security group as quickly
// as possible. However, a small delay might occur.
//
//    // Example sending a request using RevokeSecurityGroupIngressRequest.
//    req := client.RevokeSecurityGroupIngressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeSecurityGroupIngress
func (c *Client) RevokeSecurityGroupIngressRequest(input *RevokeSecurityGroupIngressInput) RevokeSecurityGroupIngressRequest {
	op := &aws.Operation{
		Name:       opRevokeSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSecurityGroupIngressInput{}
	}

	req := c.newRequest(op, input, &RevokeSecurityGroupIngressOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RevokeSecurityGroupIngressRequest{Request: req, Input: input, Copy: c.RevokeSecurityGroupIngressRequest}
}

// RevokeSecurityGroupIngressRequest is the request type for the
// RevokeSecurityGroupIngress API operation.
type RevokeSecurityGroupIngressRequest struct {
	*aws.Request
	Input *RevokeSecurityGroupIngressInput
	Copy  func(*RevokeSecurityGroupIngressInput) RevokeSecurityGroupIngressRequest
}

// Send marshals and sends the RevokeSecurityGroupIngress API request.
func (r RevokeSecurityGroupIngressRequest) Send(ctx context.Context) (*RevokeSecurityGroupIngressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeSecurityGroupIngressResponse{
		RevokeSecurityGroupIngressOutput: r.Request.Data.(*RevokeSecurityGroupIngressOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeSecurityGroupIngressResponse is the response type for the
// RevokeSecurityGroupIngress API operation.
type RevokeSecurityGroupIngressResponse struct {
	*RevokeSecurityGroupIngressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeSecurityGroupIngress request.
func (r *RevokeSecurityGroupIngressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
